/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.general;

import hec.heclib.util.HecTime;
import hec.util.GeneralTableModel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;

public class ImportTableModel
extends GeneralTableModel {
    public static final int UNSET = 0;
    public static final int SKIP = 1;
    public static final int DATE_TIME = 10;
    public static final int DATE = 11;
    public static final int TIME = 12;
    public static final int HOUR = 13;
    public static final int MINUTE = 14;
    public static final int DAY = 15;
    public static final int MONTH = 16;
    public static final int YEAR = 17;
    public static final int JULIAN_DAY = 18;
    public static final int DAY_MONTH = 19;
    public static final int MONTH_DAY = 20;
    public static final int MONTH_YEAR = 21;
    public static final int PART_A = 50;
    public static final int PART_B = 51;
    public static final int PART_C = 52;
    public static final int PART_D = 53;
    public static final int PART_E = 54;
    public static final int PART_F = 55;
    public static final int UNITS = 60;
    protected int[][] cellAction = null;
    protected HashSet _actionsSet = new HashSet();
    protected HashSet _skipColumns = new HashSet();
    protected HashSet _skipRows = new HashSet();
    protected int[] _dataCols = null;

    public ImportTableModel() {
    }

    public ImportTableModel(String[] columnNames) {
        super(columnNames);
    }

    public void setRows(Vector rows) {
        if (rows != null) {
            this._rows = new Vector(rows.size());
            for (int i = 0; i < rows.size(); ++i) {
                String[] r = (String[])rows.elementAt(i);
                String[] r2 = new String[r.length + 1];
                r2[0] = Integer.toString(i + 1);
                for (int j = 0; j < r.length; ++j) {
                    r2[j + 1] = r[j];
                }
                this._rows.add(r2);
            }
        }
        this.initCellAction();
        this.fireTableDataChanged();
    }

    public void setColumnNames(String[] columnNames) {
        super.setColumnNames(columnNames);
        this.initCellAction();
    }

    protected void initCellAction() {
        if (this.colNames == null) {
            return;
        }
        int numbRows = this.getRowCount();
        if (this.colNames.length > 0 && numbRows > 0) {
            this.cellAction = new int[this.colNames.length][numbRows];
            Arrays.fill(this.cellAction[0], 1);
            for (int i = 1; i < this.colNames.length; ++i) {
                Arrays.fill(this.cellAction[i], 0);
            }
            this._dataCols = new int[this.colNames.length];
            Arrays.fill(this._dataCols, 0);
        }
    }

    protected void skip(int row, int column) {
        if (row == -1) {
            Arrays.fill(this.cellAction[column], 1);
            this._skipColumns.add(column);
        } else if (column == 0) {
            for (int i = 1; i < this.colNames.length; ++i) {
                this.cellAction[i][row] = 1;
            }
            this._skipRows.add(row);
        } else {
            this.cellAction[column][row] = 1;
        }
    }

    protected void unskip(int row, int column) {
        if (row == -1) {
            Arrays.fill(this.cellAction[column], 0);
            this._skipColumns.remove(column);
        } else if (column == 0) {
            for (int i = 1; i < this.colNames.length; ++i) {
                this.cellAction[i][row] = 0;
            }
            this._skipRows.remove(row);
        } else {
            this.cellAction[column][row] = 0;
        }
    }

    public boolean isSkippedColumn(int col) {
        return this._skipColumns.contains(col);
    }

    public boolean isSkippedRow(int row) {
        return this._skipRows.contains(row);
    }

    public boolean isDataRow(int row) {
        for (int i = 1; i < this.getColumnCount(); ++i) {
            if (this.cellAction[i][row] <= 99) continue;
            return true;
        }
        return false;
    }

    public int getColumnAction(int column) {
        int action;
        int i;
        for (i = 0; i < this.getRowCount(); ++i) {
            action = this.cellAction[column][i];
            if (action < 100) continue;
            return action;
        }
        for (i = 0; i < this.getRowCount(); ++i) {
            action = this.cellAction[column][i];
            if (action < 1) continue;
            return action;
        }
        return 0;
    }

    public int getCellAction(int row, int column) {
        return this.cellAction[column][row];
    }

    public void setCellAction(int row, int column, int action) {
        if (this.cellAction[column][row] == 0) {
            this.cellAction[column][row] = action;
        }
    }

    public void setCellActionOverride(int row, int column, int action) {
        this.cellAction[column][row] = action;
    }

    public void actionSet(int column, int action) {
        this._dataCols[column] = action;
        this.actionSet(action);
    }

    public void actionSet(int action) {
        this._actionsSet.add(action);
    }

    public void unsetDataColumn(int column) {
        int action = this._dataCols[column];
        this._dataCols[column] = 0;
        this._actionsSet.remove(action);
    }

    public boolean isDataColumn(int col) {
        return this._dataCols[col] > 0;
    }

    public boolean isColumnSet(int col) {
        if (this.isDataColumn(col)) {
            return true;
        }
        for (int i = 0; i < this.cellAction[col].length; ++i) {
            if (this.cellAction[col][i] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean isRowSet(int row) {
        for (int i = 1; i < this.getColumnCount(); ++i) {
            if (this.cellAction[i][row] == 0) continue;
            return true;
        }
        return false;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return columnIndex != 0;
    }

    public void clearColumn(int column) {
        if (this.isDataColumn(column)) {
            this.unsetDataColumn(column);
        }
        if (this.isSkippedColumn(column)) {
            this._skipColumns.remove(column);
        }
        Arrays.fill(this.cellAction[column], 0);
    }

    public void clearRow(int row) {
        this.unskip(row, 0);
    }

    public boolean getActionSet(int action) {
        return this._actionsSet.contains(action);
    }

    public int getActionCell(int row, int action) {
        for (int j = 1; j < this.getColumnCount(); ++j) {
            int act = this.getCellAction(row, j);
            if (act != action) continue;
            return j;
        }
        return -1;
    }

    public boolean colHasAction(int col, int action) {
        for (int row = 0; row < this.getRowCount(); ++row) {
            int act = this.getCellAction(row, col);
            if (act != action) continue;
            return true;
        }
        return false;
    }

    public boolean isAnySet() {
        if (this.isTimeSet()) {
            return true;
        }
        if (this.isDataSet()) {
            return true;
        }
        if (this.isPathPartsSet()) {
            return true;
        }
        return this.areUnitsSet();
    }

    public boolean isTimeSet() {
        for (int i = 10; i <= 21; ++i) {
            if (!this.getActionSet(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isDataSet() {
        for (int i = 100; i <= 200; ++i) {
            if (!this.getActionSet(i)) continue;
            return true;
        }
        return false;
    }

    public boolean isPathPartsSet() {
        for (int i = 50; i <= 55; ++i) {
            if (!this.getActionSet(i)) continue;
            return true;
        }
        return false;
    }

    public boolean areUnitsSet() {
        return this.getActionSet(60);
    }

    public void clearAll() {
        if (this._actionsSet == null) {
            return;
        }
        this._actionsSet.clear();
        if (this._skipColumns == null) {
            return;
        }
        this._skipColumns.clear();
        if (this._skipRows == null) {
            return;
        }
        this._skipRows.clear();
        if (this._dataCols != null) {
            return;
        }
        Arrays.fill(this._dataCols, 0);
        for (int i = 1; i < this.colNames.length; ++i) {
            Arrays.fill(this.cellAction[i], 0);
        }
    }

    public int getDataColumnNumber(int dataSet) {
        int action = 100 + dataSet;
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int col = 1; col < this.getColumnCount(); ++col) {
                int act = this.getCellAction(row, col);
                if (act != action) continue;
                return col;
            }
        }
        return -1;
    }

    public String[] getPathnameParts(int dataSet) {
        String[] pathnameParts = new String[6];
        if (dataSet < 0) {
            return pathnameParts;
        }
        int col = this.getDataColumnNumber(dataSet);
        if (col < 0) {
            return pathnameParts;
        }
        for (int row = 0; row < this.getRowCount(); ++row) {
            int act = this.getCellAction(row, col);
            for (int i = 0; i < 6; ++i) {
                int action = 50 + i;
                if (act != action) continue;
                pathnameParts[i] = this.getValueAt(row, col).toString();
            }
        }
        return pathnameParts;
    }

    public String getUnits(int dataSet) {
        if (dataSet < 0) {
            return "";
        }
        int col = this.getDataColumnNumber(dataSet);
        for (int row = 0; row < this.getRowCount(); ++row) {
            int act = this.getCellAction(row, col);
            if (act != 60) continue;
            return this.getValueAt(row, col).toString();
        }
        return "";
    }

    public HecTime getFirstTime() {
        HecTime hecTime = new HecTime();
        if (!(this.getActionSet(10) || this.getActionSet(11) || this.getActionSet(17))) {
            return hecTime;
        }
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (this.isSkippedRow(i)) continue;
            this.getTime(i, hecTime);
            if (!hecTime.isDefined()) continue;
            return hecTime;
        }
        return hecTime;
    }

    public void getTime(int row, HecTime hecTime) {
        String s;
        String[] sp;
        int col;
        hecTime.setUndefined();
        if (this.getActionSet(10) && (col = this.getActionCell(row, 10)) > -1) {
            String s2 = this.getValueAt(row, col).toString();
            hecTime.set(s2);
            return;
        }
        Object time = null;
        if (this.getActionSet(12) && (col = this.getActionCell(row, 12)) > -1) {
            time = this.getValueAt(row, col).toString().trim();
        }
        Object hours = null;
        if (this.getActionSet(13) && (col = this.getActionCell(row, 13)) > -1) {
            hours = this.getValueAt(row, col).toString().trim();
        }
        Object minutes = null;
        if (this.getActionSet(14) && (col = this.getActionCell(row, 14)) > -1) {
            minutes = this.getValueAt(row, col).toString().trim();
        }
        if (time == null && hours != null && minutes != null) {
            try {
                int ihours = (int)Double.parseDouble((String)hours);
                int imin = (int)Double.parseDouble(minutes);
                hours = String.valueOf(ihours);
                minutes = String.valueOf(imin);
            }
            catch (Exception ihours) {
                // empty catch block
            }
            if (((String)hours).length() == 1) {
                hours = "0" + (String)hours;
            }
            if (((String)minutes).length() == 1) {
                minutes = "0" + (String)minutes;
            }
            time = (String)hours + (String)minutes;
        }
        if (time == null) {
            time = "2400";
        }
        if (((String)time).length() < 3 && ((String)(time = (String)time + "00")).length() == 3) {
            time = "0" + (String)time;
        }
        if (this.getActionSet(11) && (col = this.getActionCell(row, 11)) > -1) {
            String date = this.getValueAt(row, col).toString().trim();
            if (date.endsWith("0000") && time != null) {
                date = date.substring(0, date.length() - 5);
            }
            hecTime.set(date, (String)time);
            return;
        }
        String year = null;
        String month = null;
        String day = null;
        String julianDay = null;
        if (this.getActionSet(17) && (col = this.getActionCell(row, 17)) > -1) {
            year = this.getValueAt(row, col).toString();
        }
        if (this.getActionSet(16) && (col = this.getActionCell(row, 16)) > -1) {
            month = this.getValueAt(row, col).toString();
        }
        if (this.getActionSet(15) && (col = this.getActionCell(row, 15)) > -1) {
            day = this.getValueAt(row, col).toString();
        }
        if (this.getActionSet(18) && (col = this.getActionCell(row, 18)) > -1) {
            julianDay = this.getValueAt(row, col).toString();
        }
        if (this.getActionSet(21) && (col = this.getActionCell(row, 21)) > -1 && (sp = (s = this.getValueAt(row, col).toString()).split("-/, ")).length >= 2) {
            month = sp[0];
            year = sp[1];
        }
        if (this.getActionSet(20) && (col = this.getActionCell(row, 20)) > -1 && (sp = (s = this.getValueAt(row, col).toString()).split("[ ,-/]")).length >= 2) {
            month = sp[0];
            day = sp[1];
        }
        if (this.getActionSet(19) && (col = this.getActionCell(row, 19)) > -1 && (sp = (s = this.getValueAt(row, col).toString()).split("[ ,-/]")).length >= 2) {
            day = sp[0];
            month = sp[1];
        }
        if (year == null) {
            return;
        }
        int iday = -1;
        int imon = -1;
        int iyear = -1;
        int jday = -1;
        try {
            if (day != null) {
                iday = (int)Double.parseDouble(day);
            }
            if (julianDay != null) {
                jday = (int)Double.parseDouble(julianDay);
            }
            iyear = (int)Double.parseDouble(year);
        }
        catch (Exception e) {
            return;
        }
        if (iyear == -1) {
            return;
        }
        if (jday != -1) {
            int itime = HecTime.ihm2m((String)time);
            hecTime.setYearMonthDay(iyear, 1, 1, itime);
            hecTime.addDays(jday - 1);
            return;
        }
        try {
            if (month != null) {
                imon = (int)Double.parseDouble(month);
            }
        }
        catch (Exception itime) {
            // empty catch block
        }
        if (imon == -1) {
            if (month != null) {
                String d = day != null ? month + "/" + day + "/" + year : month + "/01/" + year;
                hecTime.set(d, (String)time);
                return;
            }
            hecTime.setYearMonthDay(iyear, 12, 31, 1440);
        } else if (iday == -1) {
            if (day != null) {
                return;
            }
            hecTime.setYearMonthDay(iyear, imon + 1, 0, 0);
            hecTime.cleanTime();
        } else {
            String d = String.valueOf(imon).concat("/").concat(String.valueOf(iday)).concat("/").concat(String.valueOf(iyear));
            hecTime.set(d, (String)time);
        }
    }
}

