/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.general;

import hec.dataui.importExport.general.ImportTableEditor;
import hec.util.ObservableClass;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import java.util.Observer;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.UIManager;
import rma.util.RMAIO;

public class ImportWizard {
    protected ImportTableEditor _importTableEditor;
    protected String _message = "";
    protected ObservableClass _observer;
    protected List<Observer> _observers = new Vector<Observer>();
    protected File _file;
    private Frame _parentFrame = null;

    public ImportWizard() {
        System.out.println("Time series import wizard, developmental version 0.3");
        this._observer = new ObservableClass();
    }

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            try {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
                Font f = new Font("dialog", 0, 12);
                UIManager.put("TextField.font", f);
                UIManager.put("TextArea.font", f);
                UIManager.put("TextPane.font", f);
                UIManager.put("Table.font", f);
                UIManager.put("Menu.font", f);
                UIManager.put("MenuItem.font", f);
            }
            catch (Exception f) {
                // empty catch block
            }
        }
        ImportWizard importwizard = new ImportWizard();
    }

    public void begin() {
        File file = this.openDataFile();
        if (file != null) {
            this._file = file;
            ActionEvent event = new ActionEvent(this, 0, "fileSelected");
            if (this._observer != null) {
                this._observer.notifyObservers((Object)event);
            }
            this.startWizard(file);
        }
    }

    public File openDataFile() {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String importdirectory = preferences.get("importdirectory", "");
        JFileChooser chooser = importdirectory.length() > 0 ? new JFileChooser(importdirectory) : new JFileChooser();
        chooser.setDialogTitle("Enter data file to import");
        chooser.setMultiSelectionEnabled(false);
        this._parentFrame = this.findParentFrame();
        chooser.showOpenDialog(this._parentFrame);
        File file = chooser.getSelectedFile();
        if (file != null) {
            File curDir = chooser.getCurrentDirectory();
            preferences.put("importdirectory", curDir.getAbsolutePath());
        }
        return file;
    }

    public File getFile() {
        return this._file;
    }

    private Frame findParentFrame() {
        Frame[] frames = Frame.getFrames();
        if (frames == null || frames.length == 0) {
            return null;
        }
        for (Frame frame : frames) {
            if (frame == null || !frame.isVisible() || !frame.isActive()) continue;
            return frame;
        }
        return null;
    }

    public void startWizard(File file) {
        String line;
        int i;
        Vector contents = this.readFile(file);
        if (contents.size() == 0) {
            return;
        }
        int nlines = contents.size();
        if (nlines > 5) {
            nlines = 5;
        }
        boolean tabs = false;
        boolean commas = false;
        boolean semicolon = false;
        boolean spaces = false;
        String delim = null;
        for (i = 0; i < nlines; ++i) {
            line = (String)contents.elementAt(i);
            if (line.indexOf(9) < 0) continue;
            tabs = true;
            delim = "\t";
            break;
        }
        if (!tabs) {
            for (i = 0; i < nlines; ++i) {
                line = (String)contents.elementAt(i);
                if (line.indexOf(44) < 0) continue;
                commas = true;
                delim = ",";
                break;
            }
            if (!commas) {
                for (i = 0; i < nlines; ++i) {
                    line = (String)contents.elementAt(i);
                    if (line.indexOf(59) < 0) continue;
                    semicolon = true;
                    delim = ";";
                    break;
                }
                if (!semicolon) {
                    for (i = 0; i < nlines; ++i) {
                        line = (String)contents.elementAt(i);
                        if (line.indexOf(32) < 0) continue;
                        spaces = true;
                        delim = " ";
                        break;
                    }
                }
            }
        }
        Vector<String[]> parsedContents = new Vector<String[]>();
        int maxCols = 0;
        if (delim != null) {
            String[] sp;
            int i2;
            if (spaces) {
                for (i2 = 0; i2 < contents.size(); ++i2) {
                    StringTokenizer stringTokenizer = new StringTokenizer((String)contents.elementAt(i2), delim);
                    sp = new String[stringTokenizer.countTokens()];
                    int icnt = 0;
                    while (stringTokenizer.hasMoreElements()) {
                        sp[icnt] = stringTokenizer.nextToken().trim();
                        ++icnt;
                    }
                    parsedContents.add(sp);
                    if (sp.length <= maxCols) continue;
                    maxCols = sp.length;
                }
            } else {
                for (i2 = 0; i2 < contents.size(); ++i2) {
                    sp = ((String)contents.elementAt(i2)).split(delim);
                    for (int j = 0; j < sp.length; ++j) {
                        if (sp[j].startsWith("\"")) {
                            sp[j] = sp[j].substring(1);
                        }
                        if (!sp[j].endsWith("\"")) continue;
                        sp[j] = sp[j].substring(0, sp[j].length() - 1);
                    }
                    parsedContents.add(sp);
                    if (sp.length <= maxCols) continue;
                    maxCols = sp.length;
                }
            }
            String filename = RMAIO.getFileFromPath((String)file.getAbsolutePath());
            this._importTableEditor = new ImportTableEditor(filename);
            this._importTableEditor.initialize(maxCols, parsedContents);
            this._importTableEditor.setSize(800, 600);
            if (this._parentFrame != null) {
                this._importTableEditor.setLocationRelativeTo(this._parentFrame);
            } else {
                this._importTableEditor.setLocation(100, 100);
            }
            if (this._observers.size() > 0) {
                for (Observer _observer1 : this._observers) {
                    this._importTableEditor.addObserver(_observer1);
                }
            }
            this._importTableEditor.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    EventQueue.invokeLater(() -> ImportWizard.this._importTableEditor.toFront());
                }
            });
            this._importTableEditor.setVisible(true);
        }
    }

    public Vector getSelectedData() {
        return this._importTableEditor.getSelectedData();
    }

    public Vector getData() {
        return this._importTableEditor.getData();
    }

    public String getMessage() {
        if (this._message.length() > 0) {
            return this._message;
        }
        return this._importTableEditor.getMessage();
    }

    public Vector readFile(File file) {
        Vector<String> contents = new Vector<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line;
            while ((line = reader.readLine()) != null) {
                contents.add(line);
            }
        }
        catch (Exception e) {
            String string = "Unable to load file " + file.getAbsolutePath() + "\n" + e.toString();
        }
        return contents;
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
        if (this._importTableEditor != null) {
            this._importTableEditor.addObserver(o);
        } else {
            this._observers.add(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
        if (this._importTableEditor != null) {
            this._importTableEditor.removeObserver(o);
        }
        this._observers.remove(o);
    }

    public void close() {
        this._importTableEditor.close();
        if (this._observer != null) {
            this._observer.deleteObservers();
        }
    }
}

