/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.shef;

import hec.util.FileUtilities;
import hec.util.FortranField;
import hec.util.GeneralTableEditor;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.TableColumn;

public class ShefParamEditor
extends GeneralTableEditor {
    protected int[] columnWidths = new int[]{80, 140, 300};
    FortranField[] _fields = new FortranField[]{new FortranField(1, 2), new FortranField(3, 24), new FortranField(25, 80)};
    FortranField[] _fieldsOut = new FortranField[]{new FortranField(1, 2), new FortranField(4, 24), new FortranField(25, 80)};
    String[] _columnNames = new String[]{"SHEF\nPE Code", "Metric to English\nConversion Factor", "Section Name"};

    public ShefParamEditor(File file) {
        Vector paramData = this.readFile(file);
        this.initialize(this._columnNames, paramData);
        this._table.setEditable(true);
        int width = 0;
        for (int i = 0; i < this.columnWidths.length; ++i) {
            width += this.columnWidths[i];
            TableColumn tc = this._table.getColumnModel().getColumn(i);
            tc.setPreferredWidth(this.columnWidths[i]);
        }
        this.setSize(width, 600);
        this.setLocation(100, 100);
    }

    protected Vector readFile(File file) {
        this._file = file;
        Vector<String[]> paramData = new Vector<String[]>();
        if (this._file != null) {
            String fileName = this._file.getAbsolutePath();
            try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
                String line;
                String ignoreFirstLine = reader.readLine();
                while ((line = reader.readLine()) != null) {
                    line = line.trim();
                    String[] stringFields = FortranField.parseFixedFormat((String)line, (FortranField[])this._fields);
                    paramData.add(stringFields);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return paramData;
    }

    public boolean saveData() {
        String fileName = this._file.getAbsolutePath();
        try {
            FileUtilities.copyFile((String)fileName, (String)(fileName + ".bak"));
        }
        catch (Exception e) {
            System.out.println("Unable to make backup file (" + fileName + ".bak) ");
        }
        PrintWriter textOut = new PrintWriter(new FileWriter(fileName));
        try {
            textOut.println("SHEFPARM");
            Vector rows = this.getRows();
            for (int i = 0; i < rows.size(); ++i) {
                String[] s = (String[])rows.elementAt(i);
                String line = FortranField.toFixedFormat((String[])s, (FortranField[])this._fieldsOut);
                textOut.println(line.trim());
            }
            boolean bl = true;
            textOut.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    textOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write to file " + fileName + "\n" + e.toString(), "SHEF", 2);
                return false;
            }
        }
    }
}

