/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.shef;

import hec.util.FileUtilities;
import hec.util.FortranField;
import hec.util.GeneralTableEditor;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ShefParameterFileEditor
extends GeneralTableEditor {
    FortranField[] _fields = new FortranField[]{new FortranField(1, 2), new FortranField(4, 28), new FortranField(30, 37), new FortranField(39, 46), new FortranField(48, 57)};
    String[] _columnNames = new String[]{"SHEF\nPE Code", "Part C", "Units", "Type", "Factor\n(optional)"};

    public ShefParameterFileEditor(File file) {
        Vector sensorData = this.readFile(file);
        this.initialize(this._columnNames, sensorData);
        this._table.setEditable(true);
        this.setSize(600, 300);
        this.setLocation(200, 200);
    }

    protected Vector readFile(File file) {
        this._file = file;
        Vector<String[]> sensorData = new Vector<String[]>();
        if (this._file != null) {
            String fileName = this._file.getAbsolutePath();
            try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("*")) continue;
                    String[] stringFields = FortranField.parseFixedFormat((String)line, (FortranField[])this._fields);
                    sensorData.add(stringFields);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sensorData;
    }

    public boolean saveData() {
        String fileName = this._file.getAbsolutePath();
        try {
            FileUtilities.copyFile((String)fileName, (String)(fileName + ".bak"));
        }
        catch (Exception e) {
            System.out.println("Unable to make backup file (" + fileName + ".bak) ");
        }
        PrintWriter textOut = new PrintWriter(new FileWriter(fileName));
        try {
            Vector rows = this.getRows();
            for (int i = 0; i < rows.size(); ++i) {
                String[] s = (String[])rows.elementAt(i);
                String line = FortranField.toFixedFormat((String[])s, (FortranField[])this._fields);
                textOut.println(line.trim());
            }
            boolean bl = true;
            textOut.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    textOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write to file " + fileName + "\n" + e.toString(), "SHEF", 2);
                return false;
            }
        }
    }
}

