/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.importExport.shef;

import hec.util.FileUtilities;
import hec.util.FortranField;
import hec.util.GeneralTableEditor;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JOptionPane;

public class ShefSensorFileEditor
extends GeneralTableEditor {
    FortranField[] _fields = new FortranField[]{new FortranField(1, 8), new FortranField(9, 10), new FortranField(12, 15), new FortranField(17, 32), new FortranField(34, 49), new FortranField(51, 66)};
    String[] _columnNames = new String[]{"SHEF\nGage ID", "SHEF\nPE Code", "Interval\n(mins, optional)", "Part A\n(optional)", "Part B\n(optional)", "Part F\n(optional)"};

    public ShefSensorFileEditor(File file) {
        Vector sensorData = this.readFile(file);
        this.initialize(this._columnNames, sensorData);
        this._table.setEditable(true);
        this.setSize(800, 300);
        this.setLocation(200, 200);
    }

    protected Vector readFile(File file) {
        this._file = file;
        Vector<String[]> sensorData = new Vector<String[]>();
        if (this._file != null) {
            String fileName = this._file.getAbsolutePath();
            try (BufferedReader reader = new BufferedReader(new FileReader(fileName));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if ((line = line.trim()).startsWith("*")) continue;
                    String[] stringFields = FortranField.parseFixedFormat((String)line, (FortranField[])this._fields);
                    sensorData.add(stringFields);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return sensorData;
    }

    public boolean saveData() {
        String fileName = this._file.getAbsolutePath();
        try {
            FileUtilities.copyFile((String)fileName, (String)(fileName + ".bak"));
        }
        catch (Exception e) {
            System.out.println("Unable to make backup file (" + fileName + ".bak) ");
        }
        PrintWriter textOut = new PrintWriter(new FileWriter(fileName));
        try {
            Vector rows = this.getRows();
            Object[] nrows = new String[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                String[] s = (String[])rows.elementAt(i);
                if (s[2].trim().length() > 0) {
                    int l;
                    int val;
                    try {
                        val = Integer.parseInt(s[2]);
                    }
                    catch (Exception e) {
                        val = -1;
                    }
                    if (val > 0) {
                        s[2] = s[2] + "M";
                    }
                    if ((l = s[2].length()) < 4) {
                        StringBuilder intvl = new StringBuilder();
                        int k = 4 - l;
                        for (int j = 0; j < k; ++j) {
                            intvl.append(" ");
                        }
                        intvl.append(s[2]);
                        s[2] = intvl.toString();
                    }
                }
                String line = FortranField.toFixedFormat((String[])s, (FortranField[])this._fields);
                nrows[i] = line;
            }
            Arrays.sort(nrows);
            for (Object nrow : nrows) {
                textOut.println(((String)nrow).trim());
            }
            boolean bl = true;
            textOut.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    textOut.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Unable to write to file " + fileName + "\n" + e.toString(), "SHEF", 2);
                return false;
            }
        }
    }
}

