/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import com.google.common.flogger.FluentLogger;
import hec.dataui.summary.awt.DataBrowser;
import hec.dataui.summary.awt.DataSetInfo;
import hec.db.DataAccessFactory;
import hec.db.DbConnectionException;
import hec.db.DbIoException;
import hec.heclib.dss.DSSPathAndFilename;
import hec.heclib.dss.DSSPathname;
import hec.serversuite.RemoteServerEnum;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.ui.browser.IBrowseCallback;
import hec.ui.browser.IBrowserFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

final class CwmsVueDataBrowser
implements IBrowseCallback {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final DataBrowser.Callback _callback;
    private final DataAccessFactory _dataAccessFactory;
    private CwmsAuthenticationSource _cwmsAuthenticationSource;
    private final List<DataSetInfo> _dataSetList = new ArrayList<DataSetInfo>();

    CwmsVueDataBrowser(DataBrowser.Callback callback, DataAccessFactory dataAccessFactory, CwmsAuthenticationSource cwmsAuthenticationSource) {
        this._callback = callback;
        this._dataAccessFactory = dataAccessFactory;
        this._cwmsAuthenticationSource = cwmsAuthenticationSource;
    }

    void setDataSetList(List<DataSetInfo.CwmsDataSetInfo> dataSetList) {
        this._dataSetList.clear();
        this._dataSetList.addAll(dataSetList);
    }

    IBrowserFactory browse() {
        Lookup lookup = Lookups.forPath((String)"hec.cwmsVue.BrowserFactory/DataStatusSummary");
        IBrowserFactory cwmsBrowserFactory = (IBrowserFactory)lookup.lookup(IBrowserFactory.class);
        if (cwmsBrowserFactory == null) {
            return null;
        }
        Map initializer = cwmsBrowserFactory.getInitializer();
        initializer.put("selected_records", this._dataSetList);
        initializer.put("title", "Select Time Series Identifiers");
        initializer.put("datastore", this._dataAccessFactory);
        cwmsBrowserFactory.setInitializer(initializer);
        cwmsBrowserFactory.openBrowser((IBrowseCallback)this);
        return cwmsBrowserFactory;
    }

    public void replacePathnames(Vector selectionList) {
        try {
            String officeId = this._dataAccessFactory.getOfficeId();
            ArrayList dataReferences = new ArrayList(selectionList);
            List<DataSetInfo> collect = dataReferences.stream().map(d -> {
                if (new DSSPathname(d.getPathname()).isCwmsTsId()) {
                    return new DataSetInfo.CwmsDataSetInfo(d.getPathname(), this._cwmsAuthenticationSource, officeId);
                }
                DSSPathAndFilename dssName = new DSSPathAndFilename();
                dssName.setPathname(d.getDSSPathname().pathname());
                if (d.getHost() != null) {
                    String strUrl = "//" + d.getHost() + ":" + d.getPort() + "/" + RemoteServerEnum.DSS_FILE_MANAGER.getRemoteName();
                    dssName.setFilename(strUrl + ":" + d.getFilename());
                } else {
                    dssName.setFilename(d.getFilename());
                }
                return new DataSetInfo.DssDataSetInfo(dssName);
            }).collect(Collectors.toList());
            this._callback.dataSetInfoAdded(collect);
        }
        catch (DbConnectionException | DbIoException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Unable to determine database url for browsing CWMSVue for servers: " + this._cwmsAuthenticationSource.getDisplayName());
        }
    }
}

