/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import com.google.common.flogger.FluentLogger;
import hec.dataui.summary.awt.CwmsVueDataBrowser;
import hec.dataui.summary.awt.DataSetInfo;
import hec.dataui.summary.awt.DataStatusOracleTS;
import hec.dataui.summary.awt.DataStatusSummary;
import hec.dataui.summary.awt.LocalDssDataBrowser;
import hec.dataui.tx.ValidationFactory;
import hec.dataui.tx.awt.DisplayOracleTS;
import hec.db.DataAccessFactory;
import hec.heclib.dss.DSSPathAndFilename;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.DssManagerBridge;
import hec.io.TimeSeriesContainer;
import hec.lang.LoginException;
import hec.serversuite.ServerSuite;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.ui.browser.IBrowserFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;
import rma.util.RMAIO;

final class DataBrowser {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final Set<IBrowserFactory> _browsers = new HashSet<IBrowserFactory>();
    private final ExecutorService _executorService = Executors.newFixedThreadPool(10);
    private final DataAccessFactory _dataAccessFactory;
    private final DssManagerBridge _dssManager;
    private final DssManagerBridge _remoteManager;
    private final Callback _callback;
    private final Set<DataStatusOracleTS> _dataStatusRunners = new HashSet<DataStatusOracleTS>();
    private final TimeZone _projectTimeZone;

    DataBrowser(DataAccessFactory dataAccessFactory, DssManagerBridge dssManager, DssManagerBridge remoteManager, Callback callback, TimeZone projectTimeZone) {
        this._dataAccessFactory = dataAccessFactory;
        this._dssManager = dssManager;
        this._remoteManager = remoteManager;
        this._callback = callback;
        this._projectTimeZone = projectTimeZone;
    }

    void closeBrowsers() {
        this._browsers.forEach(IBrowserFactory::closeBrowser);
    }

    void browseOracle(List<DataSetInfo> dataSetList) {
        ServerSuite serverSuite = ServerSuiteUtil.getServerSuite();
        if (serverSuite != null) {
            CwmsVueDataBrowser oracleDataBrowser = new CwmsVueDataBrowser(this._callback, this._dataAccessFactory, serverSuite.getServer());
            oracleDataBrowser.setDataSetList(this.trimToCwms(dataSetList));
            IBrowserFactory browse = oracleDataBrowser.browse();
            if (browse != null) {
                this._browsers.add(browse);
            }
        }
    }

    private List<DataSetInfo.CwmsDataSetInfo> trimToCwms(List<DataSetInfo> dataSetList) {
        return dataSetList.stream().filter(DataSetInfo.CwmsDataSetInfo.class::isInstance).map(DataSetInfo.CwmsDataSetInfo.class::cast).collect(Collectors.toList());
    }

    private List<DataSetInfo.DssDataSetInfo> trimToLocalDss(List<DataSetInfo.DssDataSetInfo> dataSetList) {
        return dataSetList.stream().filter(d -> d.getPathname().trim().endsWith("/")).filter(d -> !d.getDataSourceLocation().startsWith("//")).collect(Collectors.toList());
    }

    private List<DataSetInfo.DssDataSetInfo> trimToRemoteDss(List<DataSetInfo.DssDataSetInfo> dataSetList) {
        return dataSetList.stream().filter(d -> d.getPathname().trim().endsWith("/")).filter(d -> d.getDataSourceLocation().startsWith("//")).collect(Collectors.toList());
    }

    void browseRadar(CwmsAuthenticationSource radarAuthenticationSource, List<DataSetInfo> dataSetList) {
        try {
            CwmsAuthenticationSource source = ServerSuiteUtil.replaceWithPreferences((CwmsAuthenticationSource)radarAuthenticationSource);
            ServerSuite serverSuite = ServerSuiteUtil.loginSecondary((String)"DataStatusSummary", (CwmsAuthenticationSource)source);
            DataAccessFactory dataAccessFactory = serverSuite.getDataAccessFactory();
            CwmsVueDataBrowser oracleDataBrowser = new CwmsVueDataBrowser(this._callback, dataAccessFactory, radarAuthenticationSource);
            oracleDataBrowser.setDataSetList(this.trimToCwms(dataSetList));
            IBrowserFactory browse = oracleDataBrowser.browse();
            if (browse != null) {
                this._browsers.add(browse);
            }
        }
        catch (LoginException e1) {
            RMAIO.postError(null, (String)("Unable to browse: " + radarAuthenticationSource + " due to:\n" + e1.getMessage()));
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e1)).log("Unable to connect to database.");
        }
    }

    void browseDss(List<DataSetInfo> dataSetList) {
        List<DataSetInfo.DssDataSetInfo> dssDataSetInfo = dataSetList.stream().filter(d -> d instanceof DataSetInfo.DssDataSetInfo).map(d -> (DataSetInfo.DssDataSetInfo)d).collect(Collectors.toList());
        LocalDssDataBrowser localDssBrowser = new LocalDssDataBrowser(this._callback);
        localDssBrowser.setDataSetList(this.trimToLocalDss(dssDataSetInfo));
        IBrowserFactory browse = localDssBrowser.browse();
        if (browse != null) {
            this._browsers.add(browse);
        }
    }

    private void readDssDataSets(List<DataSetInfo.DssDataSetInfo> datalist, TimeZone viewTimeZone, Function<DSSIdentifier, Optional<TimeSeriesContainer>> dssReader) {
        ArrayList<TimeSeriesContainer> containers = new ArrayList<TimeSeriesContainer>();
        for (DataSetInfo.DssDataSetInfo dataSetInfo : datalist) {
            DSSPathAndFilename dssPath = new DSSPathAndFilename();
            dssPath.setPathname(dataSetInfo.getPathname());
            dssPath.setFilename(dataSetInfo.getDataSourceLocation());
            DSSIdentifier dssId = new DSSIdentifier(dssPath.filename(), dssPath.pathname());
            dssId.setTimeZoneID(viewTimeZone.getID());
            if (DSSPathname.getTSIntervalSeconds((String)new DSSPathname(dataSetInfo.getPathname()).getEPart(), null) <= 0) {
                dssId.setStartTime(new HecTime(dataSetInfo.getNoReportStartTime(), 1));
            } else {
                dssId.setStartTime(new HecTime(dataSetInfo.getStartTime(), 1));
            }
            dssId.setEndTime(new HecTime(dataSetInfo.getEndTime(), 1));
            dssReader.apply(dssId).ifPresent(tsc -> {
                TimeSeriesContainer clone = new TimeSeriesContainer();
                tsc.clone(clone);
                if (clone.getTimeZoneID() == null || clone.getTimeZoneID().trim().isEmpty()) {
                    clone.setTimeZoneID(this._projectTimeZone.getID());
                }
                containers.add(clone);
            });
        }
        this._callback.dataSetInfoListUpdated(containers);
    }

    private Optional<TimeSeriesContainer> readLocalDss(DSSIdentifier dssId) {
        TimeSeriesContainer timeSeriesContainer;
        String dssPath;
        Optional<TimeSeriesContainer> retval = Optional.empty();
        String file = dssId.getFileName();
        int type = this._dssManager.recordType(file, dssPath = dssId.getDSSPath());
        if (type >= 100 && type < 200 && (timeSeriesContainer = this._dssManager.readTS(dssId, true)) != null && timeSeriesContainer.values != null && timeSeriesContainer.getNumberValues() > 0) {
            retval = Optional.of(timeSeriesContainer);
        }
        return retval;
    }

    private Optional<TimeSeriesContainer> readRemoteDss(DSSIdentifier dssId) {
        TimeSeriesContainer timeSeriesContainer;
        Optional<TimeSeriesContainer> retval = Optional.empty();
        String file = dssId.getFileName();
        file = file.substring(file.indexOf(58) + 1);
        file = file.substring(file.indexOf(58) + 1);
        dssId.setFileName(file);
        String dssPath = dssId.getDSSPath();
        int type = this._remoteManager.recordType(file, dssPath);
        if (type >= 100 && type < 200 && (timeSeriesContainer = this._remoteManager.readTS(dssId, true)) != null && timeSeriesContainer.values != null && timeSeriesContainer.getNumberValues() > 0) {
            retval = Optional.of(timeSeriesContainer);
        }
        return retval;
    }

    void validate(DataStatusSummary parent, Preferences preferences) {
        ValidationFactory.showDataVerify(parent, preferences, this._dssManager, null);
    }

    CompletableFuture<Void> retrieveData(List<DataSetInfo> dataSetList, HecTime startTime, HecTime endTime, TimeZone timeZone, int unitSystem) {
        List<DataSetInfo.CwmsDataSetInfo> cwmsData;
        List<DataSetInfo.DssDataSetInfo> dssDataSetInfo = dataSetList.stream().filter(d -> d instanceof DataSetInfo.DssDataSetInfo).map(d -> (DataSetInfo.DssDataSetInfo)d).collect(Collectors.toList());
        List<DataSetInfo.DssDataSetInfo> localDss = this.trimToLocalDss(dssDataSetInfo);
        if (!localDss.isEmpty()) {
            this.readDssDataSets(localDss, timeZone, this::readLocalDss);
        }
        List<DataSetInfo.DssDataSetInfo> remoteDss = this.trimToRemoteDss(dssDataSetInfo);
        if (this._remoteManager != null && !remoteDss.isEmpty()) {
            this.readDssDataSets(remoteDss, timeZone, this::readRemoteDss);
        }
        if (!(cwmsData = this.trimToCwms(dataSetList)).isEmpty()) {
            return this.retrieveCwmsData(startTime, endTime, timeZone, unitSystem, cwmsData);
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<Void> retrieveCwmsData(HecTime startTime, HecTime endTime, TimeZone timeZone, int unitSystem, List<DataSetInfo.CwmsDataSetInfo> cwmsData) {
        this._dataStatusRunners.forEach(DisplayOracleTS::cancel);
        Map<DataAccessFactory, List<TimeSeriesTemplate>> collect = cwmsData.stream().collect(Collectors.groupingBy(this::findDataAccessFactory, Collectors.mapping(d -> this.mapToTimeSeriesTemplate(startTime, endTime, (DataSetInfo.CwmsDataSetInfo)d, timeZone), Collectors.toList()))).entrySet().stream().filter(e -> ((Optional)e.getKey()).isPresent()).collect(Collectors.toMap(e -> (DataAccessFactory)((Optional)e.getKey()).get(), Map.Entry::getValue));
        DataStatusOracleTS dataStatusRunner = new DataStatusOracleTS(this._callback, collect, unitSystem);
        this._dataStatusRunners.add(dataStatusRunner);
        return CompletableFuture.runAsync(dataStatusRunner, this._executorService).whenComplete((o, t) -> this._dataStatusRunners.remove(dataStatusRunner));
    }

    Optional<DataAccessFactory> findDataAccessFactory(DataSetInfo.CwmsDataSetInfo d) {
        DataAccessFactory retval = null;
        Optional<CwmsAuthenticationSource> cwmsAuthenticationSourceOpt = d.getCwmsAuthenticationSource();
        try {
            ServerSuite serverSuite;
            if (!cwmsAuthenticationSourceOpt.isPresent()) {
                serverSuite = ServerSuiteUtil.getServerSuite();
            } else {
                CwmsAuthenticationSource cwmsAuthenticationSource = cwmsAuthenticationSourceOpt.get();
                CwmsAuthenticationSource source = ServerSuiteUtil.replaceWithPreferences((CwmsAuthenticationSource)cwmsAuthenticationSource);
                serverSuite = ServerSuiteUtil.loginSecondary((String)"DataStatusSummary", (CwmsAuthenticationSource)source);
            }
            if (serverSuite != null) {
                retval = serverSuite.getDataAccessFactory();
            }
        }
        catch (LoginException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to get data access factory from: " + d.getDataSourceName());
        }
        return Optional.ofNullable(retval);
    }

    private TimeSeriesTemplate mapToTimeSeriesTemplate(HecTime startTime, HecTime endTime, DataSetInfo.CwmsDataSetInfo dataSetInfo, TimeZone timeZone) {
        try {
            long start;
            String officeId = dataSetInfo.getOfficeId();
            TimeSeriesIdentifier timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(officeId), (String)dataSetInfo.getPathname(), null);
            if (timeSeriesIdentifier.getInterval().isIrregular()) {
                HecTime adjustedStart = new HecTime(dataSetInfo.getNoReportStartTime(), 1);
                start = adjustedStart.getJavaDate((int)TimeUnit.MILLISECONDS.toMinutes(timeZone.getRawOffset())).getTime();
            } else {
                start = startTime.getJavaDate((int)TimeUnit.MILLISECONDS.toMinutes(timeZone.getRawOffset())).getTime();
            }
            long end = endTime.getJavaDate((int)TimeUnit.MILLISECONDS.toMinutes(timeZone.getRawOffset())).getTime();
            return new TimeSeriesTemplate(timeSeriesIdentifier, start, end);
        }
        catch (DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Unable to parse time series identifier: " + dataSetInfo.getPathname());
            return null;
        }
    }

    void shutdown() {
        this._executorService.shutdownNow();
    }

    void cancelRetrieval() {
        this._dataStatusRunners.forEach(DisplayOracleTS::cancel);
    }

    static interface Callback {
        public void dataSetInfoAdded(List<DataSetInfo> var1);

        public void dataSetInfoListUpdated(List<TimeSeriesContainer> var1);

        public void displayErrors(String var1);
    }
}

