/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import hec.dataui.tx.client.QualityColorBar;
import hec.heclib.dss.DSSPathAndFilename;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsLoginUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;

public abstract class DataSetInfo {
    private final HecTime _lastTime = new HecTime();
    private final QualityColorBar _qualityColorBar = new QualityColorBar();
    private int _noReportStartTime;
    private int _startTime;
    private int _endTime;
    private int _numberMissing = -1;
    private boolean _earliest = false;
    private boolean _dataRetrieved = false;
    private TimeSeriesContainer _tsContainer = new TimeSeriesContainer();

    abstract String getPathname();

    abstract void setName(String var1);

    abstract String getDataSourceName();

    final HecTime getLastTime() {
        return this._lastTime;
    }

    final int getEndTime() {
        return this._endTime;
    }

    final void setEndTime(int value) {
        this._endTime = value;
    }

    final int getNoReportStartTime() {
        return this._noReportStartTime;
    }

    final void setNoReportStartTime(int value) {
        this._noReportStartTime = value;
    }

    final int getNumberMissing() {
        return this._numberMissing;
    }

    final void setNumberMissing(int missing) {
        this._numberMissing = missing;
    }

    final int getStartTime() {
        return this._startTime;
    }

    final void setStartTime(int value) {
        this._startTime = value;
    }

    final QualityColorBar getQualityColorBar() {
        return this._qualityColorBar;
    }

    final boolean getDataRetrieved() {
        return this._dataRetrieved;
    }

    final void setDataRetrieved(boolean dataRetrieved) {
        this._dataRetrieved = dataRetrieved;
    }

    final boolean isEarliest() {
        return this._earliest;
    }

    final void setIsEarliest(boolean earliest) {
        this._earliest = earliest;
    }

    final TimeSeriesContainer getTsContainer() {
        return this._tsContainer;
    }

    final void setTsContainer(TimeSeriesContainer timeSeriesContainer) {
        this._tsContainer = timeSeriesContainer;
    }

    abstract String toSerializableForm();

    public static final class CwmsDataSetInfo
    extends DataSetInfo {
        private final CwmsAuthenticationSource _cwmsAuthenticationSource;
        private final String _officeId;
        private String _timeSeriesIdentifier;

        CwmsDataSetInfo(String timeSeriesIdentifier, CwmsAuthenticationSource cwmsAuthenticationSource, String officeId) {
            this._timeSeriesIdentifier = timeSeriesIdentifier;
            this._cwmsAuthenticationSource = cwmsAuthenticationSource;
            this._officeId = officeId;
        }

        public Optional<CwmsAuthenticationSource> getCwmsAuthenticationSource() {
            return Optional.ofNullable(this._cwmsAuthenticationSource);
        }

        @Override
        public String getDataSourceName() {
            return this.getCwmsAuthenticationSource().map(CwmsAuthenticationSource::getDisplayName).orElse("Oracle");
        }

        @Override
        public String getPathname() {
            return this._timeSeriesIdentifier;
        }

        @Override
        void setName(String name) {
            String[] split = name.split(":");
            this._timeSeriesIdentifier = split[split.length - 1];
        }

        public String getOfficeId() {
            return this._officeId;
        }

        @Override
        String toSerializableForm() {
            CwmsAuthenticationSource server;
            String dataSource = this.getCwmsAuthenticationSource().flatMap(CwmsLoginUtil::toXml).orElse("");
            if (ServerSuiteUtil.isConnected() && ((server = ServerSuiteUtil.getServerSuite().getServer()).equals(this._cwmsAuthenticationSource) || dataSource.isEmpty())) {
                dataSource = "";
            }
            return dataSource + ":" + this.getPathname();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CwmsDataSetInfo that = (CwmsDataSetInfo)o;
            return Objects.equals(this.getCwmsAuthenticationSource(), that.getCwmsAuthenticationSource()) && Objects.equals(this.getOfficeId(), that.getOfficeId()) && Objects.equals(this._timeSeriesIdentifier, that._timeSeriesIdentifier);
        }

        public int hashCode() {
            return Objects.hash(this.getCwmsAuthenticationSource(), this.getOfficeId(), this._timeSeriesIdentifier);
        }
    }

    public static final class DssDataSetInfo
    extends DataSetInfo {
        private final DSSPathAndFilename _dssPathAndFilename;

        DssDataSetInfo(DSSPathAndFilename dssPathAndFilename) {
            this._dssPathAndFilename = dssPathAndFilename;
        }

        public String toString() {
            String filename = this._dssPathAndFilename.filename();
            String[] split = filename.split(":");
            Path fileName = Paths.get(split[split.length - 1], new String[0]).getFileName();
            return fileName + ":" + this._dssPathAndFilename.pathname();
        }

        @Override
        public String getDataSourceName() {
            String dataSourceLocation = this.getDataSourceLocation();
            String[] split = dataSourceLocation.split(":");
            String filePath = split[split.length - 1];
            return Paths.get(filePath, new String[0]).getFileName().toString();
        }

        public String getDataSourceLocation() {
            return this._dssPathAndFilename.filename();
        }

        @Override
        public String getPathname() {
            return this._dssPathAndFilename.pathname();
        }

        @Override
        void setName(String name) {
            this._dssPathAndFilename.setPathname(name);
        }

        @Override
        String toSerializableForm() {
            return this.getDataSourceLocation().trim() + ":" + this.getPathname().trim();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DssDataSetInfo that = (DssDataSetInfo)o;
            return Objects.equals(this._dssPathAndFilename, that._dssPathAndFilename);
        }

        public int hashCode() {
            return Objects.hash(this._dssPathAndFilename);
        }
    }
}

