/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import com.google.common.flogger.FluentLogger;
import hec.dataui.summary.awt.DataSetInfo;
import hec.db.DbConnectionException;
import hec.db.DbIoException;
import hec.heclib.dss.DSSPathAndFilename;
import hec.serversuite.ClientAuthenticationException;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsLoginUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public final class DataSetInfoParser {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    private DataSetInfoParser() {
        throw new AssertionError((Object)"Utility class");
    }

    public static List<String> serializeDataSetInfo(List<DataSetInfo> dataSetList) {
        return dataSetList.stream().filter(d -> !d.getPathname().trim().isEmpty()).map(d -> d.toSerializableForm()).collect(Collectors.toList());
    }

    public static List<DataSetInfo> parseDataSetList(List<String> nameList) {
        ArrayList<DataSetInfo> retval = new ArrayList<DataSetInfo>();
        for (String strName : nameList) {
            DataSetInfo dataSetInfo;
            String pathname;
            int pathnameIndex;
            if (strName.trim().isEmpty()) continue;
            if (strName.toLowerCase().contains(".dss")) {
                pathnameIndex = strName.toLowerCase().lastIndexOf("dss:");
                pathname = strName.substring(pathnameIndex + 4);
                String dataSourceLocationName = "";
                if (pathnameIndex > 0) {
                    dataSourceLocationName = strName.substring(0, pathnameIndex + 3);
                }
                dataSetInfo = DataSetInfoParser.deserializeDssDataSet(pathname, dataSourceLocationName);
            } else {
                pathnameIndex = strName.toLowerCase().lastIndexOf(":");
                pathname = strName.substring(pathnameIndex + 1);
                String authenticationSource = "";
                if (pathnameIndex > 0) {
                    authenticationSource = strName.substring(0, pathnameIndex);
                }
                dataSetInfo = DataSetInfoParser.deserializeCwmsDataSet(pathname, authenticationSource);
            }
            retval.add(dataSetInfo);
        }
        return retval;
    }

    private static DataSetInfo deserializeDssDataSet(String pathname, String authenticationSource) {
        DSSPathAndFilename dssPathAndFilename = new DSSPathAndFilename();
        dssPathAndFilename.setPathname(pathname);
        dssPathAndFilename.setFilename(authenticationSource);
        DataSetInfo.DssDataSetInfo dataSetInfo = new DataSetInfo.DssDataSetInfo(dssPathAndFilename);
        return dataSetInfo;
    }

    private static DataSetInfo deserializeCwmsDataSet(String pathname, String authenticationSource) {
        CwmsAuthenticationSource dataSourceName = null;
        String officeId = "";
        if (authenticationSource.isEmpty() && ServerSuiteUtil.isConnected()) {
            try {
                dataSourceName = ServerSuiteUtil.getServerSuite().getServer();
                officeId = ServerSuiteUtil.getServerSuite().getDataAccessFactory().getOfficeId();
            }
            catch (DbConnectionException | DbIoException | ClientAuthenticationException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause(e)).log("Unable to get DataAccessFactory from authenticated server suite. Cannot determine data source for: " + authenticationSource);
            }
        } else {
            Optional cwmsAuthenticationSource = CwmsLoginUtil.fromXml((String)authenticationSource);
            if (!authenticationSource.isEmpty() && cwmsAuthenticationSource.isPresent()) {
                dataSourceName = ServerSuiteUtil.replaceWithPreferences((CwmsAuthenticationSource)((CwmsAuthenticationSource)cwmsAuthenticationSource.get()));
                officeId = dataSourceName.getServerInfo().getExtraColumn1();
            }
        }
        return new DataSetInfo.CwmsDataSetInfo(pathname, dataSourceName, officeId);
    }
}

