/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import com.google.common.flogger.FluentLogger;
import hec.appInterface.FileOpener;
import hec.dataTable.HecDataTableFrame;
import hec.dataui.summary.awt.DataBrowser;
import hec.dataui.summary.awt.DataSetInfo;
import hec.dataui.summary.awt.DataSetInfoParser;
import hec.dataui.summary.awt.DataStatusSummaryTableCellRenderer;
import hec.dataui.summary.awt.DataStatusTableModel;
import hec.dataui.summary.awt.MissingDataScrollPanel;
import hec.dataui.summary.awt.MissingDataTableModel;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.TsContainerDataSource;
import hec.dataui.tx.awt.ValidationDataSource;
import hec.dataui.tx.client.QualityColorBar;
import hec.dataui.tx.client.QualityColorBarLegendFrame;
import hec.db.DataAccessFactory;
import hec.db.DbConnectionException;
import hec.gfx2d.G2dDialog;
import hec.heclib.dss.DSSPathAndFilename;
import hec.heclib.util.HecDouble;
import hec.heclib.util.HecTime;
import hec.heclib.util.booleanContainer;
import hec.io.DSSIdentifier;
import hec.io.DssManagerBridge;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerTimeZoneCheck;
import hec.map.vrt.SimpleFileOpeners;
import hec.serversuite.RemoteServerEnum;
import hec.serversuite.ServerSuite;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.CwmsLoginUtil;
import hec.util.TimeWindowDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Observable;
import java.util.Observer;
import java.util.Optional;
import java.util.TimeZone;
import java.util.Vector;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;
import mil.army.usace.hec.rmi.client.RmiFileDialog;
import rma.services.ServiceLookup;
import rma.services.tz.TimeZoneComponent;
import rma.swing.RmaFrame;
import rma.swing.RmaImage;
import rma.swing.RmaJTable;
import rma.swing.table.RmaCellRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class DataStatusSummary
extends RmaFrame
implements ActionListener,
MouseListener,
Observer,
TimeZoneComponent {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String LIST_EXTENSION = ".dataStatus";
    private static boolean showRetainTimeWindow = true;
    private final TimeZone _projectTimeZone;
    protected RmaJTable _table;
    protected DataStatusTableModel _tableModel;
    protected String _dataStatusListFileName = null;
    protected String _iconQualityInformation = null;
    protected HecTime _startTime = new HecTime();
    protected HecTime _endTime = new HecTime();
    protected TimeWindowDialog _timeWindowDialog = null;
    protected Preferences _preferences = null;
    protected boolean _editable = true;
    protected boolean _statusUpdated = false;
    protected boolean _dataListChanged = false;
    protected boolean _insertMode = false;
    protected boolean _standalone = false;
    protected int _unitSystem;
    protected List<DataSetInfo> _dataSetList = new ArrayList<DataSetInfo>();
    protected List<TimeSeriesContainer> _tsContainers = new ArrayList<TimeSeriesContainer>();
    protected Object _parent;
    protected String _lastFileName = null;
    private final DataBrowser _dataBrowser;
    private JLabel _jTextFieldStartDate;
    private JLabel _jTextFieldStartTime;
    private JLabel _jTextFieldEndDate;
    private JLabel _jTextFieldEndTime;
    private JTextField _noReportHoursText;
    private JMenuItem _newMenu;
    private JMenuItem _openMenu;
    private JMenuItem _saveAsMenu;
    private JMenuItem _saveMenu;
    private JMenuItem _plotMenu;
    private JMenuItem _tabulateMenu;
    private JMenuItem _refreshMenu;
    private JMenuItem _closeMenu;
    private JMenuItem _insertMenu;
    private JMenuItem _deleteMenu;
    private JMenuItem _missingSegmentsMenu;
    private JMenuItem _validationMenu;
    private JMenuItem _qualityColorLegend;
    private boolean _localDataListFile = true;
    private QualityColorBarLegendFrame _legend = null;
    private FileOpener _fileOpener = new SimpleFileOpeners();
    private JMenuItem _logoutMenu;
    private JLabel _timeZoneDisplay;
    private TimeZone _viewTimeZone;

    public DataStatusSummary(Object parent, TimeZone projectTimeZone, DataAccessFactory dataAccessFactory, int unitSystem, DssManagerBridge dssManager, DssManagerBridge remoteManager) {
        this._parent = parent;
        this._projectTimeZone = projectTimeZone;
        this._dataBrowser = new DataBrowser(dataAccessFactory, dssManager, remoteManager, new CallbackImpl(), this._projectTimeZone);
        this._viewTimeZone = this.getTimeZone();
        this._unitSystem = unitSystem;
        Image image = RmaImage.loadURLImage((String)"Images/rts32.gif");
        if (image != null) {
            this.setIconImage(image);
        }
        this.setTitle("Data Status Summary");
        this.buildMenu();
        this.buildComponents();
        ServiceLookup.getTimeZoneDisplayService().addContainer((Container)((Object)this));
    }

    public static void setShowRetainTimeWindow(boolean bShow) {
        showRetainTimeWindow = bShow;
    }

    public void setPreferences(Preferences preferences) {
        this._preferences = preferences;
        if (this._preferences.getBoolean("RetainSetting", false)) {
            String startString = this._preferences.get("startTime", "");
            String endString = this._preferences.get("endTime", "");
            HecTime startTime = new HecTime(startString);
            HecTime endTime = new HecTime(endString);
            TimeWindowDialog.getTimeWindow((HecTime)startTime, (HecTime)endTime, (Preferences)this._preferences);
            this.updateTimeWindow(startTime, endTime);
        }
    }

    private void loadDataList() {
        String nr;
        if (this._lastFileName == null && this._preferences != null) {
            this._lastFileName = this._preferences.get("LastFileName", null);
        }
        if (this._noReportHoursText.getText().trim().length() == 0 && this._preferences != null && (nr = this._preferences.get("noReportHours", "")).length() > 0) {
            this._noReportHoursText.setText(nr);
        }
        if (this._lastFileName != null && new File(this._lastFileName).exists()) {
            this.setTitle("Data Status Summary - " + RMAIO.getFileFromPath((String)this._lastFileName));
            List<String> dataList = this.readDataList(this._lastFileName);
            if (!dataList.isEmpty()) {
                this._dataStatusListFileName = this._lastFileName;
                this.setDataSetList(dataList);
            }
        }
        if (this._dataSetList.isEmpty()) {
            this._insertMode = true;
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.loadDataList();
            int ix = 50;
            int iy = 50;
            int x = -1000;
            int y = -1000;
            int width = 600;
            int height = 700;
            int w = 600;
            int h = 700;
            Dimension size = Toolkit.getDefaultToolkit().getScreenSize();
            Rectangle screenSize = new Rectangle(size);
            if (this._preferences != null) {
                x = this._preferences.getInt("x", x);
                y = this._preferences.getInt("y", y);
                w = this._preferences.getInt("width", width);
                h = this._preferences.getInt("height", height);
            }
            if (screenSize.contains(x, y)) {
                ix = x;
                iy = y;
            }
            this.setLocation(ix, iy);
            if (screenSize.contains(new Rectangle(w, h)) && w > 100 && h > 100) {
                width = w;
                height = h;
            }
            this.setSize(width, height);
        } else {
            ServiceLookup.getTimeZoneDisplayService().removeContainer((Container)((Object)this));
            this._dataBrowser.shutdown();
            this._dataBrowser.closeBrowsers();
        }
        super.setVisible(visible);
    }

    public void setLastFileName(String name) {
        this._lastFileName = name;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._insertMenu.setEnabled(this._editable);
        this._deleteMenu.setEnabled(this._editable);
        this._newMenu.setEnabled(this._editable);
        this._saveMenu.setEnabled(this._editable);
        this._saveAsMenu.setEnabled(this._editable);
    }

    public void setWaitCursor() {
        this._refreshMenu.setEnabled(false);
        this._plotMenu.setEnabled(false);
        this._tabulateMenu.setEnabled(false);
        this._missingSegmentsMenu.setEnabled(false);
        this._validationMenu.setEnabled(false);
        this._insertMenu.setEnabled(false);
        this._deleteMenu.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void setIconQualityInformation(String iconQualityInformation) {
        this._iconQualityInformation = iconQualityInformation;
    }

    public void setNoReportHours(double numberHours) {
        if (numberHours <= 0.0) {
            this._noReportHoursText.setText("");
        } else {
            HecDouble d = new HecDouble(numberHours, 1);
            String s = d.toString();
            if (s.indexOf(".0") > 0) {
                d.setPrecision(0);
                this._noReportHoursText.setText(d.toString());
            } else {
                this._noReportHoursText.setText(s);
            }
        }
    }

    public void updateTimeWindow(HecTime start, HecTime end) {
        this._startTime = start;
        if (start.isDefined()) {
            this._jTextFieldStartDate.setText(start.date(7));
            this._jTextFieldStartTime.setText(start.time());
        } else {
            this._jTextFieldStartDate.setText("");
            this._jTextFieldStartTime.setText("");
        }
        this._endTime = end;
        if (end.isDefined()) {
            this._jTextFieldEndDate.setText(end.date(7));
            this._jTextFieldEndTime.setText(end.time());
        } else {
            this._jTextFieldEndDate.setText("");
            this._jTextFieldEndTime.setText("");
        }
    }

    public void setDataSetList(List<String> nameList) {
        this._dataSetList.clear();
        this._dataSetList.addAll(DataSetInfoParser.parseDataSetList(nameList));
        this.updateList();
    }

    private void addDataSetList(List<DataSetInfo> nameList) {
        for (DataSetInfo dataSetInfo : nameList) {
            if (this._dataSetList.contains(dataSetInfo)) continue;
            this._dataSetList.add(dataSetInfo);
        }
        this.updateList();
    }

    public HecTime getStartTime() {
        return new HecTime(this._startTime);
    }

    public HecTime getEndTime() {
        return new HecTime(this._endTime);
    }

    public int getMinutesNoReport() {
        int minutesNoReport = 0;
        String noReport = this._noReportHoursText.getText().trim();
        if (noReport.length() > 0) {
            try {
                double value = Double.parseDouble(this._noReportHoursText.getText());
                minutesNoReport = (int)(value * 60.0);
                if (minutesNoReport < 0) {
                    minutesNoReport = 0;
                }
            }
            catch (RuntimeException e) {
                String mess = "Invalid number: " + this._noReportHoursText.getText();
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log(mess);
                JOptionPane.showMessageDialog((Component)((Object)this), mess, "", 2);
            }
        }
        return minutesNoReport;
    }

    public List<TimeSeriesContainer> getValidationSelectedDataSets() {
        return this.getSelectedDataSets();
    }

    public List<TimeSeriesContainer> getSelectedDataSets() {
        ArrayList<TimeSeriesContainer> containers = new ArrayList<TimeSeriesContainer>();
        int[] rows = this._table.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select data sets from the table for this operation.", "No Data Selected", 2);
            return containers;
        }
        for (int row : rows) {
            DataSetInfo info;
            if (this._dataSetList.size() <= row || !(info = this._dataSetList.get(row)).getDataRetrieved()) continue;
            containers.add(info.getTsContainer());
        }
        return containers;
    }

    public List<TimeSeriesContainer> getSelectedDataForDisplay() {
        ArrayList<TimeSeriesContainer> containers = new ArrayList<TimeSeriesContainer>();
        int[] rows = this._table.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select data sets from the table for this operation.", "No Data Selected", 2);
            return containers;
        }
        ArrayList<String> noDataNames = new ArrayList<String>();
        for (int row : rows) {
            DataSetInfo info;
            if (this._dataSetList.size() <= row || !(info = this._dataSetList.get(row)).getDataRetrieved()) continue;
            if (info.getTsContainer().numberValues > 0 && info.getTsContainer().startTime < info.getStartTime()) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)info.getTsContainer().clone();
                int count = tsc.numberValues;
                for (int j = 0; j < count && info.getStartTime() <= tsc.times[j]; ++j) {
                    tsc.numberValues = info.getTsContainer().numberValues - j;
                    tsc.values = new double[tsc.numberValues];
                    tsc.times = new int[tsc.numberValues];
                    if (info.getTsContainer().quality != null) {
                        tsc.quality = new int[tsc.numberValues];
                    }
                    tsc.startTime = info.getStartTime();
                    for (int k = 0; k < tsc.numberValues; ++k) {
                        tsc.values[k] = info.getTsContainer().values[k + j];
                        tsc.times[k] = info.getTsContainer().times[k + j];
                        if (info.getTsContainer().quality == null) continue;
                        tsc.quality[k] = info.getTsContainer().quality[k + j];
                    }
                }
                containers.add(tsc);
                continue;
            }
            if (info.getTsContainer().numberValues > 0) {
                containers.add(info.getTsContainer());
                continue;
            }
            if (info.getTsContainer().fullName.isEmpty()) {
                noDataNames.add(info.getPathname());
                continue;
            }
            noDataNames.add(info.getTsContainer().fullName);
        }
        if (!noDataNames.isEmpty()) {
            StringBuilder sb = new StringBuilder("No data for location(s):\n ");
            for (String noDataName : noDataNames) {
                sb.append("\n\t");
                sb.append(noDataName);
            }
            JOptionPane.showMessageDialog((Component)((Object)this), sb.toString(), "No Data", 1);
        }
        return containers;
    }

    public void resetCursor() {
        this._plotMenu.setEnabled(true);
        this._tabulateMenu.setEnabled(true);
        this._missingSegmentsMenu.setEnabled(true);
        this._validationMenu.setEnabled(true);
        this._refreshMenu.setEnabled(true);
        if (this._editable) {
            this._insertMenu.setEnabled(true);
            this._deleteMenu.setEnabled(true);
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public void updateStatus(List<TimeSeriesContainer> tsContainers) {
        this._tsContainers = tsContainers;
        this.processTsContainers();
        this._statusUpdated = true;
    }

    public void checkForNoReportData(DataSetInfo info, int minutesNoReport) {
        int missing = (info.getTsContainer().times[0] - this.getStartTime().value()) / minutesNoReport;
        if (missing < 0) {
            missing = 0;
        }
        for (int i = 1; i < info.getTsContainer().numberValues; ++i) {
            missing += (info.getTsContainer().times[i] - info.getTsContainer().times[i - 1] + 1) / minutesNoReport;
        }
        info.setNumberMissing(info.getNumberMissing() + missing);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object object = event.getSource();
        String action = event.getActionCommand();
        if (object == this._newMenu) {
            this.newAction();
        } else if (object == this._openMenu) {
            this.openAction();
        } else if (object == this._saveMenu) {
            this.saveAction();
        } else if (object == this._saveAsMenu) {
            this.saveAsAction();
        } else if ("Plot".equals(action)) {
            this.plotAction();
        } else if ("Tabulate".equals(action)) {
            this.tabulateAction();
        } else if ("TimeWindow".equals(action)) {
            this.setTimeWindow();
        } else if (object == this._qualityColorLegend) {
            this.openQualityColorBarLegend();
        } else if ("Missing".equals(action)) {
            this.missingSegmentsAction();
        } else if ("Validate".equals(action)) {
            this.validateData();
        } else if (object == this._refreshMenu) {
            this.refreshAction();
        } else if (object == this._logoutMenu) {
            this.logoutAction();
        } else if (object == this._closeMenu) {
            this.closeAction();
        } else if (object == this._insertMenu) {
            this.insertAction();
        } else if (object == this._deleteMenu) {
            this.deleteAction();
        } else if (object == this._noReportHoursText) {
            this.updateNoReportTime();
        }
    }

    private void validateData() {
        this._dataBrowser.validate(this, this._preferences);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ActionEvent) {
            ActionEvent event = (ActionEvent)arg;
            String eventName = event.getActionCommand();
            if (this._timeWindowDialog != null && eventName.compareTo("timesUpdated") == 0) {
                booleanContainer applyToAll = new booleanContainer();
                HecTime startTime = new HecTime();
                HecTime endTime = new HecTime();
                this._timeWindowDialog.getTimeWindow(startTime, endTime, applyToAll);
                this.updateTimeWindow(startTime, endTime);
                this.updateList();
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            int row;
            int numberSelected = this._table.getSelectedRowCount();
            if (numberSelected == 0 && (row = this._table.rowAtPoint(event.getPoint())) >= 0) {
                this._table.setRowSelectionInterval(row, row);
                numberSelected = 1;
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Plot");
            menuItem.setActionCommand("Plot");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            menuItem = new JMenuItem("Tabulate");
            menuItem.setActionCommand("Tabulate");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            menuItem = new JMenuItem("Missing Segments");
            menuItem.setActionCommand("Missing");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = new JMenuItem("Validate");
            menuItem.setActionCommand("Validate");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event)) {
            int row;
            int numberSelected = this._table.getSelectedRowCount();
            if (numberSelected == 0 && (row = this._table.rowAtPoint(event.getPoint())) >= 0) {
                this._table.setRowSelectionInterval(row, row);
                numberSelected = 1;
            }
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem("Plot");
            menuItem.setActionCommand("Plot");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            menuItem = new JMenuItem("Tabulate");
            menuItem.setActionCommand("Tabulate");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            menuItem = new JMenuItem("Missing Segments");
            menuItem.setActionCommand("Missing");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.addSeparator();
            menuItem = new JMenuItem("Validate");
            menuItem.setActionCommand("Validate");
            if (numberSelected == 0) {
                menuItem.setEnabled(false);
            }
            menuItem.addActionListener(this);
            popup.add(menuItem);
            popup.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    private boolean isTimeWindowValid() {
        return this.getStartTime().isDefined() && this.getEndTime().isDefined();
    }

    protected String getChooserFileName(boolean save) {
        ArrayList<String> v = new ArrayList<String>();
        v.add("*.dataStatus");
        Object directory = this._preferences != null ? this._preferences.get("defaultDir", "/") : "/";
        if (!((String)directory).endsWith("/")) {
            directory = (String)directory + "/";
        }
        RmiFileDialog chooser = new RmiFileDialog((Frame)((Object)this), true, (String)directory, v, false);
        FileOpener fileOpener = this._fileOpener;
        chooser.setFileOpener(fileOpener);
        chooser.setLocal(this.isLocalDataListFile());
        if (save) {
            chooser.setSaveTitle();
        } else {
            chooser.setOpenTitle();
        }
        if (this._dataStatusListFileName != null) {
            String fileName = RMAIO.getFileFromPath((String)this._dataStatusListFileName);
            chooser.setDefaultFilename(fileName);
        } else {
            chooser.setDefaultFilename("CriticalData.dataStatus");
        }
        chooser.setVisible(true);
        if (chooser.isCanceled()) {
            return null;
        }
        String name = chooser.getIdentifier().getPath();
        if (this._preferences != null) {
            this._preferences.put("defaultDir", RMAIO.getDirectoryFromPath((String)name));
        }
        return name;
    }

    public String openFileDialog(String title, String directory, boolean newFile) {
        JFileChooser chooser = directory != null ? new JFileChooser(directory) : new JFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setDialogTitle(title);
        if (newFile) {
            chooser.setApproveButtonText("Create");
        }
        FileNameExtensionFilter filter = new FileNameExtensionFilter("*.dataStatus", LIST_EXTENSION);
        chooser.addChoosableFileFilter(filter);
        int option = chooser.showSaveDialog((Component)((Object)this));
        if (option != 0) {
            return null;
        }
        File file = chooser.getSelectedFile();
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public void setFileOpener(FileOpener fileOpener) {
        this._fileOpener = fileOpener;
    }

    protected List<String> getCurrentList() {
        this.stopEditing();
        return DataSetInfoParser.serializeDataSetInfo(this._dataSetList);
    }

    protected void buildMenu() {
        JMenuBar menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        menuBar.add(fileMenu);
        this._newMenu = new JMenuItem("New");
        this._newMenu.setMnemonic('N');
        this._newMenu.addActionListener(this);
        this._newMenu.setEnabled(this._editable);
        fileMenu.add(this._newMenu);
        this._openMenu = new JMenuItem("Open...");
        this._openMenu.setMnemonic('O');
        this._openMenu.addActionListener(this);
        this._openMenu.setEnabled(true);
        fileMenu.add(this._openMenu);
        this._saveMenu = new JMenuItem("Save");
        this._saveMenu.setMnemonic('S');
        this._saveMenu.addActionListener(this);
        this._saveMenu.setEnabled(false);
        fileMenu.add(this._saveMenu);
        this._saveAsMenu = new JMenuItem("Save As...");
        this._saveAsMenu.setMnemonic('A');
        this._saveAsMenu.addActionListener(this);
        this._saveAsMenu.setEnabled(true);
        fileMenu.add(this._saveAsMenu);
        fileMenu.addSeparator();
        this._logoutMenu = new JMenuItem("Logout...");
        this._logoutMenu.setMnemonic('L');
        this._logoutMenu.addActionListener(this);
        this._logoutMenu.setEnabled(true);
        fileMenu.add(this._logoutMenu);
        this._closeMenu = new JMenuItem("Close");
        this._closeMenu.setMnemonic('C');
        this._closeMenu.addActionListener(this);
        this._closeMenu.setEnabled(true);
        fileMenu.add(this._closeMenu);
        JMenu editMenu = new JMenu("Edit");
        editMenu.setMnemonic('E');
        menuBar.add(editMenu);
        this._insertMenu = new JMenuItem("Insert Row(s)");
        this._insertMenu.setMnemonic('I');
        this._insertMenu.addActionListener(this);
        this._insertMenu.setEnabled(this._editable);
        editMenu.add(this._insertMenu);
        this._deleteMenu = new JMenuItem("Delete Row(s)");
        this._deleteMenu.setMnemonic('D');
        this._deleteMenu.addActionListener(this);
        this._deleteMenu.setEnabled(this._editable);
        editMenu.add(this._deleteMenu);
        if (ServerSuiteUtil.isConnected()) {
            editMenu.addSeparator();
            JMenuItem menuItem = new JMenuItem("Browse CWMSVue...", 66);
            menuItem.addActionListener(this::browseOracle);
            editMenu.add(menuItem);
        }
        JMenu radarMenuItem = new JMenu("Browse CWMS Data API...");
        radarMenuItem.setToolTipText("Setup CWMS Data API data sources through the CWMS Login Setup dialog");
        editMenu.add(radarMenuItem);
        CwmsLoginUtil.buildPreferenceServers().stream().filter(c -> c.getLookup().equals("cwms/radar/http")).map(this::browseRadar).forEach(radarMenuItem::add);
        JMenuItem menuItem = new JMenuItem("Browse DSS...", 68);
        menuItem.addActionListener(this::browseDss);
        editMenu.add(menuItem);
        JMenu viewMenu = new JMenu("View");
        viewMenu.setMnemonic('V');
        menuBar.add(viewMenu);
        this._plotMenu = new JMenuItem("Plot");
        this._plotMenu.setMnemonic('P');
        this._plotMenu.addActionListener(this);
        this._plotMenu.setActionCommand("Plot");
        this._plotMenu.setEnabled(false);
        viewMenu.add(this._plotMenu);
        this._tabulateMenu = new JMenuItem("Tabulate");
        this._tabulateMenu.setMnemonic('T');
        this._tabulateMenu.addActionListener(this);
        this._tabulateMenu.setActionCommand("Tabulate");
        this._tabulateMenu.setEnabled(false);
        viewMenu.add(this._tabulateMenu);
        this._missingSegmentsMenu = new JMenuItem("Missing Segments");
        this._missingSegmentsMenu.setMnemonic('M');
        this._missingSegmentsMenu.addActionListener(this);
        this._missingSegmentsMenu.setActionCommand("Missing");
        this._missingSegmentsMenu.setEnabled(false);
        viewMenu.add(this._missingSegmentsMenu);
        viewMenu.addSeparator();
        this._validationMenu = new JMenuItem("Validate");
        this._validationMenu.setMnemonic('V');
        this._validationMenu.addActionListener(this);
        this._validationMenu.setActionCommand("Validate");
        viewMenu.add(this._validationMenu);
        viewMenu.addSeparator();
        this._qualityColorLegend = new JMenuItem("Quality Color Legend", 81);
        this._qualityColorLegend.addActionListener(this);
        viewMenu.add(this._qualityColorLegend);
        viewMenu.addSeparator();
        JMenuItem miTimeWindow = new JMenuItem("Time Window...");
        miTimeWindow.addActionListener(this);
        miTimeWindow.setActionCommand("TimeWindow");
        viewMenu.add(miTimeWindow);
        this._refreshMenu = new JMenuItem("Refresh");
        this._refreshMenu.setMnemonic('R');
        this._refreshMenu.addActionListener(this);
        this._refreshMenu.setEnabled(true);
        KeyStroke f5 = KeyStroke.getKeyStroke(116, 0);
        this._refreshMenu.setAccelerator(f5);
        viewMenu.add(this._refreshMenu);
        this.setJMenuBar(menuBar);
    }

    protected void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        JPanel jPanel1 = new JPanel();
        jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(20, 50, 0, 50);
        gbc.fill = 2;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(jPanel1, gbc);
        this.getContentPane().add(jPanel1);
        JLabel jLabelStartDate = new JLabel();
        jLabelStartDate.setText("Start Date:");
        jLabelStartDate.setFont(new Font("Dialog", 0, 12));
        jLabelStartDate.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(jLabelStartDate, gbc);
        jPanel1.add(jLabelStartDate);
        this._jTextFieldStartDate = new JLabel();
        this._jTextFieldStartDate.setFont(new Font("Dialog", 0, 12));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 2;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(this._jTextFieldStartDate, gbc);
        jPanel1.add(this._jTextFieldStartDate);
        JLabel jLabelStartTime = new JLabel();
        jLabelStartTime.setText("Start Time:");
        jLabelStartTime.setFont(new Font("Dialog", 0, 12));
        jLabelStartTime.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.insets = new Insets(0, 10, 0, 0);
        gbc.fill = 0;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(jLabelStartTime, gbc);
        jPanel1.add(jLabelStartTime);
        this._jTextFieldStartTime = new JLabel();
        this._jTextFieldStartTime.setFont(new Font("Dialog", 0, 12));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.fill = 2;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(this._jTextFieldStartTime, gbc);
        jPanel1.add(this._jTextFieldStartTime);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        jPanel1.add((Component)new JLabel(" "), gbc);
        JLabel jLabelEndDate = new JLabel();
        jLabelEndDate.setText("End Date:");
        jLabelEndDate.setFont(new Font("Dialog", 0, 12));
        jLabelEndDate.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.fill = 0;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(jLabelEndDate, gbc);
        jPanel1.add(jLabelEndDate);
        this._jTextFieldEndDate = new JLabel();
        this._jTextFieldEndDate.setBounds(96, 80, 108, 24);
        this._jTextFieldEndDate.setFont(new Font("Dialog", 0, 12));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 5, 0, 0);
        gbc.fill = 2;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(this._jTextFieldEndDate, gbc);
        jPanel1.add(this._jTextFieldEndDate);
        JLabel jLabelEndTime = new JLabel();
        jLabelEndTime.setText("End Time:");
        jLabelEndTime.setFont(new Font("Dialog", 0, 12));
        jLabelEndTime.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.insets = new Insets(10, 10, 0, 0);
        gbc.fill = 0;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(jLabelEndTime, gbc);
        jPanel1.add(jLabelEndTime);
        this._jTextFieldEndTime = new JLabel();
        this._jTextFieldEndTime.setFont(new Font("Dialog", 0, 12));
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(10, 5, 0, 0);
        gbc.fill = 2;
        ((GridBagLayout)jPanel1.getLayout()).setConstraints(this._jTextFieldEndTime, gbc);
        jPanel1.add(this._jTextFieldEndTime);
        gbc = new GridBagConstraints();
        gbc.gridx = 4;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        jPanel1.add((Component)new JLabel(" "), gbc);
        JLabel label = new JLabel("Time Zone:");
        label.setFont(new Font("Dialog", 0, 12));
        label.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = new Insets(10, 0, 0, 0);
        gbc.fill = 0;
        jPanel1.add((Component)label, gbc);
        this._timeZoneDisplay = new JLabel();
        this._timeZoneDisplay.setText(this.getTimeZone().getID());
        this._timeZoneDisplay.setFont(new Font("Dialog", 0, 12));
        this._timeZoneDisplay.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.insets = new Insets(10, 10, 0, 0);
        gbc.fill = 2;
        jPanel1.add((Component)this._timeZoneDisplay, gbc);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(15, 50, 0, 50);
        gbc.fill = 2;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(jPanel2, gbc);
        this.getContentPane().add(jPanel2);
        JLabel jLabelshowNoReport = new JLabel();
        jLabelshowNoReport.setText("Consider missing when no report after  ");
        jLabelshowNoReport.setFont(new Font("Dialog", 0, 12));
        jLabelshowNoReport.setForeground(Color.black);
        gbc = new GridBagConstraints();
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 0;
        ((GridBagLayout)jPanel2.getLayout()).setConstraints(jLabelshowNoReport, gbc);
        jPanel2.add(jLabelshowNoReport);
        this._noReportHoursText = new JTextField();
        this._noReportHoursText.addActionListener(this);
        this._noReportHoursText.setFont(new Font("Dialog", 0, 12));
        this._noReportHoursText.setForeground(new Color(0));
        this._noReportHoursText.setColumns(4);
        this._noReportHoursText.setHorizontalAlignment(4);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.fill = 0;
        ((GridBagLayout)jPanel2.getLayout()).setConstraints(this._noReportHoursText, gbc);
        jPanel2.add(this._noReportHoursText);
        JLabel hoursLabel = new JLabel("   hours");
        hoursLabel.setLabelFor(this._noReportHoursText);
        hoursLabel.setFont(new Font("Dialog", 0, 12));
        hoursLabel.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.fill = 0;
        ((GridBagLayout)jPanel2.getLayout()).setConstraints(hoursLabel, gbc);
        jPanel2.add(hoursLabel);
        gbc = new GridBagConstraints();
        gbc.gridx = 3;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        jPanel2.add((Component)new JLabel(" "), gbc);
        this._tableModel = new DataStatusTableModel(this);
        this._table = new RmaJTable((Component)((Object)this));
        this._table.setModel((TableModel)this._tableModel);
        this._table.setDefaultRenderer(JLabel.class, (TableCellRenderer)new DataStatusSummaryTableCellRenderer());
        this._table.setDefaultRenderer(String.class, (TableCellRenderer)new RmaCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                String pathValue = DataStatusSummary.this._tableModel.getToolTipText(row, column);
                this.setToolTipText(pathValue);
                return c;
            }
        });
        JScrollPane scrollPane = new JScrollPane((Component)this._table);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(20, 15, 20, 15);
        gbc.fill = 1;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(scrollPane, gbc);
        this.getContentPane().add(scrollPane);
        TableColumn column = this._table.getColumnModel().getColumn(0);
        column.setPreferredWidth(220);
        column = this._table.getColumnModel().getColumn(1);
        column.setPreferredWidth(160);
        column = this._table.getColumnModel().getColumn(2);
        column.setPreferredWidth(50);
        column = this._table.getColumnModel().getColumn(3);
        column.setPreferredWidth(112);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                Object object = event.getSource();
                if (object == DataStatusSummary.this) {
                    DataStatusSummary.this.DataStatusSummary_WindowClosing(event);
                }
            }
        });
        this._table.addMouseListener((MouseListener)this);
    }

    public void updateList() {
        this.stopEditing();
        this._table.clearSelection();
        if (this._insertMode) {
            this._insertMode = false;
        }
        if (this._dataSetList.isEmpty()) {
            this._insertMode = true;
            this._tableModel.fireTableDataChanged();
            return;
        }
        this._tableModel.fireTableDataChanged();
        boolean valid = this.isTimeWindowValid();
        if (!valid) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Time Window is invalid - start time or end time is undefined. Data sets will not be updated");
            return;
        }
        HecTime adjustedStartTime = new HecTime(this.getStartTime());
        int minutes = this.getMinutesNoReport();
        adjustedStartTime.subtract(minutes);
        this._dataSetList.removeIf(d -> d.getPathname().isEmpty());
        for (DataSetInfo dataSetInfo : this._dataSetList) {
            dataSetInfo.setDataRetrieved(false);
            dataSetInfo.setIsEarliest(false);
            dataSetInfo.setNumberMissing(-1);
            dataSetInfo.getLastTime().setUndefined();
            dataSetInfo.setNoReportStartTime(adjustedStartTime.value());
            dataSetInfo.setStartTime(this.getStartTime().value());
            dataSetInfo.setEndTime(this.getEndTime().value());
            dataSetInfo.getQualityColorBar().clearData();
            dataSetInfo.getQualityColorBar().setXLimits(this.getStartTime().value(), this.getEndTime().value());
        }
        this.setWaitCursor();
        this._dataBrowser.retrieveData(this._dataSetList, this.getStartTime(), this.getEndTime(), this.getTimeZone(), this._unitSystem).whenComplete((o, t) -> this.resetCursor());
    }

    protected void processTsContainers() {
        int minutesNoReport = this.getMinutesNoReport();
        block0: for (DataSetInfo dataSetInfo : this._dataSetList) {
            for (TimeSeriesContainer tsContainer : this._tsContainers) {
                if (!this.tscMatches(dataSetInfo, tsContainer)) continue;
                tsContainer.convertTimeZone(this.getTimeZone());
                dataSetInfo.setTsContainer((TimeSeriesContainer)tsContainer.clone());
                if (this._iconQualityInformation != null) {
                    dataSetInfo.getQualityColorBar().setColorSettings(this._iconQualityInformation);
                }
                dataSetInfo.getQualityColorBar().setData(dataSetInfo.getTsContainer());
                double noReport = (double)minutesNoReport / 60.0;
                dataSetInfo.getQualityColorBar().setNoReportHours(noReport);
                continue block0;
            }
        }
        HecTime earliestTime = new HecTime();
        HecTime lastTime = new HecTime();
        for (DataSetInfo info : this._dataSetList) {
            int j;
            info.setDataRetrieved(true);
            int numberValues = info.getTsContainer().numberValues;
            if (numberValues > 0) {
                for (j = info.getTsContainer().numberValues - 1; j >= 0 && !RMAConst.isValidValue((double)info.getTsContainer().values[j]); --j) {
                    --numberValues;
                }
            }
            if (numberValues > 0) {
                info.setNumberMissing(0);
                for (j = 0; j < numberValues; ++j) {
                    if (RMAConst.isValidValue((double)info.getTsContainer().values[j])) continue;
                    info.setNumberMissing(info.getNumberMissing() + 1);
                }
                if (info.getTsContainer().interval == 0 && minutesNoReport > 0) {
                    this.checkForNoReportData(info, minutesNoReport);
                }
                lastTime.set(info.getTsContainer().times[numberValues - 1]);
                this.processTimeZone(lastTime, info.getTsContainer());
                info.getLastTime().set(lastTime);
                if (!earliestTime.isDefined()) {
                    earliestTime.set(info.getLastTime());
                    continue;
                }
                if (!earliestTime.greaterThan(info.getLastTime())) continue;
                earliestTime.set(info.getLastTime());
                continue;
            }
            info.getLastTime().setUndefined();
        }
        for (DataSetInfo info : this._dataSetList) {
            if (!earliestTime.equalTo(info.getLastTime())) continue;
            info.setIsEarliest(true);
        }
        this._tableModel.fireTableRowsUpdated(0, this._tableModel.getRowCount());
        this._table.invalidate();
        this._table.validate();
    }

    private boolean tscMatches(DataSetInfo dataSetInfo, TimeSeriesContainer tsContainer) {
        String infoName = dataSetInfo.getPathname().toLowerCase();
        String tscName = tsContainer.fullName.toLowerCase();
        boolean pathnamesMatch = tscName.equalsIgnoreCase(infoName);
        boolean dataSourcesMatch = false;
        if (pathnamesMatch) {
            Optional<DataAccessFactory> dataAccessFactory;
            if (dataSetInfo instanceof DataSetInfo.DssDataSetInfo) {
                String dataSourceLocation = ((DataSetInfo.DssDataSetInfo)dataSetInfo).getDataSourceLocation();
                if (dataSourceLocation.toLowerCase().contains(RemoteServerEnum.DSS_FILE_MANAGER.getRemoteName().toLowerCase())) {
                    String[] split = dataSourceLocation.split(":");
                    dataSourceLocation = split[split.length - 1];
                }
                dataSourcesMatch = Objects.equals(Paths.get(tsContainer.fileName, new String[0]), Paths.get(dataSourceLocation, new String[0]));
            } else if (dataSetInfo instanceof DataSetInfo.CwmsDataSetInfo && (dataAccessFactory = this._dataBrowser.findDataAccessFactory((DataSetInfo.CwmsDataSetInfo)dataSetInfo)).isPresent()) {
                try {
                    dataSourcesMatch = Objects.equals(tsContainer.fileName, dataAccessFactory.get().getDataSourceUrl());
                }
                catch (DbConnectionException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to obtain data source URL from: " + dataSetInfo.getDataSourceName());
                }
            }
        }
        return pathnamesMatch && dataSourcesMatch;
    }

    protected List<String> readDataList(String fullFileName) {
        ArrayList<String> dataList = new ArrayList<String>();
        if (this._fileOpener != null) {
            Identifier id = this._fileOpener.openFile(new Identifier(fullFileName), false);
            if (id != null) {
                HecFile file = id.getFile();
                try (BufferedReader in = file.getBufferedReader();){
                    String line;
                    while ((line = in.readLine()) != null) {
                        if (line.startsWith("#")) continue;
                        dataList.add(line.trim());
                    }
                }
                catch (IOException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error while reading file " + fullFileName + ".");
                }
            } else {
                ((FluentLogger.Api)LOGGER.atSevere()).log("Failed to open file {0}.", (Object)fullFileName);
            }
        } else {
            ((FluentLogger.Api)LOGGER.atSevere()).log("Unable to open file {0}. No FileOpener specified.", (Object)fullFileName);
        }
        return dataList;
    }

    protected int saveDataStatusList(Identifier id, List<String> dataList) {
        block14: {
            if (id != null) {
                String mess;
                int n;
                HecFile file = id.getFile();
                if (!file.canWrite() && file.exists()) {
                    String mess2 = file.getName() + " is not writable.";
                    JOptionPane.showMessageDialog((Component)((Object)this), mess2, "Error on Write", 0);
                    return -3;
                }
                if (file.exists() && (n = JOptionPane.showConfirmDialog((Component)((Object)this), mess = file.getName() + " already exists.\nDo you want to replace it?", "Save", 0)) == 1) {
                    try {
                        file.close();
                    }
                    catch (IOException | RuntimeException e) {
                        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to close file: " + file);
                    }
                    return -2;
                }
                try (BufferedWriter out = file.getBufferedWriter();){
                    for (String s : dataList) {
                        out.write(s);
                        out.newLine();
                    }
                    break block14;
                }
                catch (IOException | RuntimeException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to read file: " + file);
                    return -1;
                }
            }
            return -1;
        }
        return 0;
    }

    protected void openQualityColorBarLegend() {
        QualityColorBar colorBar = new QualityColorBar();
        if (this._iconQualityInformation != null) {
            colorBar.setColorSettings(this._iconQualityInformation);
        } else {
            colorBar.setColorSettings("");
        }
        int minutesNoReport = this.getMinutesNoReport();
        double noReport = (double)minutesNoReport / 60.0;
        colorBar.setNoReportHours(noReport);
        String params = colorBar.getAllColorSettings();
        if (this._legend == null) {
            this._legend = new QualityColorBarLegendFrame(params);
            this._legend.setIconImage(this.getIconImage());
        } else {
            this._legend.setParameterString(params);
        }
        this._legend.setVisible(true);
    }

    protected void updateNoReportTime() {
        if (this._statusUpdated) {
            this.processTsContainers();
            this._statusUpdated = false;
        }
    }

    protected void newAction() {
        this._dataStatusListFileName = null;
        this.setTitle("Data Status Summary");
        this.setDataSetList(new ArrayList<String>());
    }

    protected void openAction() {
        String fullFileName = this.getChooserFileName(false);
        if (fullFileName != null) {
            this._dataBrowser.cancelRetrieval();
            this._dataStatusListFileName = fullFileName;
            List<String> dataList = this.readDataList(this._dataStatusListFileName);
            this.setDataSetList(dataList);
            if (!dataList.isEmpty() && this._preferences != null) {
                String fileName = RMAIO.getFileFromPath((String)this._dataStatusListFileName);
                this._preferences.put("LastFileName", this._dataStatusListFileName);
                this.setLastFileName(this._dataStatusListFileName);
                this.setTitle("Data Status Summary - " + fileName);
            }
        }
    }

    protected int saveAction() {
        int status;
        if (this._dataStatusListFileName == null) {
            return this.saveAsAction();
        }
        List<String> list = this.getCurrentList();
        if (this._fileOpener == null) {
            return -1;
        }
        Identifier id = this._fileOpener.openFile(new Identifier(this._dataStatusListFileName), false);
        if (id == null) {
            id = this._fileOpener.createFile(new Identifier(this._dataStatusListFileName));
        }
        if ((status = this.saveDataStatusList(id, list)) == 0) {
            String fileName = RMAIO.getFileFromPath((String)this._dataStatusListFileName);
            JOptionPane.showMessageDialog((Component)((Object)this), "Data status summary list " + fileName + " saved.", "", 1);
            this._dataListChanged = false;
        } else if (status == -1) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Unable to save data status summary list to " + this._dataStatusListFileName, "", 2);
        }
        return status;
    }

    protected int saveAsAction() {
        int status = -1;
        List<String> list = this.getCurrentList();
        if (list.isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Nothing in the list.", "", 2);
            return status;
        }
        String fullFileName = this.getChooserFileName(true);
        if (fullFileName != null) {
            this._dataStatusListFileName = fullFileName.endsWith(LIST_EXTENSION) ? fullFileName : fullFileName + LIST_EXTENSION;
            status = this.saveAction();
            if (status == 0 && this._preferences != null) {
                this._preferences.put("LastFileName", this._dataStatusListFileName);
                this.setLastFileName(this._dataStatusListFileName);
            }
        }
        return status;
    }

    protected void setTimeWindow() {
        this.createTimeWindowDialog();
        this._timeWindowDialog.toFront();
        this._timeWindowDialog.setVisible(true);
    }

    protected void createTimeWindowDialog() {
        if (this._preferences == null) {
            this._preferences = Preferences.userNodeForPackage(this.getClass());
        }
        if (this._timeWindowDialog == null) {
            this._timeWindowDialog = showRetainTimeWindow ? new TimeWindowDialog((Window)((Object)this), "Set Time Window", this._preferences, false, false) : new TimeWindowDialog((Window)((Object)this), "Set Time Window", this._preferences, false, false){

                protected void buildRetainSettings() {
                }

                protected void init() {
                    super.init();
                    this.setSelectionType(2, true);
                }
            };
            this._timeWindowDialog.addObserver((Observer)this);
            this._timeWindowDialog.setLocation(100, 100);
        }
    }

    protected void plotAction() {
        List<TimeSeriesContainer> containers = this.getSelectedDataForDisplay();
        if (!containers.isEmpty()) {
            Vector<TimeSeriesContainer> timeSeriesContainers = new Vector<TimeSeriesContainer>(containers);
            TimeSeriesContainerTimeZoneCheck.checkTimezone(timeSeriesContainers);
            G2dDialog gfxdlg = new G2dDialog((Frame)((Object)this), containers.get((int)0).fullName, false, timeSeriesContainers);
            gfxdlg.setLocation(75, 75);
            gfxdlg.setIconImage(this.getIconImage());
            gfxdlg.setVisible(true);
        }
    }

    protected void tabulateAction() {
        HecDataTableFrame tabulateTable;
        int status;
        List<TimeSeriesContainer> containers = this.getSelectedDataForDisplay();
        if (!containers.isEmpty() && (status = (tabulateTable = new HecDataTableFrame((Object)this)).setData(containers)) == 0) {
            String timezone;
            TimeSeriesContainer obj = containers.get(0);
            if (obj != null && (timezone = this.getTimeZone().getDisplayName(false, 0)) != null && timezone.length() > 2) {
                tabulateTable.setTableTitleText(timezone);
            }
            tabulateTable.allowEditing(false);
            tabulateTable.setLocation(50, 50);
            tabulateTable.setIconImage(this.getIconImage());
            tabulateTable.setVisible(true);
        }
    }

    protected void missingSegmentsAction() {
        int minutesNoReport = this.getMinutesNoReport();
        List<TimeSeriesContainer> containers = this.getSelectedDataSets();
        if (containers.isEmpty()) {
            return;
        }
        JFrame missingFrame = new JFrame("Missing Data Segments");
        missingFrame.setIconImage(this.getIconImage());
        missingFrame.getContentPane().setLayout(new BorderLayout());
        MissingDataScrollPanel mainPanel = new MissingDataScrollPanel(missingFrame);
        mainPanel.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane(mainPanel);
        missingFrame.getContentPane().add((Component)scrollPane, "North");
        int i = 0;
        while (i < containers.size()) {
            TimeSeriesContainer tsContainer = containers.get(i);
            List<JLabel[]> missingTableInfo = this.processMissingSegments(tsContainer, minutesNoReport);
            MissingDataTableModel missingModel = new MissingDataTableModel(missingTableInfo);
            JTable missingDataTable = new JTable(missingModel);
            missingDataTable.setDefaultRenderer(JLabel.class, new DataStatusSummaryTableCellRenderer());
            JPanel missingPanel = new JPanel();
            missingPanel.setLayout(new BorderLayout());
            missingPanel.setBorder(new EtchedBorder());
            missingPanel.add((Component)new JLabel(" " + tsContainer.fullName), "North");
            if (!missingTableInfo.isEmpty()) {
                missingPanel.add((Component)missingDataTable.getTableHeader(), "Center");
                missingPanel.add((Component)missingDataTable, "South");
            } else if (tsContainer.numberValues == 0) {
                missingPanel.add((Component)new JLabel(" -- No Data -- "), "Center");
            } else {
                missingPanel.add((Component)new JLabel(" -- No Missing Data -- "), "Center");
            }
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.gridx = 0;
            gbc.gridy = i++;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(0, 0, 10, 0);
            ((GridBagLayout)mainPanel.getLayout()).setConstraints(missingPanel, gbc);
            mainPanel.add(missingPanel);
        }
        missingFrame.setSize(500, 300);
        missingFrame.setLocation(75, 75);
        missingFrame.setVisible(true);
    }

    protected void refreshAction() {
        this.updateList();
    }

    public void setStandalone(boolean standalone) {
        this._standalone = standalone;
    }

    protected void logoutAction() {
    }

    protected void closeAction() {
        this.closeAction(true);
    }

    protected void closeAction(boolean bExit) {
        int status;
        int n;
        this.stopEditing();
        if (this._dataListChanged && ((n = JOptionPane.showConfirmDialog((Component)((Object)this), "Save changes?", "", 1)) == 0 ? (status = this.saveAsAction()) != 0 : n == 2)) {
            return;
        }
        this._dataBrowser.cancelRetrieval();
        Point p = this.getLocation();
        Dimension d = this.getSize();
        if (this._preferences != null) {
            if (this._lastFileName != null) {
                this._preferences.put("LastFileName", this._lastFileName);
            }
            this._preferences.putInt("x", p.x);
            this._preferences.putInt("y", p.y);
            this._preferences.putInt("width", d.width);
            this._preferences.putInt("height", d.height);
            this._preferences.put("noReportHours", this._noReportHoursText.getText().trim());
            try {
                this._preferences.flush();
            }
            catch (BackingStoreException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to save DataStatusSummary preferences");
            }
        }
        this.setVisible(false);
        if (this._standalone && bExit) {
            System.exit(0);
        }
        this.dispose();
    }

    protected void insertAction() {
        this.stopEditing();
        int[] rows = this._table.getSelectedRows();
        this._tableModel.insertRows(rows);
        this._table.clearSelection();
    }

    protected void deleteAction() {
        this.stopEditing();
        int[] rows = this._table.getSelectedRows();
        int status = this._tableModel.deleteRows(rows);
        if (status != 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select data sets from the table for this operation.", "No Data Selected", 2);
        }
        this._table.clearSelection();
    }

    protected void stopEditing() {
        AbstractCellEditor cellEditor = (AbstractCellEditor)((Object)this._table.getCellEditor());
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
    }

    protected List<JLabel[]> processMissingSegments(TimeSeriesContainer tsContainer, int minutesNoReport) {
        JLabel[] missingInfo;
        double hours;
        int i;
        ArrayList<JLabel[]> missingTableInfo = new ArrayList<JLabel[]>();
        HecDouble hecDoubleHours = new HecDouble();
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        int missing = 0;
        for (i = 0; i < tsContainer.numberValues; ++i) {
            if (tsContainer.values[i] == -3.4028234663852886E38) {
                if (missing == 0) {
                    start.set(tsContainer.times[i]);
                }
                ++missing;
                continue;
            }
            if (missing <= 0) continue;
            end.set(tsContainer.times[i]);
            hours = (double)(end.value() - start.value()) / 60.0;
            hecDoubleHours.set(hours, 1);
            missingInfo = new JLabel[4];
            this.processTimeZone(start, tsContainer);
            this.processTimeZone(end, tsContainer);
            missingInfo[0] = new JLabel(Integer.toString(missing));
            missingInfo[1] = new JLabel(hecDoubleHours.toString());
            missingInfo[2] = new JLabel(start.toString(14));
            missingInfo[3] = new JLabel(end.toString(14));
            missingTableInfo.add(missingInfo);
            missing = 0;
        }
        if (tsContainer.interval == 0 && minutesNoReport > 0) {
            for (i = 0; i < tsContainer.numberValues; ++i) {
                missing = i == 0 ? (tsContainer.times[0] - this.getStartTime().value()) / minutesNoReport : (tsContainer.times[i] - tsContainer.times[i - 1] + 1) / minutesNoReport;
                if (missing <= 0) continue;
                if (i == 0) {
                    hours = (double)(tsContainer.times[0] - this.getStartTime().value()) / 60.0;
                    start.set(this.getStartTime());
                } else {
                    hours = (double)(tsContainer.times[i] - tsContainer.times[i - 1]) / 60.0;
                    start.set(tsContainer.times[i - 1]);
                }
                hecDoubleHours.set(hours, 1);
                end.set(tsContainer.times[i]);
                missingInfo = new JLabel[4];
                this.processTimeZone(start, tsContainer);
                this.processTimeZone(end, tsContainer);
                missingInfo[0] = new JLabel(Integer.toString(missing));
                missingInfo[1] = new JLabel(hecDoubleHours.toString());
                missingInfo[2] = new JLabel(start.toString(14));
                missingInfo[3] = new JLabel(end.toString(14));
                missingTableInfo.add(missingInfo);
            }
        }
        return missingTableInfo;
    }

    protected void DataStatusSummary_WindowClosing(WindowEvent event) {
        this.closeAction(true);
    }

    private void processTimeZone(HecTime time, TimeSeriesContainer tsContainer) {
        String timeZoneID = tsContainer.getTimeZoneID();
        TimeZone timeZone = TimeZone.getTimeZone(timeZoneID);
        HecTime.convertTimeZone((HecTime)time, (TimeZone)timeZone, (TimeZone)this.getTimeZone());
    }

    public boolean isLocalDataListFile() {
        return this._localDataListFile;
    }

    public void setLocalDataListFile(boolean localDataListFile) {
        this._localDataListFile = localDataListFile;
    }

    JMenuItem getSaveMenu() {
        return this._saveMenu;
    }

    public void showLogoutMenu(boolean show, boolean enable) {
        if (this._logoutMenu != null) {
            this._logoutMenu.setVisible(show);
            this._logoutMenu.setEnabled(enable);
        }
    }

    private void browseOracle(ActionEvent e) {
        this._table.commitEdit(true);
        this._table.setModified(false);
        this._dataBrowser.browseOracle(this._dataSetList);
    }

    private JMenuItem browseRadar(CwmsAuthenticationSource r) {
        JMenuItem radarInstanceMenuItem = new JMenuItem(r.getDisplayName());
        radarInstanceMenuItem.addActionListener(e -> {
            this._table.commitEdit(true);
            this._table.setModified(false);
            this._dataBrowser.browseRadar(r, this._dataSetList);
        });
        radarInstanceMenuItem.setToolTipText(r.getServerInfo().getUrl());
        return radarInstanceMenuItem;
    }

    private void browseDss(ActionEvent e) {
        this._table.commitEdit(true);
        this._table.setModified(false);
        this._dataBrowser.browseDss(this._dataSetList);
    }

    public void setTimeZone(TimeZone tz) {
        TimeZone newViewedTimeZone = this.getTimeZone();
        if (this._startTime.isDefined() && this._endTime.isDefined()) {
            HecTime newStart = HecTime.convertToTimeZone((HecTime)this._startTime, (TimeZone)this._viewTimeZone, (TimeZone)newViewedTimeZone);
            HecTime newEnd = HecTime.convertToTimeZone((HecTime)this._endTime, (TimeZone)this._viewTimeZone, (TimeZone)newViewedTimeZone);
            this.updateTimeWindow(newStart, newEnd);
        }
        this._viewTimeZone = newViewedTimeZone;
        this._timeZoneDisplay.setText(newViewedTimeZone.getID());
        this.refreshAction();
    }

    public TimeZone getTimeZone() {
        return ServiceLookup.getTimeZoneDisplayService().getDisplayTimeZone().orElse(this._projectTimeZone);
    }

    public List<DataSource> getValidationSelectedDataSources() {
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        int[] rows = this._table.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select data sets from the table for this operation.", "No Data Selected", 2);
            return dataSources;
        }
        for (int row : rows) {
            DataSetInfo info;
            if (this._dataSetList.size() <= row || !(info = this._dataSetList.get(row)).getDataRetrieved()) continue;
            try {
                if (info instanceof DataSetInfo.CwmsDataSetInfo) {
                    ServerSuite serverSuite = ServerSuiteUtil.getServerSuite();
                    CwmsAuthenticationSource cwmsAuthenticationSource = ((DataSetInfo.CwmsDataSetInfo)info).getCwmsAuthenticationSource().orElse(Optional.ofNullable(serverSuite).map(ServerSuite::getServer).orElse(null));
                    if (cwmsAuthenticationSource == null) continue;
                    TimeSeriesContainer timeSeriesContainer = info.getTsContainer();
                    String officeId = ((DataSetInfo.CwmsDataSetInfo)info).getOfficeId();
                    TimeSeriesIdentifier desc = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(officeId), (String)timeSeriesContainer.getFullName(), null);
                    TimeSeriesTemplate template = new TimeSeriesTemplate(desc);
                    ValidationDataSource dataSource = new ValidationDataSource(template, cwmsAuthenticationSource);
                    dataSources.add(dataSource);
                    continue;
                }
                TimeSeriesContainer timeSeriesContainer = info.getTsContainer();
                TsContainerDataSource dataSource = new TsContainerDataSource(timeSeriesContainer, null);
                String rawFullName = dataSource.getRawFullName();
                if (rawFullName != null) {
                    DSSIdentifier dssId = new DSSIdentifier(timeSeriesContainer.fileName, rawFullName);
                    dssId.setStartTime(timeSeriesContainer.getStartTime());
                    dssId.setEndTime(timeSeriesContainer.getEndTime());
                    DSSPathAndFilename dssPathAndFilename = new DSSPathAndFilename();
                    dssPathAndFilename.setFilename(timeSeriesContainer.fileName);
                    dssPathAndFilename.setPathname(rawFullName);
                    DataSetInfo.DssDataSetInfo dssDataSetInfo = new DataSetInfo.DssDataSetInfo(dssPathAndFilename);
                    dssDataSetInfo.setStartTime(timeSeriesContainer.getStartTime().value());
                    dssDataSetInfo.setNoReportStartTime(timeSeriesContainer.getStartTime().value());
                    dssDataSetInfo.setEndTime(timeSeriesContainer.getEndTime().value());
                }
                dataSources.add(dataSource);
            }
            catch (RuntimeException | DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Unable to process TimeSeriesContainer: " + info + " for data validation");
            }
        }
        return dataSources;
    }

    private class CallbackImpl
    implements DataBrowser.Callback {
        private CallbackImpl() {
        }

        @Override
        public void dataSetInfoAdded(List<DataSetInfo> dataSetInfo) {
            DataStatusSummary.this.addDataSetList(dataSetInfo);
        }

        @Override
        public void dataSetInfoListUpdated(List<TimeSeriesContainer> timeSeriesContainers) {
            DataStatusSummary.this.updateStatus(timeSeriesContainers);
        }

        @Override
        public void displayErrors(String message) {
            JOptionPane.showMessageDialog((Component)((Object)DataStatusSummary.this), message, "", 2);
        }
    }
}

