/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import hec.dataui.summary.awt.DataSetInfo;
import hec.dataui.summary.awt.DataStatusSummary;
import hec.heclib.dss.DSSPathAndFilename;
import hec.serversuite.data.CwmsAuthenticationSource;
import hec.serversuite.data.ServerInfo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.table.AbstractTableModel;

final class DataStatusTableModel
extends AbstractTableModel {
    private final DataStatusSummary _dataStatusSummary;

    DataStatusTableModel(DataStatusSummary dataStatusSummary) {
        this._dataStatusSummary = dataStatusSummary;
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        String name = ((String)value).trim();
        if (row < this._dataStatusSummary._dataSetList.size()) {
            if (name.isEmpty()) {
                this._dataStatusSummary._dataSetList.remove(row);
                this.fireTableRowsDeleted(row, row);
            } else {
                DataSetInfo info = this._dataStatusSummary._dataSetList.get(row);
                info.setName(name);
                this.fireTableRowsUpdated(row, row);
            }
        }
        this._dataStatusSummary._dataListChanged = true;
        this._dataStatusSummary.getSaveMenu().setEnabled(this._dataStatusSummary._editable);
    }

    @Override
    public int getColumnCount() {
        return COL.values().length;
    }

    @Override
    public int getRowCount() {
        if (this._dataStatusSummary._insertMode) {
            return this._dataStatusSummary._dataSetList.size() + 1;
        }
        return this._dataStatusSummary._dataSetList.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        COL col = COL.values()[column];
        if (row >= this._dataStatusSummary._dataSetList.size()) {
            if (col == COL.DATA_SET_COL || col == COL.DATA_SOURCE_COL) {
                return "";
            }
            return new JLabel("");
        }
        Object retval = null;
        if (row < this._dataStatusSummary._dataSetList.size()) {
            DataSetInfo dataSetInfo = this._dataStatusSummary._dataSetList.get(row);
            switch (col) {
                case DATA_SOURCE_COL: {
                    retval = dataSetInfo.getDataSourceName();
                    break;
                }
                case DATA_SET_COL: {
                    retval = dataSetInfo.getPathname();
                    break;
                }
                case QUALITY_COL: {
                    retval = new JLabel((Icon)((Object)dataSetInfo.getQualityColorBar()));
                    break;
                }
                case MISSING_COL: {
                    retval = this.createMissingLabel(dataSetInfo);
                    break;
                }
                case LAST_VAL_COL: {
                    retval = this.createLastValLabel(dataSetInfo);
                }
            }
        }
        return retval;
    }

    private Object createLastValLabel(DataSetInfo dataSetInfo) {
        JLabel label = new JLabel("");
        if (dataSetInfo.getDataRetrieved()) {
            if (dataSetInfo.getLastTime().isDefined()) {
                label.setText(dataSetInfo.getLastTime().toString(14));
                if (dataSetInfo.isEarliest()) {
                    label.setForeground(Color.blue);
                }
            } else {
                label.setText("-- No Data --");
                label.setForeground(Color.red);
            }
        }
        JLabel retval = label;
        return retval;
    }

    private JLabel createMissingLabel(DataSetInfo dataSetInfo) {
        JLabel label = new JLabel("");
        if (dataSetInfo.getDataRetrieved()) {
            if (dataSetInfo.getLastTime().isDefined()) {
                label.setText(Integer.toString(dataSetInfo.getNumberMissing()));
            } else {
                label.setForeground(Color.red);
                label.setText("All");
            }
        }
        return label;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        return COL.values()[column]._columnClass;
    }

    @Override
    public String getColumnName(int column) {
        return COL.values()[column]._name;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return this._dataStatusSummary._editable && COL.values()[column]._editable;
    }

    public void insertRows(int[] rows) {
        if (rows.length == 0) {
            this._dataStatusSummary._insertMode = true;
            this.fireTableRowsInserted(this.getRowCount(), this.getRowCount());
        } else {
            ArrayList<DataSetInfo> insertPosition = new ArrayList<DataSetInfo>();
            for (int row : rows) {
                if (row < this._dataStatusSummary._dataSetList.size()) {
                    DataSetInfo info = this._dataStatusSummary._dataSetList.get(row);
                    insertPosition.add(info);
                }
                if (row != this._dataStatusSummary._dataSetList.size() - 1) continue;
                this._dataStatusSummary._insertMode = true;
            }
            Object object = insertPosition.iterator();
            while (object.hasNext()) {
                DataSetInfo dataSetInfo = (DataSetInfo)object.next();
                int loc = this._dataStatusSummary._dataSetList.indexOf(dataSetInfo);
                this._dataStatusSummary._dataSetList.add(loc, new DataSetInfo.DssDataSetInfo(new DSSPathAndFilename()));
            }
            this.fireTableDataChanged();
        }
    }

    public int deleteRows(int[] rows) {
        ArrayList<DataSetInfo> toDelete = new ArrayList<DataSetInfo>();
        if (rows.length == 0) {
            Object object = this._dataStatusSummary._dataSetList.iterator();
            while (object.hasNext()) {
                DataSetInfo info = (DataSetInfo)object.next();
                if (info.getPathname().length() != 0) continue;
                toDelete.add(info);
            }
            if (this._dataStatusSummary._insertMode) {
                this._dataStatusSummary._insertMode = false;
            } else if (toDelete.isEmpty()) {
                return -1;
            }
        }
        for (int row : rows) {
            if (row < this._dataStatusSummary._dataSetList.size()) {
                DataSetInfo info = this._dataStatusSummary._dataSetList.get(row);
                toDelete.add(info);
                continue;
            }
            this._dataStatusSummary._insertMode = false;
        }
        for (DataSetInfo dataSetInfo : toDelete) {
            this._dataStatusSummary._dataSetList.remove(dataSetInfo);
        }
        this._dataStatusSummary._dataListChanged = true;
        this._dataStatusSummary.getSaveMenu().setEnabled(this._dataStatusSummary._editable);
        this.fireTableDataChanged();
        return 0;
    }

    String getToolTipText(int row, int column) {
        String retval = null;
        if (COL.values()[column] == COL.DATA_SOURCE_COL && row >= 0 && row < this._dataStatusSummary._dataSetList.size()) {
            DataSetInfo dataSetInfo = this._dataStatusSummary._dataSetList.get(row);
            if (dataSetInfo instanceof DataSetInfo.DssDataSetInfo) {
                retval = ((DataSetInfo.DssDataSetInfo)dataSetInfo).getDataSourceLocation();
            } else if (dataSetInfo instanceof DataSetInfo.CwmsDataSetInfo) {
                Optional<CwmsAuthenticationSource> cwmsAuthenticationSource = ((DataSetInfo.CwmsDataSetInfo)dataSetInfo).getCwmsAuthenticationSource();
                retval = cwmsAuthenticationSource.map(CwmsAuthenticationSource::getServerInfo).map(ServerInfo::getUrl).orElse("");
            }
        }
        return retval;
    }

    static enum COL {
        DATA_SOURCE_COL("Data Source", String.class, false),
        DATA_SET_COL("Data Set", String.class, true),
        QUALITY_COL("Quality Color Bar", JLabel.class, false),
        MISSING_COL("Missing", JLabel.class, false),
        LAST_VAL_COL("Time of Last Value", JLabel.class, false);

        private String _name;
        private Class<?> _columnClass;
        private boolean _editable;

        private COL(String name, Class<?> columnClass, boolean editable) {
            this._name = name;
            this._columnClass = columnClass;
            this._editable = editable;
        }
    }
}

