/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.summary.awt;

import hec.dataui.summary.awt.DataBrowser;
import hec.dataui.summary.awt.DataSetInfo;
import hec.heclib.dss.DSSPathAndFilename;
import hec.ui.browser.IBrowseCallback;
import hec.ui.browser.IBrowserFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

final class LocalDssDataBrowser
implements IBrowseCallback {
    private final DataBrowser.Callback _callback;
    private final List<DataSetInfo> _dataSetList = new ArrayList<DataSetInfo>();

    LocalDssDataBrowser(DataBrowser.Callback callback) {
        this._callback = callback;
    }

    void setDataSetList(List<DataSetInfo.DssDataSetInfo> dataSetList) {
        this._dataSetList.clear();
        this._dataSetList.addAll(dataSetList);
    }

    IBrowserFactory browse() {
        Lookup lookup = Lookups.forPath((String)"hec.dssVue/BrowseDSS");
        IBrowserFactory dssBrowserFactory = (IBrowserFactory)lookup.lookup(IBrowserFactory.class);
        if (dssBrowserFactory == null) {
            return null;
        }
        Map initializer = dssBrowserFactory.getInitializer();
        initializer.put("title", "Select Pathnames");
        dssBrowserFactory.setInitializer(initializer);
        dssBrowserFactory.openBrowser((IBrowseCallback)this);
        return dssBrowserFactory;
    }

    public void replacePathnames(Vector selectionList) {
        ArrayList dataReferences = new ArrayList(selectionList);
        List<DataSetInfo> collect = dataReferences.stream().map(d -> {
            DSSPathAndFilename dssName = new DSSPathAndFilename();
            dssName.setPathname(d.getDSSPathname().pathname());
            dssName.setFilename(d.getFilename());
            return new DataSetInfo.DssDataSetInfo(dssName);
        }).collect(Collectors.toList());
        this._callback.dataSetInfoAdded(collect);
    }
}

