/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import hec.data.TimeSeriesDataEditorListener;
import hec.data.TimeWindowMap;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TimeZone;

public abstract class DataSource
extends Observable
implements Observer {
    protected long _startTime;
    protected long _endTime;
    protected TimeZone _tz = null;
    protected String _name;
    protected Set<TimeSeriesDataEditorListener> _listeners;

    public DataSource(String name, HecTime startTime, HecTime endTime) {
        this._name = name;
        this._startTime = startTime.getTimeInMillis();
        this._endTime = endTime.getTimeInMillis();
    }

    public DataSource(String name, long startTime, long endTime) {
        this._name = name;
        this._startTime = startTime;
        this._endTime = endTime;
    }

    public void setTimeWindow(long startTime, long endTime) {
        this._startTime = startTime;
        this._endTime = endTime;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public String getName() {
        return this._name;
    }

    @Override
    public synchronized void setChanged() {
        super.setChanged();
    }

    @Override
    public void update(Observable o, Object arg) {
    }

    public String tabulate() {
        return this.toString();
    }

    public void reloadTsContainer(HecTime startTime, HecTime endTime, boolean bAll) {
    }

    public TimeSeriesContainer retrieveValueTsContainer() {
        return null;
    }

    public void addDataEditorListener(TimeSeriesDataEditorListener listener) {
        if (this._listeners == null) {
            this._listeners = new HashSet<TimeSeriesDataEditorListener>();
        }
        this._listeners.add(listener);
    }

    public void removeDataEditorListener(TimeSeriesDataEditorListener listener) {
        if (this._listeners == null) {
            return;
        }
        this._listeners.remove(listener);
        if (this._listeners.isEmpty()) {
            this._listeners = null;
        }
    }

    protected Serializable fireReload(Serializable o) {
        if (this._listeners != null) {
            for (TimeSeriesDataEditorListener listener : this._listeners) {
                o = listener.reload(o);
            }
        }
        return o;
    }

    protected void fireSave(Serializable o) {
        if (this._listeners == null) {
            return;
        }
        for (TimeSeriesDataEditorListener listener : this._listeners) {
            listener.save(o);
        }
    }

    protected void fireSaveAs(Serializable o) {
        if (this._listeners == null) {
            return;
        }
        for (TimeSeriesDataEditorListener listener : this._listeners) {
            listener.saveAs(o);
        }
    }

    public void firePlot(List list) {
        if (this._listeners == null) {
            return;
        }
        for (TimeSeriesDataEditorListener listener : this._listeners) {
            listener.plot(list);
        }
    }

    public void fireTabulate(List list) {
        if (this._listeners == null) {
            return;
        }
        for (TimeSeriesDataEditorListener listener : this._listeners) {
            listener.tabulate(list);
        }
    }

    public abstract String toString();

    public abstract Serializable retrieveValueData();

    public abstract Serializable getRetrieveMetadata();

    public abstract boolean storeRevisedData(Serializable var1);

    public abstract boolean storeRevisedDataAs(Serializable var1);

    public abstract Serializable retrieveRawData();

    public abstract void deleteValues(Serializable var1, TimeWindowMap var2);

    public void fireDeleteValues(Serializable data, TimeWindowMap timeWindowMap) {
        if (this._listeners == null) {
            return;
        }
        HashMap<Serializable, TimeWindowMap> timeSeriesTimeWindowMap = new HashMap<Serializable, TimeWindowMap>();
        timeSeriesTimeWindowMap.put(data, timeWindowMap);
        for (TimeSeriesDataEditorListener listener : this._listeners) {
            listener.deleteValues(timeSeriesTimeWindowMap);
        }
    }

    protected String getRawVersion(String revVersion) {
        String rawVersion = null;
        List<int[]> replaceList = this.getRevReplaceList(revVersion);
        if (!replaceList.isEmpty()) {
            StringBuilder rawFPart = new StringBuilder("");
            int from = 0;
            for (int[] replace : replaceList) {
                int to = replace[0];
                rawFPart.append(revVersion.substring(from, to));
                rawFPart.append("Raw");
                from = replace[1];
            }
            rawFPart.append(revVersion.substring(from, revVersion.length()));
            rawVersion = rawFPart.toString();
        }
        return rawVersion;
    }

    private List<int[]> getRevReplaceList(String version) {
        String[] revStart = new String[]{"rev-", "best-"};
        String[] revEnd = new String[]{"-rev", "-best"};
        String[] revContain = new String[]{"-rev-", "-best-"};
        ArrayList<int[]> replaceList = new ArrayList<int[]>();
        String versionLC = version.toLowerCase();
        for (String revStr : revStart) {
            if (!versionLC.startsWith(revStr)) continue;
            int[] replace = new int[]{0, revStr.length() - 1};
            replaceList.add(replace);
        }
        for (String revStr : revContain) {
            int fromIndex = 0;
            do {
                if ((fromIndex = versionLC.indexOf(revStr, fromIndex)) == -1) continue;
                int[] replace = new int[]{fromIndex + 1, fromIndex + (revStr.length() - 1)};
                replaceList.add(replace);
                fromIndex += revStr.length() - 1;
            } while (fromIndex != -1);
        }
        for (String revStr : revEnd) {
            if (!versionLC.endsWith(revStr)) continue;
            int[] replace = new int[]{versionLC.length() - (revStr.length() - 1), versionLC.length()};
            replaceList.add(replace);
        }
        Collections.sort(replaceList, (arg0, arg1) -> arg0[0] - arg1[0]);
        return replaceList;
    }

    public abstract String getDataSourceLocation();

    public abstract String getDataSourceLocationDetails();

    public boolean hasQuality() {
        return false;
    }
}

