/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import hec.data.TimeSeriesDataEditorListener;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.awt.ValidationDataSource;
import hec.heclib.util.HecTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.TimeZone;
import javax.swing.JFrame;

public abstract class DataSourceList {
    public static final String PRIMARY_START = "PRIMARY";
    public static final String RAW = "RAW";
    public static final String START_TIME = "STARTTIME";
    public static final String END_TIME = "ENDTIME";
    public static final String RELATIVE_TIME = "RELATIVETIME";
    protected boolean _dataSourcesSet = false;
    protected TimeZone _tz = null;
    protected long _startTime = Long.MIN_VALUE;
    protected long _endTime = Long.MIN_VALUE;
    protected boolean _trim = true;
    private List<DataSource> _sources = new ArrayList<DataSource>();

    public DataSourceList(HecTime startTime, HecTime endTime, TimeZone tz) {
        if (tz == null) {
            tz = TimeZone.getTimeZone("UTC");
        }
        this._tz = tz;
        if (startTime != null && endTime != null) {
            Calendar cal = Calendar.getInstance(tz);
            this._startTime = startTime.getTimeInMillis(cal);
            this._endTime = endTime.getTimeInMillis(cal);
        }
        this.initDataSources();
    }

    public boolean getTrim() {
        return this._trim;
    }

    public void setTrim(boolean trim) {
        this._trim = trim;
        for (DataSource source : this._sources) {
            if (!(source instanceof ValidationDataSource)) continue;
            ((ValidationDataSource)source).setTrim(trim);
        }
    }

    public void addDataEditorListener(TimeSeriesDataEditorListener listener) {
        for (int ii = 0; ii < this.size(); ++ii) {
            this.get(ii).addDataEditorListener(listener);
        }
    }

    public void removeDataEditorListener(TimeSeriesDataEditorListener listener) {
        for (int ii = 0; ii < this.size(); ++ii) {
            this.get(ii).removeDataEditorListener(listener);
        }
    }

    public int size() {
        return this._sources.size();
    }

    public void clear() {
        this._sources.clear();
        this._dataSourcesSet = false;
    }

    public TimeZone getTimeZone() {
        return this._tz;
    }

    public long getStartTime() {
        return this._startTime;
    }

    public long getEndTime() {
        return this._endTime;
    }

    public int getMode() {
        return 0;
    }

    public boolean initDataSources() {
        boolean tf = false;
        if (this._startTime != Long.MIN_VALUE && this._endTime != Long.MIN_VALUE) {
            for (int ii = 0; ii < this._sources.size(); ++ii) {
                DataSource dataSource = this._sources.get(ii);
                dataSource.setTimeWindow(this._startTime, this._endTime);
            }
            this._dataSourcesSet = true;
            tf = true;
        }
        return tf;
    }

    public void add(DataSource dataSource) {
        this._sources.add(dataSource);
        this._dataSourcesSet = false;
    }

    public DataSource get(int idx) {
        if (!this._dataSourcesSet) {
            this.initDataSources();
        }
        return this._sources.get(idx);
    }

    public List getSources() {
        return new ArrayList<DataSource>(this._sources);
    }

    protected void setSources(ArrayList list) {
        this._sources = list;
        this.initDataSources();
    }

    public abstract int filter(JFrame var1);

    public void normalize() {
    }

    public void tabulate() {
        System.out.println(this._sources.size() + " Data Sources in List");
        for (int ii = 0; ii < this._sources.size(); ++ii) {
            DataSource source = this._sources.get(ii);
            System.out.println(source.tabulate());
        }
    }

    public boolean initDataSources(DataSource _dataSource) {
        return this.initDataSources();
    }
}

