/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import com.google.common.flogger.FluentLogger;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.DataSourceList;
import hec.dataui.tx.ValidationDataSourceList;
import hec.heclib.util.HecTime;
import hec.io.DssManagerBridge;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.nio.file.Path;
import java.util.List;
import java.util.TimeZone;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeListener;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import rma.services.ServiceLookup;
import rma.swing.ButtonCmdPanel;
import rma.swing.RmaInsets;
import rma.swing.RmaJDialog;
import rma.util.RMAIO;

public class DataVerificationModeSelector
extends RmaJDialog {
    private static final long serialVersionUID = 5142253137065247738L;
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static String _programName = "Select Data Validation Sets";
    private final List<Path> _fileIdentifiers;
    private final JFrame _parent;
    private final List<DataSource> _dataSourcesMap;
    private final DssManagerBridge _dssManagerBridge;
    private final DssManagerBridge _dssRemoteManagerBridge;
    private final Preferences _preferences;
    private final HecTime _startTime;
    private final HecTime _endTime;
    private TimeZone _timeZone;
    private boolean _canceled = false;
    private ButtonGroup _listButtonGroup;
    private JRadioButton _adHocModeJRadioButton;
    private JRadioButton _listModeJRadioButton;
    private JComboBox<Path> _selectionList;
    private JCheckBox _showComparisons;
    private ButtonGroup _displayButtonGroup;
    private JRadioButton _displayAllLocs;
    private JRadioButton _displaySpecificLocs;
    private JCheckBox _showQuestionable;
    private JCheckBox _showMissing;
    private JCheckBox _showRejected;
    private DataSourceList _dataSourceList;
    private JCheckBox _showFullTimeWindow;

    public DataVerificationModeSelector(JFrame parent, HecTime startTime, HecTime endTime, TimeZone timezone, List<DataSource> dataSourcesMap, List<Path> fileList, boolean listMode, Preferences preferences, DssManagerBridge managerBridge, DssManagerBridge remoteManagerBridge) {
        super((Frame)parent, true);
        this._dssManagerBridge = managerBridge;
        this._dssRemoteManagerBridge = remoteManagerBridge;
        this._parent = parent;
        this._preferences = preferences;
        this._dataSourcesMap = dataSourcesMap;
        this._fileIdentifiers = fileList;
        this._startTime = startTime;
        this._endTime = endTime;
        this._timeZone = timezone;
        if (this._timeZone == null) {
            this._timeZone = ServiceLookup.getTimeZoneDisplayService().getDisplayTimeZone().orElse(NumericalConstants.UTC_TZ);
        }
        this._dataSourceList = new ValidationDataSourceList(startTime, endTime, timezone, preferences);
        this.buildComponents();
        this.initListeners();
        this.fillSelectionList();
        this.initToProperties();
        if ((fileList == null || fileList.isEmpty()) && (dataSourcesMap == null || dataSourcesMap.isEmpty())) {
            throw new IllegalArgumentException("Must have file identifiers or nodes.");
        }
        if (dataSourcesMap == null || dataSourcesMap.isEmpty()) {
            this._adHocModeJRadioButton.setVisible(false);
            this._adHocModeJRadioButton.setEnabled(false);
        } else if (fileList == null || fileList.isEmpty()) {
            this._listModeJRadioButton.setVisible(false);
            this._selectionList.setVisible(false);
            this._adHocModeJRadioButton.setVisible(false);
            this._listModeJRadioButton.setEnabled(false);
        }
        if (listMode && this._selectionList.getItemCount() > 0) {
            this._listModeJRadioButton.setSelected(true);
        } else {
            this._adHocModeJRadioButton.setSelected(true);
        }
        this.pack();
        if (this._parent != null) {
            this.setLocationRelativeTo(this._parent);
        }
    }

    private void buildComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setLocation();
        this.setTitle(_programName);
        this._listButtonGroup = new ButtonGroup();
        this._adHocModeJRadioButton = new JRadioButton("Icons");
        this._adHocModeJRadioButton.setMnemonic('A');
        this._listButtonGroup.add(this._adHocModeJRadioButton);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this._adHocModeJRadioButton, gbc);
        this._listModeJRadioButton = new JRadioButton("List");
        this._listModeJRadioButton.setMnemonic('L');
        this._listButtonGroup.add(this._listModeJRadioButton);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        this.getContentPane().add((Component)this._listModeJRadioButton, gbc);
        JLabel selListLabel = new JLabel("Selection List");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = RmaInsets.insets((int)5, (int)10, (int)0, (int)0);
        gbc.anchor = 18;
        this.getContentPane().add((Component)selListLabel, gbc);
        this._selectionList = new JComboBox();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.fill = 2;
        gbc.anchor = 18;
        this.getContentPane().add(this._selectionList, gbc);
        JPanel displayOptionsPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)5, (int)5);
        gbc.fill = 1;
        gbc.anchor = 18;
        this.getContentPane().add((Component)displayOptionsPanel, gbc);
        displayOptionsPanel.setBorder(new TitledBorder("Display Options"));
        this._showFullTimeWindow = new JCheckBox("Show Data For Full Time Window");
        this._showFullTimeWindow.setMnemonic('T');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        displayOptionsPanel.add((Component)this._showFullTimeWindow, gbc);
        this._showComparisons = new JCheckBox("Show Comparisons");
        this._showComparisons.setMnemonic('C');
        this._showComparisons.setVisible(false);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        displayOptionsPanel.add((Component)this._showComparisons, gbc);
        this._displayButtonGroup = new ButtonGroup();
        this._displayAllLocs = new JRadioButton("Display All Locations");
        this._displayAllLocs.setMnemonic('D');
        this._displayButtonGroup.add(this._displayAllLocs);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        displayOptionsPanel.add((Component)this._displayAllLocs, gbc);
        this._displaySpecificLocs = new JRadioButton("Display Locations With Specific Quality Flags");
        this._displaySpecificLocs.setMnemonic('F');
        this._displayButtonGroup.add(this._displaySpecificLocs);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 3;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        displayOptionsPanel.add((Component)this._displaySpecificLocs, gbc);
        JPanel showPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = RmaInsets.insets((int)10, (int)5, (int)5, (int)5);
        gbc.fill = 3;
        gbc.anchor = 18;
        displayOptionsPanel.add((Component)showPanel, gbc);
        this._showQuestionable = new JCheckBox("Questionable");
        this._showQuestionable.setMnemonic('Q');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        showPanel.add((Component)this._showQuestionable, gbc);
        this._showMissing = new JCheckBox("Missing");
        this._showMissing.setMnemonic('M');
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.anchor = 18;
        showPanel.add((Component)this._showMissing, gbc);
        this._showRejected = new JCheckBox("Rejected");
        this._showRejected.setMnemonic('R');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.insets = RmaInsets.INSETS5500;
        gbc.weighty = 1.0;
        gbc.anchor = 18;
        showPanel.add((Component)this._showRejected, gbc);
        ButtonCmdPanel okApplyCancel = new ButtonCmdPanel(12);
        okApplyCancel.addCmdPanelListener(event -> {
            int exitId = event.getID();
            if (exitId == 8) {
                this.okPressed();
            } else if (exitId == 4) {
                this.cancelPressed();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.gridwidth = 2;
        gbc.insets = RmaInsets.INSETS5555;
        gbc.fill = 1;
        gbc.anchor = 16;
        this.getContentPane().add((Component)okApplyCancel, gbc);
    }

    public DataSourceList getDataSourceList() {
        if (this._listModeJRadioButton.isSelected()) {
            Path selectedList = (Path)this._selectionList.getSelectedItem();
            if (selectedList == null) {
                RMAIO.postError((Component)this._parent, (String)"List Mode was chosen without specifying a Pre-Selected List File.");
                return null;
            }
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
            RootPaneContainer root = (RootPaneContainer)((Object)topFrame.getRootPane().getTopLevelAncestor());
            root.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            root.getGlassPane().setVisible(true);
            this._dataSourceList = new ValidationDataSourceList(this._startTime, this._endTime, this._timeZone, this._preferences, selectedList, this._dssManagerBridge, this._dssRemoteManagerBridge);
            this._dataSourceList.setTrim(!this._showFullTimeWindow.isSelected());
            root.getGlassPane().setCursor(Cursor.getDefaultCursor());
        } else {
            JFrame topFrame = (JFrame)SwingUtilities.getWindowAncestor((Component)((Object)this));
            RootPaneContainer root = (RootPaneContainer)((Object)topFrame.getRootPane().getTopLevelAncestor());
            root.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
            root.getGlassPane().setVisible(true);
            this._dataSourceList.setTrim(!this._showFullTimeWindow.isSelected());
            this._dataSourceList.normalize();
            root.getGlassPane().setCursor(Cursor.getDefaultCursor());
        }
        return this._dataSourceList;
    }

    void initListModeDataSourceList() {
        if (this._selectionList.getItemCount() < 1) {
            this._adHocModeJRadioButton.doClick();
            return;
        }
        this._selectionList.setEnabled(true);
    }

    void initAdHocModeDataSourceList() {
        if (this._dataSourcesMap == null || this._dataSourcesMap.size() < 1) {
            this._listModeJRadioButton.doClick();
            return;
        }
        this._dataSourceList.clear();
        this._dataSourcesMap.forEach(this._dataSourceList::add);
    }

    void initListeners() {
        ChangeListener modeListener = e -> {
            if (this._listModeJRadioButton.isSelected()) {
                this.initListModeDataSourceList();
            } else if (this._adHocModeJRadioButton.isSelected()) {
                this.initAdHocModeDataSourceList();
            }
        };
        this._adHocModeJRadioButton.addChangeListener(modeListener);
        this._listModeJRadioButton.addChangeListener(modeListener);
        ChangeListener displayListener = e -> {
            boolean tf = this._displaySpecificLocs.isSelected();
            if (tf) {
                this._showQuestionable.setEnabled(true);
                this._showRejected.setEnabled(true);
                this._showMissing.setEnabled(true);
            } else {
                this._showQuestionable.setEnabled(false);
                this._showRejected.setEnabled(false);
                this._showMissing.setEnabled(false);
            }
        };
        this._displaySpecificLocs.addChangeListener(displayListener);
        this._displayAllLocs.addChangeListener(displayListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataVerificationModeSelector.this.cancelPressed();
            }
        });
        this.registerEscapeKey(true);
        this.registerEnterKey(true);
    }

    void initToProperties() {
        String listname = null;
        if (this._preferences != null) {
            listname = this._preferences.get("Selection List", "");
        }
        if (listname != null) {
            this._selectionList.setSelectedItem(listname);
        }
        String displayMode = null;
        if (this._preferences != null) {
            displayMode = this._preferences.get("Display Mode", "Display All Locations");
        }
        if (displayMode != null) {
            if (displayMode.equals("Display All Locations")) {
                this._displayAllLocs.setSelected(true);
            } else if (displayMode.equals("Display Locations With Specific Quality Flags")) {
                this._displaySpecificLocs.setSelected(true);
            }
        } else {
            this._displaySpecificLocs.setSelected(true);
        }
        boolean bShowC = true;
        boolean bShowQ = true;
        boolean bShowR = true;
        boolean bShowM = true;
        boolean bShowFull = true;
        if (this._preferences != null) {
            bShowC = this._preferences.getBoolean("Show Comparisons", true);
            bShowQ = this._preferences.getBoolean("Questionable", true);
            bShowR = this._preferences.getBoolean("Rejected", true);
            bShowM = this._preferences.getBoolean("Missing", true);
            bShowFull = this._preferences.getBoolean("FullTimeWindow", true);
        }
        this._showComparisons.setSelected(bShowC);
        this._showQuestionable.setSelected(bShowQ);
        this._showMissing.setSelected(bShowM);
        this._showRejected.setSelected(bShowR);
        this._showFullTimeWindow.setSelected(bShowFull);
    }

    void saveProperties() {
        Object o;
        if (this._listModeJRadioButton.isSelected() && (o = this._selectionList.getSelectedItem()) != null && this._preferences != null) {
            this._preferences.put("Selection List", o.toString());
        }
        String value = this.getDisplay();
        if (this._preferences != null) {
            this._preferences.put("Display Mode", value);
            this._preferences.putBoolean("Show Comparisons", true);
            this._preferences.putBoolean("Questionable", this._showQuestionable.isSelected());
            this._preferences.putBoolean("Rejected", this._showRejected.isSelected());
            this._preferences.putBoolean("Missing", this._showMissing.isSelected());
            this._preferences.putBoolean("FullTimeWindow", this._showFullTimeWindow.isSelected());
            try {
                this._preferences.flush();
            }
            catch (BackingStoreException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log("Error saving data filtering selection options to preferences");
            }
        }
    }

    void fillSelectionList() {
        if (this._fileIdentifiers != null) {
            this._selectionList.setModel(new DefaultComboBoxModel<Path>(this._fileIdentifiers.toArray(new Path[0])));
        }
    }

    public boolean getCanceled() {
        return this._canceled;
    }

    public String getDisplay() {
        if (this._displayAllLocs.isSelected()) {
            return "Display All Locations";
        }
        if (this._displaySpecificLocs.isSelected()) {
            return "Display Locations With Specific Quality Flags";
        }
        return null;
    }

    public void okPressed() {
        this.saveProperties();
        this.setVisible(false);
    }

    public void cancelPressed() {
        this._canceled = true;
        this.setVisible(false);
    }
}

