/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import hec.data.TimeWindowMap;
import hec.dataui.tx.DataSource;
import hec.io.DSSIdentifier;
import hec.io.DataContainer;
import hec.io.TimeSeriesContainer;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.RemoteException;
import java.util.Optional;
import mil.army.usace.hec.rmi.csinterface.DSSManager;

public class DssDataSource
extends DataSource {
    private DSSIdentifier _dssId;
    private DSSManager _dssManager;

    public DssDataSource(DSSIdentifier dssId, DSSManager dssManager) {
        super(dssId.getDSSPath(), dssId.getStartTime(), dssId.getEndTime());
        this._dssId = dssId;
        this._dssManager = dssManager;
    }

    @Override
    public Serializable getRetrieveMetadata() {
        return this._dssId;
    }

    @Override
    public Serializable retrieveValueData() {
        return this.retrieveValueTsContainer();
    }

    @Override
    public TimeSeriesContainer retrieveValueTsContainer() {
        TimeSeriesContainer timeSeriesContainer = null;
        try {
            timeSeriesContainer = this._dssManager.readTS(this._dssId, false, true);
        }
        catch (RemoteException re) {
            re.printStackTrace();
        }
        catch (FileNotFoundException e) {
            System.out.println("retrieveValueTsContainer:DSS file not found " + e);
            e.printStackTrace();
        }
        return timeSeriesContainer;
    }

    @Override
    public boolean storeRevisedData(Serializable data) {
        if (data instanceof TimeSeriesContainer) {
            return this.storeRevisedTsContainer((TimeSeriesContainer)data);
        }
        return false;
    }

    @Override
    public boolean storeRevisedDataAs(Serializable data) {
        return false;
    }

    public boolean storeRevisedTsContainer(TimeSeriesContainer tsContainer) {
        try {
            int status = this._dssManager.write((DataContainer)tsContainer);
            return true;
        }
        catch (RemoteException re) {
            re.printStackTrace();
            return false;
        }
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this._dssId.getDSSPath());
        return sb.toString();
    }

    @Override
    public Serializable retrieveRawData() {
        return null;
    }

    @Override
    public void deleteValues(Serializable data, TimeWindowMap timeWindowMap) {
    }

    @Override
    public String getDataSourceLocation() {
        return Optional.ofNullable(this._dssId.getFileName()).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getFileName).map(Object::toString).orElse("");
    }

    @Override
    public String getDataSourceLocationDetails() {
        return Optional.ofNullable(this._dssId.getFileName()).map(x$0 -> Paths.get(x$0, new String[0])).map(Object::toString).orElse("");
    }
}

