/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import rma.swing.RmaJDialog;

public class FilterProgressIndicator
extends RmaJDialog {
    Insets INSETS5555 = new Insets(5, 5, 5, 5);
    Insets INSETS5500 = new Insets(5, 5, 0, 0);
    JFrame _parent;
    long _max;
    JProgressBar totalProgressBar;
    JProgressBar filterProgressBar;
    String _title = "Filtering Validation Data Sets";

    public FilterProgressIndicator(JFrame parent, long max) {
        super((Frame)parent, false);
        this._parent = parent;
        this._max = max;
        this.setResizable(false);
        this.setTitle(this._title);
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        JLabel totalLabel = new JLabel("Percent of Data Sets Checked");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)totalLabel, gbc);
        this.totalProgressBar = new JProgressBar();
        this.totalProgressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)this.totalProgressBar, gbc);
        this.totalProgressBar.setMaximum((int)this._max);
        JLabel filterLabel = new JLabel("Percent of Data Sets Selected");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)filterLabel, gbc);
        this.filterProgressBar = new JProgressBar();
        this.filterProgressBar.setStringPainted(true);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.gridwidth = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.5;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = this.INSETS5555;
        this.getContentPane().add((Component)this.filterProgressBar, gbc);
        this.filterProgressBar.setMaximum((int)this._max);
    }

    public void incrementProgress(boolean filter) {
        SwingUtilities.invokeLater(new IncrementProgress(filter));
    }

    public void setVisible(boolean b) {
        if (b) {
            this._parent.setCursor(new Cursor(3));
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            super.setVisible(true);
        } else {
            super.setVisible(false);
        }
    }

    public void done() {
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this._parent.setCursor(new Cursor(0));
    }

    public class IncrementProgress
    implements Runnable {
        boolean _filter;

        public IncrementProgress(boolean filter) {
            this._filter = filter;
        }

        @Override
        public void run() {
            FilterProgressIndicator.this.totalProgressBar.setValue(FilterProgressIndicator.this.totalProgressBar.getValue() + 1);
            if (this._filter) {
                FilterProgressIndicator.this.filterProgressBar.setValue(FilterProgressIndicator.this.filterProgressBar.getValue() + 1);
            }
        }
    }
}

