/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import hec.dataui.dataentry.TimeSeriesPathnameEditor;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PathnameDefinitionPanel
extends JPanel {
    protected TimeSeriesPathnameEditor _pathnamePanel;
    protected JPanel _specsPanel;
    protected JPanel _timePanel;
    protected JPanel _typePanel;
    protected JLabel _labelStartDate;
    protected JTextField _startDateTextField;
    protected JLabel _labelStartTime;
    protected JTextField _startTimeTextField;
    protected JLabel _labelUnits;
    protected JTextField _unitsTextField;
    protected JLabel _labelType;
    protected JComboBox _typeComboBox;

    public PathnameDefinitionPanel() {
        this.build();
    }

    protected void build() {
        this.buildPathnamePanel();
        this.buildSpecsPanel();
    }

    public DSSPathname getPathname() {
        return (DSSPathname)this._pathnamePanel.getDSSPathname().clone();
    }

    public void setPathname(String pathname) {
        this._pathnamePanel.setPathname(pathname);
    }

    public void setAPart(String part) {
        this._pathnamePanel.setPathnamePart(1, part);
    }

    public void setBPart(String part) {
        this._pathnamePanel.setPathnamePart(2, part);
    }

    public void setCPart(String part) {
        this._pathnamePanel.setPathnamePart(3, part);
    }

    public void setDPart(String part) {
        this._pathnamePanel.setPathnamePart(4, part);
    }

    public void setEPart(String part) {
        this._pathnamePanel.setPathnamePart(5, part);
    }

    public void setFPart(String part) {
        this._pathnamePanel.setPathnamePart(6, part);
    }

    public String getUnits() {
        return this._unitsTextField.getText();
    }

    public void setUnits(String units) {
        this._unitsTextField.setText(units);
    }

    public String getRecordType() {
        return this._typeComboBox.getSelectedItem().toString();
    }

    public void setRecordType(String type) {
        this._typeComboBox.setSelectedItem(type);
    }

    public HecTime getFirstTime() {
        HecTime hecTime = new HecTime();
        hecTime.set(this._startDateTextField.getText(), this._startTimeTextField.getText());
        return hecTime;
    }

    public void setFirstTime(HecTime hecTime) {
        String time;
        String date;
        if (hecTime.isDefined()) {
            date = hecTime.date(4);
            time = hecTime.time();
        } else {
            date = "";
            time = "";
        }
        this._startDateTextField.setText(date);
        this._startTimeTextField.setText(time);
    }

    protected void buildPathnamePanel() {
        this.setLayout(new GridBagLayout());
        this._pathnamePanel = new TimeSeriesPathnameEditor();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(10, 24, 10, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        ((GridBagLayout)this.getLayout()).setConstraints(this._pathnamePanel, gbc);
        this.add(this._pathnamePanel);
    }

    protected void buildSpecsPanel() {
        this._specsPanel = new JPanel(new GridLayout(1, 2));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.insets = new Insets(20, 24, 0, 24);
        gbc.weightx = 1.0;
        gbc.anchor = 11;
        gbc.fill = 2;
        this.add((Component)this._specsPanel, gbc);
        this._timePanel = new JPanel(new GridBagLayout());
        this._specsPanel.add(this._timePanel);
        this._labelStartDate = new JLabel("Start Date:");
        this._labelStartDate.setFont(new Font("Dialog", 0, 12));
        this._labelStartDate.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        this._timePanel.add((Component)this._labelStartDate, gbc);
        this._startDateTextField = new JTextField();
        this._startDateTextField.setToolTipText("Date of the first data value");
        this._startDateTextField.setFont(new Font("Dialog", 0, 12));
        this._startDateTextField.setForeground(new Color(0));
        this._startDateTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 15);
        gbc.ipady = 0;
        this._timePanel.add((Component)this._startDateTextField, gbc);
        this._labelStartTime = new JLabel("Start Time:");
        this._labelStartTime.setFont(new Font("Dialog", 0, 12));
        this._labelStartTime.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 0, 0, 0);
        this._timePanel.add((Component)this._labelStartTime, gbc);
        this._startTimeTextField = new JTextField();
        this._startTimeTextField.setToolTipText("Time of the first data value");
        this._startTimeTextField.setFont(new Font("Dialog", 0, 12));
        this._startTimeTextField.setForeground(new Color(0));
        this._startTimeTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 15);
        gbc.ipady = 0;
        this._timePanel.add((Component)this._startTimeTextField, gbc);
        this._typePanel = new JPanel();
        this._typePanel.setLayout(new GridBagLayout());
        this._specsPanel.add(this._typePanel);
        this._labelUnits = new JLabel("Units:");
        this._labelUnits.setFont(new Font("Dialog", 0, 12));
        this._labelUnits.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.insets = new Insets(0, 16, 0, 0);
        this._typePanel.add((Component)this._labelUnits, gbc);
        this._unitsTextField = new JTextField();
        this._unitsTextField.setToolTipText("Data units (e.g., FEET)");
        this._unitsTextField.setFont(new Font("Dialog", 0, 12));
        this._unitsTextField.setForeground(new Color(0));
        this._unitsTextField.setMargin(new Insets(0, 2, 0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 5, 0, 0);
        gbc.ipady = 0;
        this._typePanel.add((Component)this._unitsTextField, gbc);
        this._labelType = new JLabel("Type:");
        this._labelType.setFont(new Font("Dialog", 0, 12));
        this._labelType.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = 0;
        gbc.insets = new Insets(10, 16, 0, 0);
        this._typePanel.add((Component)this._labelType, gbc);
        String[] types = new String[]{"PER-AVER", "PER-CUM", "INST-VAL", "INST-CUM"};
        this._typeComboBox = new JComboBox<String>(types);
        this._typeComboBox.setSelectedItem("INST-VAL");
        this._typeComboBox.setFont(new Font("Dialog", 0, 12));
        this._typeComboBox.setForeground(new Color(0));
        this._typeComboBox.setBackground(Color.white);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 5, 0, 0);
        gbc.ipadx = 0;
        gbc.ipady = 0;
        this._typePanel.add((Component)this._typeComboBox, gbc);
    }
}

