/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import com.google.common.flogger.FluentLogger;
import hec.data.TimeWindowMap;
import hec.dataui.tx.DataSource;
import hec.db.DataAccessFactory;
import hec.db.DbConnectionException;
import hec.db.DbIoException;
import hec.db.DbNoDataFoundException;
import hec.db.cwms.CwmsTimeSeriesDao;
import hec.db.cwms.DataAccessKey;
import hec.lang.Const;
import hec.lang.LoginException;
import hec.serversuite.ClientAuthenticationException;
import hec.serversuite.ServerSuite;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import java.awt.Component;
import java.io.Serializable;
import java.util.LinkedHashMap;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.util.RMAIO;

public class TimeSeriesDataSource
extends DataSource {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final CwmsAuthenticationSource _cwmsAuthenticationSource;
    protected TimeSeriesTemplate _valueTemplate;
    protected int _storeRule = 101;
    protected boolean _blocking = true;
    protected boolean _overrideProtection = false;

    public TimeSeriesDataSource(TimeSeriesTemplate template, CwmsAuthenticationSource cwmsAuthenticationSource) {
        super(template.getTimeSeriesIdentifier().toString(), template.getStartTime(), template.getEndTime());
        this._startTime = template.getStartTime();
        this._endTime = template.getEndTime();
        this._valueTemplate = template;
        this._cwmsAuthenticationSource = cwmsAuthenticationSource;
    }

    @Override
    public Serializable retrieveValueData() {
        return this.retrieveValueTx();
    }

    protected void init() {
        try {
            this._valueTemplate = new TimeSeriesTemplate(this._valueTemplate.getTimeSeriesIdentifier(), this._startTime, this._endTime, this._valueTemplate.getUnits());
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Unable to initialize time window for template: " + this._valueTemplate);
        }
    }

    @Override
    public Serializable getRetrieveMetadata() {
        return this.getValueTemplate();
    }

    public TimeSeriesTemplate getValueTemplate() {
        return this._valueTemplate;
    }

    public TimeSeries retrieveValueTx() {
        return this.retrieveValueTx(null, false);
    }

    public TimeSeries retrieveValueTx(boolean bTrim) {
        return this.retrieveValueTx(null, bTrim);
    }

    public TimeSeries retrieveValueTx(Component ui, boolean bTrim) {
        this.init();
        TimeSeries dstx = null;
        if (Const.isDefined((long)this._valueTemplate.getStartTime()) && Const.isDefined((long)this._valueTemplate.getEndTime())) {
            try (DataAccessKey dataAccessKey = this.getDataAccessFactory().getDataAccessKey(this.getClass().getSimpleName());){
                CwmsTimeSeriesDao timeSeriesDao = (CwmsTimeSeriesDao)this.getDataAccessFactory().getDao(CwmsTimeSeriesDao.class);
                dstx = timeSeriesDao.retrieveTimeSeries(dataAccessKey, this._valueTemplate, bTrim);
                if (dstx != null) {
                    dstx.addEmptyQualityTx();
                }
            }
            catch (DbNoDataFoundException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log("No data for time series: " + this._valueTemplate.getTimeSeriesIdentifier());
            }
            catch (DbIoException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error retrieving time series: " + this._valueTemplate.getTimeSeriesIdentifier());
                RMAIO.postError((Component)ui, (String)e.getMessage());
            }
            catch (DbConnectionException | ClientAuthenticationException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Error connecting to the database to retrieve time series: " + this._valueTemplate.getTimeSeriesIdentifier());
                RMAIO.postError((Component)ui, (String)e.getMessage());
            }
        }
        return dstx;
    }

    protected final DataAccessFactory getDataAccessFactory() throws ClientAuthenticationException {
        try {
            CwmsAuthenticationSource source = ServerSuiteUtil.replaceWithPreferences((CwmsAuthenticationSource)this._cwmsAuthenticationSource);
            ServerSuite serverSuite = ServerSuiteUtil.loginSecondary((String)"Data Validation Editor", (CwmsAuthenticationSource)source);
            return serverSuite.getDataAccessFactory();
        }
        catch (LoginException e) {
            throw new ClientAuthenticationException("Unable to login to authentication source: " + this._cwmsAuthenticationSource, (Exception)((Object)e));
        }
    }

    public void setStoreRule(int storeRule) {
        this._storeRule = storeRule;
    }

    public void setBlocking(boolean tf) {
        this._blocking = tf;
    }

    public void setOverrideProtection(boolean tf) {
        this._overrideProtection = tf;
    }

    @Override
    public boolean storeRevisedData(Serializable data) {
        if (data instanceof TimeSeries) {
            return this.storeRevisedTimeSeries((TimeSeries)data);
        }
        return false;
    }

    @Override
    public boolean storeRevisedDataAs(Serializable data) {
        return false;
    }

    public boolean storeRevisedTimeSeries(TimeSeries data) {
        boolean bl;
        block8: {
            DataAccessKey dataAccessKey = this.getDataAccessFactory().getDataAccessKey(this.getClass().getSimpleName());
            try {
                CwmsTimeSeriesDao timeSeriesDao = (CwmsTimeSeriesDao)this.getDataAccessFactory().getDao(CwmsTimeSeriesDao.class);
                timeSeriesDao.storeTimeSeries(dataAccessKey, data, this._storeRule, this._overrideProtection);
                this.getDataAccessFactory().closeResource(dataAccessKey, true);
                bl = true;
                if (dataAccessKey == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (dataAccessKey != null) {
                        try {
                            dataAccessKey.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DbConnectionException | DbIoException | ClientAuthenticationException e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Error storing rev time series: " + data);
                    return false;
                }
            }
            dataAccessKey.close();
        }
        return bl;
    }

    @Override
    public String toString() {
        return "PRIMARY=" + this._valueTemplate.getTimeSeriesIdentifier().toString() + "\n";
    }

    @Override
    public Serializable retrieveRawData() {
        return null;
    }

    @Override
    public void deleteValues(Serializable data, TimeWindowMap timeWindowMap) {
        try (DataAccessKey dataAccessKey = this.getDataAccessFactory().getDataAccessKey(this.getClass().getSimpleName());){
            LinkedHashMap<TimeSeriesIdentifier, TimeWindowMap> deleteMap = new LinkedHashMap<TimeSeriesIdentifier, TimeWindowMap>();
            deleteMap.put(this._valueTemplate.getTimeSeriesIdentifier(), timeWindowMap);
            CwmsTimeSeriesDao.OverrideProtection enumOverrideProtection = CwmsTimeSeriesDao.OverrideProtection.True;
            String officeId = this._valueTemplate.getTimeSeriesIdentifier().getOfficeId().map(OfficeId::getOfficeId).orElse(null);
            CwmsTimeSeriesDao timeSeriesDao = (CwmsTimeSeriesDao)this.getDataAccessFactory().getDao(CwmsTimeSeriesDao.class);
            timeSeriesDao.deleteValues(this.getDataAccessFactory(), officeId, deleteMap, enumOverrideProtection);
            this.getDataAccessFactory().closeResource(dataAccessKey, true);
        }
        catch (DbConnectionException | DbIoException | ClientAuthenticationException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Error during delete values.");
        }
    }

    @Override
    public String getDataSourceLocation() {
        return this._cwmsAuthenticationSource.getDisplayName();
    }

    @Override
    public String getDataSourceLocationDetails() {
        return this._cwmsAuthenticationSource.getHtmlDisplay();
    }

    @Override
    public boolean hasQuality() {
        return true;
    }
}

