/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import hec.data.TimeWindowMap;
import hec.data.tx.ComparisonDataSource;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.awt.ValidationDataSource;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.lang.DSSPathString;
import hec.serversuite.data.CwmsAuthenticationSource;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class TsContainerDataSource
extends DataSource
implements ComparisonDataSource {
    private List<TimeSeriesContainer> _comparisonList = new ArrayList<TimeSeriesContainer>();
    private final List<ValidationDataSource> _comparisonDataSource = new ArrayList<ValidationDataSource>();
    private final List<TimeSeriesContainer> _rawContainerList = new ArrayList<TimeSeriesContainer>();
    private TimeSeriesContainer _tsContainer;

    public TsContainerDataSource(TimeSeriesContainer tsContainer, TimeSeriesContainer rawContainer) {
        super(tsContainer.toString(), tsContainer.getStartTime(), tsContainer.getEndTime());
        this._tsContainer = tsContainer;
        this.setRawContainer(rawContainer);
    }

    public TsContainerDataSource(String pathname, TimeSeriesContainer tsContainer, TimeSeriesContainer rawContainer) {
        super(pathname, tsContainer.getStartTime(), tsContainer.getEndTime());
        this._tsContainer = tsContainer;
        this.setRawContainer(rawContainer);
    }

    public void setRawContainer(TimeSeriesContainer rawContainer) {
        this._rawContainerList.clear();
        if (rawContainer != null) {
            this._rawContainerList.add(rawContainer);
        }
    }

    public void addRawContainer(TimeSeriesContainer rawContainer) {
        this._rawContainerList.add(rawContainer);
    }

    @Override
    public void setTimeWindow(long startTime, long endTime) {
    }

    public List<TimeSeriesContainer> retrieveComparisonList() {
        List collect = this._comparisonDataSource.stream().map(ValidationDataSource::getTimeSeriesContainer).collect(Collectors.toList());
        ArrayList<TimeSeriesContainer> containers = new ArrayList<TimeSeriesContainer>(this._comparisonList);
        containers.addAll(collect);
        return containers;
    }

    public void setComparisonList(List<TimeSeriesContainer> list) {
        this._comparisonList.clear();
        this._comparisonList.addAll(list);
    }

    @Override
    public Serializable getRetrieveMetadata() {
        return this.retrieveValueTsContainer();
    }

    @Override
    public Serializable retrieveValueData() {
        return this.retrieveValueTsContainer();
    }

    @Override
    public TimeSeriesContainer retrieveValueTsContainer() {
        return this._tsContainer;
    }

    @Override
    public boolean storeRevisedData(Serializable data) {
        if (data instanceof TimeSeriesContainer) {
            return this.storeRevisedTsContainer((TimeSeriesContainer)data);
        }
        return false;
    }

    @Override
    public boolean storeRevisedDataAs(Serializable data) {
        if (data instanceof TimeSeriesContainer) {
            return this.storeRevisedTsContainerAs((TimeSeriesContainer)data);
        }
        return false;
    }

    @Override
    public void reloadTsContainer(HecTime startTime, HecTime endTime, boolean bAll) {
        this._tsContainer.startHecTime = startTime;
        this._tsContainer.endHecTime = endTime;
        this._tsContainer = (TimeSeriesContainer)super.fireReload((Serializable)this._tsContainer);
        if (bAll) {
            TimeSeriesContainer tsContainer;
            int i;
            for (i = 0; i < this._rawContainerList.size(); ++i) {
                tsContainer = this._rawContainerList.get(i);
                tsContainer.startHecTime = startTime;
                tsContainer.endHecTime = endTime;
                this._rawContainerList.set(i, (TimeSeriesContainer)super.fireReload((Serializable)tsContainer));
            }
            for (i = 0; i < this._comparisonList.size(); ++i) {
                tsContainer = this._comparisonList.get(i);
                tsContainer.startHecTime = startTime;
                tsContainer.endHecTime = endTime;
                this._comparisonList.set(i, (TimeSeriesContainer)super.fireReload((Serializable)tsContainer));
            }
        }
    }

    public boolean storeRevisedTsContainer(TimeSeriesContainer tsContainer) {
        this._tsContainer = tsContainer;
        super.fireSave((Serializable)tsContainer);
        return true;
    }

    public boolean storeRevisedTsContainerAs(TimeSeriesContainer tsContainer) {
        this._tsContainer = tsContainer;
        super.fireSaveAs((Serializable)tsContainer);
        return true;
    }

    @Override
    public String toString() {
        return this._tsContainer.toString();
    }

    @Override
    public Serializable retrieveRawData() {
        if (!this._rawContainerList.isEmpty()) {
            return (Serializable)this._rawContainerList.get(0);
        }
        return null;
    }

    public String getRawFullName() {
        String rawName = null;
        DSSPathString dssPath = new DSSPathString(this._tsContainer.getName());
        String rawFPart = this.getRawVersion(dssPath.getFPart());
        if (rawFPart != null) {
            dssPath.setFPart(rawFPart);
            rawName = dssPath.getPathname();
        }
        return rawName;
    }

    @Override
    public void deleteValues(Serializable data, TimeWindowMap timeWindowMap) {
        super.fireDeleteValues(data, timeWindowMap);
    }

    @Override
    public String getDataSourceLocation() {
        Object otherInfo = this._tsContainer.otherInfo;
        if (otherInfo instanceof CwmsAuthenticationSource) {
            return ((CwmsAuthenticationSource)otherInfo).getDisplayName();
        }
        return Optional.ofNullable(this._tsContainer.fileName).map(x$0 -> Paths.get(x$0, new String[0])).map(Path::getFileName).map(Object::toString).orElse("");
    }

    @Override
    public String getDataSourceLocationDetails() {
        Object otherInfo = this._tsContainer.otherInfo;
        if (otherInfo instanceof CwmsAuthenticationSource) {
            return ((CwmsAuthenticationSource)otherInfo).getHtmlDisplay();
        }
        return Optional.ofNullable(this._tsContainer.fileName).map(x$0 -> Paths.get(x$0, new String[0])).map(Object::toString).orElse("");
    }

    @Override
    public boolean hasQuality() {
        return this._tsContainer != null && this._tsContainer.getQuality() != null && this._tsContainer.getQuality7() != null;
    }

    void addComparison(TimeSeriesContainer readTS) {
        this._comparisonList.add(readTS);
    }

    void addComparison(ValidationDataSource validationDataSource) {
        this._comparisonDataSource.add(validationDataSource);
    }
}

