/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.ComparisonDataSource;
import hec.dataui.summary.awt.DataSetInfo;
import hec.dataui.summary.awt.DataSetInfoParser;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.DataSourceList;
import hec.dataui.tx.FilterProgressIndicator;
import hec.dataui.tx.TimeSeriesDataSource;
import hec.dataui.tx.TsContainerDataSource;
import hec.dataui.tx.awt.ValidationDataSource;
import hec.heclib.util.HecTime;
import hec.io.DSSIdentifier;
import hec.io.DssManagerBridge;
import hec.io.HecFile;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerQualityUtil;
import hec.model.TsDataSetName;
import hec.serversuite.ServerSuite;
import hec.serversuite.ServerSuiteUtil;
import hec.serversuite.data.CwmsAuthenticationSource;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesStatistics;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;
import rma.util.IllegalTimeIntervalLengthException;
import rma.util.IllegalTimeIntervalTypeException;
import rma.util.RMAIO;
import rma.util.TimeInterval;

public class ValidationDataSourceList
extends DataSourceList {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String LINE_ERROR = "Error while trying to read raw data from line: %s";
    Preferences _preferences;
    private DssManagerBridge _managerBridge;
    private DssManagerBridge _remoteManagerBridge;
    private HecTime _hecStartTime = null;
    private HecTime _hecEndTime = null;

    @Deprecated
    public ValidationDataSourceList(HecTime startTime, HecTime endTime, List<TimeSeriesContainer> valContainerList) {
        this(startTime, endTime, valContainerList, TimeZone.getDefault());
    }

    public ValidationDataSourceList(HecTime startTime, HecTime endTime, List<TimeSeriesContainer> valContainerList, TimeZone tz) {
        super(startTime, endTime, tz);
        ArrayList<DataSource> list = new ArrayList<DataSource>();
        for (TimeSeriesContainer timeSeriesContainer : valContainerList) {
            if (timeSeriesContainer == null) continue;
            TsContainerDataSource dataSource = new TsContainerDataSource(timeSeriesContainer, null);
            list.add(dataSource);
        }
        for (DataSource dataSource : list) {
            if (!(dataSource instanceof ComparisonDataSource)) continue;
            ComparisonDataSource comparisonDataSource = (ComparisonDataSource)dataSource;
            this.buildCompList(list, comparisonDataSource);
        }
        this.setSources(list);
    }

    public ValidationDataSourceList(HecTime startTime, HecTime endTime, TimeZone tz, Preferences preferences, Path file, DssManagerBridge managerBridge, DssManagerBridge remoteManagerBridge) {
        this(startTime, endTime, tz, preferences);
        this._managerBridge = managerBridge;
        this._remoteManagerBridge = remoteManagerBridge;
        this.readFile(file);
        boolean tf = this.initDataSources();
        if (!tf) {
            throw new IllegalArgumentException("Time Window is not defined in the Selection List File or in the Data Acquisition Mode.");
        }
    }

    public ValidationDataSourceList(HecTime startTime, HecTime endTime, TimeZone tz, Preferences preferences) {
        super(startTime, endTime, tz);
        this._hecStartTime = startTime;
        this._hecEndTime = endTime;
        this._preferences = preferences;
    }

    private void buildCompList(ArrayList<DataSource> list, ComparisonDataSource comparisonDataSource) {
        ArrayList<TimeSeriesContainer> dssComparisonList = new ArrayList<TimeSeriesContainer>();
        for (DataSource dataSource : list) {
            TimeSeriesContainer timeSeriesContainer;
            if (comparisonDataSource.equals(dataSource)) continue;
            if (dataSource instanceof TimeSeriesDataSource) {
                if (comparisonDataSource instanceof ValidationDataSource) {
                    ((ValidationDataSource)comparisonDataSource).addComparison(((TimeSeriesDataSource)dataSource).getValueTemplate());
                    continue;
                }
                if (!(comparisonDataSource instanceof TsContainerDataSource)) continue;
                ((TsContainerDataSource)comparisonDataSource).addComparison((ValidationDataSource)dataSource);
                continue;
            }
            if (!(dataSource instanceof TsContainerDataSource) || (timeSeriesContainer = dataSource.retrieveValueTsContainer()) == null) continue;
            dssComparisonList.add(timeSeriesContainer);
        }
        comparisonDataSource.setComparisonList(dssComparisonList);
    }

    @Override
    public void normalize() {
        DataSource dataSource;
        ArrayList<DataSource> list = new ArrayList<DataSource>();
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i) instanceof TsContainerDataSource) {
                list.add(this.get(i));
                continue;
            }
            if (!(this.get(i) instanceof ValidationDataSource)) continue;
            dataSource = (ValidationDataSource)this.get(i);
            ((ValidationDataSource)dataSource).setTrim(this._trim);
            dataSource.setTimeWindow(this._startTime, this._endTime);
            list.add(dataSource);
        }
        for (int ii = 0; ii < list.size(); ++ii) {
            dataSource = (DataSource)list.get(ii);
            if (!(dataSource instanceof ComparisonDataSource)) continue;
            ComparisonDataSource comparisonDataSource = (ComparisonDataSource)dataSource;
            this.buildCompList(list, comparisonDataSource);
        }
        this.setSources(list);
    }

    @Override
    public int getMode() {
        return 1;
    }

    @Override
    public int filter(JFrame parent) {
        if (!this._dataSourcesSet) {
            this.initDataSources();
        }
        String displayMode = null;
        if (this._preferences != null) {
            displayMode = this._preferences.get("Display Mode", "");
        }
        if (displayMode == null || !displayMode.equals("Display Locations With Specific Quality Flags")) {
            return this.size();
        }
        boolean showQ = true;
        boolean showR = true;
        boolean showM = true;
        if (this._preferences != null) {
            showQ = this._preferences.getBoolean("Questionable", true);
            showR = this._preferences.getBoolean("Rejected", true);
            showM = this._preferences.getBoolean("Missing", true);
        }
        if (!(showQ || showR || showM)) {
            return this.size();
        }
        FilterProgressIndicator fpi = null;
        if (parent != null) {
            fpi = new FilterProgressIndicator(parent, this.size());
            fpi.pack();
            fpi.setVisible(true);
        }
        ArrayList<DataSource> tmp = new ArrayList<DataSource>(this.size());
        for (int ii = 0; ii < this.size(); ++ii) {
            DataSource obj = this.get(ii);
            if (obj instanceof ValidationDataSource) {
                ValidationDataSource ds = (ValidationDataSource)this.get(ii);
                TimeSeries dstx = ds.retrieveValueTx();
                if (dstx == null) continue;
                TimeSeriesStatistics timeSeriesStatistics = dstx.getTimeSeriesStatistics();
                if (showQ && timeSeriesStatistics.getNumberValuesQuestion() > 0 || showR && timeSeriesStatistics.getNumberValuesReject() > 0 || showM && timeSeriesStatistics.getNumberValuesMissing() > 0) {
                    tmp.add(ds);
                    if (fpi == null) continue;
                    fpi.incrementProgress(true);
                    continue;
                }
                if (fpi == null) continue;
                fpi.incrementProgress(false);
                continue;
            }
            if (!(obj instanceof TsContainerDataSource)) continue;
            TsContainerDataSource tsContainer = (TsContainerDataSource)obj;
            if (showQ && TimeSeriesContainerQualityUtil.getNumberValuesQuestion((TimeSeriesContainer)tsContainer.retrieveValueTsContainer()) > 0 || showR && TimeSeriesContainerQualityUtil.getNumberValuesReject((TimeSeriesContainer)tsContainer.retrieveValueTsContainer()) > 0 || showM && TimeSeriesContainerQualityUtil.getNumberValuesMissing((TimeSeriesContainer)tsContainer.retrieveValueTsContainer()) > 0) {
                tmp.add(tsContainer);
                if (fpi == null) continue;
                fpi.incrementProgress(true);
                continue;
            }
            if (fpi == null) continue;
            fpi.incrementProgress(false);
        }
        if (fpi != null) {
            fpi.done();
        }
        this.setSources(tmp);
        return tmp.size();
    }

    private void parseRelativeTime(String string, TimeZone tz) {
        String lengthType = RMAIO.getParam((String)string, (String)"=");
        String type = RMAIO.getParam((String)lengthType, (String)" ");
        int length = RMAIO.parseInt((String)RMAIO.getType((String)lengthType, (String)" "));
        long endTime = System.currentTimeMillis();
        try {
            TimeInterval timeInterval = new TimeInterval(type, length);
            long interval = timeInterval.getInterval();
            this._startTime = endTime - interval;
            this._endTime = endTime;
            this._hecStartTime.setTimeInMillis(this._startTime);
            this._hecEndTime.setTimeInMillis(this._endTime);
            HecTime.convertTimeZone((HecTime)this._hecStartTime, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)tz);
            HecTime.convertTimeZone((HecTime)this._hecEndTime, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)tz);
        }
        catch (IllegalTimeIntervalLengthException | IllegalTimeIntervalTypeException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Error in line: %s", (Object)string);
        }
    }

    private void readFile(Path file) {
        boolean firstRaw = true;
        TimeZone tz = this._tz;
        try {
            DataSource primaryDataSource = null;
            List<String> lines = Files.readAllLines(file);
            for (String line : lines) {
                if ((line = line.trim()).isEmpty() || line.charAt(0) == '#') continue;
                String upperLine = line.toUpperCase();
                if (upperLine.contains("STARTTIME")) {
                    this._startTime = RMAIO.parseDate((String)RMAIO.getParam((String)line, (String)"="), (TimeZone)tz);
                    this._hecStartTime.setTimeInMillis(this._startTime);
                    HecTime.convertTimeZone((HecTime)this._hecStartTime, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)tz);
                    continue;
                }
                if (upperLine.contains("ENDTIME")) {
                    this._endTime = RMAIO.parseDate((String)RMAIO.getParam((String)line, (String)"="), (TimeZone)tz);
                    this._hecEndTime.setTimeInMillis(this._endTime);
                    HecTime.convertTimeZone((HecTime)this._hecEndTime, (TimeZone)TimeZone.getTimeZone("UTC"), (TimeZone)tz);
                    continue;
                }
                if (upperLine.contains("RELATIVETIME")) {
                    this.parseRelativeTime(line, tz);
                    continue;
                }
                if (upperLine.matches("\\s*PRIMARY\\s*=.*")) {
                    firstRaw = true;
                    primaryDataSource = this.buildPrimaryDataSource(line);
                    continue;
                }
                if (upperLine.matches("\\s*RAW\\s*=.*")) {
                    firstRaw = this.parseRaw(line, firstRaw, primaryDataSource);
                    continue;
                }
                if (primaryDataSource == null) continue;
                this.parseSecondary(line, primaryDataSource);
            }
        }
        catch (IOException ioe) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)ioe)).log("Could not create validation editor list from file: %s", (Object)file);
        }
    }

    private DataSource buildPrimaryDataSource(String line) {
        DataSource retval = null;
        try {
            String strSource = RMAIO.getParam((String)line, (String)"=");
            List<DataSetInfo> dataSetInfo = DataSetInfoParser.parseDataSetList(Collections.singletonList(strSource));
            if (!dataSetInfo.isEmpty()) {
                DataSetInfo primaryDsn = dataSetInfo.get(0);
                if (primaryDsn instanceof DataSetInfo.CwmsDataSetInfo) {
                    DataSetInfo.CwmsDataSetInfo cwmsDataSetInfo = (DataSetInfo.CwmsDataSetInfo)primaryDsn;
                    retval = this.buildCwmsDataSource(cwmsDataSetInfo);
                } else if (primaryDsn instanceof DataSetInfo.DssDataSetInfo) {
                    DataSetInfo.DssDataSetInfo dssDataSetInfo = (DataSetInfo.DssDataSetInfo)primaryDsn;
                    retval = this.buildDssDataSource(dssDataSetInfo);
                }
                if (retval != null) {
                    this.add(retval);
                }
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error deserializing line: %s to time series definition", (Object)line);
        }
        return retval;
    }

    private TsContainerDataSource buildDssDataSource(DataSetInfo.DssDataSetInfo dssDataSetInfo) {
        DssManagerBridge managerBridge;
        String filename;
        TsContainerDataSource retval = null;
        String filePath = dssDataSetInfo.getDataSourceLocation();
        String url = "";
        if (filePath.matches("//.*:.*:/.*")) {
            filename = filePath.substring(filePath.indexOf(58) + 1);
            filename = filename.substring(filename.indexOf(58) + 1);
            url = filePath.substring(0, filePath.indexOf(filename));
            filename = RMAIO.parsePathName((String)filename);
            managerBridge = this._remoteManagerBridge;
        } else {
            filename = RMAIO.parsePathName((String)filePath);
            managerBridge = this._managerBridge;
        }
        String pathname = dssDataSetInfo.getPathname();
        DSSIdentifier dssId = new DSSIdentifier(filename, pathname);
        if (managerBridge != null && managerBridge.doesDSSFileExist(filename) && this._hecStartTime != null && this._hecEndTime != null) {
            int recordType = managerBridge.recordType(filename, pathname);
            if (recordType != -1) {
                TimeSeriesContainer readTS = this.readTimeZoneAdjustedTS(dssId, managerBridge);
                readTS.fileName = url + readTS.fileName;
                if (readTS.numberValues < 1) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("DSS data doesnt exist for time window.%s", (Object)dssId);
                } else {
                    int rawRecordType;
                    retval = new TsContainerDataSource(readTS, null);
                    String rawFullName = retval.getRawFullName();
                    if (rawFullName != null && (rawRecordType = managerBridge.recordType(filename, rawFullName)) != -1) {
                        DSSIdentifier rawDssId = new DSSIdentifier(filename, rawFullName);
                        TimeSeriesContainer rawContainer = this.readTimeZoneAdjustedTS(rawDssId, managerBridge);
                        retval.setRawContainer(rawContainer);
                    }
                }
            }
        } else {
            TimeSeriesContainer emptyContainer = new TimeSeriesContainer();
            emptyContainer.fullName = pathname;
            retval = new TsContainerDataSource(emptyContainer, null);
            String rawFullName = retval.getRawFullName();
            if (rawFullName != null) {
                TimeSeriesContainer emptyRawContainer = new TimeSeriesContainer();
                emptyRawContainer.fullName = rawFullName;
                retval.setRawContainer(emptyRawContainer);
            }
        }
        return retval;
    }

    private ValidationDataSource buildCwmsDataSource(DataSetInfo.CwmsDataSetInfo cwmsDataSetInfo) throws DataSetException {
        TimeSeriesIdentifier primaryDesc = TimeSeriesIdentifierFactory.from((OfficeId)new OfficeId(cwmsDataSetInfo.getOfficeId()), (String)cwmsDataSetInfo.getPathname(), null);
        TimeSeriesTemplate primaryTemplate = new TimeSeriesTemplate(primaryDesc, this._startTime, this._endTime);
        CwmsAuthenticationSource cwmsAuthenticationSource = cwmsDataSetInfo.getCwmsAuthenticationSource().orElse(Optional.ofNullable(ServerSuiteUtil.getServerSuite()).map(ServerSuite::getServer).orElse(null));
        ValidationDataSource retval = null;
        if (cwmsAuthenticationSource != null) {
            retval = new ValidationDataSource(primaryTemplate, cwmsAuthenticationSource);
            retval.setTimeWindow(this._startTime, this._endTime);
        }
        return retval;
    }

    private void parseSecondary(String line, DataSource primaryDataSource) {
        try {
            TsDataSetName dsn = new TsDataSetName(line);
            if (primaryDataSource instanceof ValidationDataSource) {
                OfficeId officeId = ((ValidationDataSource)primaryDataSource).getValueTemplate().getTimeSeriesIdentifier().getOfficeId().orElse(null);
                TimeSeriesIdentifier secondaryDesc = TimeSeriesIdentifierFactory.from((OfficeId)officeId, (String)line, null);
                TimeSeriesTemplate secondaryTemplate = new TimeSeriesTemplate(secondaryDesc, this._startTime, this._endTime);
                ((ValidationDataSource)primaryDataSource).addComparison(secondaryTemplate);
            } else if (primaryDataSource instanceof ComparisonDataSource) {
                int recordType;
                DssManagerBridge managerBridge;
                String filename;
                String filePath = dsn.filename();
                String url = "";
                if (filePath.matches("//.*:.*:/.*")) {
                    filename = filePath.substring(filePath.indexOf(58) + 1);
                    filename = filename.substring(filename.indexOf(58) + 1);
                    url = filePath.substring(0, filePath.indexOf(filename));
                    filename = RMAIO.parsePathName((String)filename);
                    managerBridge = this._remoteManagerBridge;
                } else {
                    filename = RMAIO.parsePathName((String)filePath);
                    managerBridge = this._managerBridge;
                }
                String pathname = dsn.getPathname();
                DSSIdentifier dssId = new DSSIdentifier(filename, pathname);
                if (managerBridge != null && managerBridge.doesDSSFileExist(filename) && this._hecStartTime != null && this._hecEndTime != null && (recordType = managerBridge.recordType(filename, pathname)) != -1) {
                    TimeSeriesContainer readTS = this.readTimeZoneAdjustedTS(dssId, managerBridge);
                    readTS.fileName = url + readTS.fileName;
                    if (readTS.numberValues < 1) {
                        ((FluentLogger.Api)LOGGER.atInfo()).log("DSS data doesnt exist for time window. %s", (Object)dssId);
                    } else {
                        ((TsContainerDataSource)primaryDataSource).addComparison(readTS);
                    }
                }
            }
        }
        catch (RuntimeException | DataSetException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Failed to parse secondary data set %s", (Object)line);
        }
    }

    private boolean parseRaw(String string, boolean firstRaw, DataSource primaryDataSource) {
        if (primaryDataSource instanceof ValidationDataSource) {
            if (firstRaw) {
                ((ValidationDataSource)primaryDataSource).setRawTemplate(null);
                firstRaw = false;
            }
            this.readRawOracleLine(string, (ValidationDataSource)primaryDataSource);
        } else if (primaryDataSource instanceof TsContainerDataSource) {
            if (firstRaw) {
                ((TsContainerDataSource)primaryDataSource).setRawContainer(null);
                firstRaw = false;
            }
            this.readRawDSSLine(string, (TsContainerDataSource)primaryDataSource);
        }
        return firstRaw;
    }

    private DssManagerBridge getDSSManager(String filePath) {
        return filePath.matches("//.*:.*:/.*") ? this._remoteManagerBridge : this._managerBridge;
    }

    private String getFileName(String filePath) {
        String filename;
        if (filePath.matches("//.*:.*:/.*")) {
            filename = filePath.substring(filePath.indexOf(58) + 1);
            filename = filename.substring(filename.indexOf(58) + 1);
            filename = RMAIO.parsePathName((String)filename);
        } else {
            filename = RMAIO.parsePathName((String)filePath);
        }
        return filename;
    }

    private String getUrl(String filePath) {
        String url = "";
        if (filePath.matches("//.*:.*:/.*")) {
            String filename = filePath.substring(filePath.indexOf(58) + 1);
            filename = filename.substring(filename.indexOf(58) + 1);
            url = filePath.substring(0, filePath.indexOf(filename));
        }
        return url;
    }

    private boolean baseParameterEqual(TsDataSetName dsn, TsDataSetName primaryDsn) {
        String primParameter = primaryDsn.getParameter();
        String primBaseParameter = ParameterLookup.parseBaseParameter((String)primParameter);
        String parameter = dsn.getParameter();
        String baseParameter = ParameterLookup.parseBaseParameter((String)parameter);
        return primBaseParameter.equalsIgnoreCase(baseParameter);
    }

    private void addRawContainer(TimeSeriesContainer readTS, String url, DSSIdentifier dssId, TsContainerDataSource tsDataSource) {
        if (readTS.numberValues < 1) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("DSS data doesnt exist for time window. %s", (Object)dssId);
        } else if (tsDataSource != null) {
            readTS.fileName = url + readTS.fileName;
            tsDataSource.addRawContainer(readTS);
        }
    }

    private void fillEmpty(TsDataSetName dsn, TsDataSetName primaryDsn) {
        if (dsn.getAPart().isEmpty()) {
            dsn.setAPart(primaryDsn.getAPart());
        }
        if (dsn.getBPart().isEmpty()) {
            dsn.setBPart(primaryDsn.getBPart());
        }
        if (dsn.getCPart().isEmpty()) {
            dsn.setCPart(primaryDsn.getCPart());
        }
        if (dsn.getDPart().isEmpty()) {
            dsn.setDPart(primaryDsn.getDPart());
        }
        if (dsn.getEPart().isEmpty()) {
            dsn.setEPart(primaryDsn.getEPart());
        }
        if (dsn.getFPart().isEmpty()) {
            dsn.setFPart(primaryDsn.getFPart());
        }
    }

    private void readRawDSSLine(String line, TsContainerDataSource tsDataSource) {
        try {
            String strSource = RMAIO.getParam((String)line, (String)"=");
            TsDataSetName dsn = new TsDataSetName(strSource);
            String filePath = dsn.filename();
            DssManagerBridge managerBridge = this.getDSSManager(filePath);
            String filename = this.getFileName(filePath);
            String url = this.getUrl(filePath);
            TsDataSetName primaryDsn = new TsDataSetName(tsDataSource.getName());
            this.fillEmpty(dsn, primaryDsn);
            if (this.baseParameterEqual(dsn, primaryDsn) && dsn.getEPart().equalsIgnoreCase(primaryDsn.getEPart())) {
                DSSIdentifier dssId = new DSSIdentifier(filename, dsn.getPathname());
                if (managerBridge != null && managerBridge.doesDSSFileExist(filename) && this._hecStartTime != null && this._hecEndTime != null && managerBridge.recordType(filename, dsn.getPathname()) != -1) {
                    TimeSeriesContainer readTS = this.readTimeZoneAdjustedTS(dssId, managerBridge);
                    this.addRawContainer(readTS, url, dssId, tsDataSource);
                }
            } else if (!this.baseParameterEqual(dsn, primaryDsn)) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Error while trying to read raw data from line: %s\nPrimary and Raw base parameter (C-part) do not match.", (Object)line);
            } else {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Error while trying to read raw data from line: %s\nInterval (E-part) do not match.", (Object)line);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error while trying to read raw data from line: \n%s", (Object)line);
        }
    }

    private void readRawOracleLine(String line, ValidationDataSource primaryDataSource) {
        try {
            String strSource = RMAIO.getParam((String)line, (String)"=");
            TsDataSetName dsn = new TsDataSetName(strSource);
            TsDataSetName primaryDsn = new TsDataSetName(primaryDataSource.getValueTemplate().getTimeSeriesIdentifier().getTimeSeriesId());
            this.fillEmpty(dsn, primaryDsn);
            if (this.baseParameterEqual(dsn, primaryDsn) && dsn.getDPart().equalsIgnoreCase(primaryDsn.getDPart())) {
                strSource = dsn.getPathname();
                OfficeId officeId = primaryDataSource.getValueTemplate().getTimeSeriesIdentifier().getOfficeId().orElse(null);
                TimeSeriesIdentifier rawDesc = TimeSeriesIdentifierFactory.from((OfficeId)officeId, (String)strSource, null);
                TimeSeriesTemplate rawTemplate = new TimeSeriesTemplate(rawDesc, this._startTime, this._endTime);
                primaryDataSource.setRawTemplate(rawTemplate);
            } else if (!this.baseParameterEqual(dsn, primaryDsn)) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Error while trying to read raw data from line: %s\nPrimary and Raw base parameter do not match.", (Object)line);
            } else {
                ((FluentLogger.Api)LOGGER.atWarning()).log("Error while trying to read raw data from line: %s\nInterval do not match.", (Object)line);
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error while trying to read raw data from line: \n%s", (Object)line);
        }
    }

    public boolean writeFile(HecFile file) {
        BufferedWriter bw = file.getBufferedWriter();
        try {
            for (int ii = 0; ii < this.size(); ++ii) {
                DataSource source = this.get(ii);
                bw.write(source.toString());
                bw.newLine();
            }
            bw.close();
            return true;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    @Override
    public void tabulate() {
        ((FluentLogger.Api)LOGGER.atInfo()).log("%s Data Sources in List", this.size());
        for (int ii = 0; ii < this.size(); ++ii) {
            DataSource source = this.get(ii);
            ((FluentLogger.Api)LOGGER.atInfo()).log("Data Source %s: %s", ii, (Object)source.tabulate());
        }
    }

    private TimeSeriesContainer readTimeZoneAdjustedTS(DSSIdentifier dssId, DssManagerBridge managerBridge) {
        HecTime timeRead = new HecTime(this._hecStartTime);
        timeRead.subtractHours(12);
        dssId.setStartTime(timeRead);
        timeRead = new HecTime(this._hecEndTime);
        timeRead.addHours(12);
        dssId.setEndTime(timeRead);
        TimeSeriesContainer readTS = managerBridge.readTS(dssId, true);
        if (readTS.numberValues < 1) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("%s has no data for time window.", (Object)dssId);
        } else {
            HecTime startTimeTS = new HecTime(this._hecStartTime);
            HecTime endTimeTS = new HecTime(this._hecEndTime);
            if (readTS.timeZoneID != null) {
                HecTime.convertTimeZone((HecTime)startTimeTS, (TimeZone)this._tz, (TimeZone)TimeZone.getTimeZone(readTS.timeZoneID), (boolean)false);
                HecTime.convertTimeZone((HecTime)endTimeTS, (TimeZone)this._tz, (TimeZone)TimeZone.getTimeZone(readTS.timeZoneID), (boolean)false);
            }
            readTS.trimToTime(startTimeTS, endTimeTS, true);
        }
        return readTS;
    }
}

