/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx;

import com.google.common.flogger.FluentLogger;
import hec.data.TimeSeriesDataEditorListener;
import hec.data.TimeWindowMap;
import hec.dataui.summary.awt.DataStatusSummary;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.DataSourceList;
import hec.dataui.tx.DataVerificationModeSelector;
import hec.dataui.tx.awt.VerifyDataDlg;
import hec.heclib.util.HecTime;
import hec.io.DssManagerBridge;
import hec.io.TimeSeriesContainer;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import rma.util.RMAIO;

public final class ValidationFactory {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();

    private ValidationFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static void showDataVerify(DataStatusSummary parent, Preferences preferences, DssManagerBridge dssManager, Runnable filterDslRunnable) {
        List<DataSource> selectedDataSets = parent.getValidationSelectedDataSources();
        if (selectedDataSets.isEmpty()) {
            return;
        }
        HecTime startTime = parent.getStartTime();
        HecTime endTime = parent.getEndTime();
        TimeZone timeZone = parent.getTimeZone();
        List<Path> fileList = null;
        boolean listMode = false;
        DataVerificationModeSelector modeSelector = new DataVerificationModeSelector((JFrame)((Object)parent), startTime, endTime, timeZone, selectedDataSets, fileList, listMode, preferences, dssManager, null);
        modeSelector.setVisible(true);
        if (modeSelector.getCanceled()) {
            return;
        }
        DataSourceList dsl = modeSelector.getDataSourceList();
        if (dsl == null) {
            return;
        }
        FilterDsl filterDsl = new FilterDsl(dsl, filterDslRunnable, (JFrame)((Object)parent), dssManager);
        filterDsl.start();
    }

    static final class FilterDsl
    extends Thread {
        private final DataSourceList _dsl;
        private final JFrame _frame;
        private final DssManagerBridge _dssManager;
        private final Runnable _runFilterDslClose;

        public FilterDsl(DataSourceList dsl, Runnable runnable, JFrame frame, DssManagerBridge dssManager) {
            this._dsl = dsl;
            this._runFilterDslClose = runnable;
            this._frame = frame;
            this._dssManager = dssManager;
        }

        @Override
        public void run() {
            int numrecs = this._dsl.filter(this._frame);
            if (numrecs < 1) {
                SwingUtilities.invokeLater(() -> RMAIO.postError((Component)this._frame, (String)"No Data Sets match Filtering Criteria."));
                return;
            }
            SwingUtilities.invokeLater(() -> {
                VerifyDataDlg dlg = new VerifyDataDlg(this._dsl);
                if (this._frame != null) {
                    dlg.setIconImage(this._frame.getIconImage());
                }
                this._dsl.addDataEditorListener((TimeSeriesDataEditorListener)new TimeSeriesDataEditorListener<Serializable>(){

                    public void plot(List objects) {
                    }

                    public boolean save(Serializable object) {
                        if (object instanceof TimeSeriesContainer) {
                            _dssManager.writeTS((TimeSeriesContainer)object, 0, 1);
                        }
                        return true;
                    }

                    public boolean saveAs(Serializable object) {
                        return true;
                    }

                    public void tabulate(List objects) {
                    }

                    public int deleteValues(Map<Serializable, TimeWindowMap> timeSeriesTimeWindowMap) {
                        return 0;
                    }
                });
                dlg.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        if (_runFilterDslClose != null) {
                            _runFilterDslClose.run();
                        }
                    }
                });
                dlg.setVisible(true);
            });
        }
    }
}

