/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.data.DataSetException;
import hec.db.DataAccessFactory;
import hec.db.DbConnectionException;
import hec.db.DbNoDataFoundException;
import hec.db.cwms.CwmsTimeSeriesDao;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerFactory;
import hec.io.TimeSeriesContainerTimeZoneCheck;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierFactory;

public abstract class DisplayOracleTS
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(DisplayOracleTS.class.getName());
    private final Map<DataAccessFactory, List<TimeSeriesTemplate>> _dataTemplates;
    private final int _unitSystem;
    protected boolean _canceled;

    public DisplayOracleTS(Map<DataAccessFactory, List<TimeSeriesTemplate>> dataTemplates, int unitSystem) {
        this._dataTemplates = dataTemplates;
        this._unitSystem = unitSystem;
        this._canceled = false;
    }

    public final void cancel() {
        this._canceled = true;
    }

    protected abstract void addContainer(TimeSeriesContainer var1);

    public abstract void displayData(List<TimeSeriesContainer> var1);

    public String getErrors(List<TimeSeriesContainer> tsContainers) {
        List containersNotFound = tsContainers.stream().filter(s -> s.getNumberValues() == 0).collect(Collectors.toList());
        StringBuilder message = new StringBuilder();
        if (!containersNotFound.isEmpty()) {
            TimeSeriesContainer tsc = (TimeSeriesContainer)containersNotFound.get(0);
            message.append("Data not found for the following:");
            if (tsc.startTime > 0 && tsc.endTime > 0) {
                HecTime start = new HecTime(tsc.startTime, 1);
                HecTime end = new HecTime(tsc.endTime, 1);
                message.append("\nTime window:  ").append(start.toString(7)).append(";   ").append(end.toString(7));
            }
        }
        for (TimeSeriesContainer tsContainer : containersNotFound) {
            message.append("\n").append("Data Source: ").append(tsContainer.fileName).append(" ").append(tsContainer.getFullVersionedName());
        }
        return message.toString();
    }

    public void showErrors(String message) {
        LOGGER.info(message);
    }

    @Override
    public final void run() {
        LOGGER.log(Level.FINE, () -> "Running under thread: " + Thread.currentThread().getName());
        this._canceled = false;
        List<TimeSeriesContainer> timeSeriesContainers = this.retrieveTimeSeriesData();
        ArrayList<TimeSeriesContainer> tsContainers = new ArrayList<TimeSeriesContainer>();
        ArrayList<TimeSeriesContainer> tsNotFound = new ArrayList<TimeSeriesContainer>();
        for (TimeSeriesContainer tsc : timeSeriesContainers) {
            if (tsc.values == null) {
                tsNotFound.add(tsc);
                continue;
            }
            tsContainers.add(tsc);
        }
        LOGGER.log(Level.INFO, "{0} data sets processed; {1} data sets retrieved.", new Object[]{this._dataTemplates.values().stream().mapToLong(Collection::size).sum(), tsContainers.size()});
        if (!tsNotFound.isEmpty()) {
            String message = this.getErrors(tsNotFound);
            this.showErrors(message);
        }
        TimeSeriesContainerTimeZoneCheck.checkTimezone(new Vector<TimeSeriesContainer>(timeSeriesContainers));
        this.displayData(timeSeriesContainers);
    }

    private List<TimeSeriesContainer> retrieveTimeSeriesData() {
        HashMap<String, Map<TimeSeriesTemplate, CompletableFuture<TimeSeriesContainer>>> futures = new HashMap<String, Map<TimeSeriesTemplate, CompletableFuture<TimeSeriesContainer>>>();
        for (Map.Entry<DataAccessFactory, List<TimeSeriesTemplate>> entry : this._dataTemplates.entrySet()) {
            List<TimeSeriesTemplate> timeSeriesTemplates = entry.getValue();
            DataAccessFactory dataAccessFactory = entry.getKey();
            CwmsTimeSeriesDao timeSeriesDao = (CwmsTimeSeriesDao)dataAccessFactory.getDao(CwmsTimeSeriesDao.class);
            try {
                String databaseUrl = dataAccessFactory.getDataSourceUrl();
                if (timeSeriesDao == null) continue;
                LOGGER.log(Level.FINER, "Processing {0} Records", timeSeriesTemplates.size());
                for (TimeSeriesTemplate template : timeSeriesTemplates) {
                    LOGGER.log(Level.FINER, "Submitting time series retrieve for: {0}", template);
                    CompletionStage future = ((CompletableFuture)timeSeriesDao.submitRetrieveTimeSeries(dataAccessFactory, template, false).thenApplyAsync(t -> this.wrapWithContainer((TimeSeries)t, databaseUrl), SwingUtilities::invokeLater)).exceptionally(e -> this.handleError((Throwable)e, template, databaseUrl));
                    Map templates = futures.computeIfAbsent(databaseUrl, d -> new HashMap());
                    templates.put(template, future);
                    if (!this._canceled) continue;
                    return new ArrayList<TimeSeriesContainer>();
                }
            }
            catch (DbConnectionException e2) {
                LOGGER.log(Level.WARNING, e2, () -> "Unable to obtain data source URL from: " + dataAccessFactory);
            }
        }
        return this.createContainers(futures);
    }

    private TimeSeriesContainer wrapWithContainer(TimeSeries data, String databaseUrl) {
        if (this._unitSystem != 0) {
            this.updateUnitSystem(data);
        }
        try {
            TimeSeriesContainer retval = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)data);
            retval.fileName = databaseUrl;
            this.addContainer(retval);
            LOGGER.log(Level.INFO, "Data found for: {0} from data source {1}", new Object[]{data.getTimeSeriesIdentifier(), databaseUrl});
            return retval;
        }
        catch (DataSetTimeSeriesException e) {
            throw new IllegalStateException(e);
        }
    }

    private TimeSeriesContainer handleError(Throwable e, TimeSeriesTemplate template, String databaseUrl) {
        if (e.getCause() instanceof DbNoDataFoundException || e.getCause().getCause() instanceof DbNoDataFoundException) {
            LOGGER.info("No data found for time series id: " + template.getTimeSeriesIdentifier() + " at URL: " + databaseUrl);
            LOGGER.log(Level.FINE, e, () -> e.getCause().getMessage().substring(0, e.getMessage().indexOf(10)));
        } else {
            LOGGER.log(Level.WARNING, e, () -> "Error while retrieving time series: \n" + template + "\nAt URL: " + databaseUrl);
        }
        try {
            String timeSeriesId = template.getTimeSeriesIdentifier().getTimeSeriesId();
            OfficeId officeId = template.getTimeSeriesIdentifier().getOfficeId().orElse(null);
            TimeSeriesIdentifier timeSeriesIdentifier = TimeSeriesIdentifierFactory.from((OfficeId)officeId, (String)timeSeriesId, (ZoneId)NumericalConstants.UTC_ZONEID);
            Units defaultUnits = timeSeriesIdentifier.getParameter().getDefaultUnits();
            TimeSeries timeSeries = TimeSeriesBuilder.createBuilder((TimeSeriesIdentifier)timeSeriesIdentifier, (Units)defaultUnits).build();
            TimeSeriesContainer timeSeriesContainer = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)timeSeries);
            timeSeriesContainer.fileName = databaseUrl;
            return timeSeriesContainer;
        }
        catch (mil.army.usace.hec.metadata.DataSetException ex) {
            throw new DataSetException((Throwable)ex);
        }
    }

    private List<TimeSeriesContainer> createContainers(Map<String, Map<TimeSeriesTemplate, CompletableFuture<TimeSeriesContainer>>> futures) {
        ArrayList<TimeSeriesContainer> retval = new ArrayList<TimeSeriesContainer>();
        try {
            for (Map.Entry<String, Map<TimeSeriesTemplate, CompletableFuture<TimeSeriesContainer>>> entry : futures.entrySet()) {
                Map<TimeSeriesTemplate, CompletableFuture<TimeSeriesContainer>> value = entry.getValue();
                for (Map.Entry<TimeSeriesTemplate, CompletableFuture<TimeSeriesContainer>> template : value.entrySet()) {
                    try {
                        retval.add(template.getValue().get());
                    }
                    catch (ExecutionException e) {
                        LOGGER.log(Level.WARNING, e, () -> "Error while retrieving time series: " + (String)entry.getKey() + " from data source: " + (String)entry.getKey());
                    }
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.FINE, "Thread interrupted while retrieving time series", e);
            Thread.currentThread().interrupt();
        }
        return retval;
    }

    private void updateUnitSystem(TimeSeries data) {
        try {
            data.changeUnitSystem(this._unitSystem);
        }
        catch (DataSetIllegalArgumentException | UnitsConversionException | DataSetTimeSeriesException e) {
            LOGGER.log(Level.FINE, "Error converting units for retrieved data.", e);
        }
    }
}

