/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.heclib.util.HecTimeArray;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import java.util.TimeZone;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import rma.swing.DateTimeGroup;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJDialog;

public class InputDateDialog
extends RmaJDialog {
    public boolean ok;
    JLabel wrappingLabel_message;
    RmaJCalendarField dateField;
    RmaJ24HourTimeField timeField;
    JPanel panel_buttons;
    JPanel panel_text;
    JButton buttonOk;
    JButton buttonCancel;
    DateTimeGroup dateTimeGroup;
    private String _userResponse = "";
    private String _message = "";
    private String _defaultText = "";

    public InputDateDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.init();
    }

    public InputDateDialog(Frame parent, String title, boolean modal) {
        this(parent, modal);
        this.setTitle(title);
    }

    public static void main(String[] args) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception exception) {
            // empty catch block
        }
        InputDateDialog dlg = new InputDateDialog(null, true);
        dlg.setValue("01Feb2000 0130");
        dlg.setMessage("Enter new date/time");
        dlg.setVisible(true);
        if (dlg.ok) {
            String datestr = dlg.getDateString();
            String timestr = dlg.getTimeString();
            boolean bl = false;
        }
    }

    public String getTimeString() {
        return this.timeField.getText();
    }

    public String getDateString() {
        return this.dateField.getText();
    }

    public void setDefaultText(String txt) {
        this._defaultText = txt;
        this.dateField.setText(this._defaultText);
    }

    public void setMessage(String msg) {
        String msgout = "<html><font color=white><center><font size=-1>" + msg + "</html>";
        JTextArea htmlTextArea = new JTextArea();
        htmlTextArea.setText(msgout);
        this.wrappingLabel_message.setText(htmlTextArea.getText());
    }

    public String getValue() {
        String txt = this._userResponse;
        return txt;
    }

    public void setValue(String dateStr) {
        if (dateStr.length() < 1) {
            return;
        }
        String str1 = "";
        String str2 = "";
        String date = "";
        String time = "";
        StringTokenizer parser = new StringTokenizer(dateStr, " ,;");
        if (parser.countTokens() <= 1) {
            date = dateStr;
        } else {
            str1 = new String(parser.nextToken());
            str2 = new String(parser.nextToken());
            date = str1;
            time = str2;
            if (str1.length() >= str2.length()) {
                date = str1;
                time = str2;
            }
        }
        this.dateField.setText(date);
        this.timeField.setText(time);
    }

    public void setDateTime(HecTimeArray hta, TimeZone displayTimeZone) {
        if (hta != null) {
            this.dateTimeGroup.setDateTime(hta);
        }
        if (displayTimeZone != null) {
            this.dateTimeGroup.setDisplayTimeZone(displayTimeZone);
        }
    }

    public HecTimeArray getDateTime() {
        return this.dateTimeGroup.getDateTime();
    }

    private void init() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getContentPane().setLayout(gridBagLayout);
        this.setVisible(false);
        this.setSize(300, 143);
        this.wrappingLabel_message = new JLabel("Text");
        this.wrappingLabel_message.setDisplayedMnemonic('T');
        this.wrappingLabel_message.setOpaque(true);
        this.wrappingLabel_message.setForeground(Color.white.brighter());
        this.wrappingLabel_message.setBackground(Color.cyan.darker().darker());
        this.wrappingLabel_message.setHorizontalAlignment(0);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.ipady = 20;
        gbc.fill = 1;
        gbc.insets = new Insets(6, 4, 6, 4);
        this.getContentPane().add((Component)this.wrappingLabel_message, gbc);
        this.panel_buttons = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.panel_buttons.setLayout(gridBagLayout);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(8, 10, 5, 10);
        this.getContentPane().add((Component)this.panel_buttons, gbc);
        this.buttonOk = new JButton("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.ipadx = 20;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.panel_buttons.add((Component)this.buttonOk, gbc);
        this.buttonCancel = new JButton("Cancel");
        this.buttonCancel.setBounds(96, 0, 84, 23);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.ipadx = 10;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.panel_buttons.add((Component)this.buttonCancel, gbc);
        this.panel_text = new JPanel();
        gridBagLayout = new GridBagLayout();
        this.panel_text.setLayout(gridBagLayout);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(5, 10, 5, 10);
        this.getContentPane().add((Component)this.panel_text, gbc);
        this.dateField = new RmaJCalendarField();
        this.wrappingLabel_message.setLabelFor((Component)this.dateField);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 0, 0, 8);
        this.panel_text.add((Component)this.dateField, gbc);
        this.timeField = new RmaJ24HourTimeField();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.ipadx = 80;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 8, 0, 0);
        this.panel_text.add((Component)this.timeField, gbc);
        this.setTitle("Input Date/Time");
        this.dateTimeGroup = new DateTimeGroup(this.dateField, this.timeField);
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.buttonOk.addActionListener(lSymAction);
        this.buttonCancel.addActionListener(lSymAction);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    public void setVisible(boolean b) {
        if (b && this.getParent() != null) {
            Rectangle bounds = this.getParent().getBounds();
            Rectangle abounds = this.getBounds();
            if (bounds.getCenterX() == 0.0 || bounds.getCenterY() == 0.0) {
                this.setLocation(60, 40);
            } else {
                this.setLocation(bounds.x + (bounds.width - abounds.width) / 2, bounds.y + (bounds.height - abounds.height) / 2);
            }
        }
        super.setVisible(b);
    }

    void InputDateDialog_WindowClosing(WindowEvent event) {
    }

    void buttonOk_Action(ActionEvent event) {
        this._userResponse = this.dateField.getText();
        this.ok = true;
        this.close();
    }

    void buttonCancel_Action(ActionEvent event) {
        this.ok = false;
        this.close();
    }

    void close() {
        this.setVisible(false);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == InputDateDialog.this) {
                InputDateDialog.this.InputDateDialog_WindowClosing(event);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == InputDateDialog.this.buttonOk) {
                InputDateDialog.this.buttonOk_Action(event);
            } else if (object == InputDateDialog.this.buttonCancel) {
                InputDateDialog.this.buttonCancel_Action(event);
            }
        }
    }
}

