/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.dataui.tx.awt.InterpolationLineGlyph;
import hec.geometry.LocalPt;
import hec.gfx2d.G2dEditComponent;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dMouseAdapter;
import hec.gfx2d.Viewport;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.JPanel;

public class InterpolationLineAdapter
extends G2dMouseAdapter {
    static int[] _xpt = new int[4];
    static int[] _ypt = new int[4];
    static int[] _xp = new int[400];
    static int[] _yp = new int[400];
    G2dEditComponent eComp = null;
    JPanel _graphicsPanel = null;
    InterpolationLineGlyph _glyph = null;
    Vector _editableGlyphs = new Vector();
    Vector _ptVec = new Vector();
    LocalPt _beginPt = new LocalPt();
    LocalPt _endPt = new LocalPt();
    LocalPt _pt = new LocalPt();
    LocalPt _pt0 = new LocalPt();
    boolean _creatingLine = false;
    LocalPt _ptAbs = new LocalPt();
    LocalPt _ptAbsCorrected = new LocalPt();
    private double _windowYSize;
    private double _windowXSize;

    public InterpolationLineAdapter(G2dEditComponent c, JPanel comp) {
        this.eComp = c;
        this._graphicsPanel = comp;
        this._viewport = (Viewport)this.eComp;
        this.getWindowSize();
    }

    public void getWindowSize() {
        Dimension d = this._graphicsPanel.getSize();
        this._windowXSize = d.getWidth();
        this._windowYSize = d.getHeight();
    }

    public void init() {
        this._graphicsPanel.getParent().addMouseListener((MouseListener)((Object)this));
        this._graphicsPanel.getParent().addMouseMotionListener((MouseMotionListener)((Object)this));
    }

    public void abort() {
        super.abort();
        this._graphicsPanel.getParent().removeMouseListener((MouseListener)((Object)this));
        this._graphicsPanel.getParent().removeMouseMotionListener((MouseMotionListener)((Object)this));
        int len = this._ptVec.size();
        if (len > 0 && ((LocalPt)this._ptVec.elementAt((int)(len - 1))).x > this._pt.x) {
            for (int i = len - 1; i >= 0; --i) {
                LocalPt tmpPt = (LocalPt)this._ptVec.elementAt(i);
                this._ptVec.removeElementAt(i);
            }
            this._viewport.paintImmediately(new Rectangle(this._viewport.getSize()));
            this.drawVector(this._ptVec);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (InterpolationLineAdapter.pressedButton3((MouseEvent)e) && this._creatingLine) {
            this._viewport.setCursor(this.getCursor());
            this._creatingLine = false;
            int len = this._ptVec.size();
            this._viewport.setDirty();
            if (len > 1) {
                this.findGlyph();
                if (this._glyph != null) {
                    this._glyph.createLine(this._ptVec);
                }
            } else {
                this._viewport.paintImmediately(new Rectangle(this._viewport.getSize()));
            }
            this._ptVec.removeAllElements();
        }
    }

    public void mousePressed(MouseEvent e) {
        if (this._viewport == null) {
            return;
        }
        if (!this.findGlyph()) {
            return;
        }
        boolean isInViewPort = this.getCoordinatesOutsideViewport(e);
        if (InterpolationLineAdapter.pressedButton1((MouseEvent)e)) {
            if (this._creatingLine) {
                if (isInViewPort) {
                    this._pt0.init(this._pt);
                } else {
                    this._pt0.init(this._ptAbsCorrected);
                }
                int len = this._ptVec.size();
                if (len > 0 && ((LocalPt)this._ptVec.elementAt((int)(len - 1))).x > this._pt.x) {
                    for (int i = len - 1; i >= 0; --i) {
                        LocalPt tmpPt = (LocalPt)this._ptVec.elementAt(i);
                        if (tmpPt.x < this._pt.x) break;
                        this._ptVec.removeElementAt(i);
                    }
                    if (isInViewPort) {
                        this._ptVec.addElement(new LocalPt(this._pt));
                    } else {
                        this._ptVec.addElement(new LocalPt(this._ptAbsCorrected));
                    }
                    this._viewport.paintImmediately(new Rectangle(this._viewport.getSize()));
                    this.drawVector(this._ptVec);
                } else if (isInViewPort) {
                    this.drawPt(this._pt, true);
                    this._ptVec.addElement(new LocalPt(this._pt));
                } else {
                    this.drawPt(this._ptAbsCorrected, true);
                    this._ptVec.addElement(new LocalPt(this._ptAbsCorrected));
                }
            } else if (!this._creatingLine && InterpolationLineAdapter.pressedButton1((MouseEvent)e)) {
                this._viewport.setCursor(Cursor.getPredefinedCursor(1));
                if (isInViewPort) {
                    this._creatingLine = true;
                    this._pt0.init(e.getX(), e.getY());
                    this._pt.init(this._pt0);
                    this.drawPt(this._pt, true);
                    this._ptVec.removeAllElements();
                    this._ptVec.addElement(new LocalPt(this._pt));
                }
            }
        }
    }

    public void mouseDragged(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
        if (this._creatingLine) {
            Graphics g = this._graphicsPanel.getGraphics();
            g.setXORMode(new Color(255, 255, 255));
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            this._ptAbs.init(MouseInfo.getPointerInfo().getLocation().x, MouseInfo.getPointerInfo().getLocation().y);
            Point origin = this._graphicsPanel.getLocationOnScreen();
            this._pt.init(this._ptAbs.x - origin.x, this._ptAbs.y - origin.y);
            g.drawLine(this._pt0.x, this._pt0.y, this._pt.x, this._pt.y);
            g.setPaintMode();
            g.dispose();
        }
    }

    protected boolean getCoordinatesOutsideViewport(MouseEvent e) {
        Object src = e.getSource();
        if (src.getClass().equals(this._graphicsPanel.getParent().getClass())) {
            double xMin = 0.0;
            double xMax = 0.0 + this._windowXSize;
            double yMin = 0.0;
            double yMax = 0.0 + this._windowYSize;
            double xUsingMax = (double)this._pt0.x + (double)(this._pt.x - this._pt0.x) * ((yMax - (double)this._pt0.y) / ((double)this._pt.y - (double)this._pt0.y));
            double xUsingMin = (double)this._pt0.x + (double)(this._pt.x - this._pt0.x) * ((yMin - (double)this._pt0.y) / ((double)this._pt.y - (double)this._pt0.y));
            double yUsingMax = (double)this._pt0.y + (double)(this._pt.y - this._pt0.y) * ((xMax - (double)this._pt0.x) / ((double)this._pt.x - (double)this._pt0.x));
            double yUsingMin = (double)this._pt0.y + (double)(this._pt.y - this._pt0.y) * ((xMin - (double)this._pt0.x) / ((double)this._pt.x - (double)this._pt0.x));
            if (yMax < (double)this._pt.y && xMin < xUsingMax && xMax > xUsingMax) {
                this._ptAbsCorrected.init((int)Math.round(xUsingMax), (int)Math.round(yMax));
            } else if (yMin > (double)this._pt.y && xMin < xUsingMin && xMax > xUsingMin) {
                this._ptAbsCorrected.init((int)Math.round(xUsingMin), (int)Math.round(yMin));
            } else if (xMax < (double)this._pt.x && yMin < yUsingMax && yMax > yUsingMax) {
                this._ptAbsCorrected.init((int)Math.round(xMax), (int)Math.round(yUsingMax));
            } else if (xMin > (double)this._pt.x && yMin < yUsingMin && yMax > yUsingMin) {
                this._ptAbsCorrected.init((int)Math.round(xMin), (int)Math.round(yUsingMin));
            }
            return false;
        }
        return true;
    }

    boolean findGlyph() {
        if (this.eComp == null) {
            return false;
        }
        Vector glyphVec = this.eComp.getGlyphVector();
        int nglyphs = glyphVec.size();
        this._editableGlyphs.removeAllElements();
        for (int i = 0; i < nglyphs; ++i) {
            G2dGlyph g = (G2dGlyph)glyphVec.elementAt(i);
            if (!(g instanceof InterpolationLineGlyph)) continue;
            this._editableGlyphs.add(g);
        }
        if (this._editableGlyphs == null || this._editableGlyphs.isEmpty()) {
            return false;
        }
        nglyphs = this._editableGlyphs.size();
        this._glyph = (InterpolationLineGlyph)this._editableGlyphs.elementAt(0);
        return true;
    }

    void drawPt(LocalPt pt, boolean isXOR) {
        Graphics g = this._graphicsPanel.getGraphics();
        if (isXOR) {
            g.setXORMode(new Color(255, 255, 255));
        } else {
            g.setColor(Color.black);
        }
        InterpolationLineAdapter._xpt[0] = pt.x - 3;
        InterpolationLineAdapter._ypt[0] = pt.y;
        InterpolationLineAdapter._xpt[1] = pt.x;
        InterpolationLineAdapter._ypt[1] = pt.y + 3;
        InterpolationLineAdapter._xpt[2] = pt.x + 3;
        InterpolationLineAdapter._ypt[2] = pt.y;
        InterpolationLineAdapter._xpt[3] = pt.x;
        InterpolationLineAdapter._ypt[3] = pt.y - 3;
        g.fillPolygon(_xpt, _ypt, 4);
        g.setPaintMode();
        g.dispose();
    }

    void drawVector(Vector ptVec) {
        if (ptVec == null || ptVec.size() < 1) {
            return;
        }
        Graphics g = this._graphicsPanel.getGraphics();
        g.setXORMode(new Color(255, 255, 255));
        int npts = ptVec.size();
        LocalPt pt0 = (LocalPt)ptVec.elementAt(0);
        this.drawPt(pt0, true);
        for (int i = 1; i < npts; ++i) {
            LocalPt pt1 = (LocalPt)ptVec.elementAt(i);
            g.drawLine(pt0.x, pt0.y, pt1.x, pt1.y);
            this.drawPt(pt1, true);
            pt0 = pt1;
        }
        g.setPaintMode();
        g.dispose();
    }
}

