/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.dataui.tx.awt.InterpolationLineData;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.gfx2d.G2dEditGlyph;
import hec.gfx2d.G2dObject;
import hec.gfx2d.NoLegend;
import hec.gfx2d.ObjectSelectionEvent;
import hec.gfx2d.Viewport;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

public class InterpolationLineGlyph
extends G2dEditGlyph
implements ActionListener,
NoLegend {
    InterpolationLineData _obj;
    Vector _pointList = null;
    Vector _lineList = new Vector();

    public InterpolationLineGlyph(Viewport view, InterpolationLineData map, Scale scl) {
        super(view, (G2dObject)map, scl);
        this._obj = map;
    }

    public void draw(Graphics g) {
        int ilen = 0;
        int istart = 0;
        int number = 0;
        this._line.clearLineData();
        Rectangle rect = this.getVisibleRect();
        double[] xarray = new double[10000];
        double[] yarray = new double[10000];
        int nlines = this._lineList.size();
        for (int l = 0; l < nlines; ++l) {
            Vector pointList = (Vector)this._lineList.elementAt(l);
            ilen = pointList.size();
            for (int i = istart; i < ilen; ++i) {
                LocalPt pt = (LocalPt)pointList.elementAt(i);
                xarray[i] = this._scale.x2e(pt.x);
                yarray[i] = this._scale.y2n(pt.y);
            }
            number = ilen;
            if (number <= 0) continue;
            this._line.addLineData(xarray, yarray, number);
        }
        if (this._pointList != null && this._pointList.size() > 0) {
            ilen = this._pointList.size();
            for (int i = istart; i < ilen; ++i) {
                LocalPt pt = (LocalPt)this._pointList.elementAt(i);
                xarray[i] = this._scale.x2e(pt.x);
                yarray[i] = this._scale.y2n(pt.y);
            }
            number = ilen;
            if (number > 0) {
                this._line.addLineData(xarray, yarray, number);
            }
        }
    }

    private void drawSelected(Graphics g, Rectangle rect) {
    }

    public void clearSelection() {
    }

    public void createLine(Vector ptVec) {
        this._lineList.removeAllElements();
        this._lineList.add(ptVec);
        this._viewport.repaint();
        this._viewport.fireObjectSelectionChanged(new ObjectSelectionEvent((Object)this));
    }

    public double[][] getInterpolationLine() {
        int nlines = this._lineList.size();
        if (nlines < 1) {
            return null;
        }
        Vector pointList = (Vector)this._lineList.elementAt(0);
        int ilen = pointList.size();
        if (ilen < 2) {
            return null;
        }
        for (int i = 0; i < ilen - 1; ++i) {
            LocalPt pt0 = (LocalPt)pointList.elementAt(i);
            LocalPt pt1 = (LocalPt)pointList.elementAt(i + 1);
            if (pt0.x <= pt1.x) continue;
            this._lineList.removeAllElements();
            return null;
        }
        double[][] xy = new double[2][ilen];
        for (int i = 0; i < ilen; ++i) {
            LocalPt pt = (LocalPt)pointList.elementAt(i);
            xy[0][i] = this._scale.x2e(pt.x);
            xy[1][i] = this._scale.y2n(pt.y);
        }
        this._lineList.removeAllElements();
        return xy;
    }

    public void drawLegendPict(Graphics g, Dimension dim) {
    }

    public boolean objectEditPopupMenu(LocalPt pt, int modifiers) {
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        return false;
    }

    public boolean objectSelect(LocalPt pt, int modifiers) {
        return false;
    }

    public boolean pointerOver(LocalPt pt) {
        return false;
    }

    public void editLineProperties() {
        boolean dum = false;
    }
}

