/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.dataui.tx.awt.ScrollViewGlyph;
import hec.dataui.tx.awt.VerifyTSDataSetBase;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dData;
import hec.gfx2d.G2dGlyphFactory;
import hec.gfx2d.G2dObject;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.time.ZoneId;
import java.util.Optional;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class ScrollViewData
extends G2dData
implements G2dObject,
AdjustmentListener,
ListSelectionListener,
TableModelListener {
    static double[] _tvals;
    public int[] times;
    public double[] ydata;
    public double ymin;
    public double ymax;
    public int numberValues;
    public double[] xdataOrg;
    public double[] ydataOrg;
    int _xAxisType = 0;
    int _yAxisType = 0;
    int _lastRow = -1;
    int _firstRow = -1;
    int _selectedRow = -1;
    int _icolumn = -1;
    boolean _plotXvsY = false;
    boolean _loaded = false;
    JScrollBar _scrollBar = null;
    JTable _table = null;
    ListSelectionModel _lsm = null;
    G2dObject _g2dObject = null;

    public ScrollViewData() {
        this.name = "ScrollView Data";
        this.yunits = "yunits";
        this.xunits = "min";
    }

    public void setData(JTable table, JScrollPane sp, int icol, double ymin, double ymax, String xUnits, String yUnits, int yparamid) {
        this._icolumn = icol;
        this._table = table;
        this.xunits = xUnits;
        this.yunits = yUnits;
        this.setYParameterId(yparamid);
        this.updateTimes();
        this._scrollBar = sp.getVerticalScrollBar();
        this._scrollBar.removeAdjustmentListener(this);
        this._scrollBar.addAdjustmentListener(this);
        this._lsm = this._table.getSelectionModel();
        this._lsm.removeListSelectionListener(this);
        this._lsm.addListSelectionListener(this);
        TableModel tm = this._table.getModel();
        tm.removeTableModelListener(this);
        tm.addTableModelListener(this);
        this.ymin = ymin;
        this.ymax = ymax;
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setData(JTable table, JScrollPane sp, int icol, double ymin, double ymax, G2dObject g2dObject) {
        this._g2dObject = g2dObject;
        String xUnits = "xunits";
        String yUnits = "yunits";
        int yparamid = -1;
        if (this._g2dObject != null) {
            xUnits = g2dObject.getXAxisName();
            yUnits = g2dObject.getYAxisName();
            yparamid = g2dObject.getYParameterId();
            this.setGmtOffset(g2dObject.getGmtOffset());
        }
        this.setData(table, sp, icol, ymin, ymax, xUnits, yUnits, yparamid);
    }

    public void setData(JTable table, JScrollPane sp, int icol, String xUnits, String yUnits, int yparamid) {
        this._icolumn = icol;
        this._table = table;
        this.xunits = xUnits;
        this.yunits = yUnits;
        this.setYParameterId(yparamid);
        this.updateTimes();
        this._scrollBar = sp.getVerticalScrollBar();
        this._scrollBar.removeAdjustmentListener(this);
        this._scrollBar.addAdjustmentListener(this);
        this._lsm = this._table.getSelectionModel();
        this._lsm.removeListSelectionListener(this);
        this._lsm.addListSelectionListener(this);
        TableModel tm = this._table.getModel();
        tm.removeTableModelListener(this);
        tm.addTableModelListener(this);
        this.ymin = this.ymin;
        this.ymax = this.ymax;
        this.bounds = null;
        this.setChanged();
        this.notifyObservers("reset data");
    }

    public void setData(JTable table, JScrollPane sp, int icol, G2dObject g2dObject) {
        this._g2dObject = g2dObject;
        String xUnits = "xunits";
        String yUnits = "yunits";
        int yparamid = -1;
        if (this._g2dObject != null) {
            xUnits = g2dObject.getXAxisName();
            yUnits = g2dObject.getYAxisName();
            yparamid = g2dObject.getYParameterId();
            this.setGmtOffset(g2dObject.getGmtOffset());
        }
        this.setData(table, sp, icol, xUnits, yUnits, yparamid);
    }

    public boolean getScrollSettings(double[] val) {
        if (this._table == null) {
            return false;
        }
        int nrows = this._table.getRowCount();
        if (nrows < 1) {
            return false;
        }
        Rectangle rectv = this._table.getVisibleRect();
        Point upperleft = rectv.getLocation();
        int firstRow = this._table.rowAtPoint(upperleft);
        Point lowerleft = new Point(rectv.x, rectv.y + rectv.height - 1);
        int lastRow = this._table.rowAtPoint(lowerleft);
        int numValOld = this.numberValues;
        this.numberValues = this.times.length;
        if (lastRow >= nrows) {
            lastRow = nrows - 1;
        }
        if (lastRow >= this.numberValues) {
            lastRow = this.numberValues - 1;
        }
        if (lastRow < firstRow) {
            lastRow = firstRow;
        }
        val[0] = this.times[firstRow];
        val[1] = this.times[lastRow];
        int numberVisibleRows = lastRow - firstRow + 1;
        if (numberVisibleRows == nrows) {
            val[0] = this.times[firstRow];
            val[1] = this.times[firstRow];
        }
        boolean changed = false;
        if (firstRow != this._firstRow) {
            this._firstRow = firstRow;
            changed = true;
        }
        if (lastRow != this._lastRow) {
            this._lastRow = lastRow;
            changed = true;
        }
        if (numValOld != this.numberValues) {
            changed = true;
        }
        return changed;
    }

    private void updateTimes() {
        VerifyTSDataSetBase model = null;
        if (this._table.getModel() instanceof VerifyTSDataSetBase) {
            model = (VerifyTSDataSetBase)((Object)this._table.getModel());
        } else if (this._g2dObject instanceof VerifyTSDataSetBase) {
            model = (VerifyTSDataSetBase)this._g2dObject;
        } else {
            return;
        }
        int[] itimes = model.getTimes();
        if (itimes != null) {
            this.times = (int[])itimes.clone();
        }
        this.numberValues = this.times.length;
    }

    public String getXAxisName() {
        return "Minutes";
    }

    public String getYAxisName() {
        return this.yunits;
    }

    public int getXAxisType() {
        return 1;
    }

    public void setXAxisType(int xAxis) {
        this._xAxisType = xAxis;
    }

    public int getYAxisType() {
        return 0;
    }

    public void setYAxisType(int yAxis) {
        this._yAxisType = yAxis;
    }

    public int getYParameterId() {
        return -1;
    }

    public int getUnitSystem() {
        return 0;
    }

    public void load() {
    }

    public void unload() {
    }

    public WorldRect getBounds() {
        return null;
    }

    @Override
    public void adjustmentValueChanged(AdjustmentEvent e) {
        boolean changed = this.getScrollSettings(_tvals);
        if (!changed) {
            return;
        }
        this.setChanged();
        this.notifyObservers("Table Scroll");
        this.clearChanged();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting() || e.getFirstIndex() == -1) {
            return;
        }
        if (e.getFirstIndex() < 0) {
            return;
        }
        int firstRow = this._lsm.getMinSelectionIndex();
        if (this._selectedRow == firstRow) {
            return;
        }
        this._selectedRow = firstRow;
        this.setChanged();
        this.notifyObservers("Row Selection Changed");
        this.clearChanged();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getColumn() == this._icolumn || e.getType() == 1 || e.getType() == -1) {
            this.updateTimes();
        }
    }

    public int getRowSelection() {
        if (this._table == null) {
            return Integer.MIN_VALUE;
        }
        int nrows = this._table.getRowCount();
        int selectedRow = this._selectedRow;
        if (selectedRow < 0) {
            return Integer.MIN_VALUE;
        }
        if (selectedRow >= nrows) {
            return Integer.MIN_VALUE;
        }
        return this.times[this._selectedRow];
    }

    public Optional<ZoneId> getDataZoneId() {
        if (this._g2dObject != null) {
            return this._g2dObject.getDataZoneId();
        }
        return super.getDataZoneId();
    }

    static {
        G2dGlyphFactory.addMapping((String)ScrollViewData.class.getName(), (String)ScrollViewGlyph.class.getName());
        _tvals = new double[2];
    }
}

