/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.dataui.tx.awt.ScrollViewData;
import hec.geometry.Scale;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPolygonProperties;
import hec.gfx2d.NoLegend;
import hec.gfx2d.Viewport;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Observable;

public class ScrollViewGlyph
extends G2dGlyph
implements NoLegend {
    ScrollViewData _obj;

    public ScrollViewGlyph(Viewport view, ScrollViewData map, Scale scl) {
        super(view, (G2dObject)map, scl);
        this._obj = map;
        G2dLineProperties prop = this._line.getProperties();
        prop._drawPoints = false;
        prop._symbolSize = 3.0f;
        prop._fillType = 0;
        prop.setLineColor(new Color(255, 255, 0));
        prop._lineStylePattern = G2dLineProperties.DASH_STYLE_PATTERN;
        this._drawProp.lineProperties = new ArrayList();
        this._drawProp.lineProperties.add(prop);
        G2dPolygonProperties gprop = this._polygon.getProperties();
        gprop.setBackgroundColor(Color.green.darker());
        gprop.setBackgroundFill(6);
        this._drawProp.polygonProperties = gprop;
    }

    public void draw(Graphics g) {
        double dymin = Math.min(this._scale.getAxis(1).getActMax(), this._scale.getAxis(1).getActMin());
        double dymax = Math.max(this._scale.getAxis(1).getActMax(), this._scale.getAxis(1).getActMin());
        int ymin = this._scale.getAxis(1).w2l(dymin);
        int ymax = this._scale.getAxis(1).w2l(dymax);
        Rectangle rect = this.getVisibleRect();
        double[] vals = new double[2];
        this._obj.getScrollSettings(vals);
        double tim1 = vals[0];
        double tim2 = vals[1];
        int[] xarray = new int[4];
        int[] yarray = new int[4];
        xarray[0] = this._scale.e2x(tim1);
        yarray[0] = ymin;
        xarray[1] = this._scale.e2x(tim1);
        yarray[1] = ymax;
        xarray[2] = this._scale.e2x(tim2);
        yarray[2] = ymax;
        xarray[3] = this._scale.e2x(tim2);
        yarray[3] = ymin;
        if (this._drawProp.polygonProperties.drawBackground) {
            this._polygon.setProperties(this._drawProp.polygonProperties);
            this._polygon.setPolygonData(xarray, yarray, 4);
            this._polygon.drawPolygon(g, rect);
        }
        this._line.clearLineData();
        if (!this._drawProp.lineProperties.isEmpty()) {
            this._line.setProperties((G2dLineProperties)this._drawProp.lineProperties.get(0));
        }
        int selectedValue = this._obj.getRowSelection();
        double[] dxarray = new double[2];
        double[] dyarray = new double[2];
        if (selectedValue != Integer.MIN_VALUE) {
            dxarray[0] = tim1 = (double)selectedValue;
            dyarray[0] = this._scale.y2n(0);
            dxarray[1] = tim1;
            dyarray[1] = this._scale.y2n(rect.height);
            this._line.setLineData(dxarray, dyarray, 2);
            this._line.drawLine(g, rect);
        }
    }

    public String getToolTipText(MouseEvent e) {
        return null;
    }

    public void update(Observable o, Object arg) {
        if (o instanceof ScrollViewData) {
            this._viewport.repaint();
        } else {
            super.update(o, arg);
        }
    }

    public WorldRect getBounds() {
        return this._g2dObject != null ? this._g2dObject.getBounds() : null;
    }
}

