/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import com.google.common.flogger.FluentLogger;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.dataui.tx.awt.VerifyTSDataSetBase;
import hec.dataui.tx.awt.VerifyTimeSeriesGlyph;
import hec.gfx2d.G2dGlyphFactory;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerFactory;
import hec.model.Interpolate;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import rma.util.RMAConst;

public class TimeSeriesEditorDataSet
extends VerifyTSDataSetBase {
    private static final long serialVersionUID = -3151623767899171831L;
    private static final FluentLogger LOGGER;
    private static final int DATE_TIME_COLUMN = 0;
    private static final int VALUE_DATA_COLUMN = 1;
    private static final int ESTIMATE_DATA_COLUMN = 2;
    private static final int REVISED_DATA_COLUMN = 3;
    private TimeSeriesContainer _timeSeriesContainer;
    private TimeSeries _valueTx;
    private transient int[] _tmpTimes;
    private transient double[] _tmpValues;

    public TimeSeriesEditorDataSet(String name, int retrStartTime, int retrEndTime, TimeSeries valueTx) throws DataSetTimeSeriesException {
        super(name, retrStartTime, retrEndTime);
        String[] columnNames = new String[4];
        String unitsLabel = "%S";
        columnNames[0] = "Date/Time\n(%S)";
        columnNames[1] = unitsLabel;
        columnNames[2] = unitsLabel;
        columnNames[3] = unitsLabel;
        this.setColumnNames(columnNames);
        if (valueTx == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Empty time series for graphical editor.");
            return;
        }
        int[] itimes = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)valueTx).getTimes().getIntArray();
        double[] dvals = valueTx.getValues();
        int[] iquals = valueTx.getQuality().map(Quality::getIntQuality).orElse(null);
        this.setValueData(dvals, iquals);
        this.setValueTimes(itimes);
        this.fillInEstimates(this.getTimes(), this.getEstimateData());
        this.setEditableQuality(true);
        this._valueTx = valueTx;
        boolean isRegularIntervalData = !valueTx.getTimeSeriesIdentifier().getInterval().isIrregular();
        this.setRegularIntervalData(isRegularIntervalData);
        boolean isInstantaneous = valueTx.getTimeSeriesIdentifier().getParameterType().isInstantaneous();
        this.setInstantaneous(isInstantaneous);
        int paramid = valueTx.getTimeSeriesIdentifier().getParameter().getParameterId();
        this.setYParameterId(paramid);
        int numCols = columnNames.length;
        int[] paramIds = new int[numCols];
        paramIds[0] = -1;
        paramIds[1] = paramid;
        paramIds[2] = paramid;
        paramIds[3] = paramid;
        this.setColumnParameters(paramIds);
        this.setYUnits(valueTx.getUnits().toString());
        int unitSystem = 2;
        this.setUnitSystem(unitSystem);
        TimeZone timeZone = valueTx.getTimeSeriesIdentifier().getIntervalZoneId().map(TimeZone::getTimeZone).orElse(TimeZone.getTimeZone("GMT"));
        this.setTimeZone(timeZone);
    }

    public TimeSeriesEditorDataSet(int retrStartTime, int retrEndTime, TimeSeriesContainer tsc) {
        super(tsc.getShortName(), retrStartTime, retrEndTime);
        String paramName;
        if (tsc == null || tsc.times == null || tsc.values == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("<TimeSeriesEditorDataSet(DataSource ds, TimeSeriesContainer tsc)> TimeSeriesContainer is null");
            return;
        }
        this.setValueData(tsc.values, tsc.quality);
        this.setValueTimes(tsc.times);
        this._timeSeriesContainer = tsc;
        this.setRegularIntervalData(tsc.interval > 0);
        boolean isInstantaneous = true;
        if (tsc.type != null && tsc.type.length() > 0 && tsc.type.indexOf("INST") < 0) {
            isInstantaneous = false;
        }
        this.setInstantaneous(isInstantaneous);
        this.setEditableQuality(false);
        String realUnits = Units.getUnitsForAlias((String)tsc.units);
        int unitSystem = Units.getUnitSystemForUnits((String)realUnits);
        if (unitSystem != 0) {
            this.setUnitSystem(unitSystem);
        }
        if (Parameter.isNotValid((String)(paramName = tsc.getParameterName()))) {
            String[] params;
            for (String aParam : params = Parameter.getAvailableParameters()) {
                if (!paramName.toLowerCase().startsWith(aParam.toLowerCase())) continue;
                paramName = aParam;
                break;
            }
            tsc.parameter = paramName;
        }
        String param = tsc.getParameterName();
        boolean canConvert = false;
        try {
            Parameter parameter = new Parameter(param);
            this.setYParameterId(parameter.getParameterId());
            canConvert = Units.canConvertBetweenUnits((String)parameter.getUnitsString(), (String)tsc.units);
        }
        catch (DataSetIllegalArgumentException parameter) {
            // empty catch block
        }
        this.setYUnits(tsc.units);
        if (tsc.timeZoneID != null && !tsc.timeZoneID.equals("")) {
            int tscmilliOffset = tsc.timeZoneRawOffset;
            TimeZone timeZone = TimeZone.getTimeZone(tsc.timeZoneID);
            int tzmilliOffset = timeZone.getRawOffset();
            if (tzmilliOffset != tscmilliOffset) {
                timeZone = new SimpleTimeZone(tscmilliOffset, tsc.timeZoneID);
            }
            this.setTimeZone(timeZone);
        }
        String[] columnNames = new String[4];
        columnNames[0] = "Date/Time\n(%S)";
        int paramid = this.getYParameterId();
        if (paramid == -1 || !canConvert) {
            columnNames[1] = tsc.units;
            columnNames[2] = tsc.units;
            columnNames[3] = tsc.units;
            this.m_columnNames = columnNames;
        } else {
            Object unitsLabel = "";
            try {
                unitsLabel = Parameter.getParameter((int)paramid).getParameter() + " ";
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                // empty catch block
            }
            columnNames[1] = unitsLabel = "%S";
            columnNames[2] = unitsLabel;
            columnNames[3] = unitsLabel;
            this.m_columnNames = columnNames;
            this.setYUnits((String)unitsLabel);
        }
    }

    @Override
    public int getIntervalMinutes() {
        if (this._valueTx != null) {
            return this._valueTx.getTimeSeriesIdentifier().getInterval().getMinutes();
        }
        if (this._timeSeriesContainer != null) {
            return this._timeSeriesContainer.interval;
        }
        return -1;
    }

    @Override
    public int getDateTimeColumnIndex() {
        return 0;
    }

    @Override
    public int getRawDataColumnIndex() {
        return -1;
    }

    @Override
    public int getRawQualityColumnIndex() {
        return -1;
    }

    @Override
    public int getValueDataColumnIndex() {
        return 1;
    }

    @Override
    public int getValueQualityColumnIndex() {
        return -1;
    }

    @Override
    public int getValueTestColumnIndex() {
        return -1;
    }

    @Override
    public int getEstimateDataColumnIndex() {
        return 2;
    }

    @Override
    public int getEstimateQualityColumnIndex() {
        return -1;
    }

    @Override
    public int getRevisedDataColumnIndex() {
        return 3;
    }

    @Override
    public int getRevisedQualityColumnIndex() {
        return -1;
    }

    @Override
    public void setPrecision(int precision) {
        this._precision = precision;
    }

    public TimeSeries storeRevisedData() {
        int[] itimes = this.getTimes();
        double[] revData = this.getRevisedData();
        int[] revQual = this.getRevisedQuality();
        int icnt = revData.length;
        double[] newValues = new double[icnt];
        long[] newMilliTimes = new long[icnt];
        Quality revisedQuality = new Quality(icnt);
        HecTime hecTime = new HecTime();
        icnt = 0;
        for (int i = 0; i < itimes.length; ++i) {
            long milliTime;
            int valIdx = this.getValueIndex(i);
            if (valIdx == -1) continue;
            hecTime.set(itimes[i]);
            newMilliTimes[icnt] = milliTime = hecTime.getTimeInMillis(0);
            newValues[icnt] = revData[valIdx];
            revisedQuality.setIntegerAt(revQual[valIdx], icnt);
            ++icnt;
        }
        try {
            TimeSeries revisedTx = TimeSeriesBuilder.copy((TimeSeries)this._valueTx);
            revisedTx.set(newMilliTimes, newValues, revisedQuality);
            return revisedTx;
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error creating Revised TimeSeries " + e);
            return null;
        }
    }

    public String getParameterName() {
        if (this._timeSeriesContainer != null) {
            return this._timeSeriesContainer.getParameterName();
        }
        return null;
    }

    public TimeSeriesContainer storeRevisedDssData() {
        boolean hasQual;
        int[] itimes = this.getTimes();
        double[] revData = this.getRevisedData();
        int[] revQual = this.getRevisedQuality();
        int icnt = revData.length;
        int[] newTimes = new int[icnt];
        double[] newValues = new double[icnt];
        int[] newQualities = null;
        boolean bl = hasQual = this._timeSeriesContainer.quality != null;
        if (hasQual) {
            newQualities = new int[icnt];
        }
        icnt = 0;
        for (int i = 0; i < itimes.length; ++i) {
            int valIdx = this.getValueIndex(i);
            if (valIdx == -1) continue;
            newTimes[icnt] = itimes[i];
            newValues[icnt] = revData[valIdx];
            if (revQual != null) {
                newQualities[icnt] = revQual[valIdx];
            }
            ++icnt;
        }
        TimeSeriesContainer newtsc = (TimeSeriesContainer)this._timeSeriesContainer.clone();
        newtsc.times = newTimes;
        if (newTimes != null && newTimes.length > 0) {
            newtsc.startTime = newTimes[0];
            newtsc.endTime = newTimes[newTimes.length - 1];
        }
        newtsc.values = newValues;
        newtsc.numberValues = newTimes.length;
        if (hasQual) {
            newtsc.quality = newQualities;
        }
        return newtsc;
    }

    protected void fillInEstimates(int[] itimes, double[] estimateArray) {
        int i;
        int nval = estimateArray.length;
        this._tmpTimes = new int[nval];
        this._tmpValues = new double[nval];
        int icnt = 0;
        for (i = 0; i < itimes.length; ++i) {
            int valIdx = this.getValueIndex(i);
            if (valIdx == -1 || !RMAConst.isValidValue((double)estimateArray[valIdx])) continue;
            this._tmpTimes[icnt] = itimes[i];
            this._tmpValues[icnt] = estimateArray[valIdx];
            ++icnt;
        }
        for (i = 0; i < nval && !RMAConst.isValidValue((double)estimateArray[i]); ++i) {
        }
        int istart = i;
        for (i = nval - 1; i >= 0 && !RMAConst.isValidValue((double)estimateArray[i]); --i) {
        }
        int iend = i;
        for (i = istart; i <= iend; ++i) {
            double newEstimate;
            if (RMAConst.isValidValue((double)estimateArray[i])) continue;
            int itim = this._tmpTimes[i];
            estimateArray[i] = newEstimate = Interpolate.linearInterpolate((int[])this._tmpTimes, (double[])this._tmpValues, (int)itim, (int)icnt);
        }
    }

    @Override
    public boolean resetTimeWindow(HecTime startTime, HecTime endTime) {
        return false;
    }

    public boolean canSwapXYValues() {
        return false;
    }

    public boolean swapXYValues() {
        return false;
    }

    public void setSwapXYValues(boolean b) {
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int estimateDataCol = this.getEstimateDataColumnIndex();
        if (columnIndex != estimateDataCol) {
            return false;
        }
        return this.getValueIndex(rowIndex) != -1;
    }

    static {
        G2dGlyphFactory.addMapping((String)TimeSeriesEditorDataSet.class.getName(), (String)VerifyTimeSeriesGlyph.class.getName());
        LOGGER = FluentLogger.forEnclosingClass();
    }
}

