/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.heclib.util.HecTime;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import rma.swing.RmaJ24HourTimeField;
import rma.swing.RmaJCalendarField;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;
import rma.util.RMAIO;

public class TimeWindowJDialog
extends JDialog {
    private static final String ABSOLUTE = "absolute";
    private static final String RELATIVE = "relative";
    JPanel cardPanel;
    JButton cancelButton;
    RmaJCalendarField beginDate;
    RmaJCalendarField endDate;
    RmaJ24HourTimeField beginTime;
    RmaJ24HourTimeField endTime;
    RmaJIntegerField relBeginLength;
    RmaJComboBox relBeginUnits;
    JRadioButton relTimeRadio;
    JRadioButton absTimeRadio;
    boolean fComponentsAdjusted = false;
    private boolean _canceled = false;
    private String[] relTimeType = new String[]{"Hour", "Day", "Month", "Year"};

    public TimeWindowJDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.getContentPane().setLayout(new GridBagLayout());
        this.setSize(300, 160);
        this.setLocation();
        Insets insets = new Insets(5, 5, 0, 5);
        this.setTitle("Set New TimeWindow for Data");
        this.absTimeRadio = new JRadioButton("Absolute Time (UTC)");
        this.absTimeRadio.setMnemonic('a');
        this.absTimeRadio.setActionCommand(ABSOLUTE);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        this.relTimeRadio = new JRadioButton("Relative Time");
        this.relTimeRadio.setMnemonic('r');
        this.relTimeRadio.setActionCommand(RELATIVE);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.anchor = 12;
        gbc.fill = 0;
        this.getContentPane().add((Component)buttonPanel, gbc);
        JButton okButton = new JButton("OK");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.ipadx = 10;
        gbc.insets = insets;
        gbc.anchor = 12;
        gbc.fill = 0;
        buttonPanel.add((Component)okButton, gbc);
        this.cancelButton = new JButton("Cancel");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        buttonPanel.add((Component)this.cancelButton, gbc);
        this.cardPanel = new JPanel(new CardLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.getContentPane().add((Component)this.cardPanel, gbc);
        JPanel absTimePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.weightx = 1.0;
        gbc.gridwidth = 4;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 1;
        this.cardPanel.add(ABSOLUTE, absTimePanel);
        JLabel label = new JLabel("Date");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        absTimePanel.add((Component)label, gbc);
        label = new JLabel("Time");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        absTimePanel.add((Component)label, gbc);
        label = new JLabel("Begin");
        label.setDisplayedMnemonic('b');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 12;
        gbc.fill = 0;
        absTimePanel.add((Component)label, gbc);
        this.beginDate = new RmaJCalendarField("DDMMMYYYY", "");
        label.setLabelFor((Component)this.beginDate);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 65;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        absTimePanel.add((Component)this.beginDate, gbc);
        this.beginTime = new RmaJ24HourTimeField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.ipadx = 45;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        absTimePanel.add((Component)this.beginTime, gbc);
        label = new JLabel("End");
        label.setDisplayedMnemonic('e');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 12;
        gbc.fill = 0;
        absTimePanel.add((Component)label, gbc);
        this.endDate = new RmaJCalendarField("DDMMMYYYY", "");
        label.setLabelFor((Component)this.endDate);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.ipadx = 65;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        absTimePanel.add((Component)this.endDate, gbc);
        this.endTime = new RmaJ24HourTimeField();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.ipadx = 45;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        absTimePanel.add((Component)this.endTime, gbc);
        JPanel relTimePanel = new JPanel(new GridBagLayout());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        this.cardPanel.add(RELATIVE, relTimePanel);
        label = new JLabel("Length");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        relTimePanel.add((Component)label, gbc);
        label = new JLabel("Units");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        relTimePanel.add((Component)label, gbc);
        label = new JLabel("Begin");
        label.setDisplayedMnemonic('b');
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.insets = insets;
        gbc.anchor = 12;
        gbc.fill = 0;
        relTimePanel.add((Component)label, gbc);
        this.relBeginLength = new RmaJIntegerField();
        label.setLabelFor((Component)this.relBeginLength);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        relTimePanel.add((Component)this.relBeginLength, gbc);
        this.relBeginUnits = new RmaJComboBox((Object[])this.relTimeType);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        relTimePanel.add((Component)this.relBeginUnits, gbc);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.relTimeRadio);
        bg.add(this.absTimeRadio);
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = e.getSource();
                if (obj instanceof JRadioButton) {
                    String cmd = ((JRadioButton)obj).getActionCommand();
                    ((CardLayout)TimeWindowJDialog.this.cardPanel.getLayout()).show(TimeWindowJDialog.this.cardPanel, cmd);
                }
            }
        };
        this.relTimeRadio.addActionListener(al);
        this.absTimeRadio.addActionListener(al);
        this.absTimeRadio.doClick();
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimeWindowJDialog.this.validData()) {
                    TimeWindowJDialog.this._canceled = false;
                    TimeWindowJDialog.this.setVisible(false);
                }
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindowJDialog.this._canceled = true;
                TimeWindowJDialog.this.setVisible(false);
            }
        });
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindowJDialog.this.escapePressed();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 1);
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimeWindowJDialog.this.enterPressed();
            }
        }, KeyStroke.getKeyStroke(10, 0, true), 1);
        this.getRootPane().setDefaultButton(okButton);
    }

    @Override
    public void addNotify() {
        Dimension d = this.getSize();
        super.addNotify();
        if (this.fComponentsAdjusted) {
            return;
        }
        this.setSize(this.getInsets().left + this.getInsets().right + d.width, this.getInsets().top + this.getInsets().bottom + d.height);
        Component[] components = this.getContentPane().getComponents();
        for (int i = 0; i < components.length; ++i) {
            Point p = components[i].getLocation();
            p.translate(this.getInsets().left, this.getInsets().top);
            components[i].setLocation(p);
        }
        this.fComponentsAdjusted = true;
    }

    public boolean isCanceled() {
        return this._canceled;
    }

    public void setLocation() {
        int iy;
        Rectangle bounds = this.getParent().getBounds();
        Rectangle abounds = this.getBounds();
        int ix = bounds.x + (bounds.width - abounds.width) / 2;
        if (ix < 10) {
            ix = 10;
        }
        if ((iy = bounds.y + (bounds.height - abounds.height) / 2) < 10) {
            iy = 10;
        }
        this.setLocation(ix, iy);
    }

    @Override
    public void setVisible(boolean b) {
        if (b && !this.fComponentsAdjusted) {
            this.pack();
        }
        super.setVisible(b);
    }

    public boolean isAbsolute() {
        return this.absTimeRadio.isSelected();
    }

    public void setAbsolute(boolean b) {
        if (b) {
            this.absTimeRadio.doClick();
        } else {
            this.relTimeRadio.doClick();
        }
    }

    public HecTime getAbsEndTime() {
        if (this.isAbsolute()) {
            return new HecTime(this.endDate.getText(), this.endTime.getText());
        }
        return null;
    }

    public void setAbsEndTime(HecTime end) {
        if (end == null) {
            this.endDate.setText("");
            this.endTime.setText("");
        } else {
            this.endDate.setText(end.date(4));
            this.endTime.setText(RMAIO.removeChar((String)end.time(), (char)':'));
        }
    }

    public HecTime getAbsStartTime() {
        if (this.isAbsolute()) {
            return new HecTime(this.beginDate.getText(), this.beginTime.getText());
        }
        return null;
    }

    public void setAbsStartTime(HecTime start) {
        if (start == null) {
            this.beginDate.setText("");
            this.beginTime.setText("");
        } else {
            this.beginDate.setText(start.date(4));
            this.beginTime.setText(RMAIO.removeChar((String)start.time(), (char)':'));
        }
    }

    public String getRelStartTime() {
        if (!this.isAbsolute()) {
            return this.relBeginLength.getText() + " " + this.relBeginUnits.getSelectedItem();
        }
        return null;
    }

    public void setRelStartTime(String start) {
        if (start == null || start.length() < 1) {
            this.relBeginLength.setText("");
            this.relBeginUnits.setSelectedIndex(0);
        } else {
            String value = RMAIO.getType((String)start, (String)" ");
            String duration = RMAIO.getParam((String)start, (String)" ");
            this.relBeginLength.setText(value);
            this.relBeginUnits.setSelectedItem((Object)duration);
        }
    }

    public boolean validData() {
        String msg = null;
        RmaJCalendarField field = null;
        if (this.relTimeRadio.isSelected()) {
            if (this.relBeginLength.getText().length() < 1) {
                msg = "Please enter a begin time value";
                field = this.relBeginLength;
            }
        } else if (!this.beginDate.isValid(false) || this.beginDate.getText().length() < 1) {
            msg = "Please enter a valid begin date";
            field = this.beginDate;
        } else if (!this.beginTime.isValid(false) || this.beginTime.getText().length() < 1) {
            msg = "Please enter a valid begin time";
            field = this.beginTime;
        } else if (!this.endDate.isValid(false) || this.endDate.getText().length() < 1) {
            msg = "Please enter a valid end date";
            field = this.endDate;
        } else if (!this.endTime.isValid(false) || this.endTime.getText().length() < 1) {
            msg = "Please enter a valid end time";
            field = this.endTime;
        } else {
            HecTime end;
            HecTime start = this.getAbsStartTime();
            if (start.greaterThan(end = this.getAbsEndTime())) {
                msg = "Start time can not be after End time";
                field = this.beginDate;
            }
        }
        if (msg != null) {
            JOptionPane.showMessageDialog(this, msg);
            field.requestFocus();
            return false;
        }
        return true;
    }

    protected void escapePressed() {
        this.cancelButton.doClick();
    }

    protected void enterPressed() {
        JButton b = this.getRootPane().getDefaultButton();
        if (b != null) {
            b.doClick();
        }
    }

    static {
        RmaJTextField.removeAWTEnterKeyCompatibility();
    }
}

