/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import com.google.common.flogger.FluentLogger;
import hec.data.tx.ComparisonDataSource;
import hec.dataui.tx.TimeSeriesDataSource;
import hec.dataui.tx.ValidationStoreThreadUtil;
import hec.db.DbConnectionException;
import hec.db.DbIoException;
import hec.db.cwms.CwmsTimeSeriesDao;
import hec.db.cwms.DataAccessKey;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerFactory;
import hec.serversuite.ClientAuthenticationException;
import hec.serversuite.data.CwmsAuthenticationSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.Version;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifierBuilder;
import rma.services.ServiceLookup;

public class ValidationDataSource
extends TimeSeriesDataSource
implements ComparisonDataSource {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final List<TimeSeriesTemplate> _rawTemplateList = new ArrayList<TimeSeriesTemplate>();
    private final List<TimeSeriesTemplate> _comparisonTemplateList = new ArrayList<TimeSeriesTemplate>();
    private final List<TimeSeriesContainer> _comparisonTsList = new ArrayList<TimeSeriesContainer>();
    private TimeSeriesContainer _tsContainer = null;
    private boolean _bTrim = true;

    public ValidationDataSource(TimeSeriesTemplate valueTemplate, CwmsAuthenticationSource cwmsAuthenticationSource) {
        super(valueTemplate, cwmsAuthenticationSource);
        TimeSeriesTemplate rawTemplate = this.generateRawTx(this._valueTemplate);
        this.setRawTemplate(rawTemplate);
    }

    public void setRawTemplate(TimeSeriesTemplate rawTemplate) {
        this._rawTemplateList.clear();
        if (rawTemplate != null) {
            this._rawTemplateList.add(rawTemplate);
        }
    }

    public void addRawTemplate(TimeSeriesTemplate rawTemplate) {
        this._rawTemplateList.add(rawTemplate);
    }

    public void setTrim(boolean trim) {
        this._bTrim = trim;
    }

    @Override
    public void reloadTsContainer(HecTime startTime, HecTime endTime, boolean bAll) {
        for (int i = 0; i < this._comparisonTsList.size(); ++i) {
            TimeSeriesContainer tsContainer = this._comparisonTsList.get(i);
            if (new DSSPathname(tsContainer.getFullName()).isCwmsTsId()) continue;
            tsContainer.startHecTime = startTime;
            tsContainer.endHecTime = endTime;
            this._comparisonTsList.set(i, (TimeSeriesContainer)super.fireReload((Serializable)tsContainer));
        }
    }

    private TimeSeriesTemplate generateRawTx(TimeSeriesTemplate tx) {
        TimeSeriesTemplate rawTx = null;
        String verString = tx.getTimeSeriesIdentifier().getVersion().toString();
        String rawVersion = this.getRawVersion(verString);
        if (rawVersion != null) {
            try {
                TimeSeriesIdentifier rawDesc = new TimeSeriesIdentifierBuilder(tx.getTimeSeriesIdentifier()).withVersion(new Version(rawVersion)).build();
                rawTx = new TimeSeriesTemplate(rawDesc);
            }
            catch (DataSetIllegalArgumentException | DataSetTimeSeriesIllegalArgumentException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Unable to generate raw time series id from: " + tx.getTimeSeriesIdentifier());
                rawTx = null;
            }
        }
        return rawTx;
    }

    public void addComparison(TimeSeriesTemplate comparison) {
        this._comparisonTemplateList.add(comparison);
    }

    public boolean hasRaw() {
        return !this._rawTemplateList.isEmpty();
    }

    public boolean hasComparisonList() {
        return this._comparisonTemplateList != null && this._comparisonTemplateList.size() >= 1;
    }

    public int getNumberOfComparisons() {
        if (this._comparisonTemplateList == null) {
            return -1;
        }
        return this._comparisonTemplateList.size();
    }

    public List<TimeSeriesTemplate> getComparisonList() {
        return Collections.unmodifiableList(this._comparisonTemplateList);
    }

    public void setComparisonList(List<TimeSeriesContainer> list) {
        this._comparisonTsList.clear();
        this._comparisonTsList.addAll(list);
    }

    @Override
    public long getStartTime() {
        return this._startTime;
    }

    @Override
    public long getEndTime() {
        return this._endTime;
    }

    @Override
    protected void init() {
        try {
            super.init();
            ArrayList<TimeSeriesTemplate> correctedRawTemplates = new ArrayList<TimeSeriesTemplate>();
            for (TimeSeriesTemplate rawTemplate : this._rawTemplateList) {
                correctedRawTemplates.add(new TimeSeriesTemplate(rawTemplate.getTimeSeriesIdentifier(), this._startTime, this._endTime, rawTemplate.getUnits()));
            }
            this._rawTemplateList.clear();
            this._rawTemplateList.addAll(correctedRawTemplates);
            ArrayList<TimeSeriesTemplate> comparisonTemplateList = new ArrayList<TimeSeriesTemplate>();
            for (TimeSeriesTemplate rawTemplate : this._comparisonTemplateList) {
                comparisonTemplateList.add(new TimeSeriesTemplate(rawTemplate.getTimeSeriesIdentifier(), this._startTime, this._endTime, rawTemplate.getUnits()));
            }
            this._comparisonTemplateList.clear();
            this._comparisonTemplateList.addAll(comparisonTemplateList);
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log("Error during init of ValidationDataSource.");
        }
    }

    @Override
    public boolean storeRevisedTimeSeries(TimeSeries data) {
        Thread storeThread = ValidationStoreThreadUtil.getValidationStoreThreadFactory().newValidationStoreThread(this, data);
        if (storeThread != null) {
            if (this._blocking) {
                boolean storeSuccess = false;
                storeThread.run();
                return storeSuccess;
            }
            storeThread.start();
            return true;
        }
        return false;
    }

    public boolean storeRevisedTimeSeriesToSuper(TimeSeries data) {
        return super.storeRevisedTimeSeries(data);
    }

    @Override
    public TimeSeries retrieveValueTx() {
        TimeSeries dstx = super.retrieveValueTx(this._bTrim);
        if (dstx != null && !this._bTrim) {
            dstx.getTimeSeriesStatistics().setCountMissing(true, false);
        }
        return dstx;
    }

    @Override
    public Serializable retrieveRawData() {
        return this.retrieveRawTx();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TimeSeries retrieveRawTx() {
        if (!this.hasRaw()) {
            return null;
        }
        this.init();
        try (DataAccessKey dataAccessKey = this.getDataAccessFactory().getDataAccessKey(this.getClass().getSimpleName());){
            CwmsTimeSeriesDao timeSeriesDao = (CwmsTimeSeriesDao)this.getDataAccessFactory().getDao(CwmsTimeSeriesDao.class);
            if (this._rawTemplateList.isEmpty()) return null;
            TimeSeries rawTx = timeSeriesDao.retrieveTimeSeries(dataAccessKey, this._rawTemplateList.get(0));
            if (rawTx == null) return null;
            if (this._bTrim) {
                rawTx.trimTail();
            } else {
                rawTx.getTimeSeriesStatistics().setCountMissing(true, false);
            }
            rawTx.addEmptyQualityTx();
            TimeSeries timeSeries = rawTx;
            return timeSeries;
        }
        catch (DbConnectionException | DbIoException | ClientAuthenticationException e) {
            FluentLogger.Api api = (FluentLogger.Api)LOGGER.atInfo();
            if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                api = (FluentLogger.Api)api.withCause(e);
                api.log("Unable to retrieve raw time series: " + this._rawTemplateList);
                return null;
            }
            String timeSeriesIds = this._rawTemplateList.stream().map(TimeSeriesTemplate::getTimeSeriesIdentifier).map(TimeSeriesIdentifier::getTimeSeriesId).collect(Collectors.joining(","));
            api.log("Unable to retrieve raw time series: " + timeSeriesIds);
            return null;
        }
    }

    final List<TimeSeries> retrieveComparisonTimeSeries() {
        ArrayList<TimeSeries> retval = new ArrayList<TimeSeries>();
        if (!this._comparisonTemplateList.isEmpty()) {
            this.init();
            try (DataAccessKey dataAccessKey = this.getDataAccessFactory().getDataAccessKey(this.getClass().getSimpleName());){
                CwmsTimeSeriesDao timeSeriesDao = (CwmsTimeSeriesDao)this.getDataAccessFactory().getDao(CwmsTimeSeriesDao.class);
                for (TimeSeriesTemplate comparisonTemplate : this._comparisonTemplateList) {
                    TimeSeries comparisonTimeSeries = timeSeriesDao.retrieveTimeSeries(dataAccessKey, comparisonTemplate);
                    if (comparisonTimeSeries == null) continue;
                    if (this._bTrim) {
                        comparisonTimeSeries.trimTail();
                    } else {
                        comparisonTimeSeries.getTimeSeriesStatistics().setCountMissing(true, false);
                    }
                    comparisonTimeSeries.addEmptyQualityTx();
                    retval.add(comparisonTimeSeries);
                }
            }
            catch (DbConnectionException | DbIoException | ClientAuthenticationException e) {
                FluentLogger.Api api = (FluentLogger.Api)LOGGER.atInfo();
                if (((FluentLogger.Api)LOGGER.atFine()).isEnabled()) {
                    api = (FluentLogger.Api)api.withCause(e);
                    api.log("Unable to retrieve comparison time series: " + this._comparisonTemplateList);
                }
                String timeSeriesIds = this._comparisonTemplateList.stream().map(TimeSeriesTemplate::getTimeSeriesIdentifier).map(TimeSeriesIdentifier::getTimeSeriesId).collect(Collectors.joining(","));
                api.log("Unable to retrieve comparison time series: " + timeSeriesIds);
            }
        }
        return retval;
    }

    public List<TimeSeriesContainer> retrieveComparisonList() {
        return this._comparisonTsList;
    }

    @Override
    public String tabulate() {
        StringBuilder sb = new StringBuilder();
        sb.append("Value:  ");
        sb.append(this._valueTemplate.getTimeSeriesIdentifier().toString());
        sb.append("\n");
        if (!this._rawTemplateList.isEmpty() && this._rawTemplateList.get(0) != null) {
            sb.append("Raw:    ");
            sb.append(this._rawTemplateList.get(0).getTimeSeriesIdentifier().toString());
            sb.append("\n");
        }
        if (!this._comparisonTemplateList.isEmpty()) {
            sb.append("Comparisons: \n");
            for (TimeSeriesTemplate tx : this._comparisonTemplateList) {
                sb.append("        ");
                sb.append(tx.getTimeSeriesIdentifier().toString());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PRIMARY");
        sb.append("=");
        sb.append(this._valueTemplate.getTimeSeriesIdentifier().toString());
        sb.append("\n");
        for (TimeSeriesTemplate tx : this._comparisonTemplateList) {
            sb.append("        ");
            sb.append(tx.getTimeSeriesIdentifier().toString());
            sb.append("\n");
        }
        return sb.toString();
    }

    public void setTimeSeriesContainer(TimeSeriesContainer tsContainer) {
        this._tsContainer = tsContainer;
    }

    public TimeSeriesContainer getTimeSeriesContainer() {
        TimeSeries timeSeries;
        if (this._tsContainer == null && (timeSeries = this.retrieveValueTx()) != null) {
            int unitSystem = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
            try {
                timeSeries.changeUnitSystem(unitSystem);
                this._tsContainer = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)timeSeries);
            }
            catch (DataSetIllegalArgumentException | UnitsConversionException | DataSetTimeSeriesException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("Error changing unit system and transforming into time series container.");
            }
        }
        return this._tsContainer;
    }

    @Override
    public TimeSeriesContainer retrieveValueTsContainer() {
        return this.getTimeSeriesContainer();
    }

    @Override
    public boolean hasQuality() {
        return true;
    }
}

