/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import rma.swing.RmaJDecimalField;

public class ValidationDecimalField
extends RmaJDecimalField {
    public ValidationDecimalField() {
    }

    public ValidationDecimalField(int value, int columns) {
        super(value, columns);
    }

    public ParamDouble getParamValue() {
        double retVal = 0.0;
        if (this._paramValue == null) {
            return null;
        }
        if (!this.isModified()) {
            return this._paramValue;
        }
        ParamDouble pd2 = null;
        ParamDouble pd = new ParamDouble();
        pd.setValue(this.getText());
        if (this._scaleFactor != 1.0 && this._scaleFactor != 0.0) {
            pd.scaleValue(1.0 / this._scaleFactor);
        }
        if (this._paramValue.getParameterId() == Integer.MIN_VALUE || this._paramValue.getParameterId() == -1) {
            pd.setUnitSystem(this._paramValue.getUnitSystem());
            pd.setParameterId(this._paramValue.getParameterId());
            return pd;
        }
        if (this._paramValue.getUnitSystem() != this._displayUnitsSystem && Units.isValidUnitsSystem((int)this._paramValue.getUnitSystem())) {
            String oldUnits = null;
            String newUnits = null;
            try {
                oldUnits = Parameter.getUnitsStringForSystem((int)this._paramValue.getParameterId(), (int)this._displayUnitsSystem);
                newUnits = Parameter.getUnitsStringForSystem((int)this._paramValue.getParameterId(), (int)this._paramValue.getUnitSystem());
            }
            catch (Exception e) {
                return pd2;
            }
            try {
                double multFactor;
                pd2 = Units.convertUnits((ParamDouble)pd, (String)oldUnits, (String)newUnits);
                int errorfactor = -1;
                if (multFactor > -1.0 && multFactor < 1.0) {
                    for (multFactor = Units.getScalarFactor((String)oldUnits, (String)newUnits); multFactor < 1.0; multFactor *= 10.0) {
                        ++errorfactor;
                    }
                } else if (multFactor > 1.0) {
                    while (multFactor > 1.0) {
                        ++errorfactor;
                        multFactor /= 10.0;
                    }
                }
                int tempPrec = pd2.getPrecision() + errorfactor;
                pd2.setUnitSystem(this._paramValue.getUnitSystem());
                pd2.setParameterId(this._paramValue.getParameterId());
            }
            catch (DataSetException e) {
                System.out.println("EXCEPTION <RMADecimalField.getValue()> : " + e.getMessage());
            }
        } else {
            pd.setUnitSystem(this._paramValue.getUnitSystem());
            pd.setParameterId(this._paramValue.getParameterId());
            return pd;
        }
        return pd2;
    }

    public void convertAndDisplayParamValue(ParamDouble pd, int fromUs, int toUS) {
        String oldUnits = null;
        String newUnits = null;
        try {
            oldUnits = Parameter.getUnitsStringForSystem((int)pd.getParameterId(), (int)fromUs);
            newUnits = Parameter.getUnitsStringForSystem((int)pd.getParameterId(), (int)toUS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (oldUnits == null || newUnits == null) {
            return;
        }
        try {
            ParamDouble pd3;
            double multFactor = Units.getScalarFactor((String)oldUnits, (String)newUnits);
            if (multFactor <= 0.0) {
                multFactor = 1.0;
            }
            if (pd.getParameterId() == -1) {
                try {
                    pd3 = (ParamDouble)pd.clone();
                }
                catch (CloneNotSupportedException ce) {
                    return;
                }
                multFactor = 1.0;
            } else {
                pd3 = Units.convertUnits((ParamDouble)pd, (String)oldUnits, (String)newUnits);
            }
            this.setText(pd3.toString());
        }
        catch (DataSetException e) {
            System.out.println("EXCEPTION <RMADecimalField.setDisplayUnitsSystem()> : " + e.getMessage());
            return;
        }
    }
}

