/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.dataui.tx.DataSource;
import hec.dataui.tx.TsContainerDataSource;
import hec.dataui.tx.awt.VerifyDataSubPanel;
import hec.io.TimeSeriesContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import rma.swing.RmaInsets;
import rma.swing.RmaJComboBox;
import rma.swing.RmaJIntegerField;
import rma.swing.RmaJTextField;

final class VerifyDataDetailsPanel
extends VerifyDataSubPanel {
    private static final String FIRST_RECORD = "First record";
    private static final String LAST_RECORD = "Last record";
    private final RmaJTextField _dataSourceTextField = new RmaJTextField();
    private final RmaJComboBox<DataSource> _dataSourceCombo = new RmaJComboBox();
    private final JPanel _valuePanel = new JPanel(new GridBagLayout());
    private final RmaJIntegerField _rejValInt = new RmaJIntegerField(0, 5);
    private final RmaJIntegerField _qstValInt = new RmaJIntegerField(0, 5);
    private final RmaJIntegerField _misValInt = new RmaJIntegerField(0, 5);
    private final JButton _prevBtn = new JButton("< Previous Data Set");
    private final JButton _nextBtn = new JButton("Next Data Set >");
    private final JButton _saveNextBtn = new JButton("Save and Next >");

    VerifyDataDetailsPanel(int mode) {
        super(new BorderLayout(), mode);
        super.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        super.add((Component)this.createTsPanel());
        this._rejValInt.setColumns(5);
        this._qstValInt.setColumns(5);
        this._misValInt.setColumns(5);
        this._rejValInt.setEditable(false);
        this._qstValInt.setEditable(false);
        this._misValInt.setEditable(false);
        this.disableComponent(this._prevBtn, FIRST_RECORD);
        this.disableComponent(this._nextBtn, LAST_RECORD);
        this.disableComponent(this._saveNextBtn, LAST_RECORD);
    }

    private JPanel createTsPanel() {
        JPanel comboPanel = new JPanel(new GridBagLayout());
        JLabel jl = new JLabel("Data Source:");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS5005;
        comboPanel.add((Component)jl, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)0);
        comboPanel.add((Component)this._dataSourceTextField, gbc);
        this._dataSourceTextField.setEditable(false);
        jl = new JLabel("Selected Data Set:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.insets((int)5, (int)0, (int)5, (int)5);
        comboPanel.add((Component)jl, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)0);
        comboPanel.add((Component)this._dataSourceCombo, gbc);
        this._dataSourceCombo.setRenderer((ListCellRenderer)new DataSourceListCellRenderer());
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 17;
        gbc.insets = RmaInsets.INSETS0000;
        comboPanel.add((Component)this.buildComboButtonsPanel(), gbc);
        this.buildQualitySummaryPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.INSETS0500;
        comboPanel.add((Component)this._valuePanel, gbc);
        return comboPanel;
    }

    private JPanel buildComboButtonsPanel() {
        JPanel comboBtnsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.insets = RmaInsets.insets((int)2, (int)5, (int)2, (int)5);
        comboBtnsPanel.add((Component)this._prevBtn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.insets = RmaInsets.insets((int)2, (int)5, (int)2, (int)5);
        comboBtnsPanel.add((Component)this._nextBtn, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.fill = 0;
        gbc.anchor = 11;
        gbc.insets = RmaInsets.insets((int)2, (int)5, (int)2, (int)5);
        comboBtnsPanel.add((Component)this._saveNextBtn, gbc);
        return comboBtnsPanel;
    }

    private void buildQualitySummaryPanel() {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        JPanel rejectedPanel = new JPanel(new GridBagLayout());
        rejectedPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "R"));
        rejectedPanel.add((Component)this._rejValInt, gbc);
        rejectedPanel.setToolTipText("Number Rejected Values");
        this._rejValInt.setToolTipText("Number Rejected Values");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        JPanel questionablePanel = new JPanel(new GridBagLayout());
        questionablePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Q"));
        questionablePanel.add((Component)this._qstValInt, gbc);
        questionablePanel.setToolTipText("Number Questionable Values");
        this._qstValInt.setToolTipText("Number Questionable Values");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        JPanel missingPanel = new JPanel(new GridBagLayout());
        missingPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "M"));
        missingPanel.add((Component)this._misValInt, gbc);
        missingPanel.setToolTipText("Number Missing Values");
        this._misValInt.setToolTipText("Number Missing Values");
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        this._valuePanel.add((Component)rejectedPanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)5);
        this._valuePanel.add((Component)questionablePanel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)0, (int)0, (int)0, (int)0);
        this._valuePanel.add((Component)missingPanel, gbc);
    }

    void updateComboToolTip() {
        VerifyDataDetailsPanel.setComboToolTip(this._dataSourceCombo.getSelectedItem(), this._dataSourceCombo);
    }

    void updateComboToolTip(Object item) {
        VerifyDataDetailsPanel.setComboToolTip(item, this._dataSourceCombo);
    }

    RmaJComboBox<DataSource> getDataSourceCombo() {
        return this._dataSourceCombo;
    }

    private static void setComboToolTip(Object item, JComponent comp) {
        TimeSeriesContainer tsContainer;
        Object name = "";
        if (item instanceof TsContainerDataSource && (tsContainer = ((TsContainerDataSource)item).retrieveValueTsContainer()) != null) {
            String fullName;
            if (tsContainer.fileName != null) {
                name = tsContainer.fileName + ":";
            }
            if ((fullName = tsContainer.getFullName()) != null) {
                name = (String)name + fullName;
            }
        }
        if (((String)name).isEmpty() && item instanceof DataSource) {
            name = ((DataSource)item).getName();
        }
        comp.setToolTipText((String)name);
    }

    RmaJTextField getDataSourceTextField() {
        return this._dataSourceTextField;
    }

    JPanel getValuePanel() {
        return this._valuePanel;
    }

    JButton getPrevBtn() {
        return this._prevBtn;
    }

    JButton getNextBtn() {
        return this._nextBtn;
    }

    JButton getSaveNextBtn() {
        return this._saveNextBtn;
    }

    void setRejectedCount(int count) {
        this._rejValInt.setValue(count);
    }

    void setQuestionableCount(int count) {
        this._qstValInt.setValue(count);
    }

    void setMissingCount(int count) {
        this._misValInt.setValue(count);
    }

    void updateButtonsForNewDataSet() {
        int itemIndex = this.getDataSourceCombo().getSelectedIndex();
        int itemCount = this.getDataSourceCombo().getItemCount() - 1;
        if (itemIndex > 0) {
            this.enableComponent(this.getPrevBtn());
        } else {
            this.disableComponent(this.getPrevBtn(), FIRST_RECORD);
        }
        if (itemIndex < itemCount) {
            this.enableComponent(this.getNextBtn());
            this.enableComponent(this.getSaveNextBtn());
        } else {
            this.disableComponent(this.getNextBtn(), LAST_RECORD);
            this.disableComponent(this.getSaveNextBtn(), LAST_RECORD);
        }
    }

    private class DataSourceListCellRenderer
    extends DefaultListCellRenderer {
        private DataSourceListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object dsName = null;
            if (value instanceof TsContainerDataSource && ((TsContainerDataSource)value).retrieveValueTsContainer() != null) {
                dsName = ((TsContainerDataSource)value).retrieveValueTsContainer().getFullVersionedName();
            } else if (value instanceof DataSource) {
                dsName = ((DataSource)value).getName();
            }
            if (value instanceof DataSource && VerifyDataDetailsPanel.this.getMode() != 1 && ((DataSource)value).hasQuality()) {
                dsName = (String)dsName + " (Has Quality Flags)";
            }
            Component comp = super.getListCellRendererComponent(list, dsName, index, isSelected, cellHasFocus);
            VerifyDataDetailsPanel.setComboToolTip(value, list);
            return comp;
        }
    }
}

