/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import com.google.common.flogger.FluentLogger;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.TimeWindow;
import hec.data.TimeWindowMap;
import hec.data.Units;
import hec.data.UnitsConversionException;
import hec.dataui.tx.DataSource;
import hec.dataui.tx.DataSourceList;
import hec.dataui.tx.DssDataSource;
import hec.dataui.tx.TimeSeriesDataSource;
import hec.dataui.tx.TsContainerDataSource;
import hec.dataui.tx.TsContainerDataSourceList;
import hec.dataui.tx.awt.InterpolationLineData;
import hec.dataui.tx.awt.InterpolationLineGlyph;
import hec.dataui.tx.awt.ScrollViewData;
import hec.dataui.tx.awt.TimeSeriesEditorDataSet;
import hec.dataui.tx.awt.ValidationDataSource;
import hec.dataui.tx.awt.ValidationDecimalField;
import hec.dataui.tx.awt.VerifyDataDetailsPanel;
import hec.dataui.tx.awt.VerifyDataOptions;
import hec.dataui.tx.awt.VerifyDataPlotPanel;
import hec.dataui.tx.awt.VerifyDataTablePanel;
import hec.dataui.tx.awt.VerifyTSDataSetBase;
import hec.dataui.tx.awt.VerifyTimeSeriesDataSet;
import hec.dataui.tx.awt.VerifyTimeSeriesGlyph;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanelProp;
import hec.gfx2d.Margin;
import hec.gfx2d.ObjectSelectionEvent;
import hec.gfx2d.ObjectSelectionListener;
import hec.gfx2d.PrintProperties;
import hec.gfx2d.SimpleJTableData;
import hec.gfx2d.TimeSeriesDataSetBase;
import hec.gui.HelpFrame;
import hec.heclib.dss.DSSPathname;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerFactory;
import hec.io.TimeSeriesContainerQualityUtil;
import hec.lang.Const;
import hec.model.Interpolate;
import hec.util.TimeWindowExtensionDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import java.util.stream.IntStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesBuilder;
import mil.army.usace.hec.data.timeseries.TimeSeriesStatistics;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import rma.services.ServiceLookup;
import rma.swing.FlatPanelButton;
import rma.swing.PrintPreview;
import rma.swing.RmaImage;
import rma.swing.RmaInsets;
import rma.swing.RmaJCheckBox;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJFrame;
import rma.swing.event.ReflectMultiListener;
import rma.swing.event.TableChangeListener;
import rma.swing.event.TableUpdateEvent;
import rma.swing.print.PageText;
import rma.swing.table.AlignTableCellRenderer;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.MleHeadRenderer;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaDateTimeRenderer;
import rma.swing.table.TimeZoneHeaderRenderer;
import rma.util.RMAConst;
import rma.util.RMAFilenameFilter;
import rma.util.RMAIO;

public class VerifyDataDlg
extends HelpFrame
implements ItemListener,
TableChangeListener,
KeyListener,
ObjectSelectionListener,
Observer,
Printable,
Pageable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final long serialVersionUID = -6953361551900009841L;
    public static String _programName = "Data Verification";
    protected Preferences _preferences;
    private TimeSeries _dataSetTxValue = null;
    private TimeSeriesContainer _tscValue = null;
    private DataSourceList _dataSourceList = null;
    private DataSource _dataSource = null;
    private ScrollViewData _scrollViewData = null;
    private final Cursor _waitCursor = Cursor.getPredefinedCursor(3);
    private final Cursor _defaultCursor = Cursor.getDefaultCursor();
    private boolean _dataModified = false;
    private PageFormat _pageFormat;
    private JSplitPane _splitPane;
    private final RmaJCheckBox editableDataCheckBox = new RmaJCheckBox("Edit All Data");
    private final RmaJCheckBox _jCheckBox_showComparisons = new RmaJCheckBox("Show Comparisons in Plot");
    private JTextArea textAreaMessages;
    private final ReflectMultiListener _rml = new ReflectMultiListener();
    private ButtonGroup _storageButtonGroup;
    private ButtonGroup _decimalGroup;
    private JCheckBoxMenuItem _optPostInBackgroundMenuItem;
    private JCheckBoxMenuItem _showComparisonMenuItem;
    private JCheckBoxMenuItem editableDataMenuItem;
    private JCheckBoxMenuItem _optScaleToRawMenuItem;
    private JCheckBoxMenuItem _estimateMissingMenuItem;
    private JMenu _optionsMenu;
    private ValidationDecimalField _validationDecimalField;
    private JMenuItem _plotMenuItem;
    private FlatPanelButton _plotButton;
    private JMenuItem _tabulateMenuItem;
    private FlatPanelButton _tabulateButton;
    private JMenuItem _saveAsMenuItem;
    private FlatPanelButton _saveAsButton;
    private FlatPanelButton _reloadButton;
    private JSeparator _plotTabSeparator;
    private final FocusListener _plotFocusListener = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (VerifyDataDlg.this._tablePanel.getDataTable().isEditing()) {
                VerifyDataDlg.this._tablePanel.getDataTable().commitEdit(true);
                VerifyDataDlg.this._plotPanel.repaint();
            }
        }
    };
    private int _unitSystem = 1;
    private boolean _scaleToRawValues = true;
    private final List<G2dObject> _comparisonDataList = new ArrayList<G2dObject>();
    private final List<G2dObject> _plotVec = new ArrayList<G2dObject>();
    private final List<G2dObject> _plotVecWithComparison = new ArrayList<G2dObject>();
    private final List<G2dLineProperties> _colorVec = new ArrayList<G2dLineProperties>();
    private int _mode = 0;
    private boolean _showSaveAs = true;
    private boolean _showPlotTool = true;
    private boolean _showTabulateTool = true;
    private boolean _showAddDataBtn = true;
    private boolean _showDeleteDataBtn = true;
    private boolean _initPerformed = false;
    private final VerifyDataDetailsPanel _detailsPanel;
    private final VerifyDataTablePanel _tablePanel;
    private final VerifyDataPlotPanel _plotPanel;
    private final VerifyDataOptions _options;
    private final TableModelListener _tableModelListener = this::tableChanged;

    public VerifyDataDlg(DataSourceList dsl) {
        this(dsl, 1);
    }

    public VerifyDataDlg(DataSourceList dsl, int unitSystem) {
        this(VerifyDataDlg.getTitle(dsl.getMode()), dsl.getMode(), unitSystem);
        this.setMode(dsl.getMode());
        this.setDataSourceList(dsl);
    }

    private VerifyDataDlg(String title, int mode, int unitSystem) {
        this(mode, unitSystem);
        this.setTitle(title);
    }

    VerifyDataDlg(String title, int mode) {
        this(mode, 1);
        this.setTitle(title);
    }

    private VerifyDataDlg(int mode, int unitSystem) {
        this._plotPanel = new VerifyDataPlotPanel();
        this._detailsPanel = new VerifyDataDetailsPanel(mode);
        this._tablePanel = new VerifyDataTablePanel(mode, () -> this._plotPanel.repaint(), () -> this.setDataModified(true));
        if (UnitUtil.isValidUnitsSystem((int)unitSystem)) {
            this._unitSystem = unitSystem;
        }
        this._preferences = Preferences.userNodeForPackage(this.getClass());
        this._options = new VerifyDataOptions(this._preferences);
        this.setDefaultCloseOperation(0);
        this.getContentPane().setLayout(new BorderLayout());
        JToolBar toolbar = this.buildToolbar();
        this.getContentPane().add((Component)toolbar, "North");
        this.setPreferredSize(new Dimension(1920, 1040));
        this.setSize(this.getPreferredSize());
        this.setLocation();
        this.setTitle(_programName);
        this.buildMenu();
        this.buildComponents(mode);
        this.addListeners();
        SwingUtilities.invokeLater(() -> this._splitPane.setDividerLocation(0.5));
    }

    private void addListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        this._tablePanel.getAddBtn().addActionListener(e -> this.addData());
        this._detailsPanel.getPrevBtn().addActionListener(e -> this.previousLocationAction());
        this._detailsPanel.getNextBtn().addActionListener(e -> this.nextLocationAction());
        this._detailsPanel.getSaveNextBtn().addActionListener(e -> this.saveAndNextAction());
        this.editableDataCheckBox.addActionListener(e -> this.setEditableData(this.editableDataCheckBox.isSelected()));
        this._jCheckBox_showComparisons.addActionListener(e -> this.showComparisonData(this._jCheckBox_showComparisons.isSelected()));
        ((JComponent)this.getContentPane()).registerKeyboardAction(this::downArrowKey, KeyStroke.getKeyStroke(40, 0, true), 1);
        ((JComponent)this.getContentPane()).registerKeyboardAction(e -> this.upArrowKey(), KeyStroke.getKeyStroke(38, 0, true), 1);
        ((JComponent)this.getContentPane()).registerKeyboardAction(e -> this.altDownArrowKey(), KeyStroke.getKeyStroke(40, 8, true), 1);
        ((JComponent)this.getContentPane()).registerKeyboardAction(e -> this.altUpArrowKey(), KeyStroke.getKeyStroke(38, 8, true), 1);
    }

    private void buildComponents(int mode) {
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        this.getContentPane().add((Component)mainPanel, "Center");
        JPanel centralPanel = this.buildCenterPanel();
        mainPanel.add((Component)centralPanel, "Center");
        JPanel south = new JPanel(new GridBagLayout());
        mainPanel.add((Component)south, "South");
        JPanel btnPanel = this.createOptionalsPanel();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        south.add((Component)btnPanel, gbc);
        JScrollPane scrollPane = this.createMessagePane();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.fill = 2;
        gbc.anchor = 15;
        gbc.insets = RmaInsets.insets((int)0, (int)5, (int)5, (int)5);
        south.add((Component)scrollPane, gbc);
    }

    private JScrollPane createMessagePane() {
        this.textAreaMessages = new JTextArea("", 1, 40);
        this.textAreaMessages.setBackground(Color.lightGray);
        this.textAreaMessages.setEditable(false);
        this.textAreaMessages.setRows(1);
        JScrollPane scrollPane = new JScrollPane(this.textAreaMessages, 22, 31){

            @Override
            public Dimension getMinimumSize() {
                return VerifyDataDlg.this.textAreaMessages.getMinimumSize();
            }
        };
        return scrollPane;
    }

    private JPanel createOptionalsPanel() {
        JPanel btnPanel = new JPanel(new GridBagLayout());
        this.editableDataCheckBox.setToolTipText("Allow editing of all Data");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        btnPanel.add((Component)this.editableDataCheckBox, gbc);
        this._jCheckBox_showComparisons.setToolTipText("Show other available data for comparisons in Plot");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        btnPanel.add((Component)this._jCheckBox_showComparisons, gbc);
        return btnPanel;
    }

    private JPanel buildCenterPanel() {
        JPanel output = new JPanel(new BorderLayout());
        output.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        JPanel plotAndDetailsPanel = new JPanel(new BorderLayout(5, 5));
        plotAndDetailsPanel.add((Component)((Object)this._plotPanel), "Center");
        plotAndDetailsPanel.add((Component)((Object)this._detailsPanel), "North");
        this._splitPane = new JSplitPane(this._options.getSplitPaneMode(), plotAndDetailsPanel, (Component)((Object)this._tablePanel));
        this._splitPane.setBorder(new LineBorder(this.getContentPane().getBackground().darker()));
        output.add((Component)this._splitPane, "Center");
        return output;
    }

    private static String getTitle(int mode) {
        return mode == 1 ? "Data Validation Editor" : "Graphical Editor";
    }

    public boolean updateUnitSystem(Container c) {
        if (this._dataSourceList instanceof TsContainerDataSourceList) {
            return false;
        }
        return super.updateUnitSystem(c);
    }

    protected boolean updateTimeZone(Container c, TimeZone timezone) {
        if (this._dataSourceList instanceof TsContainerDataSourceList) {
            int itemIndex = this._detailsPanel.getDataSourceCombo().getSelectedIndex();
            DataSource ds = this._dataSourceList.get(itemIndex);
            if (ds == null) {
                return super.updateTimeZone(c, TimeZone.getTimeZone("UTC"));
            }
            Serializable data = this.retrieveValueData(ds);
            if (data instanceof TimeSeriesContainer) {
                TimeSeriesContainer tsc = (TimeSeriesContainer)data;
                TimeZone tz = TimeZone.getDefault();
                tz.setRawOffset(tsc.timeZoneRawOffset);
                return super.updateTimeZone(c, tz);
            }
            return super.updateTimeZone(c, TimeZone.getTimeZone("UTC"));
        }
        return super.updateTimeZone(c, timezone);
    }

    private JToolBar buildToolbar() {
        JToolBar toolBar = new JToolBar();
        FlatPanelButton button = new FlatPanelButton((Icon)RmaImage.getImageIcon((String)"Images/Save.gif"));
        button.addActionListener((ActionListener)this._rml.add((Object)this, (Object)button, "saveAction"));
        button.setToolTipText("Save");
        button.setMargin(RmaInsets.INSETS0000);
        button.setVerticalAlignment(1);
        toolBar.add((Component)button);
        this._saveAsButton = new FlatPanelButton((Icon)RmaImage.getImageIcon((String)"Images/saveAs.gif"));
        this._saveAsButton.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._saveAsButton, "saveAsAction"));
        this._saveAsButton.setToolTipText("Save As");
        this._saveAsButton.setMargin(RmaInsets.INSETS0000);
        this._saveAsButton.setVerticalAlignment(1);
        toolBar.add((Component)this._saveAsButton);
        toolBar.addSeparator();
        ImageIcon reloadIcon = RmaImage.getImageIcon((String)"Images/reload.gif");
        this._reloadButton = new FlatPanelButton((Icon)reloadIcon);
        this._reloadButton.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._reloadButton, "reloadAction"));
        this._reloadButton.setToolTipText("Reload");
        this._reloadButton.setMargin(RmaInsets.INSETS0000);
        this._reloadButton.setVerticalAlignment(1);
        toolBar.add((Component)this._reloadButton);
        toolBar.addSeparator();
        this._plotButton = new FlatPanelButton((Icon)RmaImage.getImageIcon((String)"Images/smallPlot.gif"));
        this._plotButton.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._plotButton, "plotAction"));
        this._plotButton.setToolTipText("Plot");
        this._plotButton.setMargin(RmaInsets.INSETS0000);
        this._plotButton.setVerticalAlignment(1);
        toolBar.add((Component)this._plotButton);
        this._tabulateButton = new FlatPanelButton((Icon)RmaImage.getImageIcon((String)"Images/smallTabulate.gif"));
        this._tabulateButton.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._tabulateButton, "tabulateAction"));
        this._tabulateButton.setToolTipText("Tabulate");
        this._tabulateButton.setMargin(RmaInsets.INSETS0000);
        this._tabulateButton.setVerticalAlignment(1);
        toolBar.add((Component)this._tabulateButton);
        return toolBar;
    }

    private void setMode(int mode) {
        this._mode = mode;
    }

    private void initComponents() {
        if (this._initPerformed) {
            return;
        }
        this._initPerformed = true;
        boolean validation = this._mode == 1;
        boolean isTsContainer = this._dataSourceList instanceof TsContainerDataSourceList;
        this._detailsPanel.getPrevBtn().setVisible(validation);
        this._detailsPanel.getNextBtn().setVisible(validation);
        this._detailsPanel.getSaveNextBtn().setVisible(validation);
        this._optionsMenu.setVisible(validation);
        this._showComparisonMenuItem.setSelected(!validation);
        this._jCheckBox_showComparisons.setSelected(!validation);
        if (this._showPlotTool) {
            this._plotButton.setVisible(isTsContainer);
            this._plotMenuItem.setVisible(isTsContainer);
        } else {
            this._plotButton.setVisible(false);
            this._plotMenuItem.setVisible(false);
        }
        if (this._showTabulateTool) {
            this._tabulateButton.setVisible(isTsContainer);
            this._tabulateMenuItem.setVisible(isTsContainer);
        } else {
            this._tabulateButton.setVisible(false);
            this._tabulateMenuItem.setVisible(false);
        }
        if (this._showSaveAs) {
            this._saveAsButton.setVisible(isTsContainer);
            this._saveAsMenuItem.setVisible(isTsContainer);
        } else {
            this._saveAsButton.setVisible(false);
            this._saveAsMenuItem.setVisible(false);
        }
        this._tablePanel.getAddBtn().setVisible(this._showAddDataBtn);
        this._tablePanel.getDeleteBtn().setVisible(this._showDeleteDataBtn);
        this._plotTabSeparator.setVisible(isTsContainer);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.setLocation(50, 50);
        }
        super.setVisible(b);
    }

    void VerifyDataDlg_WindowClosing(WindowEvent event) {
        if (this._dataModified) {
            String message = "Do you want to save changes before closing?";
            int ianswer = JOptionPane.showConfirmDialog((Component)((Object)this), message, "Warning!", 1, 2);
            if (ianswer == 2) {
                return;
            }
            if (ianswer == 0) {
                if (!this._optPostInBackgroundMenuItem.isSelected()) {
                    this.setCursor(this._waitCursor);
                }
                this.storeData();
                if (!this._optPostInBackgroundMenuItem.isSelected()) {
                    this.selectDataSet();
                    this.setCursor(this._defaultCursor);
                }
            }
        }
        this._preferences.putInt("selectedTool", this._plotPanel.getG2dPanel().getSelectedToolbarButton());
        this.setVisible(false);
    }

    public void saveAction() {
        if (!this._optPostInBackgroundMenuItem.isSelected()) {
            this.setCursor(this._waitCursor);
        }
        this.storeData();
        if (!this._optPostInBackgroundMenuItem.isSelected()) {
            int dlgPrecision = this.getSelectedPrecision();
            this.selectDataSet();
            this.setCursor(this._defaultCursor);
            this.setSelectedPrecision(dlgPrecision);
        }
    }

    private Serializable getRevised(boolean addModifiedFlag) {
        if (this._tablePanel.getDataTable().getModel() == null) {
            return null;
        }
        Serializable newRevised = null;
        if (this._tablePanel.getDataTable().getModel() instanceof VerifyTimeSeriesDataSet) {
            VerifyTimeSeriesDataSet tableModel = (VerifyTimeSeriesDataSet)((Object)this._tablePanel.getDataTable().getModel());
            newRevised = tableModel.storeRevisedData();
        } else if (this._tablePanel.getDataTable().getModel() instanceof TimeSeriesEditorDataSet) {
            TimeSeriesEditorDataSet tableModel = (TimeSeriesEditorDataSet)((Object)this._tablePanel.getDataTable().getModel());
            if (this._dataSource instanceof TimeSeriesDataSource) {
                newRevised = tableModel.storeRevisedData();
            } else if (this._dataSource instanceof DssDataSource || this._dataSource instanceof TsContainerDataSource) {
                TimeSeriesContainer tsCont = tableModel.storeRevisedDssData();
                if (addModifiedFlag) {
                    tsCont.version = "Modified-" + tsCont.version;
                }
                newRevised = tsCont;
            }
        }
        return newRevised;
    }

    private HecTime getRetrieveStartTime() {
        VerifyTSDataSetBase model = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        int retrieveStartTime = model.getTimes()[0];
        return new HecTime(retrieveStartTime, 1);
    }

    private HecTime getRetrieveEndTime() {
        VerifyTSDataSetBase model = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        int retrieveEndTime = model.getTimes()[model.getTimes().length - 1];
        return new HecTime(retrieveEndTime, 1);
    }

    public void storeData() {
        boolean blocking;
        VerifyTSDataSetBase tableModel;
        Serializable newRevised = this.getRevised(false);
        if (newRevised == null) {
            return;
        }
        boolean overrideProtection = false;
        if (this._tablePanel.getDataTable().getModel() instanceof VerifyTimeSeriesDataSet) {
            tableModel = (VerifyTimeSeriesDataSet)((Object)this._tablePanel.getDataTable().getModel());
            overrideProtection = tableModel.isOverrideProtection();
        } else if (this._tablePanel.getDataTable().getModel() instanceof TimeSeriesEditorDataSet) {
            tableModel = (TimeSeriesEditorDataSet)((Object)this._tablePanel.getDataTable().getModel());
            overrideProtection = tableModel.isOverrideProtection();
        }
        Enumeration<AbstractButton> e = this._storageButtonGroup.getElements();
        int idx = 0;
        while (e.hasMoreElements() && !e.nextElement().isSelected()) {
            ++idx;
        }
        int iaction = Const.RULE_NUMBERS[idx];
        boolean bl = blocking = !this._optPostInBackgroundMenuItem.isSelected();
        if (this._dataSource instanceof TimeSeriesDataSource) {
            TimeSeriesDataSource txds = (TimeSeriesDataSource)this._dataSource;
            txds.setBlocking(blocking);
            txds.setOverrideProtection(overrideProtection);
            txds.setStoreRule(iaction);
        }
        VerifyTSDataSetBase model = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        int retrieveStartTime = model.getRetrieveStartTime();
        int retrieveEndTime = model.getRetrieveEndTime();
        int[] times = model.getTimes();
        double[] revisedData = model.getRevisedData();
        TimeZone timeZone = model.getTimeZone();
        if (timeZone != null && times != null && times.length > 0 && revisedData != null && revisedData.length == times.length) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.setTimeZone(timeZone);
            int revisedEndTime = this.getValidRevisedEndTime(times, revisedData);
            int revisedStartTime = this.getValidRevisedStartTime(times, revisedData);
            TimeWindowMap timeWindowMap = new TimeWindowMap();
            TimeWindow earlyDelete = null;
            TimeWindow lateDelete = null;
            if (retrieveStartTime < revisedStartTime) {
                Date retrStartDate = new Date(new HecTime(retrieveStartTime, 1).getTimeInMillis(cal));
                Date revStartDate = new Date(new HecTime(revisedStartTime, 1).getTimeInMillis(cal));
                earlyDelete = new TimeWindow(retrStartDate, true, revStartDate, false);
                timeWindowMap.add(earlyDelete);
            }
            if (retrieveEndTime > revisedEndTime) {
                Date retrEndDate = new Date(new HecTime(retrieveEndTime, 1).getTimeInMillis(cal));
                Date revEndDate = new Date(new HecTime(revisedEndTime, 1).getTimeInMillis(cal));
                lateDelete = new TimeWindow(revEndDate, false, retrEndDate, true);
                timeWindowMap.add(lateDelete);
            }
            model.addDeletedTimeSlots(timeWindowMap, cal);
            if (!timeWindowMap.isEmpty()) {
                this.deleteValues(this._dataSource, newRevised, timeWindowMap);
            }
        }
        this.storeRevisedData(this._dataSource, newRevised);
        this._dataSourceList.initDataSources(this._dataSource);
        this.setDataModified(false);
    }

    private int getValidRevisedEndTime(int[] times, double[] values) {
        int index = IntStream.range(1, values.length).map(i -> values.length - i).filter(i -> RMAConst.isValidValue((double)values[i])).findFirst().orElse(0);
        return times[index];
    }

    private int getValidRevisedStartTime(int[] times, double[] values) {
        int index = IntStream.range(0, values.length).filter(i -> RMAConst.isValidValue((double)values[i])).findFirst().orElse(values.length - 1);
        return times[index];
    }

    public void storeDataAs() {
        boolean blocking;
        VerifyTSDataSetBase tableModel;
        Serializable newRevised = this.getRevised(false);
        if (newRevised == null) {
            return;
        }
        boolean overrideProtection = false;
        if (this._tablePanel.getDataTable().getModel() instanceof VerifyTimeSeriesDataSet) {
            tableModel = (VerifyTimeSeriesDataSet)((Object)this._tablePanel.getDataTable().getModel());
            overrideProtection = tableModel.isOverrideProtection();
        } else if (this._tablePanel.getDataTable().getModel() instanceof TimeSeriesEditorDataSet) {
            tableModel = (TimeSeriesEditorDataSet)((Object)this._tablePanel.getDataTable().getModel());
            overrideProtection = tableModel.isOverrideProtection();
        }
        Enumeration<AbstractButton> e = this._storageButtonGroup.getElements();
        int idx = 0;
        while (e.hasMoreElements() && !((JCheckBoxMenuItem)e.nextElement()).isSelected()) {
            ++idx;
        }
        int iaction = Const.RULE_NUMBERS[idx];
        boolean bl = blocking = !this._optPostInBackgroundMenuItem.isSelected();
        if (this._dataSource instanceof TimeSeriesDataSource) {
            TimeSeriesDataSource txds = (TimeSeriesDataSource)this._dataSource;
            txds.setBlocking(blocking);
            txds.setOverrideProtection(overrideProtection);
            txds.setStoreRule(iaction);
        }
        this._dataSource.storeRevisedDataAs(newRevised);
        this._dataSourceList.initDataSources();
        this.setDataModified(false);
    }

    public void reloadAction() {
        int ianswer = 0;
        if (this._dataModified) {
            String message = "Are you sure you want to reload and lose all changes?";
            ianswer = JOptionPane.showConfirmDialog((Component)((Object)this), message, "Warning!", 0, 3);
        }
        if (ianswer == 0) {
            int dlgPrecision = this.getSelectedPrecision();
            HecTime startTime = this.getRetrieveStartTime();
            HecTime endTime = this.getRetrieveEndTime();
            this._dataSource.reloadTsContainer(startTime, endTime, true);
            this.setDataModified(false);
            this.selectDataSet();
            this.setSelectedPrecision(dlgPrecision);
        }
    }

    public void alwaysEstimateAction() {
        boolean missSelected = this._estimateMissingMenuItem.getState();
        this._preferences.putBoolean("alwaysEstimateMissing", missSelected);
        if (missSelected) {
            this.provideEstimateMissingAction();
        }
    }

    public void provideEstimateAction() {
        this._tablePanel.provideEstimateAction();
    }

    public void provideEstimateMissingAction() {
        this._tablePanel.provideEstimateMissingAction();
    }

    public void provideEstimateAllAction() {
        this._tablePanel.provideEstimateAllAction();
    }

    public void acceptEstimateAction() {
        this._tablePanel.acceptEstimateAction();
    }

    public void acceptEstimateAllAction() {
        this._tablePanel.acceptEstimateAllAction();
    }

    public void previousLocationAction() {
        int index = this._detailsPanel.getDataSourceCombo().getSelectedIndex();
        if (index <= 0) {
            return;
        }
        if (index > 0) {
            this._detailsPanel.getDataSourceCombo().setSelectedIndex(--index);
        }
    }

    public void saveAndNextAction() {
        if (this._dataModified) {
            this.storeData();
        }
        this.nextLocationAction();
    }

    public void nextLocationAction() {
        int index = this._detailsPanel.getDataSourceCombo().getSelectedIndex();
        if (index == this._detailsPanel.getDataSourceCombo().getItemCount() - 1) {
            return;
        }
        if (index < this._detailsPanel.getDataSourceCombo().getItemCount() - 1) {
            this._detailsPanel.getDataSourceCombo().setSelectedIndex(++index);
        }
    }

    void copyAction() {
        this.copyToClipboard();
    }

    void printTableAction() {
        this.printTable();
    }

    void printGraphAction() {
        this.printGraph();
        ((FluentLogger.Api)LOGGER.atFine()).log("\nPring Graph Completed.");
    }

    void printPrevAction() {
        if (this._pageFormat == null) {
            this._pageFormat = new PageFormat();
        }
        Thread runner = new Thread(){

            @Override
            public void run() {
                VerifyDataDlg.this.setCursor(Cursor.getPredefinedCursor(3));
                VerifyDataDlg frame = VerifyDataDlg.this;
                new PrintPreview((Frame)((Object)frame), (Printable)VerifyDataDlg.this, VerifyDataDlg.this.getTitle() + " preview");
                VerifyDataDlg.this.setCursor(Cursor.getPredefinedCursor(0));
            }
        };
        runner.start();
    }

    void closeAction() {
        this.VerifyDataDlg_WindowClosing(null);
    }

    public void setEditableData() {
        boolean tf = this.editableDataMenuItem.isSelected();
        this.setEditableData(tf);
    }

    void setEditableData(boolean tf) {
        this.editableDataMenuItem.setSelected(tf);
        this.editableDataCheckBox.setSelected(tf);
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        tableModel.setEditableData(tf);
        int[] selectedRows = this._tablePanel.getDataTable().getSelectedRows();
        tableModel.fireTableDataChanged();
        if (selectedRows.length > 0) {
            this._tablePanel.getDataTable().setSelectedIndices(selectedRows);
        }
    }

    public void setShowSaveAs(boolean show) {
        this._showSaveAs = show;
        this._saveAsMenuItem.setVisible(show);
        this._saveAsButton.setVisible(show);
    }

    public void setShowPlotTool(boolean show) {
        this._showPlotTool = show;
        this._plotMenuItem.setVisible(show);
        this._plotButton.setVisible(show);
    }

    public void setShowTabulateTool(boolean show) {
        this._showTabulateTool = show;
        this._tabulateButton.setVisible(show);
        this._tabulateMenuItem.setVisible(show);
    }

    public void setShowAddBtn(boolean show) {
        this._showAddDataBtn = show;
        this._tablePanel.getAddBtn().setVisible(show);
    }

    public void setShowDeleteBtn(boolean show) {
        this._showDeleteDataBtn = show;
        this._tablePanel.getDeleteBtn().setVisible(show);
    }

    public void addData() {
        HecTimeArray timeArray;
        Window w;
        int intervalMinutes;
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        int selIdx = -1;
        int[] selectedRows = this._tablePanel.getDataTable().getSelectedRows();
        int[] vtimes = tableModel.getValueTimes();
        if (vtimes == null) {
            return;
        }
        ArrayList<Integer> selectedTimes = null;
        if (selectedRows != null && selectedRows.length > 0) {
            selIdx = tableModel.getValueIndex(selectedRows[0]);
            int[] itimes = tableModel.getTimes();
            selectedTimes = new ArrayList<Integer>();
            for (int selectedRow : selectedRows) {
                if (selectedRow < 0 || selectedRow >= itimes.length) continue;
                int time = itimes[selectedRow];
                selectedTimes.add(time);
            }
        }
        boolean irregular = (intervalMinutes = tableModel.getIntervalMinutes()) == 0;
        TimeZone displayTimeZone = RmaJFrame.getTimeZone();
        TimeZone dataTimeZone = tableModel.getTimeZone();
        TimeWindowExtensionDialog extendDialog = new TimeWindowExtensionDialog((JFrame)((Object)this), vtimes, intervalMinutes, irregular, selIdx);
        extendDialog.showIncludeTimesCheckBox(false);
        if (displayTimeZone != null && dataTimeZone != null) {
            extendDialog.setTimeZone(dataTimeZone, displayTimeZone);
        }
        if ((w = extendDialog.getOwner()) instanceof Frame) {
            w.setIconImage(this.getIconImage());
        }
        extendDialog.setLocationRelativeTo((Component)((Object)this));
        extendDialog.setVisible(true);
        if (extendDialog.canceled()) {
            return;
        }
        int[] insertTimes = null;
        int[] prependTimes = null;
        int[] appendTimes = null;
        if (extendDialog.isInserted()) {
            timeArray = extendDialog.getInsertedTimes();
            insertTimes = timeArray.getIntArray();
        }
        if (extendDialog.isPrepended()) {
            timeArray = extendDialog.getPrependedTimes();
            prependTimes = timeArray.getIntArray();
        }
        if (extendDialog.isAppended()) {
            timeArray = extendDialog.getAppendedTimes();
            appendTimes = timeArray.getIntArray();
        }
        tableModel.addData(prependTimes, insertTimes, appendTimes);
        this._plotPanel.getG2dPanel().resetAllDataLimits();
        if (selectedRows != null && selectedRows.length > 0) {
            int[] itimes = tableModel.getTimes();
            Integer t0 = (Integer)selectedTimes.get(0);
            Integer t1 = (Integer)selectedTimes.get(selectedTimes.size() - 1);
            int index0 = Arrays.binarySearch(itimes, t0);
            int index1 = Arrays.binarySearch(itimes, t1);
            this._tablePanel.getDataTable().setRowSelectionInterval(index0, index1);
        }
    }

    public void scaleToRawAction() {
        this.scaleToRawAction(this._optScaleToRawMenuItem.isSelected());
    }

    void scaleToRawAction(boolean tf) {
        if (!(this._tablePanel.getDataTable().getModel() instanceof VerifyTimeSeriesDataSet)) {
            return;
        }
        VerifyTimeSeriesDataSet tableModel = (VerifyTimeSeriesDataSet)((Object)this._tablePanel.getDataTable().getModel());
        tableModel.setScaleToRawData(tf);
        this._plotPanel.getG2dPanel().resetAllDataLimits();
    }

    public void showComparisonAction() {
        this.showComparisonData(this._showComparisonMenuItem.isSelected());
    }

    void showComparisonData(boolean tf) {
        this._showComparisonMenuItem.setSelected(tf);
        this._jCheckBox_showComparisons.setSelected(tf);
        if (this._plotPanel.isShowingMissingDataMessage()) {
            return;
        }
        for (G2dObject o : this._comparisonDataList) {
            if (!(o instanceof TimeSeriesDataSetBase)) continue;
            ((TimeSeriesDataSetBase)o).setVisible(tf);
        }
        this._plotPanel.removePlot();
        if (this._plotVec != null) {
            if (tf && this._plotVecWithComparison != null && this._plotVecWithComparison.size() > 0) {
                this._plotPanel.buildPlotPanel(this._unitSystem, this._preferences, this, this._plotFocusListener, this._plotVecWithComparison, this._colorVec);
            } else {
                this._plotPanel.buildPlotPanel(this._unitSystem, this._preferences, this, this._plotFocusListener, this._plotVec, this._colorVec);
            }
        }
        this._plotPanel.restorePlot();
        this.updateTimeZone((Container)((Object)this));
        if (UnitUtil.isValidUnitsSystem((int)RmaJFrame.getUnitSystem())) {
            this.updateUnitSystem((Container)((Object)this));
        }
        this._plotPanel.revalidate();
        this._plotPanel.repaint();
        this._plotPanel.getG2dPanel().repaint();
    }

    public void viewDecimalsAction() {
        Enumeration<AbstractButton> e = this._decimalGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton o = e.nextElement();
            if (!(o instanceof PrecisionJRadioButtonMenuItem) || !((PrecisionJRadioButtonMenuItem)o).isSelected()) continue;
            this.showDecimalChange(((PrecisionJRadioButtonMenuItem)o).getPrecision());
            break;
        }
    }

    protected void showDecimalChange(int numberDecimals) {
        this._tablePanel.getDataTable().commitEdit(true);
        this._tablePanel.getDataTable().setPrecision(numberDecimals);
        this._tablePanel.getDataTable().validate();
        this._tablePanel.getDataTable().repaint();
    }

    public int getSelectedPrecision() {
        Enumeration<AbstractButton> e = this._decimalGroup.getElements();
        while (e.hasMoreElements()) {
            AbstractButton o = e.nextElement();
            if (!(o instanceof PrecisionJRadioButtonMenuItem) || !((PrecisionJRadioButtonMenuItem)o).isSelected()) continue;
            return ((PrecisionJRadioButtonMenuItem)o).getPrecision();
        }
        return -1;
    }

    public void setSelectedPrecision(int iprecis) {
        Enumeration<AbstractButton> e = this._decimalGroup.getElements();
        while (e.hasMoreElements()) {
            int menuPrecis;
            AbstractButton o = e.nextElement();
            if (!(o instanceof PrecisionJRadioButtonMenuItem) || iprecis != (menuPrecis = ((PrecisionJRadioButtonMenuItem)o).getPrecision())) continue;
            ((PrecisionJRadioButtonMenuItem)o).setSelected(true);
            this.showDecimalChange(iprecis);
            break;
        }
    }

    public void deleteSelection() {
        this._tablePanel.deleteSelection();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        Object object = event.getSource();
        if (event.getStateChange() != 1) {
            return;
        }
        if (object == this._detailsPanel.getDataSourceCombo()) {
            this._detailsPanel.updateComboToolTip(event.getItem());
            SwingUtilities.invokeLater(this::selectDataSet);
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void tableDataChanged(TableUpdateEvent e) {
        int reason = e.getChangeReason();
        if (reason == TableUpdateEvent.COPY) {
            return;
        }
        int start = e.getStartPosition()[0];
        int stop = e.getStopPosition()[0];
        this.updateEstimateColumns(start, stop);
    }

    public void tableChanged(TableModelEvent e) {
        VerifyTSDataSetBase tableModel;
        if (e.getType() == 1 || e.getType() == -1) {
            this.setDataModified(true);
            return;
        }
        int icol = e.getColumn();
        if (icol == (tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel())).getRevisedQualityColumnIndex() && !this._dataModified) {
            this.setDataModified(true);
        }
        int editingColumn = this._tablePanel.getDataTable().getEditingColumn();
        int editingRow = this._tablePanel.getDataTable().getEditingRow();
        if (editingRow < 0 || editingColumn < 0) {
            return;
        }
        if (icol == tableModel.getEstimateDataColumnIndex()) {
            int firstRow = e.getFirstRow();
            this.updateEstimateColumns(firstRow, firstRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEstimateColumns(int startRow, int stopRow) {
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        try {
            tableModel.removeTableModelListener(this._tableModelListener);
            this._tablePanel.updateEstimateColumns(VerifyDataDlg.getUnitSystem(), startRow, stopRow);
        }
        finally {
            tableModel.addTableModelListener(this._tableModelListener);
        }
    }

    protected boolean checkIfEstimateEnabled() {
        return this._tablePanel.checkIfEstimateEnabled();
    }

    protected int[] getSelectedIndices(ListSelectionModel lsm, int start, int stop) {
        return this._tablePanel.getSelectedIndices(lsm, start, stop);
    }

    public void objectSelectionChanged(ObjectSelectionEvent e) {
        InterpolationLineGlyph glyph;
        double[][] xy;
        if (e != null && e.getSource() instanceof VerifyTimeSeriesGlyph) {
            VerifyTimeSeriesGlyph glyph2 = (VerifyTimeSeriesGlyph)e.getSource();
            int[] selectedPoints = glyph2.getSelectedPoints();
            if (selectedPoints == null || selectedPoints.length < 1) {
                return;
            }
            this._tablePanel.setSelectedRows(selectedPoints);
        } else if (e != null && e.getSource() instanceof InterpolationLineGlyph && (xy = (glyph = (InterpolationLineGlyph)e.getSource()).getInterpolationLine()) != null) {
            this.interpolateToLine(xy[0], xy[1]);
        }
    }

    public final void setDataSourceList(DataSourceList dsl) {
        boolean singleDataSource;
        this._dataSourceList = dsl;
        this.fillDataSetCombo();
        boolean bl = singleDataSource = this._dataSourceList.size() <= 1;
        if (singleDataSource) {
            this._optPostInBackgroundMenuItem.setSelected(false);
        }
        this._optPostInBackgroundMenuItem.setEnabled(!singleDataSource);
    }

    public void saveAsAction() {
        if (!this._optPostInBackgroundMenuItem.isSelected()) {
            this.setCursor(this._waitCursor);
        }
        this.storeDataAs();
        if (!this._optPostInBackgroundMenuItem.isSelected()) {
            int dlgPrecision = this.getSelectedPrecision();
            this.selectDataSet();
            this.setCursor(this._defaultCursor);
            this.setSelectedPrecision(dlgPrecision);
        }
    }

    public void plotAction() {
        Serializable revised = this.getRevised(true);
        if (revised == null) {
            return;
        }
        Serializable original = this.retrieveValueData(this._dataSource);
        ArrayList<Serializable> list = new ArrayList<Serializable>(2);
        list.add(revised);
        list.add(original);
        this._dataSource.firePlot(list);
    }

    public void tabulateAction() {
        Serializable revised = this.getRevised(true);
        if (revised == null) {
            return;
        }
        Serializable original = this.retrieveValueData(this._dataSource);
        ArrayList<Serializable> list = new ArrayList<Serializable>(2);
        list.add(revised);
        list.add(original);
        this._dataSource.fireTabulate(list);
    }

    public void printTable() {
        try {
            String dataSetName = this._detailsPanel.getDataSourceCombo().getSelectedItem().toString();
            this._tablePanel.getDataTable().setPrintTitle(new PageText(dataSetName, 2));
            this._tablePanel.getDataTable().printData();
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error in printing");
        }
    }

    public void printGraph() {
        try {
            PrinterJob prnJob = PrinterJob.getPrinterJob();
            prnJob.setPageable(this);
            if (!prnJob.printDialog()) {
                return;
            }
            this._pageFormat = prnJob.defaultPage();
            prnJob.print();
        }
        catch (PrinterException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Printing error: " + e);
        }
    }

    private void buildMenu() {
        JMenuBar menu = new JMenuBar();
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        JMenuItem saveMenuItem = new JMenuItem("Save", 83);
        saveMenuItem.setIcon(RmaImage.getImageIcon((String)"Images/Save.gif"));
        saveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)saveMenuItem, "saveAction"));
        fileMenu.add(saveMenuItem);
        this._saveAsMenuItem = new JMenuItem("Save As...", 65);
        this._saveAsMenuItem.setIcon(RmaImage.getImageIcon((String)"Images/saveAs.gif"));
        this._saveAsMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._saveAsMenuItem, "saveAsAction"));
        fileMenu.add(this._saveAsMenuItem);
        fileMenu.add(new JSeparator());
        JMenuItem printTableMenuItem = new JMenuItem("Print Table...");
        printTableMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)printTableMenuItem, "printTable"));
        fileMenu.add(printTableMenuItem);
        JMenuItem printGraphMenuItem = new JMenuItem("Print Graph...");
        printGraphMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)printGraphMenuItem, "printGraph"));
        fileMenu.add(printGraphMenuItem);
        JMenuItem pageSetupMenuItem = new JMenuItem("Page Setup...");
        pageSetupMenuItem.addActionListener(e -> this._plotPanel.pageSetupAction((JFrame)((Object)this)));
        fileMenu.add(pageSetupMenuItem);
        fileMenu.add(new JSeparator());
        JMenuItem closeMenuItem = new JMenuItem("Close", 67);
        closeMenuItem.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        closeMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)closeMenuItem, "closeAction"));
        fileMenu.add(closeMenuItem);
        menu.add(fileMenu);
        JMenu editMenu = new JMenu("Edit", false);
        editMenu.setMnemonic('E');
        JMenuItem undoMenuItem = new JMenuItem("Restore Original Data", 82);
        undoMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)undoMenuItem, "reloadAction"));
        editMenu.add(undoMenuItem);
        this._estimateMissingMenuItem = new JCheckBoxMenuItem("Always Estimate Missing");
        boolean missSelected = this._preferences.getBoolean("alwaysEstimateMissing", true);
        this._estimateMissingMenuItem.setSelected(missSelected);
        this._estimateMissingMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._estimateMissingMenuItem, "alwaysEstimateAction"));
        editMenu.add(this._estimateMissingMenuItem);
        JMenuItem addData = new JMenuItem("Add Data");
        addData.addActionListener((ActionListener)this._rml.add((Object)this, (Object)addData, "addData"));
        editMenu.add(addData);
        menu.add(editMenu);
        JMenu viewMenu = new JMenu("View", false);
        viewMenu.setMnemonic('V');
        JMenu layoutMenu = this.buildLayoutMenu();
        viewMenu.add(layoutMenu);
        this._showComparisonMenuItem = new JCheckBoxMenuItem("Show Comparison Data");
        this._showComparisonMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._showComparisonMenuItem, "showComparisonAction"));
        viewMenu.add(this._showComparisonMenuItem);
        this._plotMenuItem = new JMenuItem("Show Plot...", 80);
        this._plotMenuItem.setIcon(RmaImage.getImageIcon((String)"Images/smallPlot.gif"));
        this._plotMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._plotMenuItem, "plotAction"));
        viewMenu.add(this._plotMenuItem);
        this._tabulateMenuItem = new JMenuItem("Tabulate...", 84);
        this._tabulateMenuItem.setIcon(RmaImage.getImageIcon((String)"Images/smallTabulate.gif"));
        this._tabulateMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._tabulateMenuItem, "tabulateAction"));
        viewMenu.add(this._tabulateMenuItem);
        this._plotTabSeparator = new JSeparator();
        viewMenu.add(this._plotTabSeparator);
        JMenu viewDecimals = new JMenu("Show Decimal Places");
        viewDecimals.setMnemonic('D');
        this._decimalGroup = new ButtonGroup();
        viewMenu.add(viewDecimals);
        PrecisionJRadioButtonMenuItem decimal0 = new PrecisionJRadioButtonMenuItem("0.", 0);
        decimal0.setMnemonic('0');
        decimal0.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal0, "viewDecimalsAction"));
        this._decimalGroup.add(decimal0);
        viewDecimals.add(decimal0);
        PrecisionJRadioButtonMenuItem decimal1 = new PrecisionJRadioButtonMenuItem("0.0", 1);
        decimal1.setMnemonic('1');
        decimal1.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal1, "viewDecimalsAction"));
        this._decimalGroup.add(decimal1);
        viewDecimals.add(decimal1);
        PrecisionJRadioButtonMenuItem decimal2 = new PrecisionJRadioButtonMenuItem("0.00", 2);
        decimal2.setMnemonic('2');
        decimal2.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal2, "viewDecimalsAction"));
        this._decimalGroup.add(decimal2);
        viewDecimals.add(decimal2);
        PrecisionJRadioButtonMenuItem decimal3 = new PrecisionJRadioButtonMenuItem("0.000", 3);
        decimal3.setMnemonic('3');
        decimal3.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal3, "viewDecimalsAction"));
        this._decimalGroup.add(decimal3);
        viewDecimals.add(decimal3);
        PrecisionJRadioButtonMenuItem decimal4 = new PrecisionJRadioButtonMenuItem("0.0000", 4);
        decimal4.setMnemonic('4');
        decimal4.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal4, "viewDecimalsAction"));
        this._decimalGroup.add(decimal4);
        viewDecimals.add(decimal4);
        PrecisionJRadioButtonMenuItem decimal5 = new PrecisionJRadioButtonMenuItem("0.00000", 5);
        decimal5.setMnemonic('5');
        decimal5.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal5, "viewDecimalsAction"));
        this._decimalGroup.add(decimal5);
        viewDecimals.add(decimal5);
        PrecisionJRadioButtonMenuItem decimal6 = new PrecisionJRadioButtonMenuItem("0.000000", 6);
        decimal6.setMnemonic('6');
        decimal6.addActionListener((ActionListener)this._rml.add((Object)this, (Object)decimal6, "viewDecimalsAction"));
        this._decimalGroup.add(decimal6);
        viewDecimals.add(decimal6);
        menu.add(viewMenu);
        this._optionsMenu = new JMenu("Options", false);
        this._optionsMenu.setMnemonic('O');
        this.editableDataMenuItem = new JCheckBoxMenuItem("Edit All Data");
        this.editableDataMenuItem.setMnemonic('E');
        this.editableDataMenuItem.addActionListener(e -> this.setEditableData(this.editableDataMenuItem.isSelected()));
        this._optionsMenu.add(this.editableDataMenuItem);
        this._optPostInBackgroundMenuItem = new JCheckBoxMenuItem("Save in Background");
        this._optPostInBackgroundMenuItem.setMnemonic('B');
        this._optionsMenu.add(this._optPostInBackgroundMenuItem);
        this._optScaleToRawMenuItem = new JCheckBoxMenuItem("Scale Plot to Raw Data", this._scaleToRawValues);
        this._optScaleToRawMenuItem.addActionListener((ActionListener)this._rml.add((Object)this, (Object)this._optScaleToRawMenuItem, "scaleToRawAction"));
        this._optionsMenu.add(this._optScaleToRawMenuItem);
        JMenu storageMenu = new JMenu("Storage Rule", false);
        this._storageButtonGroup = new ButtonGroup();
        String[] rules = Const.RULES;
        int storageRule = this._preferences.getInt("storageRule", 1);
        if (storageRule < 0 || storageRule > rules.length - 1) {
            storageRule = 0;
        }
        for (int i = 0; i < rules.length; ++i) {
            JCheckBoxMenuItem jcbmi = new JCheckBoxMenuItem(rules[i], false);
            jcbmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Enumeration<AbstractButton> e = VerifyDataDlg.this._storageButtonGroup.getElements();
                    int idx = 0;
                    while (e.hasMoreElements() && !((JCheckBoxMenuItem)e.nextElement()).isSelected()) {
                        ++idx;
                    }
                    VerifyDataDlg.this._preferences.putInt("storageRule", idx);
                }
            });
            if (i == storageRule) {
                jcbmi.setSelected(true);
            }
            storageMenu.add(jcbmi);
            this._storageButtonGroup.add(jcbmi);
        }
        this._optionsMenu.add(storageMenu);
        menu.add(this._optionsMenu);
        this.setJMenuBar(menu);
        this.setHelpSetLabel("HEC-DSSVue - Help");
        this.setHelpSetName("HEC-DSSVue");
        this.buildHelpSet("ListSelection.HelpOverviewMenu", "graphicalEditorHelp");
    }

    private JMenu buildLayoutMenu() {
        JMenu layoutMenu = new JMenu("Layout");
        JMenuItem restoreView = new JMenuItem("Restore Layout");
        JRadioButtonMenuItem horizontalView = new JRadioButtonMenuItem(new SwapViewAction(0));
        JRadioButtonMenuItem verticalView = new JRadioButtonMenuItem(new SwapViewAction(1));
        restoreView.addActionListener(e -> this.restoreLayout(horizontalView));
        if (this._options.getSplitPaneMode() == 1) {
            verticalView.setSelected(true);
        } else {
            horizontalView.setSelected(true);
        }
        layoutMenu.add(restoreView);
        layoutMenu.add(horizontalView);
        layoutMenu.add(verticalView);
        ButtonGroup viewButtonGroup = new ButtonGroup();
        viewButtonGroup.add(horizontalView);
        viewButtonGroup.add(verticalView);
        return layoutMenu;
    }

    private void restoreLayout(JMenuItem horizontalView) {
        this.setSize(this.getPreferredSize());
        horizontalView.setSelected(true);
        this._options.setSplitPaneMode(0);
        this._splitPane.setOrientation(0);
        this._splitPane.setDividerLocation(0.5);
    }

    protected void buildPopup() {
        this._tablePanel.buildPopup();
    }

    public void setSelectedFlags(String flag) {
        this._tablePanel.setSelectedFlags(flag);
    }

    public void setSelectedProtected(boolean tf) {
        this._tablePanel.setSelectedProtected(tf);
    }

    public void linearFillEstimate() {
        this._tablePanel.linearFillEstimate();
    }

    public void repeatFillEstimate() {
        this._tablePanel.repeatFillEstimate();
    }

    public void clearEstimate() {
        this._tablePanel.clearEstimate();
    }

    public void rawFillEstimate() {
        this._tablePanel.rawFillEstimate();
    }

    public void interpolateToLine(double[] x, double[] y) {
        if (x == null || x.length < 1 || y == null || y.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        int estimateCol = tableModel.getEstimateDataColumnIndex();
        int npts = x.length;
        int[] times = tableModel.getTimes();
        int firstRow = times.length;
        int lastRow = 0;
        int dataunitssystem = tableModel.getUnitSystem();
        int paramid = tableModel.getYParameterId();
        this._tablePanel.getDataTable().commitEdit(true);
        for (int i = 0; i < npts - 1; ++i) {
            int tim0 = (int)(x[i] + 0.5);
            int tim1 = (int)(x[i + 1] + 0.5);
            int nvals = times.length;
            int istart = Interpolate.bisearch((int[])times, (int)tim0, (int)nvals);
            int iend = Interpolate.bisearch((int[])times, (int)tim1, (int)nvals);
            if (istart < 0) {
                istart = 0;
            }
            if (iend > nvals - 1) {
                iend = nvals - 1;
            }
            if (times[istart] < tim0) {
                ++istart;
            }
            if (firstRow > istart) {
                firstRow = istart;
            }
            if (lastRow < iend) {
                lastRow = iend;
            }
            double dy = y[i + 1] - y[i];
            for (int irow = istart; irow <= iend; ++irow) {
                if (!tableModel.isCellEditable(irow, estimateCol)) continue;
                double tim = times[irow];
                double fact = (tim - x[i]) / (x[i + 1] - x[i]);
                double newval = dy * fact + y[i];
                ParamDouble pd = new ParamDouble(newval, paramid, dataunitssystem, 7);
                this._tablePanel.getDataTable().setValueAt((Object)pd, irow, estimateCol);
                tableModel.setEstimateFlag(irow, "E");
            }
        }
        int nsel = lastRow - firstRow + 1;
        if (nsel < 1) {
            return;
        }
        int[] sel = new int[nsel];
        for (int i = 0; i < nsel; ++i) {
            sel[i] = i + firstRow;
        }
        this._tablePanel.setSelectedRows(sel);
    }

    private void setupTable() {
        TableColumnModel columnModel = this._tablePanel.getDataTable().getColumnModel();
        this._tablePanel.getDataTable().setDoubleCellEditor(1, true);
        this._tablePanel.getDataTable().setDoubleCellEditor(3, true);
        this._tablePanel.getDataTable().setDoubleCellEditor(8, true);
        this._tablePanel.getDataTable().setDoubleCellEditor(6, true);
        this._tablePanel.getDataTable().setDisplayUnitsSystem(this._unitSystem);
        TableColumn column6 = columnModel.getColumn(6);
        if (column6 == null) {
            this._tablePanel.getDataTable().setDoubleCellEditor(6, true);
        } else {
            this._validationDecimalField = new ValidationDecimalField(0, 5);
            this._validationDecimalField.setHorizontalAlignment(4);
            this._validationDecimalField.addMouseListener((MouseListener)this._tablePanel.getDataTable());
            this._validationDecimalField.setPrecision(this.getSelectedPrecision());
            RmaCellEditor dcf = new RmaCellEditor((RmaJDecimalField)this._validationDecimalField);
            column6.setCellEditor((TableCellEditor)dcf);
        }
        this._tablePanel.getDataTable().setHorizontalAlignment(0, 2);
        this._tablePanel.getDataTable().setHorizontalAlignment(0, 4);
        this._tablePanel.getDataTable().setHorizontalAlignment(0, 5);
        this._tablePanel.getDataTable().setHorizontalAlignment(0, 7);
        this._tablePanel.getDataTable().setHorizontalAlignment(0, 9);
        int[] colwidths = new int[]{150, 80, 40, 80, 40, 40, 80, 40, 80, 40};
        this._tablePanel.getDataTable().setColumnWidths(colwidths);
        this._tablePanel.getDataTable().setSelectionMode(2);
        this._tablePanel.getDataTable().setCellSelectionEnabled(false);
        this._tablePanel.getDataTable().setColumnSelectionAllowed(false);
        this._tablePanel.getDataTable().setRowSelectionAllowed(true);
        this._tablePanel.getDataTable().setPrecision(2);
        this._tablePanel.getDataTable().setTabToEditCell(true);
        this._tablePanel.getDataTable().setUnitsHeaderRenderer();
        this._tablePanel.getDataTable().setDisplayUnitsSystem(this._unitSystem);
        TableColumn column0 = columnModel.getColumn(0);
        RmaDateTimeRenderer rend = new RmaDateTimeRenderer(2);
        TableModel model = this._tablePanel.getDataTable().getModel();
        if (model instanceof VerifyTSDataSetBase) {
            VerifyTSDataSetBase dataSet = (VerifyTSDataSetBase)((Object)model);
            columnModel.getColumn(dataSet.getRawQualityColumnIndex()).setCellRenderer((TableCellRenderer)((Object)new QualityTableCellRenderer()));
            columnModel.getColumn(dataSet.getValueQualityColumnIndex()).setCellRenderer((TableCellRenderer)((Object)new QualityTableCellRenderer()));
            columnModel.getColumn(dataSet.getValueTestColumnIndex()).setCellRenderer((TableCellRenderer)((Object)new QualityTableCellRenderer()));
            columnModel.getColumn(dataSet.getEstimateQualityColumnIndex()).setCellRenderer((TableCellRenderer)((Object)new QualityTableCellRenderer()));
            columnModel.getColumn(dataSet.getRevisedQualityColumnIndex()).setCellRenderer((TableCellRenderer)((Object)new QualityTableCellRenderer()));
            TimeZone dataTimeZone = dataSet.getTimeZone();
            rend.setIgnoreTimeZoneAdjustments(dataTimeZone == null);
        }
        if (this._dataSourceList instanceof TsContainerDataSourceList) {
            rend.setUseDataDefinedViewTimeZone(true);
        }
        column0.setCellRenderer((TableCellRenderer)rend);
        if (!(this._dataSourceList instanceof TsContainerDataSourceList)) {
            column0.setHeaderRenderer((TableCellRenderer)new TimeZoneHeaderRenderer());
        }
        this.buildPopup();
    }

    private void setupTableColumnHeaders() {
        MleHeadRenderer rdr = new MleHeadRenderer();
        JTableHeader tableHeader = this._tablePanel.getDataTable().getTableHeader();
        TableColumnModel cm = this._tablePanel.getDataTable().getColumnModel();
        TableColumn tc1 = cm.getColumn(1);
        TableColumn tc2 = cm.getColumn(2);
        TableColumn tc3 = cm.getColumn(3);
        TableColumn tc4 = cm.getColumn(4);
        TableColumn tc5 = cm.getColumn(5);
        TableColumn tc6 = cm.getColumn(6);
        TableColumn tc7 = cm.getColumn(7);
        TableColumn tc8 = cm.getColumn(8);
        TableColumn tc9 = cm.getColumn(9);
        if (tableHeader instanceof GroupableTableHeader) {
            GroupableTableHeader header = (GroupableTableHeader)tableHeader;
            ColumnGroup cg_Raw = header.getColumnGroup(0);
            ColumnGroup cg_Value = header.getColumnGroup(1);
            ColumnGroup cg_Estimate = header.getColumnGroup(2);
            ColumnGroup cg_Revised = header.getColumnGroup(3);
            cg_Raw.clear();
            cg_Value.clear();
            cg_Estimate.clear();
            cg_Revised.clear();
            tc2.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Raw.add((Object)tc1);
            cg_Raw.add((Object)tc2);
            Object rawName = null;
            TableModel model = this._tablePanel.getDataTable().getModel();
            rawName = "Raw";
            if (model instanceof VerifyTSDataSetBase && ((VerifyTSDataSetBase)((Object)model)).getRawName() != null) {
                rawName = (String)rawName + "-" + ((VerifyTSDataSetBase)((Object)model)).getRawName();
            }
            cg_Raw.setHeaderValue(rawName);
            tc4.setHeaderRenderer((TableCellRenderer)rdr);
            tc5.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Value.add((Object)tc3);
            cg_Value.add((Object)tc4);
            cg_Value.add((Object)tc5);
            tc7.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Estimate.add((Object)tc6);
            cg_Estimate.add((Object)tc7);
            tc9.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Revised.add((Object)tc8);
            cg_Revised.add((Object)tc9);
        } else {
            TableModel model = this._tablePanel.getDataTable().getModel();
            Object rawName = "Raw";
            if (model instanceof VerifyTSDataSetBase && ((VerifyTSDataSetBase)((Object)model)).getRawName() != null) {
                rawName = (String)rawName + "-" + ((VerifyTSDataSetBase)((Object)model)).getRawName();
            }
            ColumnGroup cg_Raw = new ColumnGroup((String)rawName);
            tc2.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Raw.add((Object)tc1);
            cg_Raw.add((Object)tc2);
            ColumnGroup cg_Value = new ColumnGroup("Original");
            tc4.setHeaderRenderer((TableCellRenderer)rdr);
            tc5.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Value.add((Object)tc3);
            cg_Value.add((Object)tc4);
            cg_Value.add((Object)tc5);
            ColumnGroup cg_Estimate = new ColumnGroup("Estimate/Entry");
            tc7.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Estimate.add((Object)tc6);
            cg_Estimate.add((Object)tc7);
            ColumnGroup cg_Revised = new ColumnGroup("Revised");
            tc9.setHeaderRenderer((TableCellRenderer)rdr);
            cg_Revised.add((Object)tc8);
            cg_Revised.add((Object)tc9);
            GroupableTableHeader header = new GroupableTableHeader(cm);
            header.addColumnGroup(cg_Raw);
            header.addColumnGroup(cg_Value);
            header.addColumnGroup(cg_Estimate);
            header.addColumnGroup(cg_Revised);
            this._tablePanel.getDataTable().setTableHeader((JTableHeader)header);
        }
    }

    private void fillDataSetCombo() {
        if (this._dataSourceList == null) {
            return;
        }
        this._detailsPanel.getDataSourceCombo().removeItemListener((ItemListener)this);
        this._detailsPanel.getDataSourceCombo().removeAllItems();
        int ncnt = this._dataSourceList.size();
        for (int i = 0; i < ncnt; ++i) {
            DataSource ds = this._dataSourceList.get(i);
            if (ds == null) {
                ((FluentLogger.Api)LOGGER.atFine()).log(" Data Source is null for item = " + i);
                continue;
            }
            this._detailsPanel.getDataSourceCombo().addItem((Object)ds);
        }
        if (ncnt > 0) {
            this._detailsPanel.getDataSourceCombo().setSelectedIndex(0);
            this._detailsPanel.updateComboToolTip();
            this.selectDataSet();
            this._detailsPanel.getDataSourceCombo().addItemListener((ItemListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectDataSet() {
        if (this._dataModified) {
            String message = "Data has changed. Store data?";
            int ianswer = JOptionPane.showConfirmDialog((Component)((Object)this), message, "Selecting New Data Set ...", 1, 3);
            if (ianswer == 0) {
                this.storeData();
            } else if (ianswer == 2) {
                this._detailsPanel.getDataSourceCombo().removeItemListener((ItemListener)this);
                this._detailsPanel.getDataSourceCombo().setSelectedItem((Object)this._dataSource.getName());
                this._detailsPanel.getDataSourceCombo().addItemListener((ItemListener)this);
                return;
            }
        }
        int itemIndex = this._detailsPanel.getDataSourceCombo().getSelectedIndex();
        this._detailsPanel.updateButtonsForNewDataSet();
        DataSource ds = this._dataSourceList.get(itemIndex);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            VerifyTSDataSetBase tableModel;
            TimeSeriesTemplate valueTxTemplate;
            int unitSystem;
            if (ds == null) {
                return;
            }
            this._dataSource = ds;
            this._detailsPanel.getDataSourceTextField().setText(this._dataSource.getDataSourceLocation());
            this._detailsPanel.getDataSourceTextField().setToolTipText(this._dataSource.getDataSourceLocationDetails());
            String name = ds.getName();
            long dsStart = ds.getStartTime();
            long dsEnd = ds.getEndTime();
            HecTime hecRetrStart = new HecTime();
            hecRetrStart.setTimeInMillis(dsStart);
            int retrStartTime = hecRetrStart.value();
            HecTime hecRetrEnd = new HecTime();
            hecRetrEnd.setTimeInMillis(dsEnd);
            int retrEndTime = hecRetrEnd.value();
            TimeSeries valueTx = null;
            TimeSeries rawTx = null;
            TimeSeriesContainer tsc = null;
            Serializable retrieveMetadata = this.getRetrieveMetaData(ds);
            Serializable data = this.retrieveValueData(ds);
            TimeSeriesContainer rawData = null;
            if (data != null) {
                if (this._mode == 1) {
                    if (data instanceof TimeSeriesContainer) {
                        Serializable raw = ds.retrieveRawData();
                        if (raw instanceof TimeSeriesContainer) {
                            rawData = (TimeSeriesContainer)raw;
                        }
                        tsc = (TimeSeriesContainer)data;
                        unitSystem = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
                        if (!UnitUtil.isValidUnitsSystem((int)unitSystem)) {
                            unitSystem = this._unitSystem;
                        }
                        Units.convertUnits((TimeSeriesContainer)tsc, (int)unitSystem);
                        if (rawData != null) {
                            Units.convertUnits((TimeSeriesContainer)rawData, (int)unitSystem);
                        }
                        if (tsc.quality == null) {
                            tsc.quality = tsc.values == null ? new int[0] : new int[tsc.values.length];
                        }
                    } else {
                        valueTx = (TimeSeries)data;
                        Serializable timeSeries = this.retrieveRawValueData(ds);
                        if (timeSeries instanceof TimeSeries) {
                            rawTx = (TimeSeries)timeSeries;
                        }
                        if (!UnitUtil.isValidUnitsSystem((int)(unitSystem = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem()))) {
                            unitSystem = this._unitSystem;
                        }
                        try {
                            valueTx.changeUnitSystem(unitSystem);
                            if (rawTx != null) {
                                rawTx.changeUnitSystem(unitSystem);
                            }
                        }
                        catch (DataSetIllegalArgumentException | UnitsConversionException | mil.army.usace.hec.metadata.DataSetIllegalArgumentException | mil.army.usace.hec.metadata.UnitsConversionException | DataSetTimeSeriesException ex) {
                            ((FluentLogger.Api)LOGGER.at(Level.SEVERE).withCause(ex)).log("Converting unit system");
                        }
                        if (ds instanceof ValidationDataSource) {
                            List<TimeSeriesContainer> compareContainers = ((ValidationDataSource)ds).retrieveComparisonList();
                            compareContainers.removeIf(v -> new DSSPathname(v.getFullName()).isCwmsTsId());
                            List<TimeSeries> comparisonData = ((ValidationDataSource)ds).retrieveComparisonTimeSeries();
                            for (TimeSeries comparisonDatum : comparisonData) {
                                try {
                                    TimeSeries compareTx = TimeSeriesBuilder.copy((TimeSeries)comparisonDatum);
                                    compareTx.changeUnitSystem(unitSystem);
                                    TimeSeriesContainer container = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)compareTx);
                                    compareContainers.add(container);
                                }
                                catch (DataSetIllegalArgumentException | UnitsConversionException | DataSetException ex) {
                                    ((FluentLogger.Api)LOGGER.at(Level.SEVERE).withCause(ex)).log("Converting unit system");
                                }
                            }
                        }
                    }
                } else if (this._dataSourceList instanceof TsContainerDataSourceList) {
                    if (data instanceof TimeSeries) {
                        valueTx = (TimeSeries)data;
                    } else if (data instanceof TimeSeriesContainer) {
                        tsc = (TimeSeriesContainer)data;
                        int unitSystem2 = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
                        if (!UnitUtil.isValidUnitsSystem((int)unitSystem2)) {
                            unitSystem2 = this._unitSystem;
                        }
                        Units.convertUnits((TimeSeriesContainer)tsc, (int)unitSystem2);
                    }
                } else {
                    return;
                }
            }
            if (this._mode == 1 && data == null && retrieveMetadata instanceof TimeSeriesTemplate) {
                valueTxTemplate = (TimeSeriesTemplate)retrieveMetadata;
                this.selectedBadDataSet(name, retrStartTime, retrEndTime, valueTxTemplate, rawTx);
                return;
            }
            if (this._mode == 0 && data == null && retrieveMetadata instanceof TimeSeriesTemplate) {
                valueTxTemplate = (TimeSeriesTemplate)retrieveMetadata;
                this.selectedBadDataSet(name, retrStartTime, retrEndTime, valueTxTemplate);
                return;
            }
            if (!(this._mode != 0 || tsc != null && tsc.numberValues >= 1 || retrieveMetadata != null && !(retrieveMetadata instanceof TimeSeriesContainer))) {
                this.selectedBadDataSet(name, retrStartTime, retrEndTime, null);
                return;
            }
            if (!(this._mode != 1 || tsc != null && tsc.numberValues >= 1 || retrieveMetadata != null && !(retrieveMetadata instanceof TimeSeriesContainer))) {
                this.selectedBadDataSet(name, retrStartTime, retrEndTime, null);
                return;
            }
            if (!(data instanceof TimeSeries) && !(data instanceof TimeSeriesContainer)) {
                return;
            }
            this._dataSetTxValue = valueTx;
            this._tscValue = tsc;
            if (this._dataSource != null && this._dataSource.countObservers() < 1) {
                this._dataSource.addObserver(this);
            }
            this._plotPanel.showPlotCard();
            if (tsc != null) {
                String realUnits = UnitUtil.getUnitsForAlias((String)tsc.units);
                unitSystem = UnitUtil.getUnitSystemForUnits((String)realUnits);
                if (unitSystem != 0) {
                    this._unitSystem = unitSystem;
                }
            } else {
                int unitSystem3 = UnitUtil.getUnitSystemForUnits((String)valueTx.getUnits().toString());
                if (unitSystem3 != 0) {
                    this._unitSystem = unitSystem3;
                }
            }
            if (this._mode == 1) {
                tableModel = null;
                boolean missSelected = this._preferences.getBoolean("alwaysEstimateMissing", true);
                if (tsc != null) {
                    if (!this._dataSourceList.getTrim()) {
                        hecRetrStart.setTimeInMillis(this._dataSourceList.getStartTime());
                        hecRetrEnd.setTimeInMillis(this._dataSourceList.getEndTime());
                        if (tsc.timeZoneID != null) {
                            HecTime.convertTimeZone((HecTime)hecRetrStart, (TimeZone)this._dataSourceList.getTimeZone(), (TimeZone)TimeZone.getTimeZone(tsc.timeZoneID), (boolean)false);
                            HecTime.convertTimeZone((HecTime)hecRetrEnd, (TimeZone)this._dataSourceList.getTimeZone(), (TimeZone)TimeZone.getTimeZone(tsc.timeZoneID), (boolean)false);
                        }
                        int startTime = hecRetrStart.value();
                        int endTime = hecRetrEnd.value();
                        if (tsc.timeZoneID != null) {
                            tableModel = new VerifyTimeSeriesDataSet(startTime, endTime, rawData, tsc, missSelected);
                        } else {
                            tsc.timeZoneID = this._dataSourceList.getTimeZone().getID();
                            tableModel = new VerifyTimeSeriesDataSet(startTime, endTime, rawData, tsc, missSelected);
                            tsc.timeZoneID = null;
                        }
                        tableModel.padToTimeWindow();
                    } else {
                        tableModel = new VerifyTimeSeriesDataSet(retrStartTime, retrEndTime, rawData, tsc, missSelected);
                    }
                } else {
                    tableModel = new VerifyTimeSeriesDataSet(name, retrStartTime, retrEndTime, rawTx, valueTx, missSelected);
                }
                if (tableModel == null) {
                    return;
                }
                this.fillForm((VerifyTimeSeriesDataSet)tableModel);
            } else if (data instanceof TimeSeries) {
                tableModel = new TimeSeriesEditorDataSet(name, retrStartTime, retrEndTime, valueTx);
                if (tableModel == null) {
                    return;
                }
                this.fillFormTSEditor((TimeSeriesEditorDataSet)tableModel);
            } else if (data instanceof TimeSeriesContainer && this._dataSourceList instanceof TsContainerDataSourceList) {
                tableModel = new TimeSeriesEditorDataSet(retrStartTime, retrEndTime, tsc){

                    @Override
                    public String getYAxisName() {
                        if (this.getYParameterId() == -1) {
                            return this.getYUnits();
                        }
                        Object parameterdString = Parameter.getParamString((int)this.getYParameterId());
                        if (!this.getYUnits().equals("%S")) {
                            try {
                                Parameter param = new Parameter((String)parameterdString);
                                if (!UnitUtil.canConvertBetweenUnits((String)param.getUnitsString(), (String)this.getYUnits())) {
                                    String unitString = this.getYUnits();
                                    return unitString;
                                }
                            }
                            catch (DataSetIllegalArgumentException e) {
                                String unitString = this.getYUnits();
                                return unitString;
                            }
                        }
                        parameterdString = (String)parameterdString + " (%S) ";
                        return parameterdString;
                    }
                };
                if (tableModel == null) {
                    return;
                }
                this.fillFormTSEditor((TimeSeriesEditorDataSet)tableModel);
            } else {
                return;
            }
            boolean missSelected = this._estimateMissingMenuItem.getState();
            if (missSelected) {
                this.provideEstimateMissingAction();
            }
            this.setDataModified(false);
            this._tablePanel.getDataTable().requestFocus();
        }
        catch (DataSetTimeSeriesException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error transforming data source for tabular and graphical display: %s", (Object)ds);
        }
        finally {
            this.setCursor(this._defaultCursor);
        }
    }

    private void selectedBadDataSet(String name, int retrStartTime, int retrEndTime, TimeSeriesTemplate valueTx, TimeSeries rawTx) throws DataSetTimeSeriesException {
        TableModel oldModel = this._tablePanel.getDataTable().getModel();
        if (this._mode == 1) {
            VerifyTimeSeriesDataSet tableModel = new VerifyTimeSeriesDataSet(name, retrStartTime, retrEndTime, rawTx, valueTx);
            if (oldModel instanceof VerifyTimeSeriesDataSet) {
                boolean editableData = ((VerifyTimeSeriesDataSet)((Object)oldModel)).getEditableData();
                tableModel.setEditableData(editableData);
            }
            this._tablePanel.getDataTable().setModel((TableModel)((Object)tableModel));
            this.setupTable();
            this.setupTableColumnHeaders();
        } else if (this._mode == 0) {
            TimeSeriesEditorDataSet tableModel = new TimeSeriesEditorDataSet(name, retrStartTime, retrEndTime, null);
            if (oldModel instanceof VerifyTimeSeriesDataSet) {
                boolean editableData = ((VerifyTimeSeriesDataSet)((Object)oldModel)).getEditableData();
                tableModel.setEditableData(editableData);
            }
            this._tablePanel.getDataTable().setModel((TableModel)((Object)tableModel));
            this._tablePanel.setupTSEditorTable(this._comparisonDataList, this._unitSystem);
            this.buildPopup();
            this._tablePanel.setupTSEditorTableColumnHeaders();
        }
        this.updateTimeZone((Container)((Object)this));
        this._plotPanel.getG2dPanel().setVisible(false);
        this._plotPanel.getG2dPanel().clearPanel();
        this._plotPanel.showMissingCard();
    }

    private void selectedBadDataSet(String name, int retrStartTime, int retrEndTime, TimeSeriesTemplate valueTx) throws DataSetTimeSeriesException {
        TableModel oldModel = this._tablePanel.getDataTable().getModel();
        if (this._mode == 1) {
            VerifyTimeSeriesDataSet tableModel = new VerifyTimeSeriesDataSet(name, retrStartTime, retrEndTime, null, valueTx);
            if (oldModel instanceof VerifyTimeSeriesDataSet) {
                boolean editableData = ((VerifyTimeSeriesDataSet)((Object)oldModel)).getEditableData();
                tableModel.setEditableData(editableData);
            }
            this._tablePanel.getDataTable().setModel((TableModel)((Object)tableModel));
            this.setupTable();
            this.setupTableColumnHeaders();
        } else if (this._mode == 0) {
            TimeSeriesEditorDataSet tableModel = new TimeSeriesEditorDataSet(name, retrStartTime, retrEndTime, null);
            if (oldModel instanceof VerifyTimeSeriesDataSet) {
                boolean editableData = ((VerifyTimeSeriesDataSet)((Object)oldModel)).getEditableData();
                tableModel.setEditableData(editableData);
            }
            this._tablePanel.getDataTable().setModel((TableModel)((Object)tableModel));
            this._tablePanel.setupTSEditorTable(this._comparisonDataList, this._unitSystem);
            this.buildPopup();
            this._tablePanel.setupTSEditorTableColumnHeaders();
        }
        this.updateTimeZone((Container)((Object)this));
        this._plotPanel.getG2dPanel().setVisible(false);
        this._plotPanel.getG2dPanel().clearPanel();
        this._plotPanel.showMissingCard();
    }

    private void fillForm(VerifyTimeSeriesDataSet tableModel) {
        int numMisVal;
        int numQueVal;
        int numRejVal;
        if (tableModel == null) {
            return;
        }
        TableModel oldModel = this._tablePanel.getDataTable().getModel();
        if (oldModel instanceof VerifyTimeSeriesDataSet) {
            boolean editableData = ((VerifyTimeSeriesDataSet)((Object)oldModel)).getEditableData();
            tableModel.setEditableData(editableData);
        }
        this._tablePanel.getDataTable().setModel((TableModel)((Object)tableModel));
        this.setupTable();
        this._tablePanel.getDataTable().removeTableChangeListener((TableChangeListener)this);
        this._tablePanel.getDataTable().addTableChangeListener((TableChangeListener)this);
        tableModel.removeTableModelListener(this._tableModelListener);
        tableModel.addTableModelListener(this._tableModelListener);
        this._tablePanel.updateLsm();
        if (this._tscValue != null) {
            numRejVal = TimeSeriesContainerQualityUtil.getNumberValuesReject((TimeSeriesContainer)this._tscValue);
            numQueVal = TimeSeriesContainerQualityUtil.getNumberValuesQuestion((TimeSeriesContainer)this._tscValue);
            numMisVal = TimeSeriesContainerQualityUtil.getNumberValuesMissing((TimeSeriesContainer)this._tscValue);
        } else if (this._dataSetTxValue != null) {
            TimeSeriesStatistics statistics = this._dataSetTxValue.getTimeSeriesStatistics();
            numRejVal = statistics.getNumberValuesReject();
            numQueVal = statistics.getNumberValuesQuestion();
            numMisVal = statistics.getNumberValuesMissing();
        } else {
            String message = "TimeSeries for value data is null";
            JOptionPane.showConfirmDialog((Component)((Object)this), message, "Warning!", -1, 2);
            this.setupTableColumnHeaders();
            return;
        }
        this._detailsPanel.setRejectedCount(numRejVal);
        this._detailsPanel.setQuestionableCount(numQueVal);
        this._detailsPanel.setMissingCount(numMisVal);
        this._detailsPanel.getValuePanel().revalidate();
        this.buildPlotData();
        int rowselect = 0;
        int[] times = tableModel.getTimes();
        int[] revisedQual = tableModel.getRevisedQuality();
        if (revisedQual != null && revisedQual.length > 0) {
            byte[] bytes = new byte[4];
            for (int i = 0; i < times.length; ++i) {
                int valIdx = tableModel.getValueIndex(i);
                if (valIdx == -1) continue;
                int qual = revisedQual[valIdx];
                Quality.getBytes((int)qual, (byte[])bytes);
                boolean isOk = Quality.isOkay((byte[])bytes);
                if (qual == 0 || isOk) continue;
                rowselect = i;
                break;
            }
        }
        this._tablePanel.initializeButtons();
        int nsize = this._comparisonDataList.size();
        boolean tf = nsize > 0;
        this._showComparisonMenuItem.setEnabled(tf);
        this._jCheckBox_showComparisons.setEnabled(tf);
        boolean editableData = tableModel.getEditableData();
        this.editableDataMenuItem.setSelected(editableData);
        this.editableDataCheckBox.setSelected(editableData);
        this.setEditableData(editableData);
        this._tablePanel.setSelectedRow(rowselect);
        this._tablePanel.setSelectedRow(rowselect);
        this._optScaleToRawMenuItem.setState(true);
        this._optScaleToRawMenuItem.setVisible(true);
        this._scaleToRawValues = true;
        int precis = this.getSelectedPrecision();
        if (precis < 0 || precis > 6) {
            precis = 2;
        }
        this.setSelectedPrecision(precis);
        this.initComponents();
        this.showComparisonAction();
        this.setupTableColumnHeaders();
    }

    private void fillFormTSEditor(TimeSeriesEditorDataSet tableModel) {
        if (tableModel == null) {
            return;
        }
        TableModel oldModel = this._tablePanel.getDataTable().getModel();
        if (oldModel instanceof VerifyTimeSeriesDataSet) {
            boolean editableData = ((VerifyTimeSeriesDataSet)((Object)oldModel)).getEditableData();
            tableModel.setEditableData(editableData);
        }
        this._tablePanel.getDataTable().setModel((TableModel)((Object)tableModel));
        this._tablePanel.setupTSEditorTable(this._comparisonDataList, this._unitSystem);
        this.buildPopup();
        this._tablePanel.getDataTable().removeTableChangeListener((TableChangeListener)this);
        this._tablePanel.getDataTable().addTableChangeListener((TableChangeListener)this);
        tableModel.removeTableModelListener(this._tableModelListener);
        tableModel.addTableModelListener(this._tableModelListener);
        this._tablePanel.updateLsm();
        int numRejVal = 0;
        int numQueVal = 0;
        int numMisVal = 0;
        this._detailsPanel.setRejectedCount(numRejVal);
        this._detailsPanel.setQuestionableCount(numQueVal);
        this._detailsPanel.setMissingCount(numMisVal);
        this._detailsPanel.getValuePanel().setVisible(false);
        this.buildPlotData();
        int rowselect = 0;
        int[] revisedQual = tableModel.getRevisedQuality();
        if (revisedQual != null && revisedQual.length > 0) {
            byte[] bytes = new byte[4];
            for (int i = 0; i < revisedQual.length; ++i) {
                Quality.getBytes((int)revisedQual[i], (byte[])bytes);
                boolean isOk = Quality.isOkay((byte[])bytes);
                if (revisedQual[i] == 0 || isOk) continue;
                rowselect = i;
                break;
            }
        }
        this._tablePanel.initializeButtons();
        boolean editableData = tableModel.getEditableData();
        this.editableDataMenuItem.setSelected(editableData);
        this.editableDataCheckBox.setSelected(editableData);
        this.setEditableData(editableData);
        this.editableDataMenuItem.setVisible(false);
        this.editableDataCheckBox.setVisible(false);
        this._jCheckBox_showComparisons.setVisible(false);
        int nsize = this._comparisonDataList.size();
        boolean tf = nsize > 0;
        this._showComparisonMenuItem.setEnabled(tf);
        this._jCheckBox_showComparisons.setEnabled(tf);
        this._optScaleToRawMenuItem.setState(false);
        this._optScaleToRawMenuItem.setVisible(false);
        this._scaleToRawValues = false;
        this._tablePanel.setSelectedRow(rowselect);
        this._tablePanel.setSelectedRow(rowselect);
        this.initComponents();
        this.showComparisonAction();
        this._tablePanel.setupTSEditorTableColumnHeaders();
    }

    SimpleJTableData getVerifyPlotArray() {
        SimpleJTableData sa = new SimpleJTableData();
        sa.xunits = "Date/Time";
        sa.yunits = "cfs";
        sa.setXAxisType(0);
        sa.setData(this._tablePanel.getDataTable(), 5, 5);
        return sa;
    }

    private void buildPlotData() {
        ArrayList<G2dObject> plotVec = new ArrayList<G2dObject>();
        ArrayList<G2dLineProperties> colorVec = new ArrayList<G2dLineProperties>();
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        tableModel.setScaleToRawData(this._optScaleToRawMenuItem.getState());
        plotVec.add(tableModel);
        G2dLineProperties properties = new G2dLineProperties();
        properties.setLineColor(VerifyTimeSeriesGlyph.ORIGINAL_COLOR);
        colorVec.add(properties);
        properties = new G2dLineProperties();
        properties.setLineColor(VerifyTimeSeriesGlyph.ESTIMATE_COLOR);
        properties.setDrawLine(false);
        properties.setDrawPoints(true);
        colorVec.add(properties);
        properties = new G2dLineProperties();
        properties.setLineColor(VerifyTimeSeriesGlyph.REVISED_COLOR);
        colorVec.add(properties);
        double[] rawData = tableModel.getRawData();
        if (rawData != null) {
            properties = new G2dLineProperties();
            properties.setLineColor(VerifyTimeSeriesGlyph.RAW_COLOR);
            colorVec.add(properties);
        }
        if (this._scrollViewData == null) {
            this._scrollViewData = new ScrollViewData();
        }
        int timeCol = 0;
        this._scrollViewData.setData((JTable)this._tablePanel.getDataTable(), this._tablePanel.getScrollPane(), timeCol, tableModel);
        plotVec.add(this._scrollViewData);
        properties = new G2dLineProperties();
        properties.setLineColor(VerifyTimeSeriesGlyph.ORIGINAL_COLOR);
        colorVec.add(properties);
        this._plotVecWithComparison.clear();
        this._plotVec.clear();
        this._colorVec.clear();
        InterpolationLineData ldata = new InterpolationLineData(tableModel);
        plotVec.add(ldata);
        properties = new G2dLineProperties();
        properties.setLineColor(VerifyTimeSeriesGlyph.ESTIMATE_COLOR);
        colorVec.add(properties);
        this._plotVec.addAll(plotVec);
        List<G2dObject> comparisonData = this._plotPanel.addComparisonData(this._unitSystem, plotVec, colorVec, this._dataSource);
        this._comparisonDataList.clear();
        this._comparisonDataList.addAll(comparisonData);
        this._plotVecWithComparison.addAll(plotVec);
        this._colorVec.addAll(colorVec);
    }

    private void setDataModified(boolean tf) {
        this._dataModified = tf;
    }

    private void nextFlaggedValue(int dir) {
        if (dir != 1 && dir != -1) {
            return;
        }
        boolean searchDown = dir == 1;
        int currentRow = this._tablePanel.getDataTable().getSelectedRow();
        int nrows = this._tablePanel.getDataTable().getRowCount();
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._tablePanel.getDataTable().getModel());
        int ifound = tableModel.getNextFlaggedValue(currentRow, searchDown);
        if (ifound < 0 || ifound > nrows - 1) {
            return;
        }
        this._tablePanel.setSelectedRow(ifound);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof DataSource) {
            UpdateRunnable run = new UpdateRunnable(arg);
            if (SwingUtilities.isEventDispatchThread()) {
                run.run();
            } else {
                SwingUtilities.invokeLater(run);
            }
        }
    }

    private void exportProperties() {
        this.writeLocal();
    }

    private void writeLocal() {
        int reply;
        RMAFilenameFilter plotPropFileFilter = new RMAFilenameFilter("template", "Plot Properties (*.template)");
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter((FileFilter)plotPropFileFilter);
        int state = chooser.showSaveDialog((Component)((Object)this));
        File file = chooser.getSelectedFile();
        if (state == 1) {
            return;
        }
        if (file == null && state == 0) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Please select a file!", "File Error", 0);
            return;
        }
        if (file == null) {
            return;
        }
        String path = file.getPath();
        if (!path.endsWith(".template")) {
            path = path.concat(".template");
        }
        if (file.exists() && (reply = RMAIO.postYesNoWarning((Component)((Object)this), (String)(file.getName() + " already exists!\n Do you want to replace it?"))) == 1) {
            return;
        }
        G2dPanelProp panelProp = this._plotPanel.getG2dPanel().getProperties();
        try (FileWriter fileWriter = new FileWriter(path);
             BufferedWriter buffW = new BufferedWriter(fileWriter);){
            panelProp.writeProperties(buffW);
            buffW.flush();
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error writing to " + path);
        }
    }

    private void importProperties() {
        this.readLocal();
    }

    private void readLocal() {
        RMAFilenameFilter plotPropFileFilter = new RMAFilenameFilter("template", "Plot Properties (*.template)");
        JFileChooser chooser = new JFileChooser();
        chooser.addChoosableFileFilter((FileFilter)plotPropFileFilter);
        int state = chooser.showOpenDialog((Component)((Object)this));
        File file = chooser.getSelectedFile();
        if (state == 1) {
            return;
        }
        G2dPanelProp panelProp = new G2dPanelProp();
        String path = file.getPath();
        if (!path.endsWith(".template")) {
            path = path.concat(".template");
        }
        try (FileReader fileReader = new FileReader(path);
             BufferedReader buffR = new BufferedReader(fileReader);){
            panelProp.readProperties(buffR);
            this._plotPanel.getG2dPanel().resetProperties(panelProp);
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Could not read template properties from file: " + path);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        return this._plotPanel.print(g, pageFormat, pageIndex, this.getTitle());
    }

    @Override
    public PageFormat getPageFormat(int pageNum) {
        PrintProperties printProperties = this._plotPanel.getPrintProperties();
        this._pageFormat.setOrientation(printProperties.getLayout());
        Margin margin = printProperties.getMargins();
        Paper paper = new Paper();
        double imageableX = margin.getLeftMargin() * 72.0;
        double imageableY = margin.getTopMargin() * 72.0;
        double imageableW = paper.getWidth() - (margin.getLeftMargin() + margin.getRightMargin()) * 72.0;
        double imageableH = paper.getHeight() - (margin.getTopMargin() + margin.getBottomMargin()) * 72.0;
        paper.setImageableArea(imageableX, imageableY, imageableW, imageableH);
        this._pageFormat.setPaper(paper);
        return this._pageFormat;
    }

    @Override
    public Printable getPrintable(int pageNum) {
        return this;
    }

    @Override
    public int getNumberOfPages() {
        return 1;
    }

    public void copyTable() {
        if (this._tablePanel.getDataTable() == null) {
            return;
        }
        this._tablePanel.getDataTable().copy();
    }

    public String copyTableHeader() {
        return this._tablePanel.copyTableHeader();
    }

    public void copyAll() {
        this._tablePanel.copyAll();
    }

    public void copyToClipboard() {
        this._plotPanel.copyToClipboard(this.getTitle());
    }

    public void downArrowKey(ActionEvent e) {
        int currentRow;
        if (!this._tablePanel.getDataTable().hasFocus() && (currentRow = this._tablePanel.getDataTable().getSelectedRow()) < this._tablePanel.getDataTable().getNumRows()) {
            this._tablePanel.setSelectedRow(currentRow + 1);
        }
    }

    public void upArrowKey() {
        int currentRow;
        if (!this._tablePanel.getDataTable().hasFocus() && (currentRow = this._tablePanel.getDataTable().getSelectedRow()) > 1) {
            this._tablePanel.setSelectedRow(currentRow - 1);
        }
    }

    public void altDownArrowKey() {
        this.nextFlaggedValue(1);
    }

    public void altUpArrowKey() {
        this.nextFlaggedValue(-1);
    }

    private Serializable retrieveRawValueData(DataSource ds) {
        return ds.retrieveRawData();
    }

    private Serializable retrieveValueData(DataSource ds) {
        return ds.retrieveValueData();
    }

    private Serializable getRetrieveMetaData(DataSource ds) {
        return ds.getRetrieveMetadata();
    }

    private void deleteValues(DataSource ds, Serializable newRevised, TimeWindowMap timeWindowMap) {
        ds.deleteValues(newRevised, timeWindowMap);
    }

    private void storeRevisedData(DataSource ds, Serializable revisedData) {
        ds.storeRevisedData(revisedData);
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == VerifyDataDlg.this) {
                VerifyDataDlg.this.VerifyDataDlg_WindowClosing(event);
            }
        }

        @Override
        public void windowOpened(WindowEvent event) {
            SwingUtilities.invokeLater(() -> {
                VerifyDataDlg.this._tablePanel.getDataTable().requestFocus();
                VerifyDataDlg.this._tablePanel.getDataTable().requestDefaultFocus();
            });
        }
    }

    private static class PrecisionJRadioButtonMenuItem
    extends JRadioButtonMenuItem {
        int _precision;

        public PrecisionJRadioButtonMenuItem(String label, int precision) {
            super(label);
            this._precision = precision;
        }

        public int getPrecision() {
            return this._precision;
        }
    }

    private class SwapViewAction
    extends AbstractAction {
        private final int _splitMode;

        public SwapViewAction(int splitMode) {
            super(splitMode == 1 ? "Horizontal Layout" : "Vertical Layout");
            this._splitMode = splitMode;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VerifyDataDlg.this._splitPane.setOrientation(this._splitMode);
            VerifyDataDlg.this._options.setSplitPaneMode(this._splitMode);
            int loc = VerifyDataDlg.this._splitPane.getDividerLocation();
            int minLoc = VerifyDataDlg.this._splitPane.getMinimumDividerLocation();
            int maxLoc = VerifyDataDlg.this._splitPane.getMaximumDividerLocation();
            if (loc < minLoc) {
                loc = minLoc;
            } else if (loc > maxLoc) {
                loc = maxLoc;
            }
            VerifyDataDlg.this._splitPane.setDividerLocation(loc);
        }
    }

    private static final class QualityTableCellRenderer
    extends AlignTableCellRenderer {
        private QualityTableCellRenderer() {
            super(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            TableModel model;
            Component retval = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (retval instanceof JComponent && (model = table.getModel()) instanceof VerifyTSDataSetBase) {
                String tooltip = ((VerifyTSDataSetBase)((Object)model)).getToolTipText(row, column);
                ((JComponent)retval).setToolTipText("<html>" + tooltip + "</html>");
            }
            return retval;
        }
    }

    public class UpdateRunnable
    implements Runnable {
        Object _arg;

        public UpdateRunnable(Object arg) {
            this._arg = arg;
        }

        @Override
        public void run() {
            String sMsg = this._arg.toString();
            if (sMsg.charAt(0) != '\n' || sMsg.charAt(sMsg.length() - 1) != '\n') {
                VerifyDataDlg.this.textAreaMessages.append("\n");
            }
            if (sMsg.charAt(sMsg.length() - 1) == '\n') {
                VerifyDataDlg.this.textAreaMessages.append(sMsg);
            } else {
                VerifyDataDlg.this.textAreaMessages.append(sMsg);
            }
            VerifyDataDlg.this.textAreaMessages.setCaretPosition(VerifyDataDlg.this.textAreaMessages.getText().length());
        }
    }
}

