/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import com.google.common.flogger.FluentLogger;
import hec.data.DataSetIllegalArgumentException;
import hec.data.Parameter;
import hec.data.Units;
import hec.data.tx.ComparisonDataSource;
import hec.dataui.tx.DataSource;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dPanel;
import hec.gfx2d.ObjectSelectionListener;
import hec.gfx2d.PageSetupJDialog;
import hec.gfx2d.PrintProperties;
import hec.gfx2d.SimpleJTableData;
import hec.gfx2d.TimeSeriesDataSetBase;
import hec.gfx2d.ToolbarButtonProp;
import hec.gfx2d.Viewport;
import hec.io.TimeSeriesContainer;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mil.army.usace.hec.metadata.UnitUtil;
import rma.services.ServiceLookup;
import rma.swing.RmaInsets;
import rma.swing.RmaJPanel;
import rma.util.RMAIO;
import rma.util.wmf.WMF;
import rma.util.wmf.WMFGraphics2D;
import rma.util.wmf.WMFUtil;

final class VerifyDataPlotPanel
extends RmaJPanel {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String MISSING_CARD = "MISSING_CARD";
    private static final String PLOT_CARD = "PLOT_CARD";
    private static final int TITLE_OFFSET = 50;
    private final CardLayout _plotLayout = new CardLayout();
    private final JPanel _missingDataMsg = new JPanel(new GridBagLayout());
    private MyG2dPanel _g2dPanel = new MyG2dPanel();
    private PrintProperties _printProperties = new PrintProperties();
    private boolean _useLocalPageFormat = true;

    VerifyDataPlotPanel() {
        super((LayoutManager)new GridBagLayout());
        this.buildPlotPanel();
    }

    private void buildPlotPanel() {
        this.setLayout(this._plotLayout);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.anchor = 15;
        gbc.insets = new Insets(5, 0, 0, 0);
        this.add(this._missingDataMsg, MISSING_CARD);
        this._missingDataMsg.setBackground(Color.white);
        JLabel jlMissing = new JLabel("No Data");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 0;
        gbc.anchor = 10;
        gbc.insets = RmaInsets.insets((int)5, (int)5, (int)5, (int)5);
        this._missingDataMsg.add((Component)jlMissing, gbc);
        Vector<SimpleJTableData> plotvec = new Vector<SimpleJTableData>();
        plotvec.addElement(this.getValuePlotArray());
        this._g2dPanel.setPlotObjects(plotvec);
        this.add((Component)((Object)this._g2dPanel), PLOT_CARD);
    }

    private SimpleJTableData getValuePlotArray() {
        SimpleJTableData sa = new SimpleJTableData();
        sa.xunits = "Date";
        sa.yunits = "Value (Units)";
        sa.setXAxisType(0);
        sa.setData(null, -1, -1);
        return sa;
    }

    void buildPlotPanel(int unitSystem, Preferences prefs, ObjectSelectionListener selectionListener, FocusListener focusListener, List<G2dObject> plotVec, List<G2dLineProperties> colorVec) {
        int selectedButton = prefs.getInt("selectedTool", 0);
        this._g2dPanel.removeObjectSelectionListener(selectionListener);
        this._g2dPanel.removeFocusListener(focusListener);
        this._g2dPanel = new MyG2dPanel();
        this._g2dPanel.buildComponents(plotVec, colorVec);
        this._g2dPanel.setDisplayUnitsSystem(unitSystem);
        Viewport[] viewports = this._g2dPanel.getViewports();
        for (int i = 0; viewports != null && i < viewports.length; ++i) {
            viewports[i].setDoubleBuffered(false);
        }
        ToolbarButtonProp bgstr = new ToolbarButtonProp();
        bgstr.up = "Images/edit.gif";
        bgstr.down = "Images/edit.gif";
        bgstr.over = "Images/edit.gif";
        bgstr.on = "Images/edit.gif";
        bgstr.adapter = "hec.dataui.tx.awt.ValidationEditAdapter";
        bgstr.toolTipText = "Single Point Edit";
        this._g2dPanel.addTool(bgstr);
        bgstr = new ToolbarButtonProp();
        bgstr.up = "Images/drawLine.gif";
        bgstr.down = "Images/drawLine.gif";
        bgstr.over = "Images/drawLine.gif";
        bgstr.on = "Images/drawLine.gif";
        bgstr.adapter = "hec.dataui.tx.awt.InterpolationLineAdapter";
        bgstr.toolTipText = "Multi-point Edit";
        this._g2dPanel.addTool(bgstr);
        this._g2dPanel.addObjectSelectionListener(selectionListener);
        if (selectedButton >= 0) {
            this._g2dPanel.setSelectedToolbarButton(selectedButton);
        }
        this._g2dPanel.addFocusListener(focusListener);
    }

    G2dPanel getG2dPanel() {
        return this._g2dPanel;
    }

    boolean isShowingMissingDataMessage() {
        Component[] c;
        boolean output = false;
        for (Component component : c = this.getComponents()) {
            if (!component.equals(this._missingDataMsg) || !component.isVisible()) continue;
            output = true;
            break;
        }
        return output;
    }

    void removePlot() {
        this.remove((Component)((Object)this._g2dPanel));
    }

    void restorePlot() {
        this.add((Component)((Object)this._g2dPanel), PLOT_CARD);
        this.showPlotCard();
    }

    void showPlotCard() {
        this._plotLayout.show((Container)((Object)this), PLOT_CARD);
    }

    void showMissingCard() {
        this._plotLayout.show((Container)((Object)this), MISSING_CARD);
    }

    private void paintGfx(Graphics g, String line) {
        double titleWidthDiff;
        int yTitleLoc;
        Dimension d = this.getG2dPanel().getSize();
        Rectangle rect = this.getG2dPanel().getBounds();
        int fontHeight = g.getFontMetrics().getHeight();
        int fontDescent = g.getFontMetrics().getDescent();
        int cnt = 1;
        Color oldColor = g.getColor();
        while (true) {
            FontMetrics fm = g.getFontMetrics();
            int lineWidth = fm.stringWidth(line);
            yTitleLoc = fontHeight * cnt - fontDescent;
            titleWidthDiff = d.width - lineWidth;
            if (!(titleWidthDiff < 0.0)) break;
            Font f = g.getFont();
            g.setFont(new Font(f.getName(), f.getStyle(), f.getSize() - 1));
        }
        g.translate(0, fontHeight - fontDescent);
        g.setColor(Color.black);
        int xTitleLoc = (int)titleWidthDiff / 2 + rect.x;
        g.drawString(line, xTitleLoc, yTitleLoc);
        g.setColor(oldColor);
        g.translate(0, ++cnt * fontHeight + 1);
        this.getG2dPanel().paintGfx(g);
    }

    public void copyToClipboard(String title) {
        if (RMAIO.getOSType() != 1 && RMAIO.getOSType() != 0) {
            throw new RuntimeException("Cannot copy metafile to clipboard on any OS other than WINDOWS!!");
        }
        WMF wmf = new WMF();
        Dimension d = this.getG2dPanel().getSize();
        WMFGraphics2D g = new WMFGraphics2D(wmf, d.width, d.height + 50, this.getG2dPanel().getForeground(), this.getG2dPanel().getBackground());
        this.paintGfx((Graphics)g, title);
        try {
            WMFUtil.writePlaceableWMFToClipboard((WMF)wmf, (int)0, (int)0, (int)d.width, (int)(d.height + 50), (int)Toolkit.getDefaultToolkit().getScreenResolution());
        }
        catch (IOException ex) {
            String messge = "The following error occured while writing wmf File to Clipboard:\n" + ex.getMessage();
            RMAIO.postError((Component)((Object)this), (String)messge);
            ((FluentLogger.Api)LOGGER.at(Level.SEVERE).withCause((Throwable)ex)).log(messge);
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex, String title) {
        if (pageIndex > 0) {
            return 1;
        }
        double imageableX = pageFormat.getImageableX();
        double imageableY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.black);
        Font origFont = g2.getFont();
        double scaleX = 1.0;
        double scaleY = 1.0;
        double plotWidth = this.getG2dPanel().getWidth();
        double plotHeight = this.getG2dPanel().getHeight();
        if (plotWidth >= pageWidth) {
            scaleX = pageWidth / plotWidth;
        }
        if (plotHeight >= pageHeight) {
            scaleY = pageHeight / plotHeight;
        }
        double plotWidthOnPage = plotWidth * scaleX;
        g2.translate(imageableX, imageableY);
        if (this._useLocalPageFormat && this._printProperties.usePlotFrame()) {
            Color oldColor = g.getColor();
            g.setColor(Color.black);
            g.drawRect(0, 0, (int)pageWidth, (int)pageHeight);
            g.setColor(oldColor);
        }
        String printDateStr = new Date().toString().substring(4);
        int fontHeight = g2.getFontMetrics().getHeight();
        int fontDesent = g2.getFontMetrics().getDescent();
        if (pageIndex == 0) {
            double titleWidthDiff;
            int yTitleLoc;
            int cnt = 0;
            ++cnt;
            String line = title;
            while (true) {
                FontMetrics fm = g2.getFontMetrics();
                int lineWidth = fm.stringWidth(line);
                yTitleLoc = fontHeight * cnt - fontDesent;
                titleWidthDiff = (int)plotWidthOnPage - lineWidth;
                if (!(titleWidthDiff < 0.0)) break;
                Font f = g2.getFont();
                g2.setFont(new Font(f.getName(), f.getStyle(), f.getSize() - 1));
            }
            int xTitleLoc = (int)titleWidthDiff / 2;
            g2.drawString(line, xTitleLoc, yTitleLoc);
        }
        if (this._useLocalPageFormat && this._printProperties.usePageNumber()) {
            String pageStr = "Page: " + (pageIndex + 1);
            int pageStrLen = g.getFontMetrics().stringWidth(pageStr);
            g2.drawString(printDateStr, 2, (int)(pageHeight - (double)fontDesent));
            g2.drawString("Page: " + (pageIndex + 1), (int)(plotWidthOnPage / 2.0 - (double)(pageStrLen / 2)), (int)(pageHeight - (double)fontDesent));
            pageHeight -= (double)(2 * fontHeight);
            if (plotHeight >= pageHeight) {
                scaleY = pageHeight / plotHeight;
            }
        }
        if (pageIndex == 0) {
            g2.translate(0.0, (double)fontHeight);
        }
        g2.scale(scaleX, scaleY);
        this.getG2dPanel().paintGfx(g);
        g2.scale(1.0 / scaleX, 1.0 / scaleY);
        if (pageIndex == 0) {
            g2.translate(0.0, (double)(-fontHeight));
        }
        g2.translate(-imageableX, -imageableY);
        g2.setFont(origFont);
        return 0;
    }

    public PrintProperties getPrintProperties() {
        return this._printProperties;
    }

    public void pageSetupAction(JFrame frame) {
        PageSetupJDialog dlg = new PageSetupJDialog((Frame)frame, true);
        dlg.setPrintProperties(this.getPrintProperties());
        dlg.setVisible(true);
        if (dlg.isCanceled()) {
            return;
        }
        this._printProperties = dlg.getPrintProperties();
        ((FluentLogger.Api)LOGGER.atFine()).log("\nPage Setup Completed.");
    }

    public List<G2dObject> addComparisonData(int panelUnitSystem, List<G2dObject> plotVec, List<G2dLineProperties> colorVec, DataSource dataSource) {
        ArrayList<G2dObject> output = new ArrayList<G2dObject>();
        if (dataSource == null || !(dataSource instanceof ComparisonDataSource)) {
            return output;
        }
        List compList = ((ComparisonDataSource)dataSource).retrieveComparisonList();
        if (compList == null || compList.isEmpty()) {
            return output;
        }
        ArrayList<Color> usedColors = new ArrayList<Color>();
        for (G2dLineProperties properties : colorVec) {
            usedColors.add(properties.getLineColor());
        }
        List<Color> comparisonColorList = this.buildComparisonColors(usedColors);
        int colorIndex = 0;
        for (TimeSeriesContainer tsCont : compList) {
            int unitSystem = ServiceLookup.getUnitsDisplayService().getDisplayUnitsSystem();
            if (!UnitUtil.isValidUnitsSystem((int)unitSystem)) {
                unitSystem = panelUnitSystem;
            }
            boolean bAver = tsCont.type.toUpperCase().startsWith("PER");
            Units.convertUnits((TimeSeriesContainer)tsCont, (int)unitSystem);
            String paramName = tsCont.getParameterName();
            if (Parameter.isNotValid((String)paramName)) {
                String[] params;
                for (String aParam : params = Parameter.getAvailableParameters()) {
                    if (!paramName.toLowerCase().startsWith(aParam.toLowerCase())) continue;
                    paramName = aParam;
                    break;
                }
                tsCont.parameter = paramName;
            }
            TimeSeriesDataSetBase g2dobj = new TimeSeriesDataSetBase(tsCont){

                public String getYAxisName() {
                    String unitString = this.getData().units;
                    if (this.getYParameterId() == -1 && this.getData() != null) {
                        return unitString;
                    }
                    Object parameterdString = Parameter.getParamString((int)this.getYParameterId());
                    try {
                        Parameter param = Parameter.getParameter((int)this.getYParameterId());
                        if (!UnitUtil.canConvertBetweenUnits((String)param.getUnitsString(), (String)unitString)) {
                            return unitString;
                        }
                    }
                    catch (DataSetIllegalArgumentException e) {
                        return unitString;
                    }
                    parameterdString = (String)parameterdString + " (%S) ";
                    return parameterdString;
                }
            };
            ((TimeSeriesDataSetBase)g2dobj).name = tsCont.getShortName();
            if (g2dobj == null) continue;
            plotVec.add((G2dObject)g2dobj);
            if (colorIndex >= comparisonColorList.size()) {
                colorIndex = 0;
            }
            Color compColor = comparisonColorList.get(colorIndex);
            ++colorIndex;
            G2dLineProperties properties = new G2dLineProperties();
            if (bAver) {
                properties.setLineStepStyle(1);
            }
            properties.setLineColor(compColor);
            colorVec.add(properties);
            output.add((G2dObject)g2dobj);
        }
        return output;
    }

    private List<Color> buildComparisonColors(List<Color> colorVec) {
        Vector<Color> comparisonColorList = new Vector<Color>(7);
        comparisonColorList.add(Color.blue);
        comparisonColorList.add(Color.red);
        comparisonColorList.add(Color.green.darker());
        comparisonColorList.add(Color.darkGray);
        comparisonColorList.add(Color.magenta);
        comparisonColorList.add(Color.orange);
        comparisonColorList.add(Color.black);
        comparisonColorList.removeAll(colorVec);
        return comparisonColorList;
    }

    private static class MyG2dPanel
    extends G2dPanel {
        private MyG2dPanel() {
        }

        public boolean ignorePopupPlotEvent() {
            return true;
        }
    }
}

