/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import com.google.common.flogger.FluentLogger;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.dataui.tx.TsContainerDataSourceList;
import hec.dataui.tx.awt.ValidationDecimalField;
import hec.dataui.tx.awt.VerifyDataSubPanel;
import hec.dataui.tx.awt.VerifyTSDataSetBase;
import hec.dataui.tx.awt.VerifyTimeSeriesDataSet;
import hec.gfx2d.G2dObject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.io.BufferedWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.ListSelectionModel;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import rma.swing.RmaInsets;
import rma.swing.RmaJDecimalField;
import rma.swing.RmaJRadioButton;
import rma.swing.RmaJTable;
import rma.swing.RmaJTitledSeparator;
import rma.swing.table.CellLocation;
import rma.swing.table.ColumnGroup;
import rma.swing.table.GroupableTableHeader;
import rma.swing.table.RmaCellEditor;
import rma.swing.table.RmaDateTimeRenderer;
import rma.swing.table.RmaJTableFillDialog;
import rma.swing.table.TimeZoneHeaderRenderer;
import rma.util.RMAConst;
import rma.util.RMAIO;

final class VerifyDataTablePanel
extends VerifyDataSubPanel {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static final String NO_DATA = "No Data";
    private static final String ESTIMATE_CELL_DISABLED = "Estimate cell is disabled";
    private static final String NO_ESTIMATE = "No estimate";
    private static final String NEED_VALID_VALUE = "Need a valid ";
    private static final String[] COLUMN_NAMES = new String[]{"Date/Time\n(%S)", "cfs", "", "cfs", "", "", "cfs", "", "cfs", ""};
    private final RmaJTable _dataTable = new MyRmaJTable((Component)((Object)this), COLUMN_NAMES);
    private ListSelectionModel _lsm = this._dataTable.getSelectionModel();
    private final JScrollPane _scrollPane = new JScrollPane((Component)this._dataTable);
    private final JButton _provideEstBtn = new JButton("Estimate");
    private final JButton _estimateMissBtn = new JButton("Estimate Missing");
    private final JButton _estimateAllBtn = new JButton("Estimate All");
    private final JButton _acceptEstBtn = new JButton("Accept");
    private final JButton _acceptAllBtn = new JButton("Accept All");
    private final JButton _addBtn = new JButton("Add Data");
    private final JButton _deleteBtn = new JButton("Delete Data");
    private final JButton _linearFill = new JButton("Fill - Linear");
    private final JButton _repeatFill = new JButton("Fill - Repeat");
    private final JButton _repeatToEndFill = new JButton("Fill - Repeat to End");
    private final JButton _rawFill = new JButton("Fill - Raw");
    private final JButton _addConstant = new JButton("Add Constant");
    private final RmaJDecimalField _constantField = new RmaJDecimalField();
    private final JButton _multipleFactor = new JButton("Multiple Factor");
    private final RmaJDecimalField _factorField = new RmaJDecimalField();
    private final JButton _clear = new JButton("Clear");
    private final ListSelectionListener _listSelectionListener = this::valueChanged;
    private final PopupMenuListener _popupMenuListener = new MyPopupListener();
    private final Runnable _repaintEvent;
    private final Runnable _dataModifiedEvent;

    VerifyDataTablePanel(int mode, Runnable repaintEvent, Runnable dataModifiedEvent) {
        super(new BorderLayout(), mode);
        this._dataModifiedEvent = dataModifiedEvent;
        this._repaintEvent = repaintEvent;
        this.buildTablePanel();
        this.addListeners();
        this._provideEstBtn.setMnemonic('E');
        this._acceptEstBtn.setMnemonic('A');
        this.disableComponent(this._provideEstBtn, NO_DATA);
        this.disableComponent(this._estimateMissBtn, NO_DATA);
        this.disableComponent(this._estimateAllBtn, NO_DATA);
        this.disableComponent(this._acceptAllBtn, NO_DATA);
    }

    private void addListeners() {
        this._provideEstBtn.addActionListener(e -> this.provideEstimateAction());
        this._estimateMissBtn.addActionListener(e -> this.provideEstimateMissingAction());
        this._estimateAllBtn.addActionListener(e -> this.provideEstimateAllAction());
        this._acceptEstBtn.addActionListener(e -> this.acceptEstimateAction());
        this._acceptAllBtn.addActionListener(e -> this.acceptEstimateAllAction());
        this._deleteBtn.addActionListener(e -> this.deleteSelection());
        this._linearFill.addActionListener(e -> this.linearFillEstimate());
        this._repeatFill.addActionListener(e -> this.repeatFillEstimate());
        this._repeatToEndFill.addActionListener(e -> this.fillToEndEstimate());
        this._rawFill.addActionListener(e -> this.rawFillEstimate());
        this._addConstant.addActionListener(e -> this.addConstantEstimate());
        this._multipleFactor.addActionListener(e -> this.multipleFactorEstimate());
        this._clear.addActionListener(e -> this.clearEstimate());
        this._constantField.addKeyListener((KeyListener)new MyKeyListener(this._addConstant, "Constant"));
        this._factorField.addKeyListener((KeyListener)new MyKeyListener(this._multipleFactor, "Factor"));
    }

    private void buildTablePanel() {
        this.add(this._scrollPane, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout(5, 5));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add(buttonPanel, "East");
        JPanel tableBtnPanel = new JPanel();
        tableBtnPanel.setLayout(new BoxLayout(tableBtnPanel, 3));
        buttonPanel.add((Component)tableBtnPanel, "North");
        JPanel estimatePanel = new JPanel(new GridLayout(0, 1, 5, 5));
        tableBtnPanel.add(estimatePanel);
        estimatePanel.add(this._provideEstBtn);
        if (this.getMode() == 0) {
            estimatePanel.add(this._estimateMissBtn);
        }
        estimatePanel.add(this._estimateAllBtn);
        tableBtnPanel.add(Box.createVerticalStrut(5));
        tableBtnPanel.add(new JSeparator());
        tableBtnPanel.add(Box.createVerticalStrut(4));
        JPanel acceptPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        tableBtnPanel.add(acceptPanel);
        acceptPanel.add(this._acceptEstBtn);
        acceptPanel.add(this._acceptAllBtn);
        tableBtnPanel.add(Box.createVerticalStrut(5));
        tableBtnPanel.add(new JSeparator());
        tableBtnPanel.add(Box.createVerticalStrut(4));
        JPanel rowPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        rowPanel.add(this._addBtn);
        rowPanel.add(this._deleteBtn);
        tableBtnPanel.add(rowPanel);
        tableBtnPanel.add(Box.createVerticalStrut(5));
        tableBtnPanel.add(new JSeparator());
        tableBtnPanel.add(Box.createVerticalStrut(4));
        JPanel fillOptions = new JPanel(new GridLayout(0, 1, 5, 5));
        fillOptions.add(this._linearFill);
        fillOptions.add(this._repeatFill);
        if (this.getMode() == 1) {
            fillOptions.add(this._rawFill);
        }
        JPanel customUis = new JPanel(new BorderLayout(5, 5));
        JPanel customButtons = new JPanel(new GridLayout(0, 1, 5, 5));
        JPanel customDecimals = new JPanel(new GridLayout(0, 1, 5, 5));
        customUis.add((Component)customButtons, "Center");
        customUis.add((Component)customDecimals, "East");
        customButtons.add(this._addConstant);
        customButtons.add(this._multipleFactor);
        this._addConstant.setEnabled(false);
        this._multipleFactor.setEnabled(false);
        customDecimals.add((Component)this._constantField);
        customDecimals.add((Component)this._factorField);
        this._constantField.setColumns(5);
        this._factorField.setColumns(5);
        tableBtnPanel.add(fillOptions);
        tableBtnPanel.add(Box.createVerticalStrut(4));
        tableBtnPanel.add(customUis);
        JPanel lastPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        lastPanel.add(this._repeatToEndFill);
        lastPanel.add(this._clear);
        tableBtnPanel.add(Box.createVerticalStrut(4));
        tableBtnPanel.add(lastPanel);
    }

    RmaJTable getDataTable() {
        return this._dataTable;
    }

    JScrollPane getScrollPane() {
        return this._scrollPane;
    }

    JButton getAddBtn() {
        return this._addBtn;
    }

    JButton getDeleteBtn() {
        return this._deleteBtn;
    }

    ListSelectionModel getLsm() {
        return this._lsm;
    }

    void updateLsm() {
        this._lsm = this._dataTable.getSelectionModel();
        this._lsm.removeListSelectionListener(this._listSelectionListener);
        this._lsm.addListSelectionListener(this._listSelectionListener);
    }

    void setEstimateButtonsEnabledForTsEditing(boolean enabled) {
        if (enabled) {
            this.enableComponent(this._provideEstBtn);
            this.enableComponent(this._estimateMissBtn);
            this.enableComponent(this._estimateAllBtn);
        } else {
            this.disableComponent(this._provideEstBtn, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._estimateMissBtn, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._estimateAllBtn, ESTIMATE_CELL_DISABLED);
        }
    }

    void setAcceptButtonsEnabledForTsEditing(boolean enabled) {
        if (enabled) {
            this.enableComponent(this._acceptEstBtn);
            this.enableComponent(this._acceptAllBtn);
        } else {
            this.disableComponent(this._acceptEstBtn, NO_ESTIMATE);
            this.disableComponent(this._acceptAllBtn, NO_ESTIMATE);
        }
    }

    void setEstimateButtonsEnabledForDataValidation(boolean enabled) {
        if (enabled) {
            this.enableComponent(this._provideEstBtn);
            this.enableComponent(this._estimateMissBtn);
            this.enableComponent(this._estimateAllBtn);
            this.enableComponent(this._acceptAllBtn);
        } else {
            this.disableComponent(this._provideEstBtn, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._estimateMissBtn, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._estimateAllBtn, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._acceptAllBtn, ESTIMATE_CELL_DISABLED);
        }
    }

    void setAcceptButtonsEnabledForDataValidation(boolean enabled) {
        if (enabled) {
            this.enableComponent(this._acceptEstBtn);
        } else {
            this.disableComponent(this._acceptEstBtn, NO_ESTIMATE);
        }
    }

    void enableAcceptButtons(boolean enabled) {
        if (enabled) {
            this.enableComponent(this._acceptEstBtn);
            this.enableComponent(this._acceptAllBtn);
        } else {
            this.disableComponent(this._acceptEstBtn, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._acceptAllBtn, ESTIMATE_CELL_DISABLED);
        }
    }

    void initializeButtons() {
        this.enableComponent(this._provideEstBtn);
        this.enableComponent(this._estimateMissBtn);
        this.enableComponent(this._estimateAllBtn);
        this.disableComponent(this._acceptEstBtn, NO_ESTIMATE);
        this.enableComponent(this._acceptAllBtn);
    }

    void provideEstimateAction() {
        int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        if (tableModel.provideEstimate(selection, false)) {
            this.enableComponent(this._acceptEstBtn);
            this.enableComponent(this._acceptAllBtn);
        }
        this._repaintEvent.run();
    }

    int[] getSelectedIndices(ListSelectionModel lsm, int start, int stop) {
        if (start == -1 || stop == -1) {
            return new int[0];
        }
        int[] guesses = new int[stop - start + 1];
        int index = 0;
        for (int i = start; i <= stop; ++i) {
            if (!lsm.isSelectedIndex(i)) continue;
            guesses[index++] = i;
        }
        int[] realthing = new int[index];
        System.arraycopy(guesses, 0, realthing, 0, index);
        return realthing;
    }

    void provideEstimateMissingAction() {
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        int rows = this._dataTable.getNumRows();
        int[] selection = new int[rows];
        for (int i = 0; i < rows; ++i) {
            selection[i] = i;
        }
        if (tableModel.provideEstimate(selection, true)) {
            this.enableComponent(this._acceptEstBtn);
            this.enableComponent(this._acceptAllBtn);
        }
        this._repaintEvent.run();
    }

    void provideEstimateAllAction() {
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        int rows = this._dataTable.getNumRows();
        int[] selection = new int[rows];
        for (int i = 0; i < rows; ++i) {
            selection[i] = i;
        }
        if (tableModel.provideEstimate(selection, false)) {
            this.enableComponent(this._acceptEstBtn);
            this.enableComponent(this._acceptAllBtn);
        }
        this._repaintEvent.run();
    }

    void acceptEstimateAction() {
        int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        this._dataTable.commitEdit(true);
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        ArrayList<Integer> changed = new ArrayList<Integer>();
        for (int j : selection) {
            if (!tableModel.acceptEstimate(j)) continue;
            changed.add(j);
        }
        if (!changed.isEmpty()) {
            Collections.sort(changed);
            Integer firstRow = (Integer)changed.get(0);
            Integer lastRow = (Integer)changed.get(changed.size() - 1);
            tableModel.fireTableRowsUpdated(firstRow, lastRow);
            this._dataModifiedEvent.run();
            this._repaintEvent.run();
        }
    }

    void acceptEstimateAllAction() {
        this._dataTable.commitEdit(true);
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        if (tableModel.acceptAllEstimates() > 0) {
            this._dataModifiedEvent.run();
            this._repaintEvent.run();
        }
    }

    void copyAll() {
        StringWriter sw = new StringWriter();
        BufferedWriter bw = new BufferedWriter(sw);
        this._dataTable.exportData(bw, '\t', true);
        try {
            bw.flush();
        }
        catch (Exception e) {
            return;
        }
        Clipboard cb = this.getToolkit().getSystemClipboard();
        StringBuilder strbuf = new StringBuilder(sw.toString());
        int len = strbuf.length();
        StringBuilder strbufnew = new StringBuilder(strbuf.length());
        for (int i = 0; i < len; ++i) {
            char chr = strbuf.charAt(i);
            if (chr == '\r') continue;
            strbufnew.append(chr);
        }
        StringSelection s = new StringSelection(strbufnew.toString());
        cb.setContents(s, s);
    }

    String copyTableHeader() {
        JTableHeader header = this._dataTable.getTableHeader();
        char delimiterChar = '\t';
        String delimiterStr = Character.valueOf(delimiterChar).toString();
        ArrayList<StringBuilder> headerLines = new ArrayList<StringBuilder>();
        Enumeration<TableColumn> enumeration = header.getColumnModel().getColumns();
        StringBuilder lastLine = new StringBuilder();
        while (enumeration.hasMoreElements()) {
            TableColumn aColumn = enumeration.nextElement();
            lastLine.append(aColumn.getHeaderValue().toString().replace('\n', ' '));
            if (!enumeration.hasMoreElements()) continue;
            lastLine.append(delimiterStr);
        }
        StringBuilder line = new StringBuilder();
        if (header instanceof GroupableTableHeader) {
            HashMap<ColumnGroup, ColumnGroup> displayedHeaders = new HashMap<ColumnGroup, ColumnGroup>();
            enumeration = header.getColumnModel().getColumns();
            headerLines.add(line);
            int cnt = 0;
            while (enumeration.hasMoreElements()) {
                TableColumn aColumn = enumeration.nextElement();
                ++cnt;
                Enumeration cGroups = ((GroupableTableHeader)header).getColumnGroups(aColumn);
                if (cGroups != null) {
                    boolean first = true;
                    int headerLine = 0;
                    while (cGroups.hasMoreElements()) {
                        StringBuilder ptr;
                        ++headerLine;
                        ColumnGroup cGroup = (ColumnGroup)cGroups.nextElement();
                        if (!first && !displayedHeaders.containsKey(cGroup)) {
                            int i;
                            if (headerLines.size() < headerLine) {
                                StringBuilder tmp = new StringBuilder();
                                for (i = 0; i < cnt - 1; ++i) {
                                    tmp.append(delimiterStr);
                                }
                                headerLines.add(tmp);
                                ptr = tmp;
                            } else {
                                int tabs;
                                ptr = (StringBuilder)headerLines.get(headerLine - 1);
                                for (i = tabs = RMAIO.getNumChars((String)ptr.toString(), (char)delimiterChar); i < cnt - 1; ++i) {
                                    ptr.append(delimiterStr);
                                }
                            }
                        } else {
                            ptr = line;
                        }
                        if (displayedHeaders.containsKey(cGroup)) {
                            ptr.append(delimiterStr);
                            first = false;
                            continue;
                        }
                        displayedHeaders.put(cGroup, cGroup);
                        ptr.append(cGroup.getHeaderValue().toString().replace('\n', ' '));
                        ptr.append(delimiterStr);
                        first = false;
                    }
                    continue;
                }
                line.append(delimiterStr);
            }
        }
        return line + "\n" + lastLine;
    }

    boolean setSelectedRow(int selectedRow) {
        int[] selRows = new int[]{selectedRow};
        return this.setSelectedRows(selRows);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setSelectedRows(int[] selectedRows) {
        if (selectedRows == null || selectedRows.length < 1) {
            return false;
        }
        this._lsm.removeListSelectionListener(this._listSelectionListener);
        try {
            this._lsm.setValueIsAdjusting(true);
            this._lsm.clearSelection();
            for (int row : selectedRows) {
                this._lsm.addSelectionInterval(row, row);
            }
            JScrollBar sb = this.getScrollPane().getVerticalScrollBar();
            int sbval = sb.getValue();
            int sbext = sb.getVisibleAmount();
            int selectedRow = selectedRows[0];
            int rowheight = this._dataTable.getRowHeight();
            int selectY = selectedRow * rowheight;
            if (selectY < sbval + 1 || selectY > sbval + sbext - 1) {
                int setY = selectY - sbext / 2;
                if (setY < 0) {
                    setY = 0;
                }
                sb.setValue(setY);
            }
            this.valueChanged(null);
        }
        finally {
            this._lsm.setValueIsAdjusting(false);
            this._lsm.addListSelectionListener(this._listSelectionListener);
        }
        return true;
    }

    void setupTSEditorTableColumnHeaders() {
        JTableHeader tableHeader = this._dataTable.getTableHeader();
        TableColumnModel cm = this._dataTable.getColumnModel();
        TableColumn tc1 = cm.getColumn(1);
        TableColumn tc2 = cm.getColumn(2);
        TableColumn tc3 = cm.getColumn(3);
        if (tableHeader instanceof GroupableTableHeader) {
            GroupableTableHeader header = (GroupableTableHeader)tableHeader;
            ColumnGroup cg_Value = header.getColumnGroup(0);
            ColumnGroup cg_Estimate = header.getColumnGroup(1);
            ColumnGroup cg_Revised = header.getColumnGroup(2);
            cg_Value.clear();
            cg_Estimate.clear();
            cg_Revised.clear();
            cg_Value.add((Object)tc1);
            cg_Estimate.add((Object)tc2);
            cg_Revised.add((Object)tc3);
        } else {
            ColumnGroup cg_Value = new ColumnGroup("Original");
            cg_Value.add((Object)tc1);
            ColumnGroup cg_Estimate = new ColumnGroup("Estimate/Entry");
            cg_Estimate.add((Object)tc2);
            ColumnGroup cg_Revised = new ColumnGroup("Revised");
            cg_Revised.add((Object)tc3);
            GroupableTableHeader header = new GroupableTableHeader(cm);
            header.addColumnGroup(cg_Value);
            header.addColumnGroup(cg_Estimate);
            header.addColumnGroup(cg_Revised);
            this._dataTable.setTableHeader((JTableHeader)header);
        }
    }

    void valueChanged(ListSelectionEvent e) {
        if (e != null && e.getValueIsAdjusting()) {
            return;
        }
        boolean editable = this.checkIfEstimateEnabled();
        this.updateFillButtonEnabledState(editable);
        this.updateEnabledStateForMathButton(this._constantField, this._addConstant, "Constant", editable);
        this.updateEnabledStateForMathButton(this._factorField, this._multipleFactor, "Factor", editable);
    }

    private void updateFillButtonEnabledState(boolean editable) {
        if (editable) {
            this.enableComponent(this._rawFill);
            this.enableComponent(this._linearFill);
            this.enableComponent(this._repeatFill);
            this.enableComponent(this._repeatToEndFill);
            this.enableComponent(this._clear);
        } else {
            this.disableComponent(this._rawFill, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._linearFill, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._repeatFill, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._repeatToEndFill, ESTIMATE_CELL_DISABLED);
            this.disableComponent(this._clear, ESTIMATE_CELL_DISABLED);
        }
    }

    boolean checkIfEstimateEnabled() {
        if (this.getMode() == 1) {
            int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
            if (selection.length < 1) {
                return false;
            }
            VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
            int estimateDataCol = tableModel.getEstimateDataColumnIndex();
            boolean ifound = false;
            boolean enableEstimate = false;
            for (int j : selection) {
                ParamDouble pd;
                if (!tableModel.isCellEditable(j, estimateDataCol)) continue;
                enableEstimate = true;
                if (j >= this._dataTable.getNumRows()) continue;
                Object obj = this._dataTable.getValueAt(j, estimateDataCol);
                if (obj instanceof ParamDouble && RMAConst.isValidValue((double)(pd = (ParamDouble)obj).getValue())) {
                    ifound = true;
                }
                if (ifound) break;
            }
            this.setAcceptButtonsEnabledForDataValidation(ifound);
            this.setEstimateButtonsEnabledForDataValidation(enableEstimate);
            return enableEstimate;
        }
        if (this.getMode() == 0) {
            double[] estData;
            int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
            if (selection.length < 1) {
                return false;
            }
            VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
            int estimateDataCol = tableModel.getEstimateDataColumnIndex();
            boolean enableEstimate = false;
            for (int j : selection) {
                if (!tableModel.isCellEditable(j, estimateDataCol)) continue;
                enableEstimate = true;
                break;
            }
            boolean ifound = false;
            for (double estDatum : estData = tableModel.getEstimateData()) {
                if (!RMAConst.isValidValue((double)estDatum)) continue;
                ifound = true;
                break;
            }
            this.setEstimateButtonsEnabledForTsEditing(enableEstimate);
            this.setAcceptButtonsEnabledForTsEditing(ifound);
            return enableEstimate;
        }
        return false;
    }

    void setupTSEditorTable(List<G2dObject> _dataSourceList, int _unitSystem) {
        this._dataTable.setDoubleCellEditor(1, true);
        this._dataTable.setDoubleCellEditor(3, true);
        this._dataTable.setDoubleCellEditor(2, true);
        TableColumn tc = this._dataTable.getColumnModel().getColumn(2);
        if (tc == null) {
            this._dataTable.setDoubleCellEditor(2, true);
        } else {
            ValidationDecimalField df = new ValidationDecimalField(0, 5);
            df.setHorizontalAlignment(4);
            df.addMouseListener((MouseListener)this._dataTable);
            RmaCellEditor dcf = new RmaCellEditor((RmaJDecimalField)df);
            tc.setCellEditor((TableCellEditor)dcf);
        }
        int[] colwidths = new int[]{150, 80, 80, 80};
        this._dataTable.setColumnWidths(colwidths);
        this._dataTable.setSelectionMode(2);
        this._dataTable.setCellSelectionEnabled(false);
        this._dataTable.setColumnSelectionAllowed(false);
        this._dataTable.setRowSelectionAllowed(true);
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        int precis = tableModel.getPrecision();
        this._dataTable.setPrecision(precis);
        this._dataTable.setUnitsHeaderRenderer();
        this._dataTable.setDisplayUnitsSystem(_unitSystem);
        tc = this._dataTable.getColumnModel().getColumn(0);
        RmaDateTimeRenderer rend = new RmaDateTimeRenderer(2);
        TableModel model = this._dataTable.getModel();
        if (model instanceof VerifyTSDataSetBase) {
            VerifyTSDataSetBase verifyTSDataSetBase = (VerifyTSDataSetBase)((Object)model);
            TimeZone dataTimeZone = verifyTSDataSetBase.getTimeZone();
            rend.setIgnoreTimeZoneAdjustments(dataTimeZone == null);
        }
        if (_dataSourceList instanceof TsContainerDataSourceList) {
            rend.setUseDataDefinedViewTimeZone(true);
        }
        tc.setCellRenderer((TableCellRenderer)rend);
        tc.setHeaderRenderer((TableCellRenderer)new TimeZoneHeaderRenderer());
    }

    void updateEstimateColumns(int dialogUnitSystem, int startRow, int stopRow) {
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        int estimateDataCol = tableModel.getEstimateDataColumnIndex();
        String cellstr = "";
        boolean state = false;
        for (int irow = startRow; irow <= stopRow; ++irow) {
            ParamDouble pd;
            Object obj = this._dataTable.getValueAt(irow, estimateDataCol);
            boolean isaNumber = false;
            if (obj instanceof ParamDouble) {
                pd = (ParamDouble)obj;
                if (RMAConst.isValidValue((double)pd.getValue())) {
                    isaNumber = true;
                }
            } else {
                cellstr = (String)obj;
                if (cellstr != null && (cellstr.length() < 1 || cellstr.equals(" ") || cellstr.indexOf("--") > -1)) {
                    isaNumber = false;
                } else {
                    int dataunitssystem = tableModel.getUnitSystem();
                    int paramid = tableModel.getYParameterId();
                    double val = RMAIO.parseDouble((String)cellstr);
                    pd = new ParamDouble(val, paramid, dialogUnitSystem, 7);
                    if (dialogUnitSystem != 0 && dialogUnitSystem != dataunitssystem && paramid != -1) {
                        try {
                            try {
                                String beforeUnitSystem = Parameter.getUnitsStringForSystem((int)paramid, (int)dialogUnitSystem);
                                String afterUnitSystem = Parameter.getUnitsStringForSystem((int)paramid, (int)dataunitssystem);
                                pd = Units.convertUnits((ParamDouble)pd, (String)beforeUnitSystem, (String)afterUnitSystem);
                            }
                            catch (Exception e) {
                                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error rendering ParamDouble  " + pd);
                            }
                        }
                        catch (Exception e) {
                            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("ERROR <VerifyDataDlg.updateEstimateColumns()> : A DataSet Exception occurred when converting data. Data is now in wrong Unit System");
                        }
                    }
                    this._dataTable.setValueAt((Object)pd, irow, estimateDataCol);
                    isaNumber = true;
                }
            }
            if (!isaNumber) {
                this._dataTable.setValueAt((Object)"--", irow, estimateDataCol);
                tableModel.setEstimateFlag(irow, " ");
                continue;
            }
            if (cellstr == null || cellstr.contains("--")) continue;
            tableModel.getEstimateFlag(irow);
            String qualstr = tableModel.getEstimateFlag(irow);
            if (Objects.equals(qualstr, "K")) continue;
            tableModel.setEstimateFlag(irow, "K");
            state = tableModel.isCellEditable(irow, estimateDataCol);
        }
        if (this.getMode() == 1 || this.getMode() == 0 && state && !this._acceptEstBtn.isEnabled()) {
            this.enableAcceptButtons(state);
        }
    }

    void setSelectedFlags(String flag) {
        if (this.getMode() != 1) {
            return;
        }
        boolean showWarning = false;
        int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
        if (selection.length > 0) {
            VerifyTimeSeriesDataSet tableModel = (VerifyTimeSeriesDataSet)((Object)this._dataTable.getModel());
            int revisedQualCol = tableModel.getRevisedQualityColumnIndex();
            int estimateDataCol = tableModel.getEstimateDataColumnIndex();
            int estimateQualCol = tableModel.getEstimateQualityColumnIndex();
            for (int j : selection) {
                String qstr;
                if (!tableModel.isCellEditable(j, estimateDataCol) || (qstr = (String)tableModel.getValueAt(j, revisedQualCol)) == null || qstr.length() < 2) continue;
                String newStr = qstr.charAt(0) + flag;
                tableModel.setValueAt(newStr, j, estimateQualCol);
                tableModel.setValueAt(newStr, j, revisedQualCol);
                this._dataModifiedEvent.run();
            }
        }
    }

    void setSelectedProtected(boolean tf) {
        int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
        if (selection.length > 0) {
            VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
            int n = selection.length;
            for (int j : selection) {
                boolean isProt;
                int valIdx = tableModel.getValueIndex(j);
                if (valIdx == -1 || (isProt = tableModel.isRevisedProtected(j)) == tf) continue;
                tableModel.setRevisedProtected(j, tf);
                if (!tf) {
                    tableModel.setEstimateProtected(j, tf);
                }
                this._dataModifiedEvent.run();
            }
        }
    }

    void deleteSelection() {
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        int[] selection = this.getSelectedIndices(this._lsm, this._lsm.getMinSelectionIndex(), this._lsm.getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        if (tableModel.isRegularIntervalData()) {
            tableModel.clearEstimate(selection);
        } else {
            tableModel.deleteRows(selection);
        }
        this._dataModifiedEvent.run();
    }

    void buildPopup() {
        JPopupMenu popupMenu = new JPopupMenu();
        if (this.getMode() == 1) {
            String qualityTitle = "Set Quality Flag";
            RmaJTitledSeparator tsep = new RmaJTitledSeparator(qualityTitle);
            popupMenu.add((Component)tsep);
            JCheckBoxMenuItem jm = new JCheckBoxMenuItem("Rejected", false);
            jm.addActionListener(e -> this.setSelectedFlags("R"));
            popupMenu.add(jm);
            jm = new JCheckBoxMenuItem("Questionable", false);
            jm.addActionListener(e -> this.setSelectedFlags("Q"));
            popupMenu.add(jm);
            jm = new JCheckBoxMenuItem("Missing", false);
            jm.addActionListener(e -> this.setSelectedFlags("M"));
            popupMenu.add(jm);
            jm = new JCheckBoxMenuItem("Acceptable", false);
            jm.setState(true);
            jm.addActionListener(e -> this.setSelectedFlags("A"));
            popupMenu.add(jm);
            popupMenu.addSeparator();
            jm = new JCheckBoxMenuItem("Unprotected", false);
            jm.addActionListener(e -> this.setSelectedProtected(true));
            popupMenu.add(jm);
            jm = new JCheckBoxMenuItem("Protected", false);
            jm.addActionListener(e -> this.setSelectedProtected(false));
            popupMenu.add(jm);
        }
        RmaJTitledSeparator tsep = new RmaJTitledSeparator("Table Fill");
        popupMenu.add((Component)tsep);
        JMenuItem mi = new JMenuItem("Fill ...");
        mi.addActionListener(e -> this._dataTable.fill());
        popupMenu.add(mi);
        mi = new JMenuItem("Clear");
        mi.addActionListener(e -> this.clearEstimate());
        popupMenu.add(mi);
        this._dataTable.setPopupMenu(popupMenu);
        popupMenu.addPopupMenuListener(this._popupMenuListener);
    }

    void linearFillEstimate() {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        tableModel.linearFillForEstimate(selection);
        this.checkIfEstimateEnabled();
        this._repaintEvent.run();
    }

    void repeatFillEstimate() {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        tableModel.repeatFillForEstimate(selection);
        this.checkIfEstimateEnabled();
        this._repaintEvent.run();
    }

    private void fillToEndEstimate() {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        tableModel.repeatFillToEndForEstimate(selection[0]);
        this.checkIfEstimateEnabled();
        this._repaintEvent.run();
    }

    void clearEstimate() {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        tableModel.clearEstimate(selection);
        this._dataModifiedEvent.run();
        this.checkIfEstimateEnabled();
        this._repaintEvent.run();
    }

    void rawFillEstimate() {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTimeSeriesDataSet tableModel = (VerifyTimeSeriesDataSet)((Object)this._dataTable.getModel());
        tableModel.rawFillForEstimate(selection);
        this.checkIfEstimateEnabled();
        this._repaintEvent.run();
    }

    private void addConstantEstimate() {
        double value = this._constantField.getValue();
        if (NumericalConstants.isValidValue((double)value)) {
            this.addConstantEstimate(value);
        }
    }

    private void addConstantEstimate(double constant) {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        if (tableModel.addConstantEstimate(selection, constant)) {
            this._repaintEvent.run();
        }
    }

    private void multipleFactorEstimate() {
        double value = this._factorField.getValue();
        if (NumericalConstants.isValidValue((double)value)) {
            this.multipleFactorEstimate(value);
        }
    }

    private void multipleFactorEstimate(double factor) {
        this._dataTable.commitEdit(true);
        int[] selection = this.getSelectedIndices(this.getLsm(), this.getLsm().getMinSelectionIndex(), this.getLsm().getMaxSelectionIndex());
        if (selection.length < 1) {
            return;
        }
        VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)this._dataTable.getModel());
        if (tableModel.multiplyByFactor(selection, factor)) {
            this._repaintEvent.run();
        }
    }

    private void updateEnabledStateForMathButton(RmaJDecimalField source, JButton button, String name, boolean estimateEnabled) {
        boolean valid = NumericalConstants.isValidValue((double)source.getValueUndefined());
        if (valid && estimateEnabled) {
            this.enableComponent(button);
        } else {
            Object disabledMessage = ESTIMATE_CELL_DISABLED;
            if (!valid && estimateEnabled) {
                disabledMessage = NEED_VALID_VALUE + name;
            }
            this.disableComponent(button, (String)disabledMessage);
        }
    }

    private class MyRmaJTable
    extends RmaJTable {
        public MyRmaJTable(Component parent, Object[] columnNames) {
            super(parent, columnNames);
        }

        protected RmaJTableFillDialog getFillDialog(RmaJTable table) {
            Window w = SwingUtilities.windowForComponent((Component)table);
            MyFillDialog dialog = w instanceof Dialog ? new MyFillDialog((Dialog)w, table) : new MyFillDialog((Frame)w, table);
            return dialog;
        }

        public void linearFill(CellLocation firstCell, CellLocation lastCell) {
            VerifyDataTablePanel.this.linearFillEstimate();
        }

        protected void repeatFill(Vector<Vector<CellLocation>> cellTable, CellLocation firstCell, CellLocation lastCell) {
            VerifyDataTablePanel.this.repeatFillEstimate();
        }

        public void fillToEnd() {
            VerifyDataTablePanel.this.fillToEndEstimate();
        }

        public void constantFill(double constantValue) {
            VerifyDataTablePanel.this.addConstantEstimate(constantValue);
        }

        public void factorFill(double factorValue) {
            VerifyDataTablePanel.this.multipleFactorEstimate(factorValue);
        }
    }

    private class MyPopupListener
    implements PopupMenuListener {
        private MyPopupListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            MenuElement[] melem;
            int[] selection = VerifyDataTablePanel.this.getSelectedIndices(VerifyDataTablePanel.this.getLsm(), VerifyDataTablePanel.this.getLsm().getMinSelectionIndex(), VerifyDataTablePanel.this.getLsm().getMaxSelectionIndex());
            JPopupMenu popup = (JPopupMenu)e.getSource();
            VerifyTSDataSetBase tableModel = (VerifyTSDataSetBase)((Object)VerifyDataTablePanel.this._dataTable.getModel());
            boolean isEditable = VerifyDataTablePanel.this.checkIfEstimateEnabled();
            int[] revQual = tableModel.getRevisedQuality();
            int numRejVal = 0;
            int numQueVal = 0;
            int numMisVal = 0;
            int numAccVal = 0;
            int numProVal = 0;
            int numUnproVal = 0;
            for (int irow : selection) {
                int valIdx = tableModel.getValueIndex(irow);
                if (valIdx == -1) continue;
                if (VerifyDataTablePanel.this.getMode() == 1) {
                    byte[] bytes;
                    int qual = 0;
                    if (revQual != null) {
                        qual = revQual[valIdx];
                    }
                    boolean aFlag = Quality.isAccepted((byte[])(bytes = Quality.getBytes((int)qual))) || Quality.isRevisedAutomaticallyCheckAllBits((byte[])bytes) || Quality.isRevisedInteractivelyCheckAllBits((byte[])bytes) || Quality.isRevisedManuallyCheckAllBits((byte[])bytes);
                    boolean qFlag = Quality.isQuestion((byte[])bytes);
                    boolean rFlag = Quality.isReject((byte[])bytes);
                    boolean mFlag = Quality.isMissing((byte[])bytes);
                    boolean pFlag = Quality.isProtected((byte[])bytes);
                    if (aFlag) {
                        ++numAccVal;
                    } else if (qFlag) {
                        ++numQueVal;
                    } else if (rFlag) {
                        ++numRejVal;
                    } else if (mFlag) {
                        ++numMisVal;
                    }
                    if (pFlag) {
                        ++numProVal;
                        continue;
                    }
                    ++numUnproVal;
                    continue;
                }
                if (VerifyDataTablePanel.this.getMode() != 0) continue;
                boolean prot = tableModel.isRevisedProtected(irow);
                if (prot) {
                    ++numProVal;
                    continue;
                }
                ++numUnproVal;
            }
            for (MenuElement menuElement : melem = popup.getSubElements()) {
                if (menuElement instanceof JMenuItem) {
                    ((JMenuItem)menuElement).setEnabled(isEditable);
                }
                if (!(menuElement instanceof JCheckBoxMenuItem)) continue;
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)menuElement;
                menuItem.setState(false);
                if (menuItem.getText().equals("Rejected") && numRejVal > 0) {
                    menuItem.setState(true);
                } else if (menuItem.getText().equals("Questionable") && numQueVal > 0) {
                    menuItem.setState(true);
                } else if (menuItem.getText().equals("Missing") && numMisVal > 0) {
                    menuItem.setState(true);
                } else if (menuItem.getText().equals("Acceptable") && numAccVal > 0) {
                    menuItem.setState(true);
                } else if (menuItem.getText().equals("Unprotected")) {
                    if (numUnproVal > 0) {
                        menuItem.setState(true);
                    }
                    menuItem.setEnabled(true);
                } else if (menuItem.getText().equals("Protected") && numProVal > 0) {
                    menuItem.setState(true);
                }
                if (VerifyDataTablePanel.this.getMode() != 0 || !menuItem.getText().equals("Unprotected") && !menuItem.getText().equals("Protected")) continue;
                menuItem.setEnabled(true);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    private class MyKeyListener
    implements KeyListener {
        private final JButton _button;
        private final String _name;

        public MyKeyListener(JButton button, String name) {
            this._button = button;
            this._name = name;
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getSource() instanceof RmaJDecimalField) {
                RmaJDecimalField source = (RmaJDecimalField)e.getSource();
                boolean estimateEnabled = VerifyDataTablePanel.this.checkIfEstimateEnabled();
                VerifyDataTablePanel.this.updateEnabledStateForMathButton(source, this._button, this._name, estimateEnabled);
            }
        }
    }

    private class MyFillDialog
    extends RmaJTableFillDialog {
        private RmaJRadioButton _fillRaw;

        public MyFillDialog(Dialog w, RmaJTable table) {
            super(w, table);
        }

        public MyFillDialog(Frame w, RmaJTable table) {
            super(w, table);
        }

        protected JPanel buildControls() {
            JPanel output = super.buildControls();
            if (VerifyDataTablePanel.this.getMode() == 1) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = -1;
                gbc.gridwidth = 1;
                gbc.anchor = 18;
                gbc.fill = 2;
                gbc.insets = RmaInsets.insets((int)5, (int)5, (int)0, (int)5);
                this._fillRaw = new RmaJRadioButton("Raw Fill");
                this.getButtonGroup().add((AbstractButton)this._fillRaw);
                output.add((Component)this._fillRaw, gbc);
            }
            return output;
        }

        protected boolean fillTable() {
            boolean output;
            if (this._fillRaw.isSelected()) {
                VerifyDataTablePanel.this.rawFillEstimate();
                output = true;
            } else {
                output = super.fillTable();
            }
            return output;
        }
    }
}

