/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.data.DataSetIllegalArgumentException;
import hec.data.Interval;
import hec.data.ParamDouble;
import hec.data.TimeWindowMap;
import hec.dataui.tx.awt.InputDateDialog;
import hec.geometry.WorldRect;
import hec.gfx2d.G2dObject;
import hec.heclib.util.HecTime;
import hec.heclib.util.HecTimeArray;
import hec.lang.Const;
import hec.model.Interpolate;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.IntSummaryStatistics;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.stream.IntStream;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.QualityStringRenderer;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import rma.lang.RmaMath;
import rma.swing.RmaJFrame;
import rma.swing.table.AbstractRmaTableModel;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.lookup.Lookup;
import rma.util.lookup.Lookups;

public abstract class VerifyTSDataSetBase
extends AbstractRmaTableModel
implements G2dObject {
    public static final String REVISED = "Revised";
    public static final String ESTIMATE_ENTRY = "Estimate/Entry";
    public static final String ORIGINAL = "Original";
    public static final String RAW = "Raw";
    public static final int DATA_UNDEFINED = 0;
    public static final int DATA_TX = 1;
    public static final int TIME_SERIES_CONTAINER = 2;
    protected WorldRect bounds = null;
    protected boolean editableData = true;
    protected boolean overrideProtection = false;
    protected boolean _scaleToRawData = true;
    protected int _precision = 2;
    protected String _rawName = null;
    protected boolean _editableQuality = false;
    Lookup m_lookup = Lookups.fixed((Object[])new Object[]{""});
    private double _defaultMaxYValue = Double.NEGATIVE_INFINITY;
    private double _defaultMinYValue = Double.NEGATIVE_INFINITY;
    private boolean _directEdit = false;
    private String name = "";
    private String yunits;
    private int _unitSystem = 0;
    private int _xParamId = -1;
    private int _yParamId = -1;
    private TimeZone _timeZone = null;
    private int _retrStartTime;
    private int _retrEndTime;
    private int[] times = null;
    private int[] valueIndexes = null;
    private int[] valueTimes = null;
    private double[] valueData = null;
    private int[] valueQuality = null;
    private double[] estimateData = null;
    private int[] estimateQuality = null;
    private double[] revisedData = null;
    private int[] revisedQuality = null;
    private int[] rawIndexes = null;
    private int[] rawTimes = null;
    private double[] rawData = null;
    private int[] rawQuality = null;
    private boolean _isRegularIntervalData = false;
    private boolean _isInstantaneous = true;
    private int[] _originalTimes;

    public VerifyTSDataSetBase(String name, int retrStartTime, int retrEndTime) {
        this.name = name;
        this._retrStartTime = retrStartTime;
        this._retrEndTime = retrEndTime;
    }

    public void setColumnNames(String[] colNames) {
        this.m_columnNames = colNames;
    }

    protected SimpleDateFormat simpleDateFormat() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(" ddMMMyyyy HHmm");
        return simpleDateFormat;
    }

    public Lookup getLookup() {
        return this.m_lookup;
    }

    public boolean isDirectEdit() {
        return this._directEdit;
    }

    public void setDirectEdit(boolean b) {
        this._directEdit = b;
    }

    protected void setRawData(int[] rawTimes, double[] rawY, int[] rawQual) {
        this.rawTimes = rawTimes;
        this.rawData = rawY;
        this.rawQuality = rawQual;
    }

    public int[] getValueIndexes() {
        if (this.valueIndexes == null) {
            this.initTimes();
        }
        return this.valueIndexes;
    }

    public int getValueIndex(int row) {
        if (this.valueIndexes == null) {
            this.initTimes();
        }
        if (this.valueIndexes == null) {
            return row;
        }
        if (row < 0 || row >= this.valueIndexes.length) {
            return -1;
        }
        return this.valueIndexes[row];
    }

    public int[] getRawIndexes() {
        if (this.rawIndexes == null) {
            this.initTimes();
        }
        return this.rawIndexes;
    }

    public int getRawIndex(int row) {
        if (this.rawIndexes == null) {
            this.initTimes();
        }
        if (this.rawIndexes == null) {
            return row;
        }
        if (row < 0 || row >= this.rawIndexes.length) {
            return -1;
        }
        return this.rawIndexes[row];
    }

    public int[] getValueTimes() {
        return this.valueTimes;
    }

    protected void setValueTimes(int[] valTimes) {
        this.valueTimes = valTimes;
        this._originalTimes = Arrays.copyOf(this.valueTimes, this.valueTimes.length);
    }

    public int[] getTimes() {
        if (this.times == null || this.times.length < 1) {
            this.initTimes();
        }
        return this.times;
    }

    private void initTimes() {
        int ii;
        if (this.rawTimes == null) {
            this.times = this.valueTimes;
            this.valueIndexes = null;
            return;
        }
        int size = this.valueTimes.length;
        this.times = new int[size += this.rawTimes.length];
        this.rawIndexes = new int[size];
        this.valueIndexes = new int[size];
        int rawIdx = 0;
        int valIdx = 0;
        for (ii = 0; ii < size; ++ii) {
            if (this.rawTimes[rawIdx] < this.valueTimes[valIdx]) {
                this.times[ii] = this.rawTimes[rawIdx];
                this.rawIndexes[ii] = rawIdx++;
                this.valueIndexes[ii] = -1;
                continue;
            }
            if (this.rawTimes[rawIdx] == this.valueTimes[valIdx]) {
                this.times[ii] = this.valueTimes[valIdx];
                this.rawIndexes[ii] = rawIdx++;
                this.valueIndexes[ii] = valIdx++;
                continue;
            }
            if (this.valueTimes[valIdx] >= this.rawTimes[rawIdx]) continue;
            this.times[ii] = this.valueTimes[valIdx];
            this.rawIndexes[ii] = -1;
            this.valueIndexes[ii] = valIdx++;
            if (rawIdx < this.rawTimes.length && valIdx < this.valueTimes.length) continue;
        }
        if (rawIdx >= this.rawTimes.length) {
            while (valIdx < this.valueTimes.length) {
                this.times[ii] = this.valueTimes[valIdx];
                this.rawIndexes[ii] = -1;
                this.valueIndexes[ii] = valIdx++;
                ++ii;
            }
        } else if (valIdx >= this.valueTimes.length) {
            while (rawIdx < this.rawTimes.length) {
                this.times[ii] = this.rawTimes[rawIdx];
                this.rawIndexes[ii] = rawIdx++;
                this.valueIndexes[ii] = -1;
                ++ii;
            }
        }
        int[] newtimes = new int[ii];
        System.arraycopy(this.times, 0, newtimes, 0, newtimes.length);
        this.times = newtimes;
        int[] newRawIndexes = new int[ii];
        System.arraycopy(this.rawIndexes, 0, newRawIndexes, 0, newRawIndexes.length);
        this.rawIndexes = newRawIndexes;
        int[] newValueIndexes = new int[ii];
        System.arraycopy(this.valueIndexes, 0, newValueIndexes, 0, newValueIndexes.length);
        this.valueIndexes = newValueIndexes;
    }

    protected void setValueData(double[] valData, int[] valQual) {
        this.valueData = valData;
        this.valueQuality = valQual;
        if (this.estimateData == null || this.estimateData.length != this.valueData.length) {
            this.initEstData();
        }
        if (this.revisedData == null || this.revisedData.length != this.valueData.length) {
            this.initRevData();
        }
    }

    protected void setEstimateData(double[] estData, int[] estQual) {
        this.estimateData = estData;
        if (estQual != null) {
            this.estimateQuality = estQual;
        }
    }

    protected void setRevisedData(double[] revData, int[] revQual) {
        this.revisedData = revData;
        if (revQual != null) {
            this.revisedQuality = revQual;
        }
    }

    protected void initEstData() {
        this.estimateData = new double[this.valueData.length];
        Arrays.fill(this.estimateData, -3.4028234663852886E38);
        if (this.valueQuality != null) {
            this.estimateQuality = new int[this.valueData.length];
        }
    }

    protected void initRevData() {
        this.revisedData = new double[this.valueData.length];
        if (this.valueQuality != null) {
            this.revisedQuality = new int[this.valueData.length];
        }
        for (int i = 0; i < this.valueData.length; ++i) {
            this.revisedData[i] = this.valueData[i];
            if (this.valueQuality == null) continue;
            this.revisedQuality[i] = this.valueQuality[i];
        }
    }

    public int getColumnParameter(int col) {
        if (col == 0) {
            return -1;
        }
        return this._yParamId;
    }

    public int getRetrieveStartTime() {
        return this._retrStartTime;
    }

    public int getRetrieveEndTime() {
        return this._retrEndTime;
    }

    public double[] getXValues() {
        return null;
    }

    public double[] getYValues(int curveNum) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String s) {
        this.name = s;
    }

    public int getUnitSystem() {
        return this._unitSystem;
    }

    public void setUnitSystem(int system) {
        this._unitSystem = system;
    }

    public int getXParameterId() {
        return this._xParamId;
    }

    public void setXParameterId(int pId) {
        this._xParamId = pId;
    }

    public int getYParameterId() {
        return this._yParamId;
    }

    public void setYParameterId(int pId) {
        this._yParamId = pId;
    }

    public double getDefaultMinYValue() {
        return this._defaultMinYValue;
    }

    public void setDefaultMinYValue(double value) {
        this._defaultMinYValue = value;
    }

    public double getDefaultMaxYValue() {
        return this._defaultMaxYValue;
    }

    public void setDefaultMaxYValue(double value) {
        this._defaultMaxYValue = value;
    }

    public boolean hasDefaultMaxYValue() {
        return RMAConst.isValidValue((double)this._defaultMaxYValue);
    }

    public boolean hasDefaultMinYValue() {
        return RMAConst.isValidValue((double)this._defaultMinYValue);
    }

    public String getLineStyleName() {
        return "";
    }

    public void load() {
    }

    public void unload() {
    }

    public String getXAxisName() {
        return "Minutes";
    }

    public String getYAxisName() {
        return this.yunits;
    }

    public int getXAxisType() {
        return 1;
    }

    public int getYAxisType() {
        return 0;
    }

    public WorldRect getBounds() {
        if (this.bounds == null) {
            int k;
            double t0 = 1.0E30;
            int[] itimes = this.getTimes();
            for (k = 0; k < this.size(); ++k) {
                int valIdx;
                if (!RMAConst.isValidValue((int)itimes[k])) continue;
                if (t0 > (double)itimes[k]) {
                    t0 = itimes[k];
                }
                if ((valIdx = this.getValueIndex(k)) == -1 || !RMAConst.isValidValue((double)this.revisedData[valIdx])) continue;
                this.bounds = new WorldRect(t0, this.revisedData[valIdx], t0, this.revisedData[valIdx]);
                break;
            }
            int numberValid = 0;
            for (int i = k + 1; i < this.size(); ++i) {
                double dx = itimes[i];
                int valIdx = this.getValueIndex(i);
                if (valIdx == -1) continue;
                double dy = this.revisedData[valIdx];
                if (!RMAConst.isValidValue((double)dx)) continue;
                if (this.bounds.w > dx) {
                    this.bounds.w = dx;
                } else if (this.bounds.e < dx) {
                    this.bounds.e = dx;
                }
                if (!RMAConst.isValidValue((double)dy)) continue;
                if (this.bounds.s > dy) {
                    this.bounds.s = dy;
                } else if (this.bounds.n < dy) {
                    this.bounds.n = dy;
                }
                ++numberValid;
            }
            if (numberValid < 1) {
                double tmin = 1.0E30;
                double tmax = -1.0E30;
                numberValid = 0;
                for (k = 0; k < this.size(); ++k) {
                    if (!RMAConst.isValidValue((int)itimes[k])) continue;
                    if (tmin > (double)itimes[k]) {
                        tmin = itimes[k];
                    }
                    if (tmax < (double)itimes[k]) {
                        tmax = itimes[k];
                    }
                    ++numberValid;
                }
                if (numberValid < 1) {
                    tmin = 1440.0;
                    tmax = 2880.0;
                }
                this.bounds = new WorldRect(tmax, 0.0, tmin, 1.0);
            }
            this.bounds.w += -60.0;
            this.bounds.e += 60.0;
            if (this.rawData != null && this._scaleToRawData) {
                for (double dy : this.rawData) {
                    if (!RMAConst.isValidValue((double)dy)) continue;
                    if (this.bounds.s > dy) {
                        this.bounds.s = dy;
                        continue;
                    }
                    if (!(this.bounds.n < dy)) continue;
                    this.bounds.n = dy;
                }
            }
        }
        return this.bounds;
    }

    protected abstract int getDateTimeColumnIndex();

    protected abstract int getRawDataColumnIndex();

    protected abstract int getRawQualityColumnIndex();

    protected abstract int getValueDataColumnIndex();

    protected abstract int getValueQualityColumnIndex();

    public abstract int getValueTestColumnIndex();

    public abstract int getEstimateDataColumnIndex();

    public abstract int getEstimateQualityColumnIndex();

    protected abstract int getRevisedDataColumnIndex();

    public abstract int getRevisedQualityColumnIndex();

    private int setQuality(String qualFlag, int[] qual, int validx, boolean isValueRevised) {
        byte[] bytes = Quality.getBytes((int)qual[validx]);
        bytes = Quality.getQualUsingFlags((byte[])bytes, (String)qualFlag, (boolean)isValueRevised);
        qual[validx] = Quality.getInteger((byte[])bytes);
        return qual[validx];
    }

    private String getQualityFlag(int[] qual, int validx) {
        if (qual == null) {
            return " ";
        }
        StringBuffer flag = new StringBuffer();
        flag.append(QualityStringRenderer.getSymbolicString((int)qual[validx]));
        String tests = QualityStringRenderer.getSymbolicRevisedString((int)qual[validx]);
        if (tests != null && tests.length() > 0) {
            flag.append(" ");
            flag.append(tests);
        }
        return flag.toString();
    }

    private int setProtected(boolean prot, int[] quality, int validx) {
        if (quality == null || quality.length < 1) {
            return 0;
        }
        if (validx < 0 || validx >= quality.length) {
            return 0;
        }
        byte[] bytes = Quality.getBytes((int)quality[validx]);
        if (prot) {
            Quality.setProtected((byte[])bytes);
        } else {
            Quality.clearProtected((byte[])bytes);
        }
        quality[validx] = Quality.getInteger((byte[])bytes);
        return quality[validx];
    }

    private boolean isProtected(int[] quality, int validx) {
        if (quality == null || quality.length < 1) {
            return false;
        }
        if (validx < 0 || validx >= quality.length) {
            return false;
        }
        byte[] bytes = Quality.getBytes((int)quality[validx]);
        try {
            return Quality.isProtected((byte[])bytes);
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isOkay(int[] quality, int validx) {
        if (quality == null || quality.length < 1) {
            return false;
        }
        if (validx < 0 || validx >= quality.length) {
            return false;
        }
        byte[] bytes = Quality.getBytes((int)quality[validx]);
        try {
            return Quality.isOkay((byte[])bytes);
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isOverrideProtection() {
        return this.overrideProtection;
    }

    public boolean isValueProtected(int row) {
        int valIdx = this.getValueIndex(row);
        if (valIdx == -1) {
            return false;
        }
        return this.isProtected(this.valueQuality, valIdx);
    }

    public boolean isRevisedOkay(int row) {
        int valIdx = this.getValueIndex(row);
        if (valIdx == -1) {
            return false;
        }
        return this.isOkay(this.revisedQuality, valIdx);
    }

    public boolean isRevisedProtected(int row) {
        int valIdx = this.getValueIndex(row);
        if (valIdx == -1) {
            return false;
        }
        return this.isProtected(this.revisedQuality, valIdx);
    }

    public void setRevisedProtected(int row, boolean prot) {
        int valIdx = this.getValueIndex(row);
        if (valIdx == -1) {
            return;
        }
        boolean oldProt = this.isProtected(this.revisedQuality, valIdx);
        this.setProtected(prot, this.revisedQuality, valIdx);
        boolean newProt = this.isProtected(this.revisedQuality, valIdx);
        if (oldProt && !newProt) {
            this.overrideProtection = true;
        }
        this.fireTableRowsUpdated(row, row);
    }

    public boolean isEstimateProtected(int row) {
        int valIdx = this.getValueIndex(row);
        if (valIdx == -1) {
            return false;
        }
        return this.isProtected(this.estimateQuality, valIdx);
    }

    public void setEstimateProtected(int row, boolean prot) {
        int valIdx = this.getValueIndex(row);
        if (valIdx == -1) {
            return;
        }
        this.setProtected(prot, this.estimateQuality, valIdx);
        this.fireTableRowsUpdated(row, row);
    }

    public int getNextFlaggedValue(int currentRow, boolean searchDown) {
        int[] itimes = this.getTimes();
        int nrows = itimes.length;
        if (searchDown) {
            for (int i = currentRow + 1; i < nrows; ++i) {
                int valIdx = this.getValueIndex(i);
                if (valIdx <= -1 || !Const.isUndefined((double)this.revisedData[valIdx])) continue;
                return i;
            }
        } else {
            for (int i = currentRow - 1; i >= 0; --i) {
                int valIdx = this.getValueIndex(i);
                if (valIdx <= -1 || !Const.isUndefined((double)this.revisedData[valIdx])) continue;
                return i;
            }
        }
        return -1;
    }

    public String getRawFlag(int irow) {
        int rawIdx = this.getRawIndex(irow);
        if (rawIdx == -1) {
            return " ";
        }
        String flag = this.getQualityFlag(this.rawQuality, rawIdx);
        return flag;
    }

    public String getRevisedFlag(int irow) {
        int valIdx = this.getValueIndex(irow);
        if (valIdx == -1) {
            return " ";
        }
        String flag = this.getQualityFlag(this.revisedQuality, valIdx);
        return flag;
    }

    public void setEstimateFlag(int row, String flgStr) {
        int estQualCol = this.getEstimateQualityColumnIndex();
        if (estQualCol < 0) {
            return;
        }
        int validx = this.getValueIndex(row);
        if (this.estimateQuality == null || validx < 0 || validx >= this.estimateQuality.length) {
            return;
        }
        this.setQuality(flgStr, this.estimateQuality, validx, false);
    }

    private String getValueFlag(int row) {
        int validx = this.getValueIndex(row);
        if (validx == -1) {
            return " ";
        }
        String qualstr = this.getQualityFlag(this.valueQuality, validx);
        return qualstr;
    }

    private String getValueTestFlag(int row) {
        if (this.valueQuality == null) {
            return " ";
        }
        int validx = this.getValueIndex(row);
        if (validx == -1) {
            return " ";
        }
        StringBuffer flag = new StringBuffer();
        String tests = QualityStringRenderer.getSymbolicTestsString((int)this.valueQuality[validx]);
        if (tests != null && tests.length() > 0) {
            flag.append(tests);
        }
        return flag.toString();
    }

    public String getEstimateFlag(int row) {
        int validx = this.getValueIndex(row);
        if (validx == -1) {
            return " ";
        }
        String qualstr = this.getQualityFlag(this.estimateQuality, validx);
        return qualstr;
    }

    public void setRevisedFlag(int row, String flgStr) {
        int revQualCol = this.getRevisedQualityColumnIndex();
        if (revQualCol < 0) {
            return;
        }
        int validx = this.getValueIndex(row);
        if (this.revisedQuality == null || validx < 0 || validx >= this.revisedQuality.length) {
            return;
        }
        this.setQuality(flgStr, this.revisedQuality, validx, true);
    }

    public boolean isRevisedCellEmpty(int irow) {
        if ((irow = this.getValueIndex(irow)) == -1) {
            return true;
        }
        boolean undefVal = false;
        boolean nullQual = false;
        if (this.revisedData[irow] == Double.NEGATIVE_INFINITY) {
            this.revisedData[irow] = -3.4028234663852886E38;
        }
        if (this.revisedData[irow] == -3.4028234663852886E38) {
            undefVal = true;
        }
        if (this.revisedQuality[irow] == 0) {
            nullQual = true;
        }
        return undefVal && nullQual;
    }

    public String getYUnits() {
        return this.yunits;
    }

    protected void setYUnits(String units) {
        this.yunits = units;
    }

    public boolean provideEstimate(int[] rows, boolean onlyMissing) {
        if (rows == null || rows.length < 1) {
            return false;
        }
        double[] estData = this.getEstimateData();
        double[] valData = this.getValueData();
        int firstGoodIdx = -1;
        for (int ii = 0; ii < rows.length; ++ii) {
            int valIdx = this.getValueIndex(rows[ii]);
            if (valIdx == -1 || !RMAConst.isValidValue((double)estData[valIdx]) && !RMAConst.isValidValue((double)valData[valIdx])) continue;
            if (firstGoodIdx == -1) {
                firstGoodIdx = valIdx;
            } else if (valIdx == firstGoodIdx + 1) {
                firstGoodIdx = valIdx;
            } else {
                this.interpVals(firstGoodIdx, valIdx, onlyMissing);
                firstGoodIdx = valIdx;
            }
            if (onlyMissing) continue;
            estData[valIdx] = valData[valIdx];
        }
        this.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
        return true;
    }

    private void interpVals(int firstGoodIdx, int lastGoodIdx, boolean onlyMissing) {
        double lastVal;
        int[] valTimes = this.getValueTimes();
        double[] estData = this.getEstimateData();
        double[] valData = this.getValueData();
        double[] revData = this.getRevisedData();
        int firstTime = valTimes[firstGoodIdx];
        int lastTime = valTimes[lastGoodIdx];
        double firstVal = estData[firstGoodIdx];
        if (!RMAConst.isValidValue((double)firstVal)) {
            firstVal = valData[firstGoodIdx];
        }
        if (!RMAConst.isValidValue((double)(lastVal = estData[lastGoodIdx]))) {
            lastVal = valData[lastGoodIdx];
        }
        for (int ii = firstGoodIdx + 1; ii < lastGoodIdx; ++ii) {
            int interpTime;
            double interpValue;
            if (onlyMissing && RMAConst.isValidValue((double)revData[ii]) || !RMAConst.isValidValue((double)(interpValue = RmaMath.linearInterpolate((double)firstTime, (double)firstVal, (double)lastTime, (double)lastVal, (double)(interpTime = valTimes[ii]))))) continue;
            estData[ii] = interpValue;
            this.setEstimateFlag(ii, "I");
        }
    }

    public int acceptAllEstimates() {
        int valsUpdated = 0;
        for (int ii = 0; ii < this.getRowCount(); ++ii) {
            if (!this.acceptEstimate(ii)) continue;
            ++valsUpdated;
        }
        this.fireTableDataChanged();
        return valsUpdated;
    }

    public boolean acceptEstimate(int irow) {
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int estimateQualCol = this.getEstimateQualityColumnIndex();
        if (!this.isCellEditable(irow, estimateDataCol)) {
            return false;
        }
        int valIdx = this.getValueIndex(irow);
        if (valIdx == -1) {
            return false;
        }
        if (!RMAConst.isValidValue((double)this.estimateData[valIdx])) {
            return false;
        }
        try {
            this.revisedData[valIdx] = this.estimateData[valIdx];
            if (estimateQualCol >= 0) {
                Object qaltxt = this.getEstimateFlag(irow);
                qaltxt = "P" + (String)qaltxt;
                this.setRevisedFlag(irow, (String)qaltxt);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public void linearFillForEstimate(int[] selection) {
        int i;
        int[] newSelection;
        int sel;
        if (selection == null || selection.length < 2) {
            return;
        }
        int n = selection.length;
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int firstIdx = this.getValueIndex(selection[0]);
        int lastIdx = this.getValueIndex(selection[n - 1]);
        double valFirst = -3.4028234663852886E38;
        if (firstIdx != -1) {
            valFirst = this.estimateData[firstIdx];
        }
        double valLast = -3.4028234663852886E38;
        if (lastIdx != -1) {
            valLast = this.estimateData[lastIdx];
        }
        if (!RMAConst.isValidValue((double)valFirst)) {
            firstIdx = this.getValueIndex(selection[0]);
            if (firstIdx != -1) {
                valFirst = this.valueData[firstIdx];
            }
            if (!RMAConst.isValidValue((double)valFirst)) {
                sel = selection[0] - 1;
                if (sel < 0) {
                    return;
                }
                newSelection = new int[selection.length + 1];
                newSelection[0] = sel;
                for (i = 0; i < selection.length; ++i) {
                    newSelection[i + 1] = selection[i];
                }
                selection = newSelection;
                ++n;
                firstIdx = this.getValueIndex(selection[0]);
                if (firstIdx != -1) {
                    valFirst = this.estimateData[firstIdx];
                }
                if (!RMAConst.isValidValue((double)valFirst) && (firstIdx = this.getValueIndex(selection[0])) != -1) {
                    valFirst = this.valueData[firstIdx];
                }
            }
        }
        if (!RMAConst.isValidValue((double)valLast)) {
            lastIdx = this.getValueIndex(selection[n - 1]);
            if (lastIdx != -1) {
                valLast = this.valueData[lastIdx];
            }
            if (!RMAConst.isValidValue((double)valLast)) {
                sel = selection[n - 1] + 1;
                if (sel >= this.getRowCount()) {
                    return;
                }
                newSelection = new int[selection.length + 1];
                for (i = 0; i < selection.length; ++i) {
                    newSelection[i] = selection[i];
                }
                newSelection[selection.length] = sel;
                selection = newSelection;
                if ((lastIdx = this.getValueIndex(selection[++n - 1])) != -1) {
                    valLast = this.estimateData[lastIdx];
                }
                if (!RMAConst.isValidValue((double)valLast) && (lastIdx = this.getValueIndex(selection[n - 1])) != -1) {
                    valLast = this.valueData[lastIdx];
                }
            }
        }
        if (!RMAConst.isValidValue((double)valFirst) || !RMAConst.isValidValue((double)valLast)) {
            return;
        }
        int[] itimes = this.getTimes();
        double dt = itimes[selection[n - 1]] - itimes[selection[0]];
        double slope = (valLast - valFirst) / dt;
        int irow = -1;
        for (int i2 = 1; i2 < n - 1; ++i2) {
            irow = selection[i2];
            if (!this.isCellEditable(irow, estimateDataCol)) continue;
            dt = itimes[selection[i2]] - itimes[selection[0]];
            float newval = (float)(valFirst + slope * dt);
            int valIdx = this.getValueIndex(irow);
            if (valIdx == -1) continue;
            this.estimateData[irow] = newval;
            this.setEstimateFlag(irow, "I");
        }
        this.fireTableRowsUpdated(selection[0], selection[selection.length - 1]);
    }

    public void repeatFillForEstimate(int[] selection) {
        if (selection == null || selection.length < 1) {
            return;
        }
        int n = selection.length;
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int estimateQualCol = this.getEstimateQualityColumnIndex();
        double valFirst = -3.4028234663852886E38;
        int firstIdx = this.getValueIndex(selection[0]);
        if (firstIdx != -1) {
            valFirst = this.estimateData[firstIdx];
        }
        if (!RMAConst.isValidValue((double)valFirst)) {
            firstIdx = this.getValueIndex(selection[0]);
            if (firstIdx != -1) {
                valFirst = this.valueData[firstIdx];
            }
            if (!RMAConst.isValidValue((double)valFirst)) {
                int sel = selection[0] - 1;
                if (sel < 0) {
                    return;
                }
                int[] newSelection = new int[selection.length + 1];
                newSelection[0] = sel;
                for (int i = 0; i < selection.length; ++i) {
                    newSelection[i + 1] = selection[i];
                }
                selection = newSelection;
                ++n;
                firstIdx = this.getValueIndex(selection[0]);
                if (firstIdx != -1) {
                    valFirst = this.estimateData[firstIdx];
                }
                if (!RMAConst.isValidValue((double)valFirst) && (firstIdx = this.getValueIndex(selection[0])) != -1) {
                    valFirst = this.valueData[firstIdx];
                }
            }
        }
        if (!RMAConst.isValidValue((double)valFirst)) {
            return;
        }
        int irow = -1;
        for (int i = 0; i < n; ++i) {
            irow = selection[i];
            if (!this.isCellEditable(irow, estimateDataCol)) continue;
            try {
                int valIdx = this.getValueIndex(irow);
                if (valIdx != -1) {
                    this.estimateData[irow] = valFirst;
                    this.setEstimateFlag(irow, "K");
                }
                if (estimateQualCol < 0) continue;
                this.setEstimateFlag(irow, "K");
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
        this.fireTableRowsUpdated(selection[0], selection[selection.length - 1]);
    }

    public void repeatFillToEndForEstimate(int row) {
        if (row < 0 || row > this.estimateData.length) {
            return;
        }
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int qualityColumn = this.getEstimateQualityColumnIndex();
        double value = this.estimateData[row];
        if (NumericalConstants.isValidValue((double)value)) {
            IntStream.range(row, this.estimateData.length).filter(i -> this.isCellEditable(i, estimateDataCol)).filter(i -> this.getValueIndex(i) != -1).forEach(i -> {
                this.estimateData[i] = value;
                if (qualityColumn >= 0) {
                    this.setEstimateFlag(i, "K");
                }
            });
        }
        this.fireTableRowsUpdated(row, this.estimateData.length - 1);
    }

    public void clearEstimate(int[] selection) {
        if (selection == null || selection.length < 1) {
            return;
        }
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int estimateQualCol = this.getEstimateQualityColumnIndex();
        for (int ii = 0; ii < selection.length; ++ii) {
            int valIdx;
            if (!this.isCellEditable(selection[ii], estimateDataCol) || (valIdx = this.getValueIndex(selection[ii])) == -1) continue;
            try {
                byte[] bytes;
                this.estimateData[valIdx] = -3.4028234663852886E38;
                this.revisedData[valIdx] = -3.4028234663852886E38;
                if (estimateQualCol < 0) continue;
                if (this.estimateQuality != null) {
                    bytes = Quality.getBytes((int)this.estimateQuality[valIdx]);
                    Quality.setMissing((byte[])bytes);
                    this.estimateQuality[valIdx] = Quality.getInteger((byte[])bytes);
                }
                if (this.revisedQuality == null) continue;
                bytes = Quality.getBytes((int)this.revisedQuality[valIdx]);
                Quality.setMissing((byte[])bytes);
                this.revisedQuality[valIdx] = Quality.getInteger((byte[])bytes);
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
        this.fireTableRowsUpdated(selection[0], selection[selection.length - 1]);
    }

    public boolean isRegularIntervalData() {
        return this._isRegularIntervalData;
    }

    protected void setRegularIntervalData(boolean tf) {
        this._isRegularIntervalData = tf;
    }

    public boolean isInstantaneous() {
        return this._isInstantaneous;
    }

    protected void setInstantaneous(boolean tf) {
        this._isInstantaneous = tf;
    }

    public void setScaleToRawData(boolean tf) {
        this._scaleToRawData = tf;
        this.bounds = null;
    }

    public int getPrecision() {
        return this._precision;
    }

    public void setPrecision(int precision) {
        this._precision = precision;
    }

    public boolean getEditableData() {
        return this.editableData;
    }

    public void setEditableData(boolean tf) {
        this.editableData = tf;
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        int estimateDataCol = this.getEstimateDataColumnIndex();
        if (columnIndex != estimateDataCol) {
            return false;
        }
        if (this.getValueIndex(rowIndex) == -1) {
            return false;
        }
        boolean tf = true;
        if (this.revisedQuality != null && !this.editableData && (this.isRevisedProtected(rowIndex) || this.isRevisedOkay(rowIndex))) {
            tf = false;
        }
        return tf;
    }

    public int estimatePrecision(double absMinNonZeroValue) {
        int precis = 1;
        if (absMinNonZeroValue < 1.0) {
            precis = 2;
        }
        if (absMinNonZeroValue < 0.1) {
            precis = 3;
        }
        if (absMinNonZeroValue < 0.01) {
            precis = 4;
        }
        if (absMinNonZeroValue < 0.001) {
            precis = 5;
        }
        if (absMinNonZeroValue < 1.0E-4) {
            precis = 6;
        }
        if (absMinNonZeroValue < 1.0E-5) {
            precis = 7;
        }
        return precis;
    }

    public String getRawName() {
        return this._rawName;
    }

    public double[] getRawData() {
        return this.rawData;
    }

    public int[] getRawQuality() {
        return this.rawQuality;
    }

    public double[] getValueData() {
        return this.valueData;
    }

    public double[] getRevisedData() {
        return this.revisedData;
    }

    public double[] getEstimateData() {
        return this.estimateData;
    }

    public int[] getValueQuality() {
        return this.valueQuality;
    }

    public int[] getEstimateQuality() {
        return this.estimateQuality;
    }

    public int[] getRevisedQuality() {
        return this.revisedQuality;
    }

    public HecTime getFirstDataTime() {
        int[] itimes = this.getTimes();
        HecTime ht = new HecTime(itimes[0], 1);
        return ht;
    }

    public HecTime getLastDataTime() {
        int[] itimes = this.getTimes();
        HecTime ht = new HecTime(itimes[this.times.length - 1], 1);
        return ht;
    }

    public int getGmtOffset() {
        if (this._timeZone == null) {
            return Integer.MIN_VALUE;
        }
        int hours = this._timeZone.getRawOffset() / 3600000;
        return hours;
    }

    public TimeZone getTimeZone() {
        return this._timeZone;
    }

    protected void setTimeZone(TimeZone tz) {
        this._timeZone = tz;
    }

    public boolean resetTimeWindow(HecTime startTime, HecTime endTime) {
        return false;
    }

    public int size() {
        int[] itimes = this.getTimes();
        if (itimes == null) {
            return 0;
        }
        return itimes.length;
    }

    public void addData(int[] prependTimes, int[] insertTimes, int[] appendTimes) {
        boolean tf;
        boolean mod = false;
        if (prependTimes != null && prependTimes.length > 0) {
            tf = false;
            try {
                tf = this.prependTimes(prependTimes);
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                // empty catch block
            }
            if (tf) {
                mod = tf;
            }
        }
        if (insertTimes != null && insertTimes.length > 0 && (tf = this.insertTimes(insertTimes))) {
            mod = tf;
        }
        if (appendTimes != null && appendTimes.length > 0) {
            tf = false;
            try {
                tf = this.appendTimes(appendTimes);
            }
            catch (DataSetIllegalArgumentException dataSetIllegalArgumentException) {
                // empty catch block
            }
            if (tf) {
                mod = tf;
            }
        }
        if (mod) {
            this.initTimes();
            this.bounds = null;
            this.fireTableRowsInserted(0, this.size());
        }
    }

    private boolean hasDuplicateTimes(int[] addTimes, int[] vtimes) {
        int ii = 0;
        int jj = 0;
        while (ii < addTimes.length && jj < vtimes.length) {
            if (addTimes[ii] == vtimes[jj]) {
                return true;
            }
            if (addTimes[ii] < vtimes[jj]) {
                ++ii;
                continue;
            }
            if (addTimes[ii] > vtimes[jj]) {
                ++jj;
                continue;
            }
            ++ii;
            ++jj;
        }
        return false;
    }

    private boolean checkOnInterval(int[] times, int intervalMins) throws DataSetIllegalArgumentException {
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        Interval interval = new Interval(intervalMins);
        String intervalName = interval.toString();
        HecTime hecTime = new HecTime();
        for (int ii = 0; ii < times.length - 1; ++ii) {
            hecTime.set(times[ii]);
            long timeInMillis = hecTime.getTimeInMillis();
            long expectedTimeAtNextInterval = Interval.getTimeAtNextInterval((long)timeInMillis, (String)intervalName, (TimeZone)gmtTimeZone);
            hecTime.set(times[ii + 1]);
            long actualtimeAtNextInterval = hecTime.getTimeInMillis();
            if (expectedTimeAtNextInterval == actualtimeAtNextInterval) continue;
            return false;
        }
        return true;
    }

    private boolean prependTimes(int[] addTimes) throws DataSetIllegalArgumentException {
        Arrays.sort(addTimes);
        int intervalMins = this.getIntervalMinutes();
        int firstDataTime = this.valueTimes[0];
        if (intervalMins > 0) {
            int[] timeArray = new int[addTimes.length + 1];
            System.arraycopy(addTimes, 0, timeArray, 0, addTimes.length);
            timeArray[timeArray.length - 1] = firstDataTime;
            if (!this.checkOnInterval(timeArray, intervalMins)) {
                return false;
            }
        } else if (addTimes[addTimes.length - 1] >= firstDataTime) {
            return false;
        }
        int size = this.valueTimes.length + addTimes.length;
        int[] newValueTimes = new int[size];
        double[] newValueData = new double[size];
        int[] newValueQuality = null;
        if (this.valueQuality != null) {
            newValueQuality = new int[size];
        }
        double[] newEstimateData = new double[size];
        byte[] bytes = new byte[4];
        Quality.setRevisedManually((byte[])bytes);
        int kQual = Quality.getInteger((byte[])bytes);
        int[] newEstimateQuality = null;
        if (this.estimateQuality != null) {
            newEstimateQuality = new int[size];
            Arrays.fill(newEstimateQuality, 0, addTimes.length, kQual);
        }
        double[] newRevisedData = new double[size];
        int[] newRevisedQuality = null;
        if (this.revisedQuality != null) {
            newRevisedQuality = new int[size];
            Arrays.fill(newRevisedQuality, 0, addTimes.length, kQual);
        }
        System.arraycopy(addTimes, 0, newValueTimes, 0, addTimes.length);
        System.arraycopy(this.valueTimes, 0, newValueTimes, addTimes.length, this.valueTimes.length);
        Arrays.fill(newValueData, 0, addTimes.length, -3.4028234663852886E38);
        System.arraycopy(this.valueData, 0, newValueData, addTimes.length, this.valueTimes.length);
        if (this.valueQuality != null) {
            System.arraycopy(this.valueQuality, 0, newValueQuality, addTimes.length, this.valueTimes.length);
        }
        Arrays.fill(newEstimateData, 0, addTimes.length, -3.4028234663852886E38);
        System.arraycopy(this.estimateData, 0, newEstimateData, addTimes.length, this.valueTimes.length);
        if (this.estimateQuality != null) {
            System.arraycopy(this.estimateQuality, 0, newEstimateQuality, addTimes.length, this.valueTimes.length);
        }
        Arrays.fill(newRevisedData, 0, addTimes.length, -3.4028234663852886E38);
        System.arraycopy(this.revisedData, 0, newRevisedData, addTimes.length, this.valueTimes.length);
        if (this.revisedQuality != null) {
            System.arraycopy(this.revisedQuality, 0, newRevisedQuality, addTimes.length, this.valueTimes.length);
        }
        this.valueTimes = newValueTimes;
        this.valueData = newValueData;
        this.valueQuality = newValueQuality;
        this.estimateData = newEstimateData;
        this.estimateQuality = newEstimateQuality;
        this.revisedData = newRevisedData;
        this.revisedQuality = newRevisedQuality;
        return true;
    }

    private boolean insertTimes(int[] addTimes) {
        Arrays.sort(addTimes);
        int intervalMins = this.getIntervalMinutes();
        int firstDataTime = this.valueTimes[0];
        int lastDataTime = this.valueTimes[this.valueTimes.length - 1];
        if (this.hasDuplicateTimes(addTimes, this.valueTimes)) {
            return false;
        }
        if (intervalMins == 0 && (addTimes[0] <= firstDataTime || addTimes[addTimes.length - 1] >= lastDataTime)) {
            return false;
        }
        int[] newValueTimes = new int[this.valueTimes.length + addTimes.length];
        double[] newValueData = new double[this.valueTimes.length + addTimes.length];
        int[] newValueQuality = null;
        if (this.valueQuality != null) {
            newValueQuality = new int[this.valueTimes.length + addTimes.length];
        }
        double[] newEstimateData = new double[this.valueTimes.length + addTimes.length];
        int[] newEstimateQuality = null;
        byte[] bytes = new byte[4];
        Quality.setRevisedManually((byte[])bytes);
        int kQual = Quality.getInteger((byte[])bytes);
        if (this.estimateQuality != null) {
            newEstimateQuality = new int[this.valueTimes.length + addTimes.length];
        }
        double[] newRevisedData = new double[this.valueTimes.length + addTimes.length];
        int[] newRevisedQuality = null;
        if (this.revisedQuality != null) {
            newRevisedQuality = new int[this.valueTimes.length + addTimes.length];
        }
        int ii = 0;
        int jj = 0;
        for (int nn = 0; nn < newValueTimes.length; ++nn) {
            if (this.valueTimes[jj] < addTimes[ii]) {
                newValueTimes[nn] = this.valueTimes[jj];
                newValueData[nn] = this.valueData[jj];
                if (this.valueQuality != null) {
                    newValueQuality[nn] = this.valueQuality[jj];
                }
                newEstimateData[nn] = this.estimateData[jj];
                if (this.estimateQuality != null) {
                    newEstimateQuality[nn] = this.estimateQuality[jj];
                }
                newRevisedData[nn] = this.revisedData[jj];
                if (this.revisedQuality != null) {
                    newRevisedQuality[nn] = this.revisedQuality[jj];
                }
                ++jj;
            } else if (addTimes[ii] < this.valueTimes[jj]) {
                newValueTimes[nn] = addTimes[ii];
                newValueData[nn] = -3.4028234663852886E38;
                newEstimateData[nn] = -3.4028234663852886E38;
                newRevisedData[nn] = -3.4028234663852886E38;
                if (this.estimateQuality != null) {
                    newEstimateQuality[nn] = kQual;
                }
                if (this.revisedQuality != null) {
                    newRevisedQuality[nn] = kQual;
                }
                ++ii;
            }
            if (ii >= addTimes.length) {
                ++nn;
                while (nn < newValueTimes.length) {
                    newValueTimes[nn] = this.valueTimes[jj];
                    newValueData[nn] = this.valueData[jj];
                    if (this.valueQuality != null) {
                        newValueQuality[nn] = this.valueQuality[jj];
                    }
                    newEstimateData[nn] = this.estimateData[jj];
                    if (this.estimateQuality != null) {
                        newEstimateQuality[nn] = this.estimateQuality[jj];
                    }
                    newRevisedData[nn] = this.revisedData[jj];
                    if (this.revisedQuality != null) {
                        newRevisedQuality[nn] = this.revisedQuality[jj];
                    }
                    ++jj;
                    ++nn;
                }
            } else {
                if (jj < this.valueTimes.length) continue;
                ++nn;
                while (nn < newValueTimes.length) {
                    newValueTimes[nn] = addTimes[ii];
                    newValueData[nn] = -3.4028234663852886E38;
                    newEstimateData[nn] = -3.4028234663852886E38;
                    newRevisedData[nn] = -3.4028234663852886E38;
                    if (this.estimateQuality != null) {
                        newEstimateQuality[nn] = kQual;
                    }
                    if (this.revisedQuality != null) {
                        newRevisedQuality[nn] = kQual;
                    }
                    ++ii;
                    ++nn;
                }
            }
            break;
        }
        this.valueTimes = newValueTimes;
        this.valueData = newValueData;
        this.valueQuality = newValueQuality;
        this.estimateData = newEstimateData;
        this.estimateQuality = newEstimateQuality;
        this.revisedData = newRevisedData;
        this.revisedQuality = newRevisedQuality;
        return true;
    }

    private boolean appendTimes(int[] addTimes) throws DataSetIllegalArgumentException {
        Arrays.sort(addTimes);
        int intervalMins = this.getIntervalMinutes();
        if (this.valueTimes != null) {
            int lastDataTime = this.valueTimes[this.valueTimes.length - 1];
            if (intervalMins > 0) {
                int[] timeArray = new int[addTimes.length + 1];
                System.arraycopy(addTimes, 0, timeArray, 1, addTimes.length);
                timeArray[0] = lastDataTime;
                if (!this.checkOnInterval(timeArray, intervalMins)) {
                    return false;
                }
            } else if (addTimes[0] <= lastDataTime) {
                return false;
            }
        }
        int size = addTimes.length;
        if (this.valueTimes != null) {
            size += this.valueTimes.length;
        }
        int[] newValueTimes = new int[size];
        double[] newValueData = new double[size];
        int[] newValueQuality = null;
        if (this.valueQuality != null) {
            newValueQuality = new int[size];
        }
        double[] newEstimateData = new double[size];
        int[] newEstimateQuality = null;
        byte[] bytes = new byte[4];
        Quality.setRevisedManually((byte[])bytes);
        int kQual = Quality.getInteger((byte[])bytes);
        if (this.estimateQuality != null) {
            newEstimateQuality = new int[size];
        }
        double[] newRevisedData = new double[size];
        int[] newRevisedQuality = null;
        if (this.revisedQuality != null) {
            newRevisedQuality = new int[size];
        }
        if (this.valueTimes != null) {
            System.arraycopy(this.valueTimes, 0, newValueTimes, 0, this.valueTimes.length);
            System.arraycopy(addTimes, 0, newValueTimes, this.valueTimes.length, addTimes.length);
            System.arraycopy(this.valueData, 0, newValueData, 0, this.valueTimes.length);
            Arrays.fill(newValueData, this.valueTimes.length, newValueData.length, -3.4028234663852886E38);
            if (this.valueQuality != null) {
                System.arraycopy(this.valueQuality, 0, newValueQuality, 0, this.valueTimes.length);
            }
            System.arraycopy(this.estimateData, 0, newEstimateData, 0, this.valueTimes.length);
            Arrays.fill(newEstimateData, this.valueTimes.length, newEstimateData.length, -3.4028234663852886E38);
            if (this.estimateQuality != null) {
                System.arraycopy(this.estimateQuality, 0, newEstimateQuality, 0, this.valueTimes.length);
                Arrays.fill(newEstimateQuality, this.valueTimes.length, newEstimateQuality.length, kQual);
            }
            System.arraycopy(this.revisedData, 0, newRevisedData, 0, this.valueTimes.length);
            Arrays.fill(newRevisedData, this.valueTimes.length, newRevisedData.length, -3.4028234663852886E38);
            if (this.revisedQuality != null) {
                System.arraycopy(this.revisedQuality, 0, newRevisedQuality, 0, this.valueTimes.length);
                Arrays.fill(newRevisedQuality, this.valueTimes.length, newRevisedQuality.length, kQual);
            }
        } else {
            newValueTimes = addTimes;
            Arrays.fill(newValueData, -3.4028234663852886E38);
            if (this.valueQuality != null) {
                // empty if block
            }
            Arrays.fill(newEstimateData, -3.4028234663852886E38);
            Arrays.fill(newRevisedData, -3.4028234663852886E38);
        }
        this.valueTimes = newValueTimes;
        this.valueData = newValueData;
        this.valueQuality = newValueQuality;
        this.estimateData = newEstimateData;
        this.estimateQuality = newEstimateQuality;
        this.revisedData = newRevisedData;
        this.revisedQuality = newRevisedQuality;
        return true;
    }

    public void padToTimeWindow() {
        int interval = this.getIntervalMinutes();
        if (interval > 0) {
            this.padRegular(interval);
        } else {
            this.padIrregular();
        }
        this.bounds = null;
    }

    private void padIrregular() {
        HecTime start = this.getFirstDataTime();
        HecTime end = this.getLastDataTime();
        int dataStart = start.value();
        int dataEnd = end.value();
        HecTime retrStartTime = new HecTime();
        retrStartTime.set(this._retrStartTime);
        HecTime retrEndTime = new HecTime();
        retrEndTime.set(this._retrEndTime);
        int retrStart = retrStartTime.value();
        int retrEnd = retrEndTime.value();
        int newSize = this.valueData.length;
        boolean prepend = false;
        boolean append = false;
        if (retrStart < dataStart) {
            ++newSize;
            prepend = true;
        }
        if (retrEnd > dataEnd) {
            ++newSize;
            append = true;
        }
        int[] newValueTimes = new int[newSize];
        double[] newValueData = new double[newSize];
        int[] newValueQuality = null;
        if (this.valueQuality != null) {
            newValueQuality = new int[newSize];
        }
        double[] newEstimateData = new double[newSize];
        int[] newEstimateQuality = null;
        if (this.estimateQuality != null) {
            newEstimateQuality = new int[newSize];
        }
        double[] newRevisedData = new double[newSize];
        int[] newRevisedQuality = null;
        if (this.revisedQuality != null) {
            newRevisedQuality = new int[newSize];
        }
        if (prepend && append) {
            newValueTimes[0] = retrStart;
            System.arraycopy(this.valueTimes, 0, newValueTimes, 1, this.valueTimes.length);
            newValueTimes[newValueTimes.length - 1] = retrEnd;
            newValueData[0] = -3.4028234663852886E38;
            System.arraycopy(this.valueData, 0, newValueData, 1, this.valueData.length);
            newValueData[newValueData.length - 1] = -3.4028234663852886E38;
            if (this.valueQuality != null) {
                System.arraycopy(this.valueQuality, 0, newValueQuality, 1, this.valueQuality.length);
            }
            newEstimateData[0] = -3.4028234663852886E38;
            System.arraycopy(this.estimateData, 0, newEstimateData, 1, this.estimateData.length);
            newEstimateData[newEstimateData.length - 1] = -3.4028234663852886E38;
            if (this.estimateQuality != null) {
                System.arraycopy(this.estimateQuality, 0, newEstimateQuality, 1, this.estimateQuality.length);
            }
            newRevisedData[0] = -3.4028234663852886E38;
            System.arraycopy(this.revisedData, 0, newRevisedData, 1, this.revisedData.length);
            newRevisedData[newRevisedData.length - 1] = -3.4028234663852886E38;
            if (this.revisedQuality != null) {
                System.arraycopy(this.revisedQuality, 0, newRevisedQuality, 1, this.revisedQuality.length);
            }
        } else if (prepend) {
            newValueTimes[0] = retrStart;
            System.arraycopy(this.valueTimes, 0, newValueTimes, 1, this.valueTimes.length);
            newValueData[0] = -3.4028234663852886E38;
            System.arraycopy(this.valueData, 0, newValueData, 1, this.valueData.length);
            if (this.valueQuality != null) {
                System.arraycopy(this.valueQuality, 0, newValueQuality, 1, this.valueQuality.length);
            }
            newEstimateData[0] = -3.4028234663852886E38;
            System.arraycopy(this.estimateData, 0, newEstimateData, 1, this.estimateData.length);
            if (this.estimateQuality != null) {
                System.arraycopy(this.estimateQuality, 0, newEstimateQuality, 1, this.estimateQuality.length);
            }
            newRevisedData[0] = -3.4028234663852886E38;
            System.arraycopy(this.revisedData, 0, newRevisedData, 1, this.revisedData.length);
            if (this.revisedQuality != null) {
                System.arraycopy(this.revisedQuality, 0, newRevisedQuality, 1, this.revisedQuality.length);
            }
        } else if (append) {
            System.arraycopy(this.valueTimes, 0, newValueTimes, 0, this.valueTimes.length);
            newValueTimes[newValueTimes.length - 1] = retrEnd;
            System.arraycopy(this.valueData, 0, newValueData, 0, this.valueData.length);
            newValueData[newValueData.length - 1] = -3.4028234663852886E38;
            System.arraycopy(this.valueData, 0, newValueData, 0, this.valueData.length);
            newValueData[newValueData.length - 1] = -3.4028234663852886E38;
            if (this.valueQuality != null) {
                System.arraycopy(this.valueQuality, 0, newValueQuality, 0, this.valueQuality.length);
            }
            System.arraycopy(this.estimateData, 0, newEstimateData, 0, this.estimateData.length);
            newEstimateData[newEstimateData.length - 1] = -3.4028234663852886E38;
            if (this.estimateQuality != null) {
                System.arraycopy(this.estimateQuality, 0, newEstimateQuality, 0, this.estimateQuality.length);
            }
            System.arraycopy(this.revisedData, 0, newRevisedData, 0, this.revisedData.length);
            newRevisedData[newRevisedData.length - 1] = -3.4028234663852886E38;
            if (this.revisedQuality != null) {
                System.arraycopy(this.revisedQuality, 0, newRevisedQuality, 0, this.revisedQuality.length);
            }
        }
        this.valueTimes = newValueTimes;
        this.valueData = newValueData;
        this.valueQuality = newValueQuality;
        this.estimateData = newEstimateData;
        this.estimateQuality = newEstimateQuality;
        this.revisedData = newRevisedData;
        this.revisedQuality = newRevisedQuality;
        this.initTimes();
        this.fireTableRowsInserted(0, this.size());
    }

    private void padRegular(int interval) {
        int ii;
        int appendCount;
        HecTime start = this.getFirstDataTime();
        HecTime end = this.getLastDataTime();
        int dataStart = start.value();
        int dataEnd = end.value();
        HecTime retrStartTime = new HecTime();
        retrStartTime.set(this._retrStartTime);
        HecTime retrEndTime = new HecTime();
        retrEndTime.set(this._retrEndTime);
        int retrStart = retrStartTime.value();
        int retrEnd = retrEndTime.value();
        int prependCount = (dataStart - retrStart) / interval;
        if (prependCount < 0) {
            prependCount = 0;
        }
        if ((appendCount = (retrEnd - dataEnd) / interval) < 0) {
            appendCount = 0;
        }
        int newSize = this.valueData.length + prependCount + appendCount;
        double[] newValueData = new double[newSize];
        Arrays.fill(newValueData, 0, prependCount, -3.4028234663852886E38);
        System.arraycopy(this.valueData, 0, newValueData, prependCount, this.valueData.length);
        Arrays.fill(newValueData, prependCount + this.valueData.length, newSize, -3.4028234663852886E38);
        int[] newValueTimes = new int[newSize];
        int count = 1;
        for (ii = prependCount - 1; ii >= 0; --ii) {
            newValueTimes[ii] = dataStart - interval * count;
            ++count;
        }
        count = 1;
        for (ii = prependCount + this.valueData.length; ii < newSize; ++ii) {
            newValueTimes[ii] = dataEnd + interval * count;
            ++count;
        }
        System.arraycopy(this.valueTimes, 0, newValueTimes, prependCount, this.valueTimes.length);
        int[] newValueQuality = null;
        if (this.valueQuality != null) {
            newValueQuality = new int[newSize];
            System.arraycopy(this.valueQuality, 0, newValueQuality, prependCount, this.valueQuality.length);
        }
        double[] newEstimateData = new double[newSize];
        Arrays.fill(newEstimateData, 0, prependCount, -3.4028234663852886E38);
        System.arraycopy(this.estimateData, 0, newEstimateData, prependCount, this.estimateData.length);
        Arrays.fill(newEstimateData, prependCount + this.valueData.length, newSize, -3.4028234663852886E38);
        int[] newEstimateQuality = null;
        if (this.estimateQuality != null) {
            newEstimateQuality = new int[newSize];
            System.arraycopy(this.estimateQuality, 0, newEstimateQuality, prependCount, this.estimateQuality.length);
        }
        double[] newRevisedData = new double[newSize];
        Arrays.fill(newRevisedData, 0, prependCount, -3.4028234663852886E38);
        System.arraycopy(this.revisedData, 0, newRevisedData, prependCount, this.revisedData.length);
        Arrays.fill(newRevisedData, prependCount + this.valueData.length, newSize, -3.4028234663852886E38);
        int[] newRevisedQuality = null;
        if (this.revisedQuality != null) {
            newRevisedQuality = new int[newSize];
            System.arraycopy(this.revisedQuality, 0, newRevisedQuality, prependCount, this.revisedQuality.length);
        }
        this.valueTimes = newValueTimes;
        this.valueData = newValueData;
        this.valueQuality = newValueQuality;
        this.estimateData = newEstimateData;
        this.estimateQuality = newEstimateQuality;
        this.revisedData = newRevisedData;
        this.revisedQuality = newRevisedQuality;
        this.initTimes();
        this.fireTableRowsInserted(0, this.size());
    }

    public abstract int getIntervalMinutes();

    public boolean getEditableQuality() {
        return this._editableQuality;
    }

    protected void setEditableQuality(boolean tf) {
        this._editableQuality = tf;
    }

    public int getRowCount() {
        return this.size();
    }

    public Class getColumnClass(int columnIndex) {
        int rawDataCol = this.getRawDataColumnIndex();
        int rawQualCol = this.getRawQualityColumnIndex();
        int valueDataCol = this.getValueDataColumnIndex();
        int valueQualCol = this.getValueQualityColumnIndex();
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int estimateQualCol = this.getEstimateQualityColumnIndex();
        int revisedDataCol = this.getRevisedDataColumnIndex();
        int revisedQualCol = this.getRevisedQualityColumnIndex();
        if (columnIndex == 0) {
            return HecTimeArray.class;
        }
        if (columnIndex == rawDataCol || columnIndex == valueDataCol || columnIndex == estimateDataCol || columnIndex == revisedDataCol) {
            return ParamDouble.class;
        }
        if (columnIndex == rawQualCol || columnIndex == valueQualCol || columnIndex == estimateQualCol || columnIndex == revisedQualCol) {
            return String.class;
        }
        if (this.getValueAt(0, columnIndex) != null) {
            return this.getValueAt(0, columnIndex).getClass();
        }
        return new Object().getClass();
    }

    public Optional<ZoneId> getDataZoneId() {
        return Optional.ofNullable(this.getTimeZone()).map(TimeZone::toZoneId);
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        int rawDataCol = this.getRawDataColumnIndex();
        int rawQualCol = this.getRawQualityColumnIndex();
        int valueDataCol = this.getValueDataColumnIndex();
        int valueQualCol = this.getValueQualityColumnIndex();
        int valueTestCol = this.getValueTestColumnIndex();
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int estimateQualCol = this.getEstimateQualityColumnIndex();
        int revisedDataCol = this.getRevisedDataColumnIndex();
        int revisedQualCol = this.getRevisedQualityColumnIndex();
        if (columnIndex == 0) {
            HecTime hecTime = new HecTime();
            int[] itimes = this.getTimes();
            hecTime.set(itimes[rowIndex]);
            return hecTime.getInstant(this.getDataZoneId().orElse(NumericalConstants.UTC_ZONEID));
        }
        if (columnIndex == rawDataCol && this.rawData != null) {
            int rawIdx = this.getRawIndex(rowIndex);
            if (rawIdx == -1) {
                return null;
            }
            double val = this.rawData[rawIdx];
            ParamDouble pd = new ParamDouble(val, this._yParamId, this._unitSystem);
            return pd;
        }
        if (columnIndex == rawQualCol) {
            String flag = this.getRawFlag(rowIndex);
            return flag;
        }
        int valIdx = this.getValueIndex(rowIndex);
        if (valIdx == -1) {
            return null;
        }
        if (columnIndex == valueDataCol) {
            double val = this.valueData[valIdx];
            ParamDouble pd = new ParamDouble(val, this._yParamId, this._unitSystem);
            return pd;
        }
        if (columnIndex == valueQualCol) {
            String flag = this.getValueFlag(rowIndex);
            return flag;
        }
        if (columnIndex == valueTestCol) {
            String flag = this.getValueTestFlag(rowIndex);
            return flag;
        }
        if (columnIndex == estimateDataCol) {
            double val = this.estimateData[valIdx];
            ParamDouble pd = new ParamDouble(val, this._yParamId, this._unitSystem);
            return pd;
        }
        if (columnIndex == estimateQualCol) {
            String flag = this.getEstimateFlag(rowIndex);
            return flag;
        }
        if (columnIndex == revisedDataCol) {
            double val = this.revisedData[valIdx];
            ParamDouble pd = new ParamDouble(val, this._yParamId, this._unitSystem);
            return pd;
        }
        if (columnIndex == revisedQualCol) {
            String flag = this.getRevisedFlag(rowIndex);
            return flag;
        }
        return null;
    }

    public void setValueAt(Object aValue, int irow, int col) {
        ParamDouble pdtmp;
        int currentPrecision;
        int valIdx = this.getValueIndex(irow);
        if (valIdx == -1) {
            return;
        }
        int valueDataCol = this.getValueDataColumnIndex();
        int valueQualCol = this.getValueQualityColumnIndex();
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int estimateQualCol = this.getEstimateQualityColumnIndex();
        int revisedDataCol = this.getRevisedDataColumnIndex();
        int revisedQualCol = this.getRevisedQualityColumnIndex();
        if (col == revisedDataCol) {
            this.revisedData[valIdx] = RMAIO.parseDouble((Object)aValue);
        } else if (col == estimateDataCol) {
            this.estimateData[valIdx] = RMAIO.parseDouble((Object)aValue);
        } else if (col == valueDataCol) {
            this.valueData[valIdx] = RMAIO.parseDouble((Object)aValue);
        } else if (aValue != null) {
            String flgStr = (String)aValue;
            if (col == revisedQualCol) {
                this.setQuality(flgStr, this.revisedQuality, irow, true);
            } else if (col == estimateQualCol) {
                this.setQuality(flgStr, this.estimateQuality, irow, false);
            } else if (col == valueQualCol) {
                this.setQuality(flgStr, this.valueQuality, irow, false);
            }
        }
        if (aValue instanceof ParamDouble && col == estimateDataCol && (currentPrecision = (pdtmp = (ParamDouble)aValue).getPrecision()) < 7) {
            pdtmp.setPrecision(7);
        }
        this.fireTableCellUpdated(irow, col);
    }

    public boolean insertDate(int irow, Component comp) {
        int[] itimes = this.getTimes();
        Window parent = comp instanceof RmaJFrame ? (Window)comp : SwingUtilities.windowForComponent(comp);
        if (parent instanceof RmaJFrame) {
            HecTimeArray htanew;
            HecTimeArray hta = new HecTimeArray(1);
            HecTime hecTime = new HecTime();
            if (irow < 0 || irow >= itimes.length) {
                irow = 0;
            }
            hecTime.set(itimes[irow]);
            hta.setElementAt(hecTime, 0);
            hta.setTimeZone(this._timeZone);
            InputDateDialog dlg = new InputDateDialog((Frame)((RmaJFrame)parent), true);
            TimeZone tz = RmaJFrame.getTimeZone();
            dlg.setDateTime(hta, tz);
            dlg.setMessage("Enter new date/time");
            dlg.setVisible(true);
            if (dlg.ok && (htanew = dlg.getDateTime()) != null) {
                if (htanew.numberElements() < 1) {
                    return false;
                }
                HecTime newTime = htanew.element(0);
                int hourOffset = 0;
                tz = htanew.getTimeZone();
                if (tz != null) {
                    int tzmilliOffset = tz.getRawOffset();
                    hourOffset = tzmilliOffset / 3600000;
                }
                int minutes = newTime.value();
                return this.insertDate(minutes, Double.NEGATIVE_INFINITY);
            }
        }
        return false;
    }

    public boolean insertDate(int minutes, double estVal) {
        if (this.isRegularIntervalData()) {
            return false;
        }
        if (minutes < this._retrStartTime || minutes > this._retrEndTime) {
            return false;
        }
        int[] itimes = this.getTimes();
        int insertPoint = Arrays.binarySearch(itimes, minutes);
        if (insertPoint >= 0) {
            return false;
        }
        insertPoint = -1 * (insertPoint + 1);
        if (insertPoint != 0 && insertPoint < this.valueTimes.length - 1) {
            int valIdx = insertPoint;
            if (this.valueIndexes != null) {
                valIdx = this.valueIndexes[insertPoint];
            }
            this.valueTimes = this.arrayInsert(this.valueTimes, valIdx, minutes);
            this.valueData = this.arrayInsert(this.valueData, valIdx, Double.NEGATIVE_INFINITY);
            if (this.valueQuality != null) {
                this.valueQuality = this.arrayInsert(this.valueQuality, valIdx, 0);
            }
            byte[] bytes = new byte[4];
            bytes = Quality.setReplaceGraphicalChange((byte[])bytes);
            int eQual = Quality.getInteger((byte[])bytes);
            this.estimateData = this.arrayInsert(this.estimateData, valIdx, estVal);
            if (this.estimateQuality != null) {
                this.estimateQuality = this.arrayInsert(this.estimateQuality, valIdx, eQual);
            }
            this.revisedData = this.arrayInsert(this.revisedData, valIdx, Double.NEGATIVE_INFINITY);
            if (this.revisedQuality != null) {
                this.revisedQuality = this.arrayInsert(this.revisedQuality, valIdx, eQual);
            }
            this.initTimes();
            this.fireTableRowsInserted(insertPoint, insertPoint);
        }
        return true;
    }

    private int[] arrayInsert(int[] array, int insertPoint, int value) {
        int[] newArray = new int[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, insertPoint);
        newArray[insertPoint] = value;
        System.arraycopy(array, insertPoint, newArray, insertPoint + 1, array.length - insertPoint);
        return newArray;
    }

    private double[] arrayInsert(double[] array, int insertPoint, double value) {
        double[] newArray = new double[array.length + 1];
        System.arraycopy(array, 0, newArray, 0, insertPoint);
        newArray[insertPoint] = value;
        System.arraycopy(array, insertPoint, newArray, insertPoint + 1, array.length - insertPoint);
        return newArray;
    }

    public void deleteRows(int[] rows) {
        if (rows == null || rows.length < 1) {
            return;
        }
        TreeMap<Integer, Integer> newrows = new TreeMap<Integer, Integer>();
        int size = this.size();
        for (int ii = 0; ii < rows.length; ++ii) {
            int valIdx;
            if (rows[ii] < 0 || rows[ii] >= size || (valIdx = this.getValueIndex(rows[ii])) == -1) continue;
            Integer rowObj = rows[ii];
            Integer valIdxObj = valIdx;
            newrows.put(rowObj, valIdxObj);
        }
        if (newrows.size() < 1) {
            return;
        }
        Set rowIdxs = newrows.keySet();
        Collection valIdxs = newrows.values();
        this.valueTimes = this.arrayDelete(this.valueTimes, valIdxs);
        this.valueData = this.arrayDelete(this.valueData, valIdxs);
        if (this.valueQuality != null) {
            this.valueQuality = this.arrayDelete(this.valueQuality, valIdxs);
        }
        this.estimateData = this.arrayDelete(this.estimateData, valIdxs);
        if (this.estimateQuality != null) {
            this.estimateQuality = this.arrayDelete(this.estimateQuality, valIdxs);
        }
        this.revisedData = this.arrayDelete(this.revisedData, valIdxs);
        if (this.revisedQuality != null) {
            this.revisedQuality = this.arrayDelete(this.revisedQuality, valIdxs);
        }
        this.initTimes();
        ArrayList rowsDeleted = new ArrayList(rowIdxs);
        int firstRow = (Integer)rowsDeleted.get(0);
        int lastRow = (Integer)rowsDeleted.get(rowsDeleted.size() - 1);
        this.fireTableRowsDeleted(firstRow, lastRow);
    }

    private int[] arrayDelete(int[] array, Collection deleteIndexes) {
        int sz = array.length - deleteIndexes.size();
        int[] dst = new int[sz];
        int prevDestPos = -1;
        int ii = 0;
        Iterator it = deleteIndexes.iterator();
        while (it.hasNext()) {
            int didx = (Integer)it.next();
            int srcPos = prevDestPos + 1;
            int destPos = srcPos - ii;
            int length = didx - prevDestPos - 1;
            System.arraycopy(array, srcPos, dst, destPos, length);
            prevDestPos = didx;
            ++ii;
        }
        int srcPos = prevDestPos + 1;
        int destPos = srcPos - ii;
        int length = array.length - prevDestPos - 1;
        System.arraycopy(array, prevDestPos + 1, dst, destPos, length);
        return dst;
    }

    private double[] arrayDelete(double[] array, Collection deleteIndexes) {
        int sz = array.length - deleteIndexes.size();
        double[] dst = new double[sz];
        int prevDestPos = -1;
        int ii = 0;
        Iterator it = deleteIndexes.iterator();
        while (it.hasNext()) {
            int didx = (Integer)it.next();
            int srcPos = prevDestPos + 1;
            int destPos = srcPos - ii;
            int length = didx - prevDestPos - 1;
            System.arraycopy(array, srcPos, dst, destPos, length);
            prevDestPos = didx;
            ++ii;
        }
        int srcPos = prevDestPos + 1;
        int destPos = srcPos - ii;
        int length = array.length - prevDestPos - 1;
        System.arraycopy(array, prevDestPos + 1, dst, destPos, length);
        return dst;
    }

    private double interpEstimateValue(int timeMinutes) {
        int ii;
        double[] estData = this.getEstimateData();
        int[] itimes = this.getTimes();
        int insertPoint = Arrays.binarySearch(itimes, timeMinutes);
        int valIdx = -1;
        if (insertPoint < 0) {
            insertPoint = -1 * (insertPoint + 1);
        } else {
            valIdx = this.getValueIndex(insertPoint);
            if (valIdx != -1 && Const.isValid((double)estData[valIdx])) {
                return estData[valIdx];
            }
        }
        if (insertPoint <= 0 || insertPoint >= itimes.length - 1) {
            return Double.NEGATIVE_INFINITY;
        }
        int[] interpTimes = new int[]{Integer.MIN_VALUE, Integer.MAX_VALUE};
        double[] interpVals = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        interpTimes[0] = itimes[insertPoint - 1];
        interpTimes[1] = itimes[insertPoint];
        valIdx = this.getValueIndex(insertPoint - 1);
        if (valIdx != -1 && RMAConst.isValidValue((double)estData[valIdx])) {
            interpVals[0] = estData[valIdx];
        } else {
            for (ii = insertPoint - 1; ii >= 0; --ii) {
                interpTimes[0] = itimes[ii];
                valIdx = this.getValueIndex(ii);
                if (valIdx == -1 || !RMAConst.isValidValue((double)estData[valIdx])) continue;
                interpVals[0] = estData[valIdx];
            }
            if (!RMAConst.isValidValue((double)interpVals[0])) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        valIdx = this.getValueIndex(insertPoint);
        if (valIdx != -1 && RMAConst.isValidValue((double)estData[valIdx])) {
            interpVals[1] = estData[valIdx];
        } else {
            for (ii = insertPoint; ii < itimes.length; ++ii) {
                interpTimes[1] = itimes[ii];
                valIdx = this.getValueIndex(ii);
                if (valIdx == -1 || !RMAConst.isValidValue((double)estData[valIdx])) continue;
                interpVals[1] = estData[valIdx];
            }
            if (!RMAConst.isValidValue((double)interpVals[1])) {
                return Double.NEGATIVE_INFINITY;
            }
        }
        double newEstimate = Interpolate.linearInterpolate((int[])interpTimes, (double[])interpVals, (int)timeMinutes, (int)2);
        return newEstimate;
    }

    private List<Integer> getDeletedTimeIndexes() {
        ArrayList<Integer> removeMe = new ArrayList<Integer>();
        int loopI = 0;
        for (int i = 0; i < this._originalTimes.length; ++i) {
            int originalTime = this._originalTimes[i];
            while (loopI < this.times.length && this.times[loopI] < originalTime) {
                ++loopI;
            }
            if (loopI < this.times.length && originalTime == this.times[loopI]) continue;
            removeMe.add(i);
        }
        return removeMe;
    }

    public void addDeletedTimeSlots(TimeWindowMap timeWindowMap, Calendar cal) {
        List<Integer> removeMe = this.getDeletedTimeIndexes();
        int removeStart = -1;
        int removeEnd = -1;
        for (int index : removeMe) {
            if (removeStart == -1) {
                removeStart = index;
                continue;
            }
            if (removeEnd == -1) {
                if (index - removeStart == 1) {
                    removeEnd = index;
                    continue;
                }
                this.addWindow(removeStart, removeStart, timeWindowMap, cal);
                removeStart = index;
                continue;
            }
            if (index - removeEnd == 1) {
                removeEnd = index;
                continue;
            }
            this.addWindow(removeStart, removeEnd, timeWindowMap, cal);
            removeStart = index;
            removeEnd = -1;
        }
        if (removeEnd != -1) {
            this.addWindow(removeStart, removeEnd, timeWindowMap, cal);
        } else if (removeStart != -1) {
            this.addWindow(removeStart, removeStart, timeWindowMap, cal);
        }
    }

    private void addWindow(int start, int end, TimeWindowMap timeWindowMap, Calendar cal) {
        HecTime hecTimeStart = new HecTime(this._originalTimes[start], 11);
        long initialStartTimeInMillis = hecTimeStart.getTimeInMillis(cal);
        Date startDate = new Date(initialStartTimeInMillis);
        HecTime hecTimeEnd = new HecTime(this._originalTimes[end], 11);
        long initialEndTimeInMillis = hecTimeEnd.getTimeInMillis(cal);
        Date endDate = new Date(initialEndTimeInMillis);
        timeWindowMap.addTimeWindow(startDate, true, endDate, true);
    }

    public int getCurveCount() {
        double[] rawData = this.getRawData();
        if (rawData == null) {
            return 3;
        }
        return 4;
    }

    String getToolTipText(int row, int column) {
        String retval = "";
        if (column == this.getRawQualityColumnIndex()) {
            int idx = this.getRawIndex(row);
            retval = this.getQualityHtmlStringDescription(this.rawQuality, idx);
        } else if (column == this.getValueQualityColumnIndex()) {
            int idx = this.getValueIndex(row);
            retval = this.getQualityHtmlStringDescription(this.valueQuality, idx);
        } else if (column == this.getValueTestColumnIndex()) {
            int idx = this.getValueIndex(row);
            retval = this.getQualityHtmlStringDescription(this.valueQuality, idx);
        } else if (column == this.getEstimateQualityColumnIndex()) {
            int idx = row;
            retval = this.getQualityHtmlStringDescription(this.estimateQuality, idx);
        } else if (column == this.getRevisedQualityColumnIndex()) {
            int idx = row;
            retval = this.getQualityHtmlStringDescription(this.revisedQuality, idx);
        } else {
            Object o = this.getValueAt(row, column);
            if (o != null) {
                retval = o.toString();
            }
        }
        return retval;
    }

    private String getQualityHtmlStringDescription(int[] qual, int idx) {
        String retval = "Has no quality";
        if (qual != null && idx >= 0 && idx < qual.length) {
            retval = QualityStringRenderer.getHtmlStringDescription((int)qual[idx]);
        }
        return retval;
    }

    public boolean addConstantEstimate(int[] rows, double constant) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int qualityColumn = this.getEstimateQualityColumnIndex();
        IntSummaryStatistics stats = IntStream.of(rows).filter(row -> row >= 0 && row < this.estimateData.length).filter(row -> NumericalConstants.isValidValue((double)this.estimateData[row])).filter(row -> this.getValueIndex(row) != -1).filter(row -> this.isCellEditable(row, estimateDataCol)).map(row -> {
            int n = row;
            this.estimateData[n] = this.estimateData[n] + constant;
            if (qualityColumn >= 0) {
                this.setEstimateFlag(row, "K");
            }
            return row;
        }).summaryStatistics();
        boolean output = false;
        if (stats.getCount() > 0L) {
            output = true;
            int max = stats.getMax();
            int min = stats.getMin();
            this.fireTableRowsUpdated(min, max);
        }
        return output;
    }

    public boolean multiplyByFactor(int[] rows, double factor) {
        if (rows == null || rows.length == 0) {
            return false;
        }
        int estimateDataCol = this.getEstimateDataColumnIndex();
        int qualityColumn = this.getEstimateQualityColumnIndex();
        IntSummaryStatistics stats = IntStream.of(rows).filter(row -> row >= 0 && row < this.estimateData.length).filter(row -> NumericalConstants.isValidValue((double)this.estimateData[row])).filter(row -> this.getValueIndex(row) != -1).filter(row -> this.isCellEditable(row, estimateDataCol)).map(row -> {
            int n = row;
            this.estimateData[n] = this.estimateData[n] * factor;
            if (qualityColumn >= 0) {
                this.setEstimateFlag(row, "K");
            }
            return row;
        }).summaryStatistics();
        boolean output = false;
        if (stats.getCount() > 0L) {
            output = true;
            int max = stats.getMax();
            int min = stats.getMin();
            this.fireTableRowsUpdated(min, max);
        }
        return output;
    }
}

