/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import com.google.common.flogger.FluentLogger;
import hec.data.DataSetIllegalArgumentException;
import hec.data.ParamDouble;
import hec.data.Parameter;
import hec.data.Units;
import hec.dataui.tx.awt.VerifyTSDataSetBase;
import hec.dataui.tx.awt.VerifyTimeSeriesGlyph;
import hec.gfx2d.G2dGlyphFactory;
import hec.heclib.util.HecTime;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerFactory;
import java.io.Serializable;
import java.util.Arrays;
import java.util.TimeZone;
import mil.army.usace.hec.data.timeseries.Quality;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.TimeSeriesFactory;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesIllegalArgumentException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import rma.lang.RmaMath;
import rma.util.RMAConst;

public class VerifyTimeSeriesDataSet
extends VerifyTSDataSetBase {
    private static final FluentLogger LOGGER;
    private static final long serialVersionUID = -8562640339243355396L;
    private static final int DATE_TIME_COLUMN = 0;
    private static final int RAW_DATA_COLUMN = 1;
    private static final int RAW_QUALITY_COLUMN = 2;
    private static final int VALUE_DATA_COLUMN = 3;
    private static final int VALUE_QUALITY_COLUMN = 4;
    private static final int VALUE_TEST_COLUMN = 5;
    private static final int ESTIMATE_DATA_COLUMN = 6;
    private static final int ESTIMATE_QUALITY_COLUMN = 7;
    private static final int REVISED_DATA_COLUMN = 8;
    private static final int REVISED_QUALITY_COLUMN = 9;
    private TimeSeriesTemplate _valueTxTemplate;
    private TimeSeriesContainer _timeSeriesContainer;

    public VerifyTimeSeriesDataSet(int retrStartTime, int retrEndTime, TimeSeriesContainer raw, TimeSeriesContainer tsc) {
        this(retrStartTime, retrEndTime, raw, tsc, true);
    }

    public VerifyTimeSeriesDataSet(int retrStartTime, int retrEndTime, TimeSeriesContainer raw, TimeSeriesContainer tsc, boolean buildEstimate) {
        super(tsc.getShortName(), retrStartTime, retrEndTime);
        String paramName;
        this.setEditableData(false);
        this._timeSeriesContainer = tsc;
        String[] columnNames = new String[]{"Date/Time\n(%S)", " ", "Qual", " ", "Qual", "Test", " ", "Qual", " ", "Qual"};
        this.setRegularIntervalData(tsc.interval > 0);
        boolean isInstantaneous = true;
        if (tsc.type != null && tsc.type.length() > 0 && tsc.type.indexOf("INST") < 0) {
            isInstantaneous = false;
        }
        this.setInstantaneous(isInstantaneous);
        String rawUnitsLabel = " ";
        if (raw != null) {
            rawUnitsLabel = "(%S)";
        }
        if (Parameter.isNotValid((String)(paramName = tsc.getParameterName()))) {
            String[] params;
            for (String aParam : params = Parameter.getAvailableParameters()) {
                if (!paramName.toLowerCase().startsWith(aParam.toLowerCase())) continue;
                paramName = aParam;
                break;
            }
            tsc.parameter = paramName;
        }
        String param = tsc.getParameterName();
        try {
            Parameter parameter = new Parameter(param);
            this.setYParameterId(parameter.getParameterId());
            param = parameter.getBaseParameter();
        }
        catch (DataSetIllegalArgumentException parameter) {
            // empty catch block
        }
        Object uLabel = Parameter.isNotValid((String)param) ? tsc.units : param + " (%S)";
        columnNames[1] = rawUnitsLabel;
        columnNames[0] = "Date/Time\n(%S)";
        columnNames[3] = uLabel;
        columnNames[6] = uLabel;
        columnNames[8] = uLabel;
        this.setColumnNames(columnNames);
        String realUnits = Units.getUnitsForAlias((String)tsc.units);
        int unitSystem = Units.getUnitSystemForUnits((String)realUnits);
        if (unitSystem != 0) {
            this.setUnitSystem(unitSystem);
        }
        this.setYUnits((String)uLabel);
        if (tsc.timeZoneID != null && !tsc.timeZoneID.equals("")) {
            int tscmilliOffset = tsc.timeZoneRawOffset;
            TimeZone timeZone = TimeZone.getTimeZone(tsc.timeZoneID);
            this.setTimeZone(timeZone);
        } else {
            TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
            int tzOffset = 0;
            gmtTimeZone.setRawOffset(tzOffset);
            this.setTimeZone(gmtTimeZone);
        }
        this.setValueData(tsc.values, tsc.quality);
        this.setValueTimes(tsc.times);
        if (raw != null) {
            this.setRawData(raw.times, raw.values, raw.quality);
            this._rawName = raw.location + "-" + raw.version;
        }
        if (buildEstimate) {
            this.buildEstimates();
        }
    }

    public VerifyTimeSeriesDataSet(String name, int retrStart, int retrEnd, TimeSeries rawTx, TimeSeriesTemplate valueTxTemplate) {
        super(name, retrStart, retrEnd);
        String unitsLabel;
        this.setEditableData(false);
        this._valueTxTemplate = valueTxTemplate;
        String[] columnNames = new String[]{"Date/Time\n(%S)", " ", "Qual", " ", "Qual", "Test", " ", "Qual", " ", "Qual"};
        if (this._valueTxTemplate != null) {
            this.setRegularIntervalData(this._valueTxTemplate.getTimeSeriesIdentifier().getInterval().isRegular());
            this.setInstantaneous(this._valueTxTemplate.getTimeSeriesIdentifier().getParameterType().isInstantaneous());
        }
        String rawUnitsLabel = " ";
        int rawParamid = -1;
        if (rawTx != null) {
            TimeSeriesIdentifier timeSeriesIdentifier = rawTx.getTimeSeriesIdentifier();
            rawParamid = timeSeriesIdentifier.getParameter().getParameterId();
            rawUnitsLabel = "(%S)";
            this._rawName = timeSeriesIdentifier.getLocationId().getLocation() + "-" + timeSeriesIdentifier.getVersion().getVersion();
        }
        columnNames[1] = rawUnitsLabel;
        columnNames[0] = "Date/Time\n(%S)";
        columnNames[3] = unitsLabel = "(%S)";
        columnNames[6] = unitsLabel;
        columnNames[8] = unitsLabel;
        this.setColumnNames(columnNames);
        if (this._valueTxTemplate == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Empty time series for validation editor");
            return;
        }
        int paramid = this._valueTxTemplate.getTimeSeriesIdentifier().getParameter().getParameterId();
        this.setYParameterId(paramid);
        int numCols = columnNames.length;
        int[] paramIds = new int[numCols];
        paramIds[0] = -1;
        paramIds[1] = rawParamid;
        paramIds[3] = paramid;
        paramIds[6] = paramid;
        paramIds[8] = paramid;
        this.setColumnParameters(paramIds);
        this.setYUnits(this._valueTxTemplate.getUnits().toString());
        int unitSystem = Units.getUnitSystemForUnits((String)this._valueTxTemplate.getUnits().toString());
        if (unitSystem != 0) {
            this.setUnitSystem(unitSystem);
        } else {
            this.setUnitSystem(2);
        }
        String param = this._valueTxTemplate.getTimeSeriesIdentifier().getParameter().getBaseParameter();
        String uLabel = param + " (%S)";
        this.setYUnits(uLabel);
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        int tzOffset = 0;
        gmtTimeZone.setRawOffset(tzOffset);
        this.setTimeZone(gmtTimeZone);
    }

    public VerifyTimeSeriesDataSet(String name, int retrStart, int retrEnd, TimeSeries rawTx, TimeSeries valueTxTemplate, boolean buildEstimate) throws DataSetTimeSeriesException {
        this(name, retrStart, retrEnd, rawTx, VerifyTimeSeriesDataSet.extractTemplate(valueTxTemplate));
        int[] valueTimes = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)valueTxTemplate).getTimes().getIntArray();
        double[] valueY = valueTxTemplate.getValues();
        int[] valQual = valueTxTemplate.getQuality().map(Quality::getIntQuality).orElse(null);
        this.setValueData(valueY, valQual);
        this.setValueTimes(valueTimes);
        if (rawTx != null) {
            int[] rawTimes = TimeSeriesContainerFactory.toTimeSeriesContainer((TimeSeries)rawTx).getTimes().getIntArray();
            double[] rawY = rawTx.getValues();
            int[] rawQual = rawTx.getQuality().map(Quality::getIntQuality).orElse(null);
            super.setRawData(rawTimes, rawY, rawQual);
        }
        if (buildEstimate) {
            this.buildEstimates();
        }
    }

    private static TimeSeriesTemplate extractTemplate(TimeSeries timeSeries) {
        try {
            return new TimeSeriesTemplate(timeSeries.getTimeSeriesIdentifier(), timeSeries.getStartTime().toInstant().toEpochMilli(), timeSeries.getEndTime().toInstant().toEpochMilli(), timeSeries.getUnits());
        }
        catch (DataSetTimeSeriesIllegalArgumentException e) {
            throw new DataSetIllegalArgumentException((Exception)((Object)e));
        }
    }

    private void buildEstimates() {
        int[] fromTimes = this.getValueTimes();
        int[] fromQuality = this.getValueQuality();
        int[] interpQuality = null;
        if (fromQuality != null) {
            interpQuality = new int[fromQuality.length];
        }
        double[] fromValues = this.getValueData();
        double[] interpVals = new double[fromValues.length];
        Arrays.fill(interpVals, -3.4028234663852886E38);
        int firstGoodIdx = -1;
        byte[] bytes = new byte[4];
        for (int ii = 0; ii < fromTimes.length; ++ii) {
            boolean tf = RMAConst.isValidValue((double)fromValues[ii]);
            if (fromQuality != null) {
                try {
                    bytes = Quality.getBytes((int)fromQuality[ii]);
                    tf = tf && Quality.isNotMissing((byte[])bytes) && Quality.isNotQuestion((byte[])bytes) && Quality.isNotReject((byte[])bytes);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!tf) continue;
            if (firstGoodIdx == -1) {
                firstGoodIdx = ii;
                continue;
            }
            if (ii == firstGoodIdx + 1) {
                firstGoodIdx = ii;
                continue;
            }
            long firstTime = fromTimes[firstGoodIdx];
            double firstVal = fromValues[firstGoodIdx];
            long lastTime = fromTimes[ii];
            double lastVal = fromValues[ii];
            for (int jj = firstGoodIdx + 1; jj < ii; ++jj) {
                long interpTime = fromTimes[jj];
                double interpValue = RmaMath.linearInterpolate((double)firstTime, (double)firstVal, (double)lastTime, (double)lastVal, (double)interpTime);
                if (!RMAConst.isValidValue((double)interpValue)) continue;
                interpVals[jj] = interpValue;
                if (fromQuality == null) continue;
                try {
                    bytes = Quality.getBytes((int)fromQuality[jj]);
                    Quality.setReplaceLinearInterpolation((byte[])bytes);
                    interpQuality[jj] = Quality.getInteger((byte[])bytes);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            firstGoodIdx = ii;
        }
        super.setEstimateData(interpVals, interpQuality);
    }

    @Override
    public int getIntervalMinutes() {
        if (this._valueTxTemplate != null) {
            return this._valueTxTemplate.getTimeSeriesIdentifier().getInterval().getMinutes();
        }
        return this._timeSeriesContainer.interval;
    }

    @Override
    public int getDateTimeColumnIndex() {
        return 0;
    }

    @Override
    public int getRawDataColumnIndex() {
        return 1;
    }

    @Override
    public int getRawQualityColumnIndex() {
        return 2;
    }

    @Override
    public int getValueDataColumnIndex() {
        return 3;
    }

    @Override
    public int getValueQualityColumnIndex() {
        return 4;
    }

    @Override
    public int getValueTestColumnIndex() {
        return 5;
    }

    @Override
    public int getEstimateDataColumnIndex() {
        return 6;
    }

    @Override
    public int getEstimateQualityColumnIndex() {
        return 7;
    }

    @Override
    public int getRevisedDataColumnIndex() {
        return 8;
    }

    @Override
    public int getRevisedQualityColumnIndex() {
        return 9;
    }

    public boolean isAverage() {
        if (this._valueTxTemplate != null) {
            return this._valueTxTemplate.getTimeSeriesIdentifier().getParameterType().isAverage();
        }
        return false;
    }

    @Override
    public void setPrecision(int precision) {
        this._precision = precision;
        int nrows = this.getRowCount();
        int ncols = this.getColumnCount();
        for (int irow = 0; irow < nrows; ++irow) {
            for (int icol = 0; icol < ncols; ++icol) {
                Object obj = this.getValueAt(irow, icol);
                if (obj == null || !(obj instanceof ParamDouble)) continue;
                ParamDouble pd = (ParamDouble)obj;
                pd.setPrecision(precision);
                this.setValueAt(pd, irow, icol);
            }
        }
    }

    @Override
    public int getNextFlaggedValue(int currentRow, boolean searchDown) {
        super.getNextFlaggedValue(currentRow, searchDown);
        int size = this.size();
        int[] valQual = this.getValueQuality();
        byte[] bytes = new byte[4];
        if (searchDown) {
            for (int i = currentRow + 1; i < size; ++i) {
                int valIdx = this.getValueIndex(i);
                if (valIdx == -1) continue;
                int qual = valQual[valIdx];
                Quality.getBytes((int)qual, (byte[])bytes);
                boolean isOk = Quality.isOkay((byte[])bytes);
                if (qual == 0 || isOk) continue;
                return i;
            }
        } else {
            for (int i = currentRow - 1; i >= 0; --i) {
                int valIdx = this.getValueIndex(i);
                if (valIdx == -1) continue;
                int qual = valQual[valIdx];
                Quality.getBytes((int)qual, (byte[])bytes);
                boolean isOk = Quality.isOkay((byte[])bytes);
                if (qual == 0 || isOk) continue;
                return i;
            }
        }
        return -1;
    }

    public Serializable storeRevisedData() {
        if (this._timeSeriesContainer != null) {
            return this.storeRevisedDssData();
        }
        int[] itimes = this.getTimes();
        double[] revData = this.getRevisedData();
        if (revData == null) {
            return null;
        }
        int[] revQual = this.getRevisedQuality();
        int icnt = revData.length;
        double[] newValues = new double[icnt];
        long[] newMilliTimes = new long[icnt];
        Quality newQuality = null;
        if (revQual != null) {
            newQuality = new Quality(icnt);
        }
        HecTime hecTime = new HecTime();
        icnt = 0;
        for (int i = 0; i < itimes.length; ++i) {
            long milliTim;
            int valIdx = this.getValueIndex(i);
            if (valIdx == -1) continue;
            hecTime.set(itimes[i]);
            newMilliTimes[icnt] = milliTim = hecTime.getTimeInMillis(0);
            newValues[icnt] = revData[valIdx];
            if (revQual != null) {
                newQuality.setIntegerAt(revQual[valIdx], icnt);
            }
            ++icnt;
        }
        TimeSeriesIdentifier desc = this._valueTxTemplate.getTimeSeriesIdentifier();
        mil.army.usace.hec.metadata.Units units = this._valueTxTemplate.getUnits();
        TimeSeries revisedTx = null;
        try {
            revisedTx = TimeSeriesFactory.buildTimeSeries((TimeSeriesTemplate)new TimeSeriesTemplate(desc, units), (long[])newMilliTimes, (double[])newValues, (Quality)newQuality);
        }
        catch (DataSetException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error creating Revised TimeSeries " + e);
            return null;
        }
        return revisedTx;
    }

    public TimeSeriesContainer storeRevisedDssData() {
        boolean hasQual;
        int[] itimes = this.getTimes();
        double[] revData = this.getRevisedData();
        int[] revQual = this.getRevisedQuality();
        int icnt = revData.length;
        int[] newTimes = new int[icnt];
        double[] newValues = new double[icnt];
        int[] newQualities = null;
        boolean bl = hasQual = this._timeSeriesContainer.quality != null;
        if (hasQual) {
            newQualities = new int[icnt];
        }
        icnt = 0;
        for (int i = 0; i < itimes.length; ++i) {
            int valIdx = this.getValueIndex(i);
            if (valIdx == -1) continue;
            newTimes[icnt] = itimes[i];
            newValues[icnt] = revData[valIdx];
            if (revQual != null) {
                newQualities[icnt] = revQual[valIdx];
            }
            ++icnt;
        }
        TimeSeriesContainer newtsc = (TimeSeriesContainer)this._timeSeriesContainer.clone();
        newtsc.times = newTimes;
        if (newTimes != null && newTimes.length > 0) {
            newtsc.startTime = newTimes[0];
            newtsc.endTime = newTimes[newTimes.length - 1];
        }
        newtsc.values = newValues;
        newtsc.numberValues = newTimes.length;
        if (hasQual) {
            newtsc.quality = newQualities;
        }
        return newtsc;
    }

    @Override
    public void setScaleToRawData(boolean tf) {
        this._scaleToRawData = tf;
        this.bounds = null;
    }

    public boolean canSwapXYValues() {
        return false;
    }

    public boolean swapXYValues() {
        return false;
    }

    public void setSwapXYValues(boolean b) {
    }

    public void rawFillForEstimate(int[] rows) {
        if (rows == null || rows.length < 1) {
            return;
        }
        int estimateDataCol = this.getEstimateDataColumnIndex();
        double[] estData = this.getEstimateData();
        double[] rawData = this.getRawData();
        for (int ii = 0; ii < rows.length; ++ii) {
            if (!this.isCellEditable(rows[ii], estimateDataCol)) continue;
            try {
                int rawIdx;
                int valIdx = this.getValueIndex(rows[ii]);
                if (valIdx == -1 || (rawIdx = this.getRawIndex(rows[ii])) == -1) continue;
                estData[valIdx] = rawData[rawIdx];
                this.setEstimateFlag(rows[ii], "K");
                continue;
            }
            catch (Exception e) {
                return;
            }
        }
        this.fireTableRowsUpdated(rows[0], rows[rows.length - 1]);
    }

    static {
        G2dGlyphFactory.addMapping((String)VerifyTimeSeriesDataSet.class.getName(), (String)VerifyTimeSeriesGlyph.class.getName());
        LOGGER = FluentLogger.forEnclosingClass();
    }
}

