/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.awt;

import hec.data.DataSetException;
import hec.data.ParamDouble;
import hec.data.Units;
import hec.dataui.tx.awt.TimeSeriesEditorDataSet;
import hec.dataui.tx.awt.VerifyTSDataSetBase;
import hec.dataui.tx.awt.VerifyTimeSeriesDataSet;
import hec.geometry.IScale;
import hec.geometry.LocalPt;
import hec.geometry.Scale;
import hec.gfx2d.G2dEditGlyph;
import hec.gfx2d.G2dLine;
import hec.gfx2d.G2dLineProperties;
import hec.gfx2d.G2dObject;
import hec.gfx2d.G2dVerifyLine;
import hec.gfx2d.ObjectSelectionEvent;
import hec.gfx2d.Symbol;
import hec.gfx2d.Viewport;
import hec.heclib.util.HecTime;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import mil.army.usace.hec.data.timeseries.Quality;
import rma.swing.RmaJTitledSeparator;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class VerifyTimeSeriesGlyph
extends G2dEditGlyph
implements TableModelListener,
ActionListener {
    public static final Color RAW_COLOR = Color.green.darker();
    public static final Color ORIGINAL_COLOR = Color.red;
    public static final Color ESTIMATE_COLOR = Color.magenta;
    public static final Color REVISED_COLOR = Color.blue;
    public static final int OBJECT_SELECT = 1;
    public static final int OBJECT_POPUP = 2;
    public static final int EDITING_SELECT = 3;
    public static final int EDITING_RIGHT_CLICK = 4;
    public static final int MAX_SELECT = 100;
    public static final int LINEAR = 0;
    public static final int STEP = 1;
    private static final long serialVersionUID = -3633236878554095810L;
    private static final double TOL = 6.0;
    protected VerifyTSDataSetBase _verifyTsData;
    protected G2dVerifyLine _line = null;
    protected G2dVerifyLine _selectedLine = null;
    protected G2dVerifyLine _rawLine = null;
    protected G2dVerifyLine _valueLine = null;
    protected G2dVerifyLine _estimateLine = null;
    protected G2dVerifyLine _revisedLine = null;
    protected int[] _timeIndexes = new int[100];
    protected int _nselect = 0;
    LocalPt _oldPt = new LocalPt();
    LocalPt _newPt = new LocalPt();
    int _timeIdx = -1;
    byte[] bytes = new byte[4];
    private byte[] _isel = null;
    private LocalPt _refPt = null;
    private int _curveType = 0;
    private double[] xarray = new double[10000];
    private double[] yarray = new double[10000];

    public VerifyTimeSeriesGlyph(Viewport view, VerifyTimeSeriesDataSet map, Scale scl) {
        this(view, (VerifyTSDataSetBase)map, scl);
        double[] rawData = map.getRawData();
        if (rawData != null && !this._verifyTsData.isDirectEdit()) {
            this._rawLine = (G2dVerifyLine)this._lineArray[3];
            this._rawLine.setColor(RAW_COLOR);
        }
    }

    public VerifyTimeSeriesGlyph(Viewport view, TimeSeriesEditorDataSet map, Scale scl) {
        this(view, (VerifyTSDataSetBase)map, scl);
    }

    public VerifyTimeSeriesGlyph(Viewport view, VerifyTSDataSetBase map, Scale scl) {
        super(view, (G2dObject)map, scl);
        G2dLine[] temp;
        this._verifyTsData = map;
        this._curveType = 0;
        if (!this._verifyTsData.isInstantaneous()) {
            this._curveType = 1;
        }
        double[] valueData = this._verifyTsData.getValueData();
        double[] revisedData = this._verifyTsData.getRevisedData();
        double[] estimateData = this._verifyTsData.getEstimateData();
        if (valueData != null) {
            this._valueLine = (G2dVerifyLine)this._lineArray[0];
            this._valueLine.setColor(ORIGINAL_COLOR);
        }
        if (estimateData != null) {
            if (this._lineArray.length < 2) {
                temp = new G2dLine[2];
                System.arraycopy(this._lineArray, 0, temp, 0, this._lineArray.length);
                this._lineArray = temp;
                this._lineArray[1] = this.createG2dLine();
                this._lineArray[1].setScale((IScale)this._scale);
            }
            this._estimateLine = (G2dVerifyLine)this._lineArray[1];
            this._estimateLine.setColor(ESTIMATE_COLOR);
            this._estimateLine.setSymbolsVisible(true);
            this._estimateLine.setLineVisible(false);
        }
        if (revisedData != null) {
            if (this._lineArray.length < 3) {
                temp = new G2dLine[3];
                System.arraycopy(this._lineArray, 0, temp, 0, this._lineArray.length);
                this._lineArray = temp;
                this._lineArray[2] = this.createG2dLine();
                this._lineArray[2].setScale((IScale)this._scale);
            }
            this._revisedLine = (G2dVerifyLine)this._lineArray[2];
            this._revisedLine.setColor(REVISED_COLOR);
        }
        this._nselect = 0;
        this._verifyTsData.addTableModelListener(this);
    }

    private static int[] growTheArray(int[] array) {
        int npts = array.length;
        if (npts < 100) {
            npts = 100;
        }
        int[] newArray = new int[npts * 2];
        System.arraycopy(array, 0, newArray, 0, npts);
        return newArray;
    }

    protected G2dLine createG2dLine() {
        return new G2dVerifyLine();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 1 || e.getType() == -1) {
            if (e.getType() == -1) {
                this._nselect = 0;
            }
            this._viewport.repaint();
        }
    }

    public String getCurveName(int curveIndex) {
        double[] rawData = this._verifyTsData.getRawData();
        String rawName = this._verifyTsData.getRawName();
        String name = null;
        StringBuffer sb = new StringBuffer();
        if (name != null) {
            sb.append(name);
            sb.append("-");
        }
        if (this._verifyTsData.isDirectEdit()) {
            sb.append(this._verifyTsData.getName());
        } else if (rawData != null) {
            switch (curveIndex) {
                case 0: {
                    sb.append("Raw");
                    if (rawName == null) break;
                    sb.append("-");
                    sb.append(rawName);
                    break;
                }
                case 1: {
                    sb.append("Original");
                    break;
                }
                case 2: {
                    sb.append("Estimate/Entry");
                    break;
                }
                case 3: {
                    sb.append("Revised");
                }
            }
        } else {
            switch (curveIndex) {
                case 0: {
                    sb.append("Original");
                    break;
                }
                case 1: {
                    sb.append("Estimate/Entry");
                    break;
                }
                case 2: {
                    sb.append("Revised");
                }
            }
        }
        return sb.toString();
    }

    public void draw(Graphics g) {
        Rectangle rect = this.getVisibleRect();
        double[] rawData = null;
        int[] rawQual = null;
        int[] rawIndexes = null;
        if (this._verifyTsData instanceof VerifyTimeSeriesDataSet) {
            rawIndexes = this._verifyTsData.getRawIndexes();
            rawData = this._verifyTsData.getRawData();
            rawQual = this._verifyTsData.getRawQuality();
        }
        this.makeEstimateLine();
        if (rawData != null) {
            this.drawData(rawIndexes, rawData, rawQual, this._rawLine, new HashSet(rect.width), new HashSet(rect.width), g, rect, true);
        }
        int[] valIndexes = this._verifyTsData.getValueIndexes();
        double[] estimateData = this._verifyTsData.getEstimateData();
        int[] estimateQual = this._verifyTsData.getEstimateQuality();
        this.drawData(valIndexes, estimateData, estimateQual, this._estimateLine, new HashSet(rect.width), new HashSet(rect.width), g, rect, false);
        double[] valueData = this._verifyTsData.getValueData();
        int[] valueQual = this._verifyTsData.getValueQuality();
        this.drawData(valIndexes, valueData, valueQual, this._valueLine, new HashSet(rect.width), new HashSet(rect.width), g, rect, true);
        double[] revisedData = this._verifyTsData.getRevisedData();
        int[] revisedQual = this._verifyTsData.getRevisedQuality();
        this.drawData(valIndexes, revisedData, revisedQual, this._revisedLine, new HashSet(rect.width), new HashSet(rect.width), g, rect, true);
        this.drawSelected(g, rect);
    }

    private void drawData(int[] indexes, double[] ydata, int[] qual, G2dVerifyLine line, HashSet drawnSymbols, HashSet drawnLinePoints, Graphics g, Rectangle rect, boolean calcLine) {
        int i;
        double dy;
        double dx;
        if (ydata == null || line == null) {
            return;
        }
        int number = 0;
        if (calcLine) {
            line.clearLineData();
        }
        int[] times = this._verifyTsData.getTimes();
        int start = (int)this._scale.x2e(rect.x);
        int len = (int)this._scale.x2e(rect.x + rect.width);
        int istart = Arrays.binarySearch(times, start);
        int ilen = Arrays.binarySearch(times, len);
        if (istart < 0) {
            istart = -1 * istart - 1;
        }
        if (ilen < 0) {
            ilen = -1 * ilen - 1;
        }
        if (istart - 1 >= 0) {
            --istart;
        }
        if (ilen + 1 <= times.length) {
            ++ilen;
        }
        if (istart == ilen) {
            return;
        }
        if (line.isLineVisible()) {
            boolean needNewSegment = false;
            if (calcLine) {
                for (int i2 = istart; i2 < ilen; ++i2) {
                    int scaledy;
                    int valIdx = i2;
                    if (indexes != null) {
                        valIdx = indexes[i2];
                    }
                    if (valIdx == -1) continue;
                    dx = times[i2];
                    dy = ydata[valIdx];
                    if (!(RMAConst.isValidValue((double)dx) && RMAConst.isValidValue((double)dy) && RMAConst.isValidValue((float)((float)dy)))) {
                        if (number <= 0) continue;
                        if (needNewSegment) {
                            line.addLineSegment(this.xarray, this.yarray, number);
                        } else {
                            line.addLineData(this.xarray, this.yarray, number);
                        }
                        needNewSegment = true;
                        number = 0;
                        continue;
                    }
                    int scaledx = this._scale.e2x(dx);
                    long lxy = (long)scaledx | (long)(scaledy = this._scale.n2y(dy)) << 32;
                    Long xy = new Long(lxy);
                    if (drawnLinePoints.contains(xy)) continue;
                    this.xarray[number] = dx;
                    this.yarray[number] = dy;
                    drawnLinePoints.add(xy);
                    if (++number < 10000) continue;
                    if (needNewSegment) {
                        line.addLineSegment(this.xarray, this.yarray, number);
                        needNewSegment = false;
                    } else {
                        line.addLineData(this.xarray, this.yarray, number);
                    }
                    number = 0;
                }
            }
            if (number > 0) {
                if (needNewSegment) {
                    line.addLineSegment(this.xarray, this.yarray, number);
                } else {
                    line.addLineData(this.xarray, this.yarray, number);
                }
            }
            G2dLineProperties prop = line.getProperties();
            prop._lineStepStyle = this._curveType == 1 ? 1 : 0;
            line.setProperties(prop);
            line.drawLine(g, rect);
        }
        if (this._isel == null || this._isel.length < ilen) {
            this._isel = new byte[ilen];
        }
        for (i = 0; i < ilen; ++i) {
            this._isel[i] = 0;
        }
        if (line == this._selectedLine && this._nselect > 0) {
            for (i = 0; i < this._nselect; ++i) {
                this._isel[this._timeIndexes[i]] = 1;
            }
        }
        Rectangle symRect = new Rectangle(rect);
        symRect.grow(1, 1);
        number = 0;
        G2dLineProperties qProp = line._questionableProperties;
        G2dLineProperties rProp = line._rejectedProperties;
        G2dLineProperties mProp = line._missingProperties;
        G2dLineProperties aProp = line._acceptableProperties;
        int deviceResolution = this.getDeviceResolution();
        for (int i3 = istart; i3 < ilen; ++i3) {
            boolean noQual;
            int scaledy;
            int scaledx;
            long lxy;
            Long xy;
            if (this._isel[i3] == 1) continue;
            int valIdx = i3;
            if (indexes != null) {
                valIdx = indexes[i3];
            }
            if (valIdx == -1) continue;
            dx = times[i3];
            dy = ydata[valIdx];
            if (!RMAConst.isValidValue((double)dx) || !RMAConst.isValidValue((double)dy) || !RMAConst.isValidValue((float)((float)dy)) || drawnSymbols.contains(xy = new Long(lxy = (long)(scaledx = this._scale.e2x(dx)) | (long)(scaledy = this._scale.n2y(dy)) << 32)) || !symRect.contains(scaledx, scaledy)) continue;
            G2dLineProperties prop = null;
            int q = 0;
            if (qual != null) {
                q = qual[valIdx];
            }
            Quality.getBytes((int)q, (byte[])this.bytes);
            boolean iFlag = Quality.isInterpolated((byte[])this.bytes);
            boolean kFlag = Quality.isKeyboardInput((byte[])this.bytes);
            boolean eFlag = Quality.isGraphicalEstimate((byte[])this.bytes);
            boolean aFlag = Quality.isAccepted((byte[])this.bytes);
            boolean pFlag = false;
            boolean rFlag = false;
            boolean qFlag = false;
            boolean mFlag = false;
            if (Quality.isScreened((byte[])this.bytes)) {
                pFlag = Quality.isProtected((byte[])this.bytes);
                rFlag = Quality.isReject((byte[])this.bytes);
                qFlag = Quality.isQuestion((byte[])this.bytes);
                mFlag = Quality.isMissing((byte[])this.bytes);
            }
            boolean bl = noQual = q == 0;
            if (iFlag || kFlag || eFlag || noQual || aFlag || pFlag) {
                prop = aProp;
            }
            if (rFlag) {
                prop = rProp;
            }
            if (qFlag) {
                prop = qProp;
            }
            if (mFlag || line == this._estimateLine) {
                prop = mProp;
            }
            if (prop == null) continue;
            int symbolType = prop._symbolType;
            Color lineColor = prop._pointLineColor;
            Color fillColor = prop._pointFillColor;
            float symbolSize = prop._symbolSize;
            Symbol.draw2((Graphics)g, (int)scaledx, (int)scaledy, (int)symbolType, (Color)lineColor, (Color)fillColor, (float)symbolSize, (int)deviceResolution);
            drawnSymbols.add(xy);
        }
    }

    private void makeEstimateLine() {
        double[] ydata = this._verifyTsData.getEstimateData();
        if (ydata == null || this._estimateLine == null) {
            return;
        }
        int number = 0;
        this._estimateLine.clearLineData();
        int[] times = this._verifyTsData.getTimes();
        for (int i = 0; i < times.length; ++i) {
            int valIdx = this._verifyTsData.getValueIndex(i);
            if (valIdx == -1) continue;
            double dx = times[i];
            double dy = ydata[valIdx];
            if (!RMAConst.isValidValue((double)dx) || !RMAConst.isValidValue((double)dy) || !RMAConst.isValidValue((float)((float)dy))) continue;
            this.xarray[number] = dx;
            this.yarray[number] = dy;
            if (++number != 10000) continue;
            this._estimateLine.addLineData(this.xarray, this.yarray, number);
            number = 0;
        }
        if (number > 0) {
            this._estimateLine.addLineData(this.xarray, this.yarray, number);
        }
    }

    protected void drawSelected(Graphics g, Rectangle rect) {
        if (this._revisedLine == null || this._selectedLine == null || this._nselect < 1) {
            return;
        }
        G2dVerifyLine line = this._selectedLine;
        double[] ydata = null;
        int[] qual = null;
        int[] times = this._verifyTsData.getTimes();
        if (this._selectedLine == this._estimateLine) {
            qual = this._verifyTsData.getEstimateQuality();
            ydata = this._verifyTsData.getEstimateData();
        } else {
            qual = this._verifyTsData.getRevisedQuality();
            ydata = this._verifyTsData.getRevisedData();
        }
        Rectangle symRect = new Rectangle(rect);
        symRect.grow(1, 1);
        byte[] bytes = new byte[4];
        for (int j = 0; j < this._nselect; ++j) {
            int iy;
            int row = this._timeIndexes[j];
            int valIdx = this._verifyTsData.getValueIndex(row);
            if (valIdx == -1 || !RMAConst.isValidValue((double)ydata[valIdx])) continue;
            G2dLineProperties prop = line.getProperties();
            prop.setDrawLine(false);
            prop.setDrawPoints(true);
            if (qual != null) {
                Quality.getBytes((int)qual[valIdx], (byte[])bytes);
            }
            boolean iFlag = Quality.isInterpolated((byte[])bytes);
            boolean kFlag = Quality.isKeyboardInput((byte[])bytes);
            boolean eFlag = Quality.isGraphicalEstimate((byte[])bytes);
            boolean noFlag = Quality.isEmpty((byte[])bytes);
            boolean aFlag = Quality.isAccepted((byte[])bytes);
            boolean rFlag = false;
            if (Quality.isScreened((byte[])bytes)) {
                rFlag = Quality.isReject((byte[])bytes);
            }
            boolean qFlag = false;
            if (Quality.isScreened((byte[])bytes)) {
                qFlag = Quality.isQuestion((byte[])bytes);
            }
            boolean mFlag = false;
            if (Quality.isScreened((byte[])bytes)) {
                mFlag = Quality.isMissing((byte[])bytes);
            }
            if (iFlag || kFlag || eFlag || noFlag) {
                aFlag = true;
            }
            if (rFlag) {
                prop = line._rejectedProperties;
            }
            if (qFlag) {
                prop = line._questionableProperties;
            }
            if (mFlag) {
                prop = line._missingProperties;
            }
            if (aFlag) {
                prop = line._acceptableProperties;
            }
            if (line == this._estimateLine) {
                prop = line._missingProperties;
            }
            double dx = times[row];
            double dy = ydata[valIdx];
            int ix = this._scale.e2x(dx);
            if (!symRect.contains(ix, iy = this._scale.n2y(dy))) continue;
            Symbol.draw2((Graphics)g, (int)ix, (int)iy, (int)prop._symbolType, (Color)prop._pointLineColor, (Color)prop._pointFillColor, (float)(prop._symbolSize * 2.0f), (int)this.getDeviceResolution());
        }
    }

    public void clearSelection() {
        if (this._selectedLine == this._estimateLine) {
            this._nselect = 0;
            this._viewport.repaint();
        }
    }

    public void drawLegendPict(Graphics g, int curveIndex, Dimension dim) {
        double[] rawData = this._verifyTsData.getRawData();
        G2dLineProperties prop = null;
        if (rawData != null) {
            switch (curveIndex) {
                case 0: {
                    prop = this._rawLine.getProperties();
                    break;
                }
                case 1: {
                    prop = this._valueLine.getProperties();
                    break;
                }
                case 2: {
                    prop = this._estimateLine._missingProperties;
                    break;
                }
                case 3: {
                    prop = this._revisedLine.getProperties();
                    break;
                }
            }
        } else {
            switch (curveIndex) {
                case 0: {
                    prop = this._valueLine.getProperties();
                    break;
                }
                case 1: {
                    prop = this._estimateLine._missingProperties;
                    break;
                }
                case 2: {
                    prop = this._revisedLine.getProperties();
                    break;
                }
            }
        }
        if (prop != null) {
            Stroke oldStroke = null;
            if (prop.drawLine()) {
                if (g instanceof Graphics2D) {
                    oldStroke = ((Graphics2D)g).getStroke();
                    ((Graphics2D)g).setStroke(new BasicStroke(prop.getLineWidth(), prop._endStyle, 0, 10.0f, prop.getLinePattern(), 0.0f));
                }
                Color oldColor = g.getColor();
                g.setColor(prop.getLineColor());
                g.drawLine(1, dim.height / 2, dim.width - 2, dim.height / 2);
                if (g instanceof Graphics2D && oldStroke != null) {
                    ((Graphics2D)g).setStroke(oldStroke);
                }
                g.setColor(oldColor);
            }
            if (prop.drawPoints()) {
                Symbol.draw2((Graphics)g, (int)(dim.width / 2), (int)(dim.height / 2), (int)prop.getSymbolType(), (Color)prop.getPointLineColor(), (Color)prop.getPointFillColor(), (float)4.0f, (int)this.getDeviceResolution());
            }
        }
    }

    public String getToolTipText(MouseEvent e) {
        if (e == null) {
            return null;
        }
        LocalPt pt = new LocalPt(e.getX(), e.getY());
        double distMin = 3.4028234663852886E38;
        G2dVerifyLine line = null;
        G2dVerifyLine closestLine = null;
        int istart = 0;
        int ilast = 4;
        for (int l = istart; l < ilast; ++l) {
            if (l == 0) {
                line = this._estimateLine;
            } else if (l == 1) {
                line = this._revisedLine;
            } else if (l == 2) {
                line = this._valueLine;
            } else if (l == 3) {
                line = this._rawLine;
            }
            double dist = this.distanceToLine(pt, line);
            if (!(dist < distMin)) continue;
            distMin = dist;
            closestLine = line;
        }
        if (closestLine == null) {
            return null;
        }
        LocalPt rpt = closestLine.getNearestDataPt(pt);
        if (rpt != null && distMin < 12.0) {
            double dtime = this._scale.x2e(rpt.x);
            int row = this.locateClosestRow((int)dtime);
            int itime = this._verifyTsData.getTimes()[row];
            double[] ydata = this._verifyTsData.getRevisedData();
            if (closestLine == this._estimateLine) {
                ydata = this._verifyTsData.getEstimateData();
            } else if (closestLine == this._valueLine) {
                ydata = this._verifyTsData.getValueData();
            } else if (closestLine == this._rawLine) {
                ydata = this._verifyTsData.getRawData();
            }
            double yVal = this._scale.y2n(rpt.y);
            int valIdx = this._verifyTsData.getValueIndex(row);
            if (valIdx == -1) {
                return " ";
            }
            if (ydata != null && RMAConst.isValidValue((double)ydata[valIdx])) {
                yVal = ydata[valIdx];
            }
            HecTime hTime = new HecTime();
            hTime.set(itime);
            this._scale.convertDataTime(hTime);
            String xvalstr = hTime.dateAndTime();
            try {
                if (this._verifyTsData.getYParameterId() != -1 && this._verifyTsData.getUnitSystem() != 0 && this._scale.getDisplayUnitSystem() != 0) {
                    yVal = Units.convertUnits((double)yVal, (int)this._verifyTsData.getYParameterId(), (int)this._verifyTsData.getUnitSystem(), (int)this._scale.getDisplayUnitSystem());
                }
                return new String("[" + xvalstr + " ," + RMAIO.setPrecision2((double)yVal, (int)2) + "]");
            }
            catch (DataSetException exp) {
                return new String("[" + xvalstr + " ," + RMAIO.setPrecision2((double)yVal, (int)2) + "]");
            }
        }
        return null;
    }

    public void selectEstimateLine() {
        this._selectedLine = this._estimateLine;
    }

    public boolean movePt(LocalPt newPt) {
        if (this._timeIdx < 0) {
            return false;
        }
        if (this._selectedLine != this._estimateLine) {
            return false;
        }
        this._line = this._selectedLine;
        this._oldPt = this._newPt;
        double refY = this._scale.y2n(this._refPt.y);
        double newY = this._scale.y2n(newPt.y);
        this._verifyTsData.removeTableModelListener(this);
        int unitsystem = this._verifyTsData.getUnitSystem();
        int paramid = this._verifyTsData.getYParameterId();
        int idatacol = this._verifyTsData.getEstimateDataColumnIndex();
        if (this._nselect <= 1 && this._verifyTsData.isCellEditable(this._timeIdx, idatacol)) {
            int valIdx = this._verifyTsData.getValueIndex(this._timeIdx);
            this._verifyTsData.getEstimateData()[valIdx] = newY;
            ParamDouble pd = new ParamDouble(newY, paramid, unitsystem);
            this._verifyTsData.setValueAt(pd, this._timeIdx, idatacol);
            this._verifyTsData.setEstimateFlag(this._timeIdx, "E");
        } else {
            double dy = newY - refY;
            this._refPt = newPt;
            for (int j = 0; j < this._nselect; ++j) {
                int valIdx;
                int row = this._timeIndexes[j];
                if (!this._verifyTsData.isCellEditable(row, idatacol) || (valIdx = this._verifyTsData.getValueIndex(row)) == -1) continue;
                double[] dArray = this._verifyTsData.getEstimateData();
                int n = valIdx;
                dArray[n] = dArray[n] + dy;
                this._verifyTsData.setEstimateFlag(row, "E");
            }
            if (this._nselect > 0) {
                this._verifyTsData.fireTableRowsUpdated(this._timeIndexes[0], this._timeIndexes[this._nselect - 1]);
            }
        }
        this._newPt = newPt;
        this._viewport.repaint();
        this._verifyTsData.addTableModelListener(this);
        return true;
    }

    public boolean addPt(LocalPt newPt, int modifiers) {
        if (this._verifyTsData.isRegularIntervalData()) {
            return false;
        }
        double newY = this._scale.y2n(newPt.y);
        double newTime = this._scale.x2e(newPt.x);
        int tim = (int)(newTime + 0.5);
        this._verifyTsData.insertDate(tim, newY);
        return true;
    }

    public boolean mousePressed(LocalPt pt, int modifiers) {
        G2dVerifyLine newSelectedLine = null;
        double distMin = 12.0;
        double diste = Double.MAX_VALUE;
        double distr = Double.MAX_VALUE;
        if (this._estimateLine != null) {
            diste = this.distanceToLine(pt, this._estimateLine);
        }
        if (this._revisedLine != null) {
            distr = this.distanceToLine(pt, this._revisedLine);
        }
        this._refPt = pt;
        if ((1 & modifiers) > 0) {
            if (this._selectedLine != this._estimateLine && this._selectedLine != this._revisedLine) {
                return false;
            }
            newSelectedLine = this._selectedLine;
        } else if ((2 & modifiers) > 0 && (this._selectedLine == this._estimateLine || this._selectedLine == this._revisedLine)) {
            newSelectedLine = this._selectedLine;
        } else if (diste < distMin || distr < distMin) {
            if (diste <= distr) {
                newSelectedLine = this._estimateLine;
                if (this._selectedLine == this._estimateLine && this._nselect > 1) {
                    return true;
                }
            } else {
                newSelectedLine = this._revisedLine;
            }
        } else {
            newSelectedLine = this._revisedLine;
        }
        int itime = (int)Math.round(this._scale.x2e(pt.x));
        this._timeIdx = this.locateClosestRow(itime);
        if (this._timeIdx < 0) {
            return false;
        }
        if (newSelectedLine != this._selectedLine) {
            this._timeIndexes[0] = this._timeIdx;
            this._nselect = 1;
        }
        this._line = newSelectedLine;
        this._selectedLine = newSelectedLine;
        this.selectThePoints(pt, modifiers, 3);
        this._viewport.fireObjectSelectionChanged(new ObjectSelectionEvent((Object)this));
        return true;
    }

    public boolean selectPt(LocalPt pt, int modifiers) {
        return true;
    }

    public boolean objectEditPopupMenu(LocalPt pt, int modifiers) {
        if (this._selectedLine != this._revisedLine && this._selectedLine != this._estimateLine) {
            this._nselect = 0;
            return false;
        }
        if (this._nselect < 1) {
            return false;
        }
        boolean isValidationEditor = true;
        boolean hasEditableQual = this._verifyTsData.getEditableQuality();
        if (this._verifyTsData instanceof TimeSeriesEditorDataSet) {
            isValidationEditor = false;
        }
        boolean flagA = false;
        boolean flagR = false;
        boolean flagQ = false;
        boolean flagM = false;
        boolean flagP = false;
        boolean flagU = false;
        for (int j = 0; j < this._nselect; ++j) {
            int row = this._timeIndexes[j];
            String flag = this._verifyTsData.getRevisedFlag(row);
            if (flag.indexOf("A") > -1 || flag.indexOf("I") > -1 || flag.indexOf("E") > -1 || flag.indexOf("K") > -1) {
                flagA = true;
            } else if (flag.indexOf("Q") > -1) {
                flagQ = true;
            } else if (flag.indexOf("R") > -1) {
                flagR = true;
            } else if (flag.indexOf("M") > -1) {
                flagM = true;
            }
            if (flag.indexOf("U") > -1) {
                flagU = true;
                continue;
            }
            if (flag.indexOf("P") <= -1) continue;
            flagP = true;
        }
        boolean isEditable = this.checkIfEstimateEnabled();
        JPopupMenu _popupMenu = new JPopupMenu("Quality Flags");
        JMenuItem jmi = new JMenuItem("Estimate");
        jmi.setEnabled(isEditable);
        jmi.addActionListener(this);
        _popupMenu.add(jmi);
        jmi = new JMenuItem("Accept");
        jmi.addActionListener(this);
        jmi.setEnabled(this.checkIfAcceptEnabled());
        _popupMenu.add(jmi);
        jmi = new JMenuItem("Add");
        jmi.addActionListener(this);
        jmi.setEnabled(!this._verifyTsData.isRegularIntervalData());
        _popupMenu.add(jmi);
        jmi = new JMenuItem("Delete");
        jmi.addActionListener(this);
        _popupMenu.add(jmi);
        RmaJTitledSeparator tsep = new RmaJTitledSeparator("Table Fill");
        _popupMenu.add((Component)tsep);
        jmi = new JMenuItem("Fill - Linear");
        jmi.addActionListener(this);
        _popupMenu.add(jmi);
        jmi = new JMenuItem("Fill - Repeat");
        jmi.addActionListener(this);
        _popupMenu.add(jmi);
        jmi = new JMenuItem("Clear");
        jmi.addActionListener(this);
        _popupMenu.add(jmi);
        if (hasEditableQual) {
            String qualityTitle = "Set Protection";
            if (isValidationEditor) {
                qualityTitle = "Set Quality Flag";
            }
            tsep = new RmaJTitledSeparator(qualityTitle);
            _popupMenu.add((Component)tsep);
            JCheckBoxMenuItem jm = null;
            if (isValidationEditor) {
                jm = new JCheckBoxMenuItem("Rejected", flagR);
                jm.setEnabled(isEditable);
                jm.addActionListener(this);
                _popupMenu.add(jm);
                jm = new JCheckBoxMenuItem("Questionable", flagQ);
                jm.setEnabled(isEditable);
                jm.addActionListener(this);
                _popupMenu.add(jm);
                jm = new JCheckBoxMenuItem("Missing", flagM);
                jm.setEnabled(isEditable);
                jm.addActionListener(this);
                _popupMenu.add(jm);
                jm = new JCheckBoxMenuItem("Acceptable", flagA);
                jm.setEnabled(isEditable);
                jm.addActionListener(this);
                _popupMenu.add(jm);
                _popupMenu.addSeparator();
            }
            boolean protectionFlagEditable = isEditable;
            if (!isValidationEditor) {
                protectionFlagEditable = true;
            }
            jm = new JCheckBoxMenuItem("Unprotected", flagU);
            jm.addActionListener(this);
            jm.setEnabled(protectionFlagEditable);
            _popupMenu.add(jm);
            jm = new JCheckBoxMenuItem("Protected", flagP);
            jm.addActionListener(this);
            jm.setEnabled(protectionFlagEditable);
            _popupMenu.add(jm);
        }
        _popupMenu.show((Component)this._viewport, pt.x, pt.y);
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object obj = e.getSource();
        if (obj instanceof JCheckBoxMenuItem) {
            JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)obj;
            if (menuItem.getText().equals("Rejected")) {
                this.setQualityFlag("R");
            } else if (menuItem.getText().equals("Questionable")) {
                this.setQualityFlag("Q");
            } else if (menuItem.getText().equals("Missing")) {
                this.setQualityFlag("M");
            } else if (menuItem.getText().equals("Acceptable")) {
                this.setQualityFlag("A");
            } else if (menuItem.getText().equals("Protected")) {
                this.setProtected(true);
            } else if (menuItem.getText().equals("Unprotected")) {
                this.setProtected(false);
            }
        } else if (obj instanceof JMenuItem) {
            JMenuItem menuItem = (JMenuItem)obj;
            if (menuItem.getText().equals("Estimate")) {
                this.action_provideEstimate();
            } else if (menuItem.getText().equals("Accept")) {
                this.action_acceptEstimate();
            } else if (menuItem.getText().equals("Add")) {
                this.action_addRow();
            } else if (menuItem.getText().equals("Delete")) {
                this.action_deleteRow();
            } else if (menuItem.getText().equals("Fill - Linear")) {
                this.action_linearFill();
            } else if (menuItem.getText().equals("Fill - Repeat")) {
                this.action_repeatFill();
            } else if (menuItem.getText().equals("Clear")) {
                this.action_Clear();
            }
        }
    }

    public boolean objectPopupMenu(LocalPt pt, int modifiers) {
        this.pointerOver(pt);
        if (this._line != null && this._line.contains(pt)) {
            this._line.showPopup((Component)this._viewport, pt.x, pt.y);
            return true;
        }
        return false;
    }

    public void editLineProperties() {
        if (this._line != null) {
            this._line.editLineProperties();
        }
    }

    public boolean objectSelect(LocalPt pt, int modifiers) {
        this._line = this._revisedLine;
        int tval = (int)Math.round(this._scale.x2e(pt.x));
        this._timeIdx = this.locateClosestRow(tval);
        if (this._timeIdx < 0) {
            return false;
        }
        if (this._selectedLine != this._revisedLine) {
            this._timeIndexes[0] = this._timeIdx;
            this._nselect = 1;
        }
        this._selectedLine = this._line;
        this.selectThePoints(pt, modifiers, 1);
        return true;
    }

    private int locateClosestRow(int time) {
        int[] times = this._verifyTsData.getTimes();
        if (times == null || times.length < 1) {
            return -1;
        }
        int tim0 = times[0];
        int numPts = times.length;
        for (int i = 1; i < numPts; ++i) {
            int tim1 = times[i];
            if (time >= tim0 && time <= tim1) {
                if (time - tim0 < tim1 - time) {
                    return i - 1;
                }
                return i;
            }
            tim0 = tim1;
        }
        if (time < times[0]) {
            return 0;
        }
        if (time > times[numPts - 1]) {
            return numPts - 1;
        }
        return -1;
    }

    private boolean selectThePoints(LocalPt pt, int modifiers, int type) {
        if (type == 1 && this._selectedLine != this._revisedLine) {
            return false;
        }
        if (type == 3 && this._selectedLine != this._estimateLine && this._selectedLine != this._revisedLine) {
            return false;
        }
        if (this._selectedLine != null && this._timeIdx > -1) {
            if ((2 & modifiers) > 0) {
                int icnt = 0;
                for (int i = 0; i < this._nselect; ++i) {
                    if (this._timeIndexes[i] == this._timeIdx) continue;
                    this._timeIndexes[icnt] = this._timeIndexes[i];
                    ++icnt;
                }
                if (icnt < this._nselect) {
                    this._nselect = icnt;
                } else {
                    if (this._nselect >= this._timeIndexes.length) {
                        this._timeIndexes = VerifyTimeSeriesGlyph.growTheArray(this._timeIndexes);
                    }
                    this._timeIndexes[this._nselect] = this._timeIdx;
                    ++this._nselect;
                }
            } else if ((1 & modifiers) > 0) {
                int first = this._timeIdx;
                int last = this._timeIdx;
                if (this._nselect > 0) {
                    first = this._timeIndexes[0];
                }
                double[] estimateData = this._verifyTsData.getEstimateData();
                if (first > last) {
                    this._nselect = 0;
                    for (int i = first; i > last - 1; --i) {
                        double yval;
                        int valIdx;
                        if (this._selectedLine == this._estimateLine && ((valIdx = this._verifyTsData.getValueIndex(i)) == -1 || !RMAConst.isValidValue((double)(yval = estimateData[valIdx])) || !RMAConst.isValidValue((float)((float)yval)))) continue;
                        if (this._nselect >= this._timeIndexes.length) {
                            this._timeIndexes = VerifyTimeSeriesGlyph.growTheArray(this._timeIndexes);
                        }
                        this._timeIndexes[this._nselect] = i;
                        ++this._nselect;
                    }
                } else {
                    this._nselect = 0;
                    for (int i = first; i < last + 1; ++i) {
                        double yval;
                        int valIdx;
                        if (this._selectedLine == this._estimateLine && ((valIdx = this._verifyTsData.getValueIndex(i)) == -1 || !RMAConst.isValidValue((double)(yval = estimateData[valIdx])) || !RMAConst.isValidValue((float)((float)yval)))) continue;
                        if (this._nselect >= this._timeIndexes.length) {
                            this._timeIndexes = VerifyTimeSeriesGlyph.growTheArray(this._timeIndexes);
                        }
                        this._timeIndexes[this._nselect] = i;
                        ++this._nselect;
                    }
                }
            } else {
                this._nselect = 0;
                this._timeIndexes[this._nselect] = this._timeIdx;
                this._nselect = 1;
            }
            this._viewport.repaint();
            return true;
        }
        if (this._nselect > 0) {
            this._nselect = 0;
            this._viewport.repaint();
        }
        return false;
    }

    public boolean pointerOver(LocalPt pt) {
        double distMin = Double.POSITIVE_INFINITY;
        G2dVerifyLine line = null;
        int istart = 0;
        int ilast = 4;
        for (int l = istart; l < ilast; ++l) {
            if (l == 0) {
                line = this._estimateLine;
            } else if (l == 1) {
                line = this._revisedLine;
            } else if (l == 2) {
                line = this._valueLine;
            } else if (l == 3) {
                line = this._rawLine;
            }
            double dist = this.distanceToLine(pt, line);
            if (!(dist < distMin)) continue;
            distMin = dist;
        }
        return distMin <= 6.0;
    }

    private double distanceToLine(LocalPt pt, G2dVerifyLine line) {
        if (line == null || !line.contains(pt)) {
            return Double.POSITIVE_INFINITY;
        }
        LocalPt rpt = line.getNearestDataPt(pt);
        if (rpt != null) {
            double dx = pt.x - rpt.x;
            double dy = pt.y - rpt.y;
            return Math.sqrt(dx * dx + dy * dy);
        }
        return Double.POSITIVE_INFINITY;
    }

    public int[] getSelectedPoints() {
        if (this._nselect < 1) {
            return null;
        }
        int[] selectedPoints = new int[this._nselect];
        System.arraycopy(this._timeIndexes, 0, selectedPoints, 0, this._nselect);
        return selectedPoints;
    }

    private void setProtected(boolean tf) {
        if (this._timeIdx < 0 || this._nselect < 1) {
            return;
        }
        this._verifyTsData.removeTableModelListener(this);
        if (this._verifyTsData instanceof TimeSeriesEditorDataSet) {
            for (int i = 0; i < this._nselect; ++i) {
                int irow = this._timeIndexes[i];
                boolean currentState = this._verifyTsData.isRevisedProtected(irow);
                if (currentState == tf) continue;
                this._verifyTsData.setRevisedProtected(irow, tf);
            }
            return;
        }
        int revisedQualCol = this._verifyTsData.getRevisedQualityColumnIndex();
        int estimateDataCol = this._verifyTsData.getEstimateDataColumnIndex();
        if (revisedQualCol < 0) {
            return;
        }
        for (int i = 0; i < this._nselect; ++i) {
            int irow = this._timeIndexes[i];
            if (!this._verifyTsData.isCellEditable(irow, estimateDataCol)) continue;
            Object flagStr = (String)this._verifyTsData.getValueAt(irow, revisedQualCol);
            if (tf) {
                if (((String)flagStr).indexOf("P") > -1) continue;
                flagStr = ((String)flagStr).indexOf("U") > -1 ? ((String)flagStr).replace('U', 'P') : "P" + ((String)flagStr).substring(1);
                this._verifyTsData.setValueAt(flagStr, irow, revisedQualCol);
                continue;
            }
            boolean pro = this._verifyTsData.isValueProtected(irow);
            if (pro) {
                if (((String)flagStr).indexOf("U") > -1) continue;
                flagStr = ((String)flagStr).indexOf("P") > -1 ? ((String)flagStr).replace('P', 'U') : "U" + ((String)flagStr).substring(1);
                this._verifyTsData.setValueAt(flagStr, irow, revisedQualCol);
                continue;
            }
            String newFlag = " " + ((String)flagStr).substring(1);
            this._verifyTsData.setValueAt(newFlag, irow, revisedQualCol);
        }
        this._verifyTsData.addTableModelListener(this);
        this._viewport.repaint();
    }

    private void setQualityFlag(String flag) {
        int revisedQualCol = this._verifyTsData.getRevisedQualityColumnIndex();
        if (revisedQualCol < 0) {
            return;
        }
        int estimateDataCol = this._verifyTsData.getEstimateDataColumnIndex();
        for (int i = 0; i < this._nselect; ++i) {
            int irow = this._timeIndexes[i];
            if (!this._verifyTsData.isCellEditable(irow, estimateDataCol)) continue;
            this._verifyTsData.setRevisedFlag(irow, flag);
        }
        this._verifyTsData.addTableModelListener(this);
        this._viewport.repaint();
    }

    void action_provideEstimate() {
        if (this._nselect < 1) {
            return;
        }
        int[] selection = new int[this._nselect];
        for (int i = 0; i < this._nselect; ++i) {
            selection[i] = this._timeIndexes[i];
        }
        if (!this._verifyTsData.provideEstimate(selection, false)) {
            return;
        }
        this._viewport.fireObjectSelectionChanged(new ObjectSelectionEvent((Object)this));
        this._viewport.repaint();
    }

    private void action_acceptEstimate() {
        int[] selection = this._timeIndexes;
        if (selection == null || this._nselect < 1) {
            return;
        }
        for (int i = 0; i < this._nselect; ++i) {
            int irow = selection[i];
            this._verifyTsData.acceptEstimate(irow);
        }
        this._viewport.repaint();
    }

    private void action_addRow() {
        int[] selection = this._timeIndexes;
        if (selection == null || this._nselect < 1) {
            return;
        }
        if (!this._verifyTsData.insertDate(selection[0], (Component)this._viewport)) {
            // empty if block
        }
    }

    private void action_deleteRow() {
        int[] selection = this.getSelectedPoints();
        if (selection == null || selection.length < 1) {
            return;
        }
        if (this._verifyTsData.isRegularIntervalData()) {
            this._verifyTsData.clearEstimate(selection);
        } else {
            this._verifyTsData.deleteRows(selection);
        }
    }

    private void action_linearFill() {
        int[] selection = this.getSelectedPoints();
        if (selection == null || selection.length < 1) {
            return;
        }
        this._verifyTsData.linearFillForEstimate(selection);
        this._viewport.repaint();
    }

    private void action_repeatFill() {
        int[] selection = this.getSelectedPoints();
        if (selection == null || selection.length < 1) {
            return;
        }
        this._verifyTsData.repeatFillForEstimate(selection);
        this._viewport.repaint();
    }

    private void action_Clear() {
        int[] selection = this.getSelectedPoints();
        if (selection == null || selection.length < 1) {
            return;
        }
        this._verifyTsData.clearEstimate(selection);
        this._viewport.repaint();
    }

    protected boolean checkIfEstimateEnabled() {
        int[] selection = this._timeIndexes;
        if (selection == null || selection.length < 1) {
            return false;
        }
        int estimateDataCol = this._verifyTsData.getEstimateDataColumnIndex();
        for (int i = 0; i < selection.length; ++i) {
            if (!this._verifyTsData.isCellEditable(selection[i], estimateDataCol)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkIfAcceptEnabled() {
        int[] selection = this._timeIndexes;
        if (selection == null || selection.length < 1) {
            return false;
        }
        int estimateDataCol = this._verifyTsData.getEstimateDataColumnIndex();
        double[] estimateData = this._verifyTsData.getEstimateData();
        for (int i = 0; i < selection.length; ++i) {
            int valIdx = this._verifyTsData.getValueIndex(selection[i]);
            if (valIdx == -1 || !this._verifyTsData.isCellEditable(selection[i], estimateDataCol) || !RMAConst.isValidValue((double)estimateData[valIdx])) continue;
            return true;
        }
        return false;
    }

    public boolean isCurveDrawn(int curveNumber) {
        if (this._verifyTsData.isDirectEdit()) {
            return curveNumber == 0;
        }
        return true;
    }
}

