/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.gfx2d.ColorBarIcon;
import hec.heclib.util.ColorBase;
import hec.heclib.util.ObjectContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.StringTokenizer;

public class ColorBarBase
extends ColorBarIcon {
    protected String _colorSettings = null;
    protected double[] _colorValues = null;
    protected Color[] _colorsArray = null;

    public void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        g.setColor(this._borderColor);
        g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        if (this._selected) {
            g.setColor(this._borderColor);
            g.drawRect(x - 1, y - 1, this.getIconWidth() + 2, this.getIconHeight() + 2);
        }
    }

    protected void parseColorSettings(String settings) {
        this._colorSettings = settings != null ? settings : "";
        ObjectContainer colors = new ObjectContainer();
        ObjectContainer values = new ObjectContainer();
        ColorBarBase.getColorValueArray(this._colorSettings, values, colors);
        this._colorValues = (double[])values.object;
        this._colorsArray = (Color[])colors.object;
    }

    public static void getColorValueArray(String settings, ObjectContainer values, ObjectContainer colors) {
        StringTokenizer st;
        int numb;
        int len;
        if (settings == null) {
            settings = "";
        }
        if ((len = (numb = (st = new StringTokenizer(settings, ",")).countTokens()) / 2) * 2 != numb) {
            ++len;
        }
        double[] colorValues = new double[len];
        Color[] colorsArray = new Color[len];
        int ncolor = 0;
        int nvalue = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Color color = ColorBarBase.getColor(token);
            if (color != null) {
                colorsArray[ncolor++] = color;
                continue;
            }
            try {
                double value = Double.valueOf(token);
                colorValues[nvalue++] = value;
            }
            catch (Exception exception) {}
        }
        if (ncolor < len) {
            colorsArray[ncolor] = colorsArray[ncolor - 1];
        }
        if (nvalue < len) {
            colorValues[nvalue] = colorValues[nvalue - 1];
        }
        values.object = colorValues;
        colors.object = colorsArray;
    }

    public String getColorSettings() {
        return this._colorSettings;
    }

    public static Color getColor(String name) {
        return ColorBase.getColorFromName((String)name);
    }
}

