/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.ColorBarBase;
import hec.dataui.tx.client.QualityColorBar;
import hec.geometry.LocalRect;
import hec.gfx2d.PlotIconBase;
import hec.heclib.dss.DSSPathAndFilename;
import hec.io.TimeSeriesContainer;
import hec.model.TsDataSetName;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import rma.util.RMAIO;

public class ColorBarBaseContainer
extends PlotIconBase {
    protected String _colorSettings = null;
    Vector colorBars = new Vector();

    public void ColorBarBaseContainer(int numberColorBars) {
        this.setNumberOfColorBars(numberColorBars);
    }

    public void ColorBarBaseContainer(Vector dataSetNames) {
        this.setDataSetNames(dataSetNames);
    }

    public void setNumberOfColorBars(int numberColorBars) {
    }

    public void setDataSetNames(Vector dataSetNames) {
        super.setDataSetNames(dataSetNames);
        this.setNumberOfColorBars(dataSetNames.size());
        for (int i = 0; i < dataSetNames.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setDataSetName((String)dataSetNames.elementAt(i));
        }
    }

    public void setColorSettings(String settings) {
        this._colorSettings = settings.trim();
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setColorSettings(this._colorSettings);
        }
    }

    public Vector getColorSettingsVector() {
        Vector<String> colorSettings = new Vector<String>();
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorSettings.add(colorBar.getColorSettings());
        }
        return colorSettings;
    }

    public String getColorSettings() {
        if (this.colorBars.size() > 0) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(0));
            if (colorBar instanceof QualityColorBar) {
                return ((QualityColorBar)colorBar).getAllColorSettings();
            }
            return colorBar.getColorSettings();
        }
        return "";
    }

    public void clearData() {
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.clearData();
        }
        super.clearData();
    }

    public void setData(TimeSeriesContainer tsContainer) {
        this.colorBars.removeAllElements();
        super.clearData();
        this.addData(tsContainer);
    }

    public void setSize(Dimension dim) {
        super.setSize(dim);
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setSize(dim);
        }
    }

    public void setXLimits(int minX, int maxX) {
        super.setXLimits(minX, maxX);
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setXLimits(minX, maxX);
        }
    }

    public void setXLimits(double minX, double maxX) {
        super.setXLimits(minX, maxX);
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setXLimits(minX, maxX);
        }
    }

    public void setSelected(boolean selected) {
        this._selected = selected;
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setSelected(selected);
        }
    }

    public int getIconHeight() {
        int height = 0;
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            height += colorBar.getIconHeight();
        }
        if (height == 0) {
            height = super.getIconHeight();
        }
        return height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        int adjustedY = y;
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.paintIcon(c, g, x, adjustedY);
            adjustedY += colorBar.getIconHeight();
        }
    }

    public LocalRect getRectangle() {
        int w = this.getIconWidth();
        int h = super.getIconHeight();
        LocalRect rect = new LocalRect();
        rect.l = -(w / 2);
        rect.r = w + rect.l;
        rect.t = -(h / 2);
        rect.b = h + rect.t;
        if (this.colorBars.size() > 1) {
            rect.b += h * (this.colorBars.size() - 1);
        }
        return rect;
    }

    public void addData(TimeSeriesContainer tsContainer) {
        boolean found = false;
        for (int i = 0; i < this.colorBars.size(); ++i) {
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            String name = colorBar.getDataSetName();
            if (name != null && name.length() > 0) {
                name = RMAIO.parsePathName((String)name);
                if (tsContainer.fileName.length() > 4) {
                    DSSPathAndFilename path = new DSSPathAndFilename(tsContainer.fullName);
                    path.setFilename(tsContainer.fileName);
                    found = path.isSameName(name, false);
                } else {
                    found = name.equalsIgnoreCase(tsContainer.fullName);
                }
            }
            if (!found) continue;
            colorBar.setData(tsContainer);
        }
        super.addData(tsContainer);
    }

    public void setColorSettings(Vector colorSettings) {
        block4: {
            if (colorSettings.size() <= 0) break block4;
            if (colorSettings.size() == this.colorBars.size()) {
                for (int i = 0; i < this.colorBars.size(); ++i) {
                    ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
                    colorBar.setColorSettings((String)colorSettings.elementAt(i));
                }
            } else {
                for (int i = 0; i < this.colorBars.size(); ++i) {
                    ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
                    colorBar.setColorSettings((String)colorSettings.elementAt(0));
                }
            }
        }
    }

    public void setTsDataSetNames(Vector dsNames) {
        super.setTsDataSetNames(dsNames);
        this.setNumberOfColorBars(dsNames.size());
        for (int i = 0; i < this._dataSetNames.size(); ++i) {
            TsDataSetName dsn = (TsDataSetName)dsNames.elementAt(i);
            ColorBarBase colorBar = (ColorBarBase)((Object)this.colorBars.elementAt(i));
            colorBar.setDataSetName((String)this._dataSetNames.elementAt(i));
            this._colorSettings = this._cumulativeInterval < 0 ? dsn.thresholdColors : dsn.cumulativeThresholdColors;
            if (this._colorSettings == null) continue;
            colorBar.setColorSettings(this._colorSettings);
        }
    }
}

