/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.ColorEditorTablePanel;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import rma.swing.RmaJDialog;

public class ColorEditorBase
extends RmaJDialog {
    JPanel jPanelApply;
    ColorEditorTablePanel _colorTablePanel;
    JButton jButtonOk;
    JButton jButtonApply;
    JButton jButtonCancel;
    JButton jButtonInsertRow;
    JButton jButtonDeleteRow;
    boolean _editable = true;
    boolean _leftColumnEditable = false;
    Vector _names = null;
    Object _parent = null;

    public ColorEditorBase(JDialog parent, String title, String columnTitle, boolean leftColumnEditable) {
        super((Dialog)parent);
        this.setTitle(title);
        this._parent = parent;
        this._leftColumnEditable = leftColumnEditable;
        this._colorTablePanel = new ColorEditorTablePanel(columnTitle, leftColumnEditable);
    }

    public ColorEditorBase(JFrame parent, String title, String columnTitle, boolean leftColumnEditable) {
        super((Frame)parent);
        this.setTitle(title);
        this._parent = parent;
        this._leftColumnEditable = leftColumnEditable;
        this._colorTablePanel = new ColorEditorTablePanel(columnTitle, leftColumnEditable);
    }

    public void setParameters(Vector names, Vector colorSelections) {
        this._names = names;
        this._colorTablePanel.setParameters(names, colorSelections);
        this.initialize();
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
        this._colorTablePanel.setEditable(editable);
    }

    public String getSelections() {
        return this._colorTablePanel.getSelections();
    }

    protected void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildSize();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(15, 20, 12, 20);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this._colorTablePanel, gbc);
        this.getContentPane().add(this._colorTablePanel);
        this.buildOKPanel();
        this.setListeners();
    }

    protected void buildSize() {
        Dimension d = this._colorTablePanel.getTableSize();
        d.height = this._leftColumnEditable ? (d.height += 116) : (d.height += 82);
        d.width += 40;
        this.setSize(d);
    }

    protected void buildOKPanel() {
        this.jPanelApply = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.jPanelApply.setLayout(gridBagLayout);
        this.jPanelApply.setFont(new Font("Dialog", 0, 12));
        this.jPanelApply.setForeground(new Color(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(10, 20, 8, 20);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this.jPanelApply, gbc);
        this.getContentPane().add(this.jPanelApply);
        this.jButtonInsertRow = new JButton();
        if (this._leftColumnEditable) {
            this.jButtonInsertRow.setText("Insert Row");
            this.jButtonInsertRow.setMnemonic('I');
            this.jButtonInsertRow.setActionCommand("Insert Row");
            this.jButtonInsertRow.setFont(new Font("Dialog", 0, 12));
            this.jButtonInsertRow.setForeground(new Color(0));
            gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 5, 8, 5);
            ((GridBagLayout)this.jPanelApply.getLayout()).setConstraints(this.jButtonInsertRow, gbc);
            this.jPanelApply.add(this.jButtonInsertRow);
        }
        this.jButtonDeleteRow = new JButton();
        if (this._leftColumnEditable) {
            this.jButtonDeleteRow.setText("Delete Row");
            this.jButtonDeleteRow.setMnemonic('D');
            this.jButtonDeleteRow.setActionCommand("Delete Row");
            this.jButtonDeleteRow.setFont(new Font("Dialog", 0, 12));
            this.jButtonDeleteRow.setForeground(new Color(0));
            gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.gridwidth = 0;
            gbc.insets = new Insets(2, 5, 8, 5);
            ((GridBagLayout)this.jPanelApply.getLayout()).setConstraints(this.jButtonDeleteRow, gbc);
            this.jPanelApply.add(this.jButtonDeleteRow);
        }
        this.jButtonOk = new JButton("OK");
        this.jButtonOk.setActionCommand("Ok");
        this.jButtonOk.setFont(new Font("Dialog", 0, 12));
        this.jButtonOk.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 10, 2, 10);
        ((GridBagLayout)this.jPanelApply.getLayout()).setConstraints(this.jButtonOk, gbc);
        this.jPanelApply.add(this.jButtonOk);
        this.jButtonCancel = new JButton("Cancel");
        this.jButtonCancel.setActionCommand("Cancel");
        this.jButtonCancel.setFont(new Font("Dialog", 0, 12));
        this.jButtonCancel.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 10, 2, 10);
        ((GridBagLayout)this.jPanelApply.getLayout()).setConstraints(this.jButtonCancel, gbc);
        this.jPanelApply.add(this.jButtonCancel);
        this.jButtonApply = new JButton();
        this.jButtonApply.setText("Apply");
        this.jButtonApply.setActionCommand("Apply");
        this.jButtonApply.setFont(new Font("Dialog", 0, 12));
        this.jButtonApply.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 10, 2, 10);
    }

    protected void setListeners() {
        SymWindow aSymWindow = new SymWindow();
        this.addWindowListener(aSymWindow);
        SymAction lSymAction = new SymAction();
        this.jButtonOk.addActionListener(lSymAction);
        this.jButtonApply.addActionListener(lSymAction);
        this.jButtonCancel.addActionListener(lSymAction);
        this.jButtonInsertRow.addActionListener(lSymAction);
        this.jButtonDeleteRow.addActionListener(lSymAction);
        this.registerEnterKey(true);
        this.registerEscapeKey(true);
    }

    void jButtonOK_actionPerformed(ActionEvent event) {
        int status = this.apply_action();
        if (status == 0) {
            this.setVisible(false);
            this.dispose();
        }
    }

    void jButtonApply_actionPerformed(ActionEvent event) {
        this.apply_action();
    }

    protected int apply_action() {
        this._colorTablePanel.stopEditing();
        return 0;
    }

    void jButtonCancel_actionPerformed() {
        this.setVisible(false);
        this.dispose();
    }

    class SymWindow
    extends WindowAdapter {
        SymWindow() {
        }

        @Override
        public void windowClosing(WindowEvent event) {
            Object object = event.getSource();
            if (object == ColorEditorBase.this) {
                ColorEditorBase.this.jButtonCancel_actionPerformed();
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            Object object = event.getSource();
            if (object == ColorEditorBase.this.jButtonOk) {
                ColorEditorBase.this.jButtonOK_actionPerformed(event);
            } else if (object == ColorEditorBase.this.jButtonApply) {
                ColorEditorBase.this.jButtonApply_actionPerformed(event);
            } else if (object == ColorEditorBase.this.jButtonCancel) {
                ColorEditorBase.this.jButtonCancel_actionPerformed();
            } else if (object == ColorEditorBase.this.jButtonInsertRow) {
                ColorEditorBase.this._colorTablePanel.insertRow();
            } else if (object == ColorEditorBase.this.jButtonDeleteRow) {
                ColorEditorBase.this._colorTablePanel.deleteRow();
            }
        }
    }
}

