/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.heclib.util.ColorBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ColorEditorTablePanel
extends JPanel {
    JScrollPane colorTablePane;
    public DataNamesTableModel _dataNamesTableModel = null;
    public JTable _colorTable = null;
    protected JLabel[] _colorLabels = null;
    protected Vector _colorCombos = new Vector();
    protected boolean _leftColumnEditable = false;
    protected int _columnCount;
    protected Vector _firstColumnText = null;
    protected Vector _secondColumnText = null;
    protected boolean _editable = true;
    protected boolean _leftColumnCentered = false;
    protected String _firstColumnHeader;
    protected String _secondColumnHeader = "";
    protected boolean _thresholdEditor = false;
    protected boolean _newTable = true;

    public ColorEditorTablePanel(String firstColumnHeader, boolean leftColumnEditable) {
        this._firstColumnHeader = firstColumnHeader;
        this._leftColumnEditable = leftColumnEditable;
        this._columnCount = 2;
    }

    public ColorEditorTablePanel(String firstColumnHeader, String secondColumnHeader, boolean leftColumnEditable) {
        this._firstColumnHeader = firstColumnHeader;
        this._secondColumnHeader = secondColumnHeader;
        this._leftColumnEditable = leftColumnEditable;
        this._columnCount = 3;
    }

    public boolean isNewTable() {
        return this._newTable;
    }

    public void setNewTable(boolean newTable) {
        this._newTable = newTable;
    }

    public void setEditable(boolean editable) {
        this._editable = editable;
    }

    public void setLeftColumnCentered(boolean leftColumnCentered) {
        this._leftColumnCentered = leftColumnCentered;
    }

    public void setParameters(Vector firstColumnText, Vector colorSelections) {
        this.setParameters(firstColumnText, new Vector(), colorSelections);
    }

    public void setThresholdEditor(boolean thresholdEditor) {
        this._thresholdEditor = thresholdEditor;
    }

    public void setParameters(Vector firstColumnText, Vector secondColumnText, Vector colorSelections) {
        this._firstColumnText = firstColumnText;
        this._secondColumnText = secondColumnText;
        this.buildColorTable();
        for (int i = 0; i < colorSelections.size(); ++i) {
            Color color;
            int index;
            if (i >= this._colorCombos.size() || (index = ColorBase.getColorIndex((Color)(color = (Color)colorSelections.elementAt(i)))) < 0) continue;
            JComboBox combo = (JComboBox)this._colorCombos.elementAt(i);
            combo.setSelectedIndex(index);
        }
        this._dataNamesTableModel.fireTableDataChanged();
    }

    public String getSelections() {
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < this._firstColumnText.size(); ++i) {
            JComboBox combo;
            int index;
            String name = ((String)this._firstColumnText.elementAt(i)).trim();
            if (name.length() <= 0 || (index = (combo = (JComboBox)this._colorCombos.elementAt(i)).getSelectedIndex()) < 0) continue;
            String colorName = ColorBase.getNameFromIndex((int)index);
            params.append(name);
            params.append(",");
            params.append(colorName);
            params.append(",");
        }
        if (params.length() > 1) {
            params.deleteCharAt(params.length() - 1);
        }
        return params.toString();
    }

    public void getSelections(Vector names, Vector colorSelections) {
        names.removeAllElements();
        colorSelections.removeAllElements();
        for (int i = 0; i < this._firstColumnText.size(); ++i) {
            JComboBox combo;
            int index;
            String name = ((String)this._firstColumnText.elementAt(i)).trim();
            if (name.length() <= 0 || (index = (combo = (JComboBox)this._colorCombos.elementAt(i)).getSelectedIndex()) < 0) continue;
            String colorName = ColorBase.getNameFromIndex((int)index);
            names.add(name);
            colorSelections.add(colorName);
        }
    }

    public boolean modified() {
        if (this._dataNamesTableModel == null) {
            return false;
        }
        return this._dataNamesTableModel.modified();
    }

    public Dimension getTableSize() {
        int number = this._firstColumnText.size();
        if (number < 2) {
            number = 2;
        }
        if (number < 5 && this._leftColumnEditable) {
            number = 5;
        }
        int height = 17 * number + 18;
        int width = 400;
        if (this._columnCount == 3) {
            width = 500;
        }
        return new Dimension(width, height);
    }

    private void buildColorTable() {
        JLabel renderer;
        if (this.colorTablePane != null) {
            this.remove(this.colorTablePane);
        } else {
            this.setLayout(new BorderLayout());
        }
        Color[] colorValues = ColorBase.getColorValues();
        String[] colorNames = ColorBase.getColorNames();
        this._colorLabels = new JLabel[colorNames.length];
        for (int j = 0; j < colorNames.length; ++j) {
            ColorIcon icon = new ColorIcon(colorNames[j], colorValues[j], 40, 10);
            this._colorLabels[j] = new JLabel(icon.getText(), icon, 2);
        }
        this._colorCombos.removeAllElements();
        for (int i = 0; i < this._firstColumnText.size(); ++i) {
            JComboBox<JLabel> comboBox = new JComboBox<JLabel>(this._colorLabels);
            renderer = new ComboBoxRenderer();
            comboBox.setRenderer((ListCellRenderer<JLabel>)((Object)renderer));
            this._colorCombos.addElement(comboBox);
        }
        this._dataNamesTableModel = new DataNamesTableModel();
        this._colorTable = new JTable(this._dataNamesTableModel);
        this.colorTablePane = new JScrollPane(this._colorTable);
        this._colorTable.setDefaultRenderer(JLabel.class, new ColorTableRenderer());
        this._colorTable.setSelectionMode(0);
        this._colorTable.setColumnSelectionAllowed(false);
        this._colorTable.setRowSelectionAllowed(false);
        this._colorTable.setCellSelectionEnabled(true);
        JComboBox<JLabel> comboBox = new JComboBox<JLabel>(this._colorLabels);
        comboBox.setRenderer(new ComboBoxRenderer());
        TableColumn colorCombosColumn = this._colorTable.getColumnModel().getColumn(this._columnCount - 1);
        colorCombosColumn.setCellEditor(new DefaultCellEditor(comboBox));
        ((DefaultTableCellRenderer)this._colorTable.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(0);
        if (this._leftColumnCentered) {
            renderer = new DefaultTableCellRenderer();
            renderer.setHorizontalAlignment(0);
            TableColumn column = this._colorTable.getColumnModel().getColumn(0);
            column.setCellRenderer((TableCellRenderer)((Object)renderer));
            if (this._columnCount == 3) {
                column = this._colorTable.getColumnModel().getColumn(1);
                column.setCellRenderer((TableCellRenderer)((Object)renderer));
            }
        }
        this.add((Component)this.colorTablePane, "Center");
    }

    public void insertRow() {
        int selected = this._colorTable.getSelectedRow();
        if (selected >= 0) {
            this._dataNamesTableModel.addRow(selected);
        }
    }

    public void deleteRow() {
        int selected = this._colorTable.getSelectedRow();
        if (selected >= 0) {
            this._dataNamesTableModel.deleteRow(selected);
        }
    }

    public void stopEditing() {
        TableCellEditor cellEditor;
        if (this._colorTable != null && (cellEditor = this._colorTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
    }

    public class DataNamesTableModel
    extends AbstractTableModel {
        Vector selectedItems;
        boolean _modified = false;

        @Override
        public int getColumnCount() {
            return ColorEditorTablePanel.this._columnCount;
        }

        @Override
        public int getRowCount() {
            if (ColorEditorTablePanel.this._leftColumnEditable) {
                int number = ColorEditorTablePanel.this._firstColumnText.size();
                if (number > 0) {
                    String lastElement = ((String)ColorEditorTablePanel.this._firstColumnText.elementAt(number - 1)).trim();
                    if (lastElement.length() > 0) {
                        ++number;
                    }
                } else {
                    ++number;
                }
                return number;
            }
            return ColorEditorTablePanel.this._firstColumnText.size();
        }

        public Class getColumnClass(int column) {
            return this.getValueAt(0, column).getClass();
        }

        public boolean modified() {
            return this._modified;
        }

        @Override
        public Object getValueAt(int row, int column) {
            String param;
            if (ColorEditorTablePanel.this._leftColumnEditable && row == ColorEditorTablePanel.this._firstColumnText.size()) {
                this.addRow(row);
            }
            if (column == 0) {
                if (row > ColorEditorTablePanel.this._firstColumnText.size() - 1) {
                    return "";
                }
                return ColorEditorTablePanel.this._firstColumnText.elementAt(row);
            }
            if (column == 1 && ColorEditorTablePanel.this._columnCount == 3) {
                if (row > ColorEditorTablePanel.this._secondColumnText.size() - 1) {
                    return "";
                }
                return ColorEditorTablePanel.this._secondColumnText.elementAt(row);
            }
            if (ColorEditorTablePanel.this._leftColumnEditable && (param = ((String)ColorEditorTablePanel.this._firstColumnText.elementAt(row)).trim()).length() == 0) {
                return new JLabel();
            }
            return ((JComboBox)ColorEditorTablePanel.this._colorCombos.elementAt(row)).getSelectedItem();
        }

        public void addRow(int row) {
            ColorEditorTablePanel.this._firstColumnText.add(row, "");
            if (ColorEditorTablePanel.this._columnCount == 3) {
                ColorEditorTablePanel.this._secondColumnText.add(row, "");
            }
            JComboBox<JLabel> comboBox = new JComboBox<JLabel>(ColorEditorTablePanel.this._colorLabels);
            ComboBoxRenderer renderer = new ComboBoxRenderer();
            comboBox.setRenderer(renderer);
            ColorEditorTablePanel.this._colorCombos.add(row, comboBox);
            this.fireTableRowsInserted(row, row);
        }

        public void deleteRow(int row) {
            ColorEditorTablePanel.this._firstColumnText.remove(row);
            if (ColorEditorTablePanel.this._columnCount == 3) {
                ColorEditorTablePanel.this._secondColumnText.remove(row);
            }
            ColorEditorTablePanel.this._colorCombos.remove(row);
            this.fireTableRowsDeleted(row, row);
        }

        @Override
        public void setValueAt(Object object, int row, int col) {
            if (col == 0) {
                ColorEditorTablePanel.this._firstColumnText.setElementAt(object, row);
                if (ColorEditorTablePanel.this._thresholdEditor) {
                    if (row > 0) {
                        ColorEditorTablePanel.this._secondColumnText.setElementAt(object, row - 1);
                        this.fireTableRowsUpdated(row - 1, row);
                    } else if (!object.toString().equals("<")) {
                        ColorEditorTablePanel.this.insertRow();
                        ColorEditorTablePanel.this._firstColumnText.setElementAt("<", 0);
                        ColorEditorTablePanel.this._secondColumnText.setElementAt(object, 0);
                        this.fireTableRowsUpdated(0, 1);
                    }
                } else {
                    this.fireTableRowsUpdated(row, row);
                }
            } else if (col == 1 && ColorEditorTablePanel.this._columnCount == 3) {
                ColorEditorTablePanel.this._secondColumnText.setElementAt(object, row);
                if (ColorEditorTablePanel.this._thresholdEditor) {
                    boolean end = false;
                    if (!object.toString().equals(">")) {
                        if (row + 1 >= this.getRowCount() - 1) {
                            end = true;
                            ColorEditorTablePanel.this._dataNamesTableModel.addRow(row + 1);
                        }
                        ColorEditorTablePanel.this._firstColumnText.setElementAt(object, row + 1);
                        if (end) {
                            ColorEditorTablePanel.this._secondColumnText.setElementAt(">", row + 1);
                        }
                        this.fireTableRowsUpdated(row, row + 1);
                    }
                } else {
                    this.fireTableRowsUpdated(row, row);
                }
            } else {
                ((JComboBox)ColorEditorTablePanel.this._colorCombos.elementAt(row)).setSelectedItem(object);
                this.fireTableRowsUpdated(row, row);
            }
            this._modified = true;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return ColorEditorTablePanel.this._leftColumnEditable;
            }
            return ColorEditorTablePanel.this._editable;
        }

        @Override
        public String getColumnName(int col) {
            if (col == 0) {
                return ColorEditorTablePanel.this._firstColumnHeader;
            }
            if (col == 1 && ColorEditorTablePanel.this._columnCount == 3) {
                return ColorEditorTablePanel.this._secondColumnHeader;
            }
            return "Color";
        }
    }

    public class ColorIcon
    extends ImageIcon {
        public Color _color;
        public String _text;
        int _width;
        int _height;

        public ColorIcon(String text, Color color, int width, int height) {
            this._text = text;
            this._color = color;
            this._width = width;
            this._height = height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.setColor(this._color);
            g.fillRect(x, y, this._width, this._height);
        }

        public String getText() {
            return this._text;
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        public int getIconWidth() {
            return this._width;
        }

        @Override
        public int getIconHeight() {
            return this._height;
        }
    }

    class ComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            JLabel label = (JLabel)value;
            this.setIcon(label.getIcon());
            this.setText(label.getText());
            return this;
        }
    }

    class ColorTableRenderer
    extends JLabel
    implements TableCellRenderer {
        public ColorTableRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean cellHasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            JLabel label = (JLabel)value;
            this.setIcon(label.getIcon());
            this.setText(label.getText());
            return this;
        }
    }
}

