/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.ColorBarBase;
import hec.heclib.util.ColorBase;
import hec.io.TimeSeriesContainer;
import java.awt.Color;
import java.util.StringTokenizer;
import java.util.Vector;

public class QualityColorBar
extends ColorBarBase {
    public static String defaultColorSettings = "Valid,DarkGreen,Questionable,Yellow,Rejected,Red,Missing,Black,No Report,DarkGray,Not Checked,Blue";
    int _noReportTime = 0;
    Color _noReportColor = Color.black;
    Color _originalNoDataColor = this._noDataColor;
    TimeSeriesContainer _originalTimeSeriesContainer = null;

    public void setColorSettings(String settings) {
        this._colorSettings = settings.trim();
        if (this._colorSettings.length() > 0) {
            StringTokenizer st = new StringTokenizer(this._colorSettings, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("Absent Time") && !token.equalsIgnoreCase("No Report Time")) continue;
                token = st.nextToken();
                try {
                    Double value = Double.valueOf(token);
                    if (!(value > 0.0)) break;
                    this.setNoReportHours(value);
                    break;
                }
                catch (Exception value) {
                }
            }
        }
        Vector params = new Vector();
        Vector colors = new Vector();
        String colorSet = this.getAllColorSettings();
        ColorBase.parseSettingsString((String)colorSet, params, colors, (boolean)false);
        if (params.size() != colors.size()) {
            return;
        }
        Color[] qualityColors = new Color[colors.size()];
        int[] values = new int[colors.size()];
        for (int i = 0; i < params.size(); ++i) {
            qualityColors[i] = (Color)colors.elementAt(i);
            String qual = ((String)params.elementAt(i)).toLowerCase();
            if (qual.indexOf("valid") != -1) {
                values[i] = 1;
                continue;
            }
            if (qual.indexOf("quest") != -1) {
                values[i] = 3;
                continue;
            }
            if (qual.indexOf("reject") != -1) {
                values[i] = 4;
                continue;
            }
            if (qual.indexOf("miss") != -1) {
                values[i] = 2;
                continue;
            }
            if (qual.indexOf("abs") != -1 || qual.indexOf("report") != -1) {
                values[i] = 5;
                this._noReportColor = qualityColors[i];
                continue;
            }
            values[i] = 0;
        }
        this.setColorValues(values, qualityColors);
    }

    public String getAllColorSettings() {
        double noReportHours = (double)this._noReportTime / 60.0;
        String noReport = ",No Report Time," + Double.toString(noReportHours);
        if (this._colorSettings == null || this._colorSettings.length() == 0) {
            return defaultColorSettings + noReport;
        }
        String colorSet = defaultColorSettings + "," + this._colorSettings + noReport;
        return colorSet;
    }

    public void clearData() {
        super.clearData();
        this._noDataColor = this._originalNoDataColor;
    }

    public void addData(TimeSeriesContainer tsContainer) {
        this.setData(tsContainer);
    }

    public void setData(TimeSeriesContainer tsContainer) {
        this._originalTimeSeriesContainer = tsContainer;
        this.setTimeSeriesContainer(tsContainer);
    }

    protected void setTimeSeriesContainer(TimeSeriesContainer tsContainer) {
        if (this._colorSettings == null) {
            this.setColorSettings("");
        }
        this.setDataSetName(tsContainer.fullName);
        if (tsContainer.times == null) {
            this._size = 0;
            this._noDataColor = this._noReportColor;
            return;
        }
        this._backgroundColor = this._noReportColor;
        boolean checkNoReport = true;
        if (this._noReportTime == 0) {
            checkNoReport = false;
        }
        int qualitySize = -1;
        if (tsContainer.quality != null) {
            qualitySize = tsContainer.quality.length;
        }
        int[] qual = null;
        int[] time = null;
        int count = 0;
        int minTime = (int)this._minXSet;
        if (tsContainer.times.length > 0) {
            time = new int[(tsContainer.times.length + 3) * 2];
            qual = new int[(tsContainer.times.length + 3) * 2];
            if (checkNoReport && tsContainer.times[0] > minTime + this._noReportTime) {
                time[count] = tsContainer.startTime;
                qual[count++] = 5;
            }
            int previousStartTime = tsContainer.startTime;
            int flag = 0;
            for (int i = 0; i < tsContainer.times.length; ++i) {
                if (checkNoReport && i < tsContainer.times.length - 1 && tsContainer.times[i] > previousStartTime + this._noReportTime) {
                    time[count] = tsContainer.times[i] - this._noReportTime;
                    qual[count++] = 5;
                }
                previousStartTime = tsContainer.times[i];
                flag = i < qualitySize ? (QualityColorBar.isIntegerBitSet(tsContainer.quality[i], 5) ? 4 : (QualityColorBar.isIntegerBitSet(tsContainer.quality[i], 4) ? 3 : (QualityColorBar.isIntegerBitSet(tsContainer.quality[i], 3) ? 2 : (QualityColorBar.isIntegerBitSet(tsContainer.quality[i], 2) ? 1 : (tsContainer.values[i] == -3.4028234663852886E38 ? 2 : 0))))) : (tsContainer.values[i] == -3.4028234663852886E38 ? 2 : 0);
                time[count] = tsContainer.times[i];
                qual[count++] = flag;
            }
            int endPoint = tsContainer.times.length - 1;
            int endTime = tsContainer.times[endPoint];
            if (endPoint >= 1) {
                if (checkNoReport) {
                    int barEndTime = this._maxXSet != -3.4028234663852886E38 ? (int)this._maxXSet : tsContainer.endTime;
                    if ((endTime += this._noReportTime) > barEndTime) {
                        time[count] = endTime = barEndTime;
                        qual[count++] = flag;
                    } else {
                        time[count] = endTime;
                        qual[count++] = 5;
                        time[count] = barEndTime;
                        qual[count++] = 5;
                    }
                } else {
                    int interval = tsContainer.times[endPoint] - tsContainer.times[endPoint - 1];
                    if ((endTime += interval) > tsContainer.endTime) {
                        endTime = tsContainer.endTime;
                    }
                    time[count] = endTime;
                    qual[count++] = flag;
                }
            }
        }
        int istart = 0;
        if (this._minXSet != -3.4028234663852886E38) {
            int i = 0;
            while (i < count && time[i] <= minTime) {
                time[i] = minTime;
                istart = i++;
            }
        }
        int[] quality = new int[count - istart];
        int[] times = new int[count - istart];
        int size = count - istart;
        for (int i = 0; i < size; ++i) {
            quality[i] = qual[istart];
            times[i] = time[istart];
            ++istart;
        }
        time = null;
        qual = null;
        super.setData(times, quality);
    }

    public void setNoReportHours(double noReportHours) {
        this._noReportTime = noReportHours > 0.001 ? (int)(noReportHours * 60.0 + 0.05) : 0;
        if (this._originalTimeSeriesContainer != null) {
            this.setTimeSeriesContainer(this._originalTimeSeriesContainer);
        }
    }

    public double getNoReportTime() {
        return (double)this._noReportTime / 60.0;
    }

    public static boolean isIntegerBitSet(int integer, int bitPosition) {
        int shifted = integer >> bitPosition - 1;
        int masked = shifted & 1;
        return masked != 0;
    }
}

