/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.ColorEditorBase;
import hec.dataui.tx.client.IQualityColorBar;
import hec.dataui.tx.client.QualityColorBar;
import hec.heclib.util.ColorBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rma.swing.RmaJDecimalField;

public class QualityColorBarEditor
extends ColorEditorBase {
    JCheckBox _showNoReportCheckBox = new JCheckBox("");
    RmaJDecimalField _noReportHoursText = new RmaJDecimalField();
    Object _parent;
    String _originalParameters = "";

    public QualityColorBarEditor(Object parent, JFrame frame, String params) {
        super(frame, "Quality Color Bar Editor", "Quality", false);
        Object colorParams;
        this._parent = parent;
        this._originalParameters = params;
        if (params == null || params.length() == 0) {
            colorParams = QualityColorBar.defaultColorSettings;
        } else {
            colorParams = QualityColorBar.defaultColorSettings + "," + params;
            StringTokenizer st = new StringTokenizer((String)colorParams, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!token.equalsIgnoreCase("Absent Time") && !token.equalsIgnoreCase("No Report Time")) continue;
                token = st.nextToken();
                try {
                    Double value = Double.valueOf(token);
                    if (!(value > 0.0)) break;
                    this.setNoReportTime(token);
                    break;
                }
                catch (Exception exception) {
                }
            }
        }
        Vector names = new Vector();
        Vector colors = new Vector();
        ColorBase.parseSettingsString((String)colorParams, names, colors, (boolean)false);
        this.setParameters(names, colors);
    }

    @Override
    protected void initialize() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.buildSize();
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(15, 20, 12, 20);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this._colorTablePanel, gbc);
        this.getContentPane().add(this._colorTablePanel);
        this.buildDisplayNoReport();
        this.buildOKPanel();
        this.setListeners();
        Dimension d = this.getSize();
        d.width += 30;
        d.height += 40;
        this.setSize(d);
    }

    protected void buildDisplayNoReport() {
        JPanel jPanelNoReport = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanelNoReport.setLayout(gridBagLayout);
        jPanelNoReport.setFont(new Font("Dialog", 0, 12));
        jPanelNoReport.setForeground(new Color(0));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(4, 32, 4, 32);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(jPanelNoReport, gbc);
        this.getContentPane().add(jPanelNoReport);
        this._showNoReportCheckBox.setMnemonic('S');
        this._showNoReportCheckBox.setEnabled(this._editable);
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.fill = 2;
        ((GridBagLayout)jPanelNoReport.getLayout()).setConstraints(this._showNoReportCheckBox, gbc);
        jPanelNoReport.add(this._showNoReportCheckBox);
        JLabel noReportLabel = new JLabel("Show no report after");
        noReportLabel.setLabelFor(this._showNoReportCheckBox);
        noReportLabel.setFont(new Font("Dialog", 0, 12));
        noReportLabel.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.weightx = 0.5;
        gbc.fill = 2;
        ((GridBagLayout)jPanelNoReport.getLayout()).setConstraints(noReportLabel, gbc);
        jPanelNoReport.add(noReportLabel);
        this._noReportHoursText.setFont(new Font("Dialog", 0, 12));
        this._noReportHoursText.setForeground(new Color(0));
        this._noReportHoursText.setColumns(2);
        this._noReportHoursText.setHorizontalAlignment(4);
        this._noReportHoursText.setEnabled(this._editable);
        gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.fill = 2;
        ((GridBagLayout)jPanelNoReport.getLayout()).setConstraints((Component)this._noReportHoursText, gbc);
        jPanelNoReport.add((Component)this._noReportHoursText);
        JLabel hoursLabel = new JLabel("  hours");
        hoursLabel.setDisplayedMnemonic('h');
        hoursLabel.setLabelFor((Component)this._noReportHoursText);
        hoursLabel.setFont(new Font("Dialog", 0, 12));
        hoursLabel.setForeground(new Color(0));
        gbc = new GridBagConstraints();
        gbc.weightx = 0.0;
        gbc.fill = 2;
        ((GridBagLayout)jPanelNoReport.getLayout()).setConstraints(hoursLabel, gbc);
        jPanelNoReport.add(hoursLabel);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        if (this._showNoReportCheckBox != null) {
            this._showNoReportCheckBox.setEnabled(this._editable);
        }
        if (this._noReportHoursText != null) {
            this._noReportHoursText.setEnabled(this._editable);
        }
    }

    public String getParameterString() {
        return this.getSelections();
    }

    public String getChangedSelections() {
        Vector defaultNames = new Vector();
        Vector defaultColors = new Vector();
        ColorBase.parseSettingsString((String)QualityColorBar.defaultColorSettings, defaultNames, defaultColors, (boolean)false);
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < this._names.size(); ++i) {
            String defautlColorName;
            String setColorName;
            String name = ((String)this._names.elementAt(i)).trim();
            if (name.length() <= 0) continue;
            JComboBox combo = (JComboBox)this._colorTablePanel._colorCombos.elementAt(i);
            int indexColor = combo.getSelectedIndex();
            int indexName = defaultNames.indexOf(name);
            if (indexColor < 0 || indexName < 0 || (setColorName = ColorBase.getNameFromIndex((int)indexColor)).equals(defautlColorName = ColorBase.getNameFromColor((Color)((Color)defaultColors.elementAt(indexName))))) continue;
            params.append(name);
            params.append(",");
            params.append(setColorName);
            params.append(",");
        }
        if (params.length() > 1) {
            params.deleteCharAt(params.length() - 1);
        } else {
            params.append("");
        }
        return params.toString();
    }

    public void setNoReportTime(String noReportTime) {
        if (noReportTime != null) {
            this._showNoReportCheckBox.setSelected(true);
            this._noReportHoursText.setText(noReportTime);
        } else {
            this._showNoReportCheckBox.setSelected(false);
        }
    }

    @Override
    protected int apply_action() {
        super.apply_action();
        if (!this._editable) {
            return 0;
        }
        Object params = null;
        String noReportTime = null;
        if (this._showNoReportCheckBox.isSelected()) {
            try {
                Double value = Double.valueOf(this._noReportHoursText.getText());
                if (value > 0.0) {
                    noReportTime = this._noReportHoursText.getText().trim();
                }
            }
            catch (Exception e) {
                String mess = "Invalid number: " + this._noReportHoursText.getText();
                System.out.println(mess);
                JOptionPane.showMessageDialog((Component)((Object)this), mess, "", 2);
                return -1;
            }
        }
        if ((params = noReportTime != null ? "No Report Time," + noReportTime + "," + this.getChangedSelections() : this.getChangedSelections()) != null && this._originalParameters != null && ((String)params).equals(this._originalParameters)) {
            return 0;
        }
        if (this._parent instanceof IQualityColorBar) {
            ((IQualityColorBar)this._parent).setIconQualityInformation((String)params);
        }
        return 0;
    }
}

