/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.ColorEditorTablePanel;
import hec.dataui.tx.client.IconLegendFrame;
import hec.dataui.tx.client.QualityColorBarContainer;
import hec.heclib.util.ColorBase;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTextField;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;

public class QualityColorBarLegend
extends IconLegendFrame {
    ColorEditorTablePanel _colorTablePanel;
    protected String _noReportTime = null;

    public QualityColorBarLegend(String params) {
        this.initialize(params);
    }

    public QualityColorBarLegend(QualityColorBarContainer baseContainer) {
        String params = baseContainer.getColorSettings();
        this.initialize(params);
    }

    protected void initialize(String params) {
        this.setTitle("Quality Color Bar Legend");
        this._colorTablePanel = new ColorEditorTablePanel("Quality", false);
        this._colorTablePanel.setEditable(false);
        if (params == null) {
            params = "";
        }
        this.setParameterString(params);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(15, 20, 12, 20);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(this._colorTablePanel, gbc);
        this.getContentPane().add(this._colorTablePanel);
        if (this._noReportTime != null) {
            JTextField noReportHours = new JTextField(" Data shows no report after " + this._noReportTime + " hours");
            noReportHours.setEditable(false);
            noReportHours.setBackground(new Color(240, 240, 240));
            gbc = new GridBagConstraints();
            gbc.gridwidth = 0;
            gbc.weightx = 1.0;
            gbc.fill = 2;
            gbc.insets = new Insets(2, 24, 7, 24);
            ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(noReportHours, gbc);
            this.getContentPane().add(noReportHours);
        }
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(8);
        cmdPanel.setApplyAlwaysOn(true);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints((Component)cmdPanel, gbc);
        this.getContentPane().add((Component)cmdPanel);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                if (event.getID() == 8) {
                    QualityColorBarLegend.this.jButtonOk_actionPerformed(event);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension d;
        if (visible && (d = this.getSize()).getHeight() < 10.0) {
            d = this._colorTablePanel.getTableSize();
            d.height += 92;
            if (this._noReportTime != null) {
                d.height += 30;
            }
            d.width += 40;
            this.setSize(d);
            this.setLocation(60, 60);
        }
        super.setVisible(visible);
    }

    public void setParameterString(String params) {
        Vector thresholdValues = new Vector();
        Vector thresholdColors = new Vector();
        ColorBase.parseSettingsString((String)params, thresholdValues, thresholdColors, (boolean)false);
        this._colorTablePanel.setParameters(thresholdValues, thresholdColors);
        StringTokenizer st = new StringTokenizer(params, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.equalsIgnoreCase("Absent Time") && !token.equalsIgnoreCase("No Report Time")) continue;
            token = st.nextToken();
            try {
                Double value = Double.valueOf(token);
                if (!(value > 0.0)) continue;
                this._noReportTime = token;
            }
            catch (Exception exception) {}
        }
    }
}

