/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.ColorBarBaseContainer;
import hec.dataui.tx.client.ColorEditorTablePanel;
import hec.dataui.tx.client.IconLegendFrame;
import hec.dataui.tx.client.ThresholdColorBarContainer;
import hec.heclib.util.ColorBase;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.lang.invoke.CallSite;
import java.util.Vector;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;

public class ThresholdColorBarLegend
extends IconLegendFrame {
    ColorBarBaseContainer _baseContainer = null;
    private Dimension _tableSize;

    public ThresholdColorBarLegend(ThresholdColorBarContainer baseContainer, String nodeName) {
        GridBagConstraints gbc;
        this._baseContainer = baseContainer;
        this.setTitle(nodeName + " Threshold Legend");
        this.getContentPane().setLayout(new GridBagLayout());
        this._tableSize = new Dimension();
        Vector params = this._baseContainer.getColorSettingsVector();
        Vector dataSetNames = this._baseContainer.getDataSetNames();
        for (int i = 0; i < params.size(); ++i) {
            ColorEditorTablePanel colorTablePanel = new ColorEditorTablePanel("Value", false);
            colorTablePanel.setEditable(false);
            colorTablePanel.setLeftColumnCentered(true);
            String colorParams = (String)params.elementAt(i);
            Vector thresholdValues = new Vector();
            Vector thresholdColors = new Vector();
            ColorBase.parseSettingsString((String)colorParams, thresholdValues, thresholdColors, (boolean)true);
            if (thresholdValues.size() > 1) {
                Vector<CallSite> thresholdRange = new Vector<CallSite>();
                thresholdRange.add((CallSite)((Object)("< " + thresholdValues.elementAt(1))));
                for (int j = 1; j < thresholdValues.size() - 1; ++j) {
                    thresholdRange.add((CallSite)((Object)(thresholdValues.elementAt(j) + " to " + thresholdValues.elementAt(j + 1))));
                }
                thresholdRange.add((CallSite)((Object)("> " + thresholdValues.elementAt(thresholdValues.size() - 1))));
                colorTablePanel.setParameters(thresholdRange, thresholdColors);
            } else {
                colorTablePanel.setParameters(thresholdValues, thresholdColors);
            }
            Dimension d = colorTablePanel.getTableSize();
            colorTablePanel.setPreferredSize(d);
            this._tableSize.width = d.width;
            this._tableSize.height += d.height;
            this._tableSize.height += 66;
            if (i < dataSetNames.size()) {
                String dataName = (String)dataSetNames.elementAt(i);
                int indx = dataName.toLowerCase().indexOf(".dss:");
                if (indx > 0) {
                    dataName = dataName.substring(indx + 5);
                }
                TitledBorder tBorder = new TitledBorder(new EtchedBorder(), dataName);
                colorTablePanel.setBorder(tBorder);
            }
            gbc = new GridBagConstraints();
            gbc.weightx = 1.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(15, 20, 12, 20);
            gbc.gridwidth = 0;
            gbc.fill = 1;
            ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(colorTablePanel, gbc);
            this.getContentPane().add(colorTablePanel);
        }
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(8);
        cmdPanel.setApplyAlwaysOn(true);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints((Component)cmdPanel, gbc);
        this.getContentPane().add((Component)cmdPanel);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                if (event.getID() == 8) {
                    ThresholdColorBarLegend.this.jButtonOk_actionPerformed(event);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension d;
        if (visible && (d = this.getSize()).getHeight() < 10.0) {
            this._tableSize.height += 60;
            this._tableSize.width += 80;
            this.setSize(this._tableSize);
            this.setLocation(60, 60);
        }
        super.setVisible(visible);
    }
}

