/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.gfx2d.PlotIcon;
import hec.heclib.util.ColorBase;
import hec.heclib.util.HecDouble;
import hec.io.TimeSeriesContainer;
import hec.model.TsDataSetName;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Vector;

public class ThumbnailPlot
extends PlotIcon {
    Vector _originalCurveColors = null;

    public ThumbnailPlot() {
    }

    public ThumbnailPlot(int cumulativeInterval, int accumulationType) {
        super.setCumulative(cumulativeInterval, accumulationType);
    }

    public void setTsDataSetNames(Vector names) {
        super.setTsDataSetNames(names);
        for (int i = 0; i < names.size(); ++i) {
            TsDataSetName dsn = (TsDataSetName)names.elementAt(i);
            HecDouble min = new HecDouble();
            HecDouble max = new HecDouble();
            dsn.getThumbnailMinMax(min, max);
            if (!min.isDefined() && !max.isDefined()) continue;
            this.setYLimits(min.value(), max.value());
        }
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        g.setColor(this._borderColor);
        g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
        if (this._selected) {
            g.setColor(this._borderColor);
            g.drawLine(x, y + this.getIconHeight(), x + this.getIconWidth(), y + this.getIconHeight());
            g.drawLine(x + this.getIconWidth(), y, x + this.getIconWidth(), y + this.getIconHeight());
            g.drawLine(x, y, x, y + this.getIconHeight());
            g.drawLine(x, y, x + this.getIconWidth(), y);
            g.drawLine(x - 1, y + this.getIconHeight() + 1, x + this.getIconWidth() + 1, y + this.getIconHeight() + 1);
            g.drawLine(x + this.getIconWidth() + 1, y - 1, x + this.getIconWidth() + 1, y + this.getIconHeight() + 1);
            g.drawLine(x - 1, y - 1, x - 1, y + this.getIconHeight() + 1);
            g.drawLine(x - 1, y - 1, x + this.getIconWidth() + 1, y - 1);
            g.drawLine(x - 2, y + this.getIconHeight() + 2, x + this.getIconWidth() + 2, y + this.getIconHeight() + 2);
            g.drawLine(x + this.getIconWidth() + 2, y - 2, x + this.getIconWidth() + 2, y + this.getIconHeight() + 2);
            g.drawLine(x - 2, y - 2, x - 2, y + this.getIconHeight() + 2);
            g.drawLine(x - 2, y - 2, x + this.getIconWidth() + 2, y - 2);
        }
    }

    public void addData(TimeSeriesContainer tsContainer) {
        int i;
        if (this._originalCurveColors == null) {
            this._originalCurveColors = new Vector();
            for (i = 0; i < this._curveColors.size(); ++i) {
                this._originalCurveColors.addElement((Color)this._curveColors.elementAt(i));
            }
        }
        for (i = 0; i < this._dataSetNames.size(); ++i) {
            String name = (String)this._dataSetNames.elementAt(i);
            if (name.indexOf(tsContainer.fullName) <= -1) continue;
            int numb = 0;
            if (this._yData != null) {
                numb = this._yData.size();
            }
            if (i >= this._originalCurveColors.size()) continue;
            Color color = (Color)this._originalCurveColors.elementAt(i);
            if (this._curveColors.size() > numb) {
                this._curveColors.setElementAt(color, numb);
                continue;
            }
            this._curveColors.addElement(color);
        }
        super.addData(tsContainer);
    }

    public void setColorSettings(String settings) {
        Vector params = new Vector();
        Vector colors = new Vector();
        ColorBase.parseSettingsString((String)settings, params, colors, (boolean)false);
        this.setColors(colors);
    }
}

