/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.client;

import hec.dataui.tx.client.IconLegendFrame;
import hec.dataui.tx.client.ThumbnailPlot;
import hec.heclib.util.ColorBase;
import hec.heclib.util.HecDouble;
import hec.heclib.util.doubleArrayContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import rma.swing.ButtonCmdPanel;
import rma.swing.ButtonCmdPanelListener;

public class ThumbnailPlotLegend
extends IconLegendFrame {
    ThumbnailPlot _thumbnailPlot = null;
    private Dimension _tableSize;

    public ThumbnailPlotLegend(ThumbnailPlot thumbnailPlot, String nodeName) {
        this._thumbnailPlot = thumbnailPlot;
        this.setTitle(nodeName + " ThumbnailPlot Legend");
        this.getContentPane().setLayout(new GridBagLayout());
        this._tableSize = new Dimension();
        Vector dataSetNames = this._thumbnailPlot.getDataSetNames();
        Vector colors = this._thumbnailPlot.getColors();
        Vector data = this._thumbnailPlot.getYDataVector();
        if (dataSetNames == null || colors == null || data == null) {
            System.out.println("No data for thumbnail plot: " + nodeName);
            JOptionPane.showMessageDialog(this, "No data for thumbnail plot: " + nodeName, "No Data", 2);
            return;
        }
        Vector<Object> tableInfo = new Vector<Object>();
        for (int i = 0; i < dataSetNames.size(); ++i) {
            String dataName = (String)dataSetNames.elementAt(i);
            int indx = dataName.toLowerCase().indexOf(".dss:");
            if (indx > 0) {
                dataName = dataName.substring(indx + 5);
            }
            tableInfo.add(dataName);
            int width = dataName.length() * 8;
            if (width > this._tableSize.width) {
                this._tableSize.width = width;
            }
            if (i < colors.size()) {
                Color color = (Color)colors.elementAt(i);
                String colorName = ColorBase.getNameFromColor((Color)color);
                tableInfo.add("        Color:  " + colorName);
            }
            if (i < data.size()) {
                doubleArrayContainer array = (doubleArrayContainer)data.elementAt(i);
                HecDouble min = new HecDouble(array.minimum());
                HecDouble max = new HecDouble(array.maximum());
                min.setSignificantDigits(4);
                max.setSignificantDigits(4);
                tableInfo.add("        Minimum:  " + min.string(true));
                tableInfo.add("        Maximum:  " + max.string(true));
            }
            if (i >= dataSetNames.size() - 1) continue;
            tableInfo.add(new String(""));
        }
        JList<String> list = new JList<String>(tableInfo);
        list.setPrototypeCellValue("Index 1234567890");
        JScrollPane tablePane = new JScrollPane(list);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(15, 20, 12, 20);
        gbc.gridwidth = 0;
        gbc.fill = 1;
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints(tablePane, gbc);
        this.getContentPane().add(tablePane);
        this._tableSize.height = tableInfo.size() * 20;
        ButtonCmdPanel cmdPanel = new ButtonCmdPanel(8);
        cmdPanel.setApplyAlwaysOn(true);
        gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(2, 2, 2, 2);
        ((GridBagLayout)this.getContentPane().getLayout()).setConstraints((Component)cmdPanel, gbc);
        this.getContentPane().add((Component)cmdPanel);
        cmdPanel.addCmdPanelListener(new ButtonCmdPanelListener(){

            public void buttonCmdActionPerformed(ActionEvent event) {
                if (event.getID() == 8) {
                    ThumbnailPlotLegend.this.jButtonOk_actionPerformed(event);
                }
            }
        });
    }

    @Override
    public void setVisible(boolean visible) {
        Dimension d;
        if (visible && (d = this.getSize()).getHeight() < 10.0) {
            this._tableSize.height += 90;
            if (this._tableSize.height > 500) {
                this._tableSize.height = 500;
            }
            this._tableSize.width += 50;
            if (this._tableSize.width > 500) {
                this._tableSize.width = 500;
            }
            this.setSize(this._tableSize);
            this.setLocation(60, 60);
        }
        super.setVisible(visible);
    }
}

