/*
 * Decompiled with CFR 0.152.
 */
package hec.dataui.tx.util;

import hec.heclib.util.HecTime;
import hec.util.FileUtilities;
import hec.util.ObservableClass;
import hec.util.PhotoViewerInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import java.util.Observer;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JFrame;

public class PhotoViewer
extends Component
implements Runnable {
    protected BufferedImage _image = null;
    protected BufferedImage _originalImage = null;
    protected BufferedImage _oldImage = null;
    protected BufferedImage _suppliedImage = null;
    protected volatile Thread _refreshThread = null;
    protected double _refreshInterval;
    protected Random _rand;
    protected String _urlOrFileName;
    protected boolean _fade;
    protected boolean _remote = false;
    protected boolean _paused = false;
    protected HecTime _lastReadTime = new HecTime(0);
    protected boolean _showReadTime = false;
    protected Color _drawTimeColor = Color.WHITE;
    protected int _xloc = 0;
    protected int _yloc = 0;
    protected int _width = 0;
    protected int _height = 0;
    protected double _xScaleAmount = 1.0;
    protected double _yScaleAmount = 1.0;
    protected boolean _newSize = false;
    protected int _newWidth = 0;
    protected int _newHeight = 0;
    protected boolean _recording = false;
    protected String _recordDirectory = null;
    protected int _recordSequence = 0;
    protected int _recordingFrequency = 0;
    protected Component _parent;
    protected Graphics _validG = null;
    protected ObservableClass _observer = new ObservableClass();
    protected URL _imageURL = null;
    protected URLConnection _urlConnection = null;
    protected long _imageTime = 0L;

    public PhotoViewer() {
    }

    public PhotoViewer(Component parent, PhotoViewerInfo photoViewerInfo) {
        this._remote = photoViewerInfo.remote;
        this.loadInfo(photoViewerInfo);
    }

    public void loadInfo(PhotoViewerInfo photoViewerInfo) {
        if (photoViewerInfo.xSize != 1.0 || photoViewerInfo.ySize != 1.0) {
            this.setImageSize(photoViewerInfo.xSize, photoViewerInfo.ySize);
        }
        this.init(this, photoViewerInfo.url, photoViewerInfo.bufferedImage, photoViewerInfo.refreshInterval, photoViewerInfo.fade);
    }

    public PhotoViewer(Component parent, String urlOrFileName, double refreshInterval, boolean fade) {
        this.init(parent, urlOrFileName, null, refreshInterval, fade);
    }

    public boolean haveImage() {
        return this._image != null && this._image.getHeight() > 0;
    }

    public void showTime(boolean showReadTime) {
        this._showReadTime = showReadTime;
    }

    public String getImageSoruce() {
        return this._urlOrFileName;
    }

    protected int init(Component parent, String urlOrFileName, BufferedImage image, double refreshInterval, boolean fade) {
        System.out.println("Connecting to " + urlOrFileName + "...");
        this._parent = parent;
        this._urlOrFileName = urlOrFileName;
        this._refreshInterval = refreshInterval;
        this._fade = fade;
        this._rand = new Random();
        this._suppliedImage = image;
        if (this._urlOrFileName == null && image == null) {
            return -1;
        }
        int istat = this.readImage();
        if (istat != 0) {
            System.out.println("Unable to read image from " + this._urlOrFileName);
            return istat;
        }
        this._refreshThread = new Thread(this);
        if (this._refreshInterval >= 0.0) {
            this._refreshThread.start();
        }
        return 0;
    }

    public int readImage() {
        String tmp = this._urlOrFileName.toLowerCase();
        if (tmp.startsWith("htt") || tmp.startsWith("ftp")) {
            int colon = tmp.substring(6).indexOf(":");
            int ast = tmp.indexOf("@");
            if (colon > 0 && ast > 0) {
                this.checkAuth();
            }
        }
        try {
            this.retrieveImage();
            this.scaleImage();
        }
        catch (Exception e) {
            String message = "Unable to access image " + this._urlOrFileName + "\n" + e.toString();
            return -1;
        }
        return 0;
    }

    public void setPaused(boolean pause) {
        this._paused = pause;
    }

    public boolean getPaused() {
        return this._paused;
    }

    public long getImageTime() {
        return this._imageTime;
    }

    public int setRecording(String dirName, boolean on) {
        this._recordDirectory = dirName;
        this._recording = on;
        return this._recordSequence;
    }

    public void setRecordingFrequency(String dirName, int frequency) {
        this._recordDirectory = dirName;
        if (!this._recordDirectory.endsWith("\\") && !this._recordDirectory.endsWith("/")) {
            this._recordDirectory = dirName + "/";
        }
        this._recordingFrequency = frequency;
    }

    public void setImageSize(double xAmount, double yAmount) {
        if (xAmount < 10.0 || yAmount < 10.0) {
            this._xScaleAmount = xAmount;
            this._yScaleAmount = yAmount;
        } else {
            this._newSize = true;
            this._newWidth = (int)xAmount;
            this._newHeight = (int)yAmount;
        }
    }

    public void resizeImage(int width, int height) {
        if (this._originalImage == null) {
            return;
        }
        this.sizeImage(width, height);
        try {
            Graphics g;
            this.scaleImage();
            if (this._oldImage != null) {
                this._oldImage = this._image;
            }
            if ((g = this._parent instanceof JFrame ? ((JFrame)this._parent).getContentPane().getGraphics() : this._parent.getGraphics()) != null) {
                this.paint(g);
            }
            this.imageResized();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void sizeImage(int width, int height) {
        if (this._originalImage == null) {
            return;
        }
        this._xScaleAmount = (double)width / (double)this._width;
        this._yScaleAmount = (double)height / (double)this._height;
        if (this._xScaleAmount > 0.99 && this._xScaleAmount < 1.01) {
            this._xScaleAmount = 1.0;
        }
        if (this._yScaleAmount > 0.99 && this._yScaleAmount < 1.01) {
            this._yScaleAmount = 1.0;
        }
    }

    protected void retrieveImage() throws Exception {
        if (this._suppliedImage != null) {
            this._originalImage = this._image = this._suppliedImage;
            this._height = this._image.getHeight();
            this._width = this._image.getWidth();
            return;
        }
        try {
            String tmp;
            if (this._image != null) {
                this._image.flush();
            }
            if ((tmp = this._urlOrFileName.substring(0, 5).toLowerCase()).startsWith("https")) {
                this._image = this.retrieveSecureImage(this._urlOrFileName);
            } else if (tmp.startsWith("htt") || tmp.startsWith("ftp")) {
                if (this._imageURL == null) {
                    this._imageURL = new URL(this._urlOrFileName);
                    if (this._imageURL == null) {
                        return;
                    }
                }
                this._image = null;
                for (int j = 0; j < 3; ++j) {
                    try {
                        this._urlConnection = this._imageURL.openConnection();
                        if (this._urlConnection == null) {
                            return;
                        }
                        this._urlConnection.setConnectTimeout(2000);
                        this._urlConnection.setReadTimeout(1000);
                        InputStream in = this._urlConnection.getInputStream();
                        this._image = ImageIO.read(in);
                        if (this._image != null) {
                            this._imageTime = System.currentTimeMillis();
                            break;
                        }
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (Exception e) {
                        this._image = null;
                    }
                }
            } else {
                this._image = null;
                File file = new File(this._urlOrFileName);
                for (int j = 0; j < 6; ++j) {
                    try {
                        this._image = ImageIO.read(file);
                        if (this._image != null) break;
                        Thread.sleep(250L);
                        continue;
                    }
                    catch (Exception ignore) {
                        this._image = null;
                    }
                }
                if (this._image == null) {
                    this._image = ImageIO.read(file);
                }
            }
            if (this._image == null) {
                this.errorGetImage();
                throw new Exception("Cannot read image");
            }
            this._originalImage = this._image;
            this._height = this._image.getHeight();
            this._width = this._image.getWidth();
            this._lastReadTime.setCurrent();
        }
        catch (Exception e) {
            this.errorGetImage();
            String mess = e.getLocalizedMessage();
            throw e;
        }
    }

    protected void scaleImage() {
        this.scaleImage(false);
    }

    protected void scaleImage(boolean fast) {
        if (this._originalImage != null) {
            if (this._newSize) {
                this.sizeImage(this._newWidth, this._newHeight);
                this._newSize = false;
            }
            this._image = PhotoViewer.scale(this._originalImage, this._xScaleAmount, this._yScaleAmount, fast);
        }
    }

    public int getPriority() {
        int pri = 5;
        try {
            pri = Thread.currentThread().getPriority();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return pri;
    }

    public void setPriority(int pri) {
        try {
            Thread.currentThread().setPriority(pri);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void proceed() {
        System.out.println("Loading " + this._urlOrFileName);
        if (this._refreshInterval < 0.0) {
            return;
        }
        while (this._refreshThread != null) {
            try {
                int delay = (int)(this._refreshInterval * 1000.0);
                Thread.sleep(delay);
                if (!this._paused) {
                    if (this._refreshThread == null) {
                        return;
                    }
                    this.retrieveImage();
                    if (this._refreshThread == null) {
                        return;
                    }
                    this.scaleImage();
                    if (this._refreshThread == null) {
                        return;
                    }
                }
                if (this._paused) continue;
                this.imageUpdated();
                if (this._recording) {
                    this.recordImage();
                }
                if (this._recordingFrequency <= 0) continue;
                this.recordFreqency(this._recordingFrequency);
            }
            catch (Exception exception) {}
        }
    }

    public void reretrieve() {
        try {
            this.retrieveImage();
            this.redraw();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void redraw() {
        if (this._originalImage != null) {
            this.scaleImage();
            this.paint();
        }
    }

    @Override
    public void run() {
        if (this._refreshInterval < 0.0) {
            return;
        }
        while (this._refreshThread != null) {
            try {
                int delay = (int)(this._refreshInterval * 1000.0);
                Thread.sleep(delay);
                if (!this._paused) {
                    if (this._refreshThread == null) {
                        return;
                    }
                    this.retrieveImage();
                    if (this._refreshThread == null) {
                        return;
                    }
                    this.scaleImage();
                    if (this._refreshThread == null) {
                        return;
                    }
                }
                if (this._paused) continue;
                this.paint();
                this.imageUpdated();
                if (this._recording) {
                    this.recordImage();
                }
                if (this._recordingFrequency <= 0) continue;
                this.recordFreqency(this._recordingFrequency);
            }
            catch (Exception exception) {}
        }
    }

    public void stop() {
        this._refreshThread = null;
        this.done();
    }

    public HecTime getLastReadTime() {
        return this._lastReadTime;
    }

    protected void recordImage() {
        String numb = Integer.toString(++this._recordSequence);
        Object name = "image00000";
        name = ((String)name).substring(0, ((String)name).length() - numb.length()) + numb;
        String fullName = this._recordDirectory + (String)name + ".jpg";
        this.drawTime(null);
        try {
            File file = new File(fullName);
            PhotoViewer.writeImageToJPEG(this._image, 100, file);
            System.out.println("Saved image " + fullName);
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }

    protected void recordFreqency(int frequency) {
        HecTime time = new HecTime(10);
        time.setCurrent();
        int secs = time.secondsSinceMidnight();
        int n = secs / (int)this._refreshInterval;
        secs = n * (int)this._refreshInterval;
        int min = secs / 60;
        time.setJulian(time.julian(), min, secs -= min * 60);
        String clockTime = time.getTime(false) + time.getTime(true).substring(6);
        Object dir = "";
        if (frequency == 1) {
            dir = time.dayOfWeekName();
        } else if (frequency == 2) {
            dir = Integer.toString(time.day());
            if (((String)dir).length() == 1) {
                dir = "0" + (String)dir;
            }
        } else if (frequency == 3) {
            dir = time.date(4);
            dir = ((String)dir).substring(0, 5);
        } else {
            dir = time.date(4);
        }
        String name = (String)dir + "/" + clockTime;
        String fullName = this._recordDirectory + name + ".jpg";
        this.drawTime(null);
        try {
            File file = new File(fullName);
            if (!file.exists()) {
                dir = FileUtilities.separateDirectoryFromName((String)fullName);
                File dFile = new File((String)dir);
                if (!dFile.exists()) {
                    dFile.mkdirs();
                }
                file.createNewFile();
                file.setWritable(true);
            } else {
                file.delete();
                file.createNewFile();
                file.setWritable(true);
            }
            if (file.canWrite()) {
                PhotoViewer.writeImageToJPEG(this._image, 100, file);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            return;
        }
    }

    public Image getImage() {
        return this._image;
    }

    @Override
    public int getHeight() {
        return (int)((double)this._height * this._yScaleAmount);
    }

    @Override
    public int getWidth() {
        return (int)((double)this._width * this._xScaleAmount);
    }

    public static BufferedImage scale(BufferedImage image, double xScaleAmount, double yScaleAmount, boolean fast) {
        if (xScaleAmount == 1.0 && yScaleAmount == 1.0) {
            return image;
        }
        AffineTransform tx = new AffineTransform();
        tx.scale(xScaleAmount, yScaleAmount);
        if (fast || xScaleAmount <= 1.0 && yScaleAmount <= 1.0) {
            AffineTransformOp op = new AffineTransformOp(tx, 1);
            return op.filter(image, null);
        }
        AffineTransformOp op = new AffineTransformOp(tx, 2);
        return op.filter(image, null);
    }

    public void paint() {
        try {
            Graphics g = this._parent instanceof JFrame ? ((JFrame)this._parent).getContentPane().getGraphics() : this._parent.getGraphics();
            if (g == null) {
                if (this._validG == null) {
                    return;
                }
                g = this._validG;
            }
            if (this._fade) {
                this.fadePaint(g);
            } else {
                this.paint(g);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void paint(Graphics g, int xloc, int yloc) {
        this._xloc = xloc;
        this._yloc = yloc;
        this.paint(g);
    }

    @Override
    public void paint(Graphics g) {
        if (this._validG == null) {
            this._validG = g;
        }
        if (g == null) {
            if (this._validG == null) {
                return;
            }
            g = this._validG;
        }
        if (this._image != null) {
            Graphics2D g2d = (Graphics2D)g;
            this.drawTime(g2d);
            g2d.drawImage((Image)this._image, this._xloc, this._yloc, this);
        }
        super.paint(g);
    }

    public void fadePaint(Graphics g) {
        if (this._paused) {
            return;
        }
        if (this._image != null) {
            Graphics2D g2d = (Graphics2D)g;
            if (this._oldImage != null) {
                g2d.drawImage((Image)this._oldImage, this._xloc, this._yloc, this);
                super.paint(g);
            }
            for (float alphaLevel = 0.0f; alphaLevel < 1.0f; alphaLevel += 0.1f) {
                Composite oldcomp = g2d.getComposite();
                AlphaComposite comp = AlphaComposite.getInstance(3, alphaLevel);
                g2d.setComposite(comp);
                g2d.drawImage((Image)this._image, this._xloc, this._yloc, this);
                g2d.setComposite(oldcomp);
                this.drawTime(g2d);
                super.paint(g);
                try {
                    Thread.sleep(50L);
                    if (!this._paused) continue;
                    return;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            this._oldImage = this._image;
        }
    }

    protected void setDrawTimeColor(Color color) {
        this._drawTimeColor = color;
    }

    protected void drawTime(Graphics2D g2d) {
        if (g2d == null) {
            return;
        }
        g2d = this._image.createGraphics();
        if (this._showReadTime && this._lastReadTime.isDefined()) {
            Color c = g2d.getColor();
            g2d.setColor(this._drawTimeColor);
            g2d.fill3DRect(6, 8, 110, 16, true);
            g2d.setColor(Color.BLACK);
            g2d.drawString(this._lastReadTime.toString(-1), 10, 20);
            g2d.setColor(c);
        }
    }

    public void addObserver(Observer o) {
        if (this._observer != null) {
            this._observer.addObserver(o);
        }
    }

    public void removeObserver(Observer o) {
        if (this._observer != null) {
            this._observer.deleteObserver(o);
        }
    }

    public void done() {
        if (this._observer != null) {
            ActionEvent event = new ActionEvent(this, 1001, "PhotoViewerClose");
            this._observer.notifyObservers((Object)event);
            this._observer.deleteObservers();
        }
    }

    protected void imageUpdated() {
        if (this._observer != null) {
            ActionEvent event = new ActionEvent(this, 1001, "imageUpdated");
            this._observer.notifyObservers((Object)event);
        }
    }

    protected void imageResized() {
        if (this._observer != null) {
            ActionEvent event = new ActionEvent(this, 1001, "imageResized");
            this._observer.notifyObservers((Object)event);
        }
    }

    protected void errorGetImage() {
        if (this._observer != null) {
            ActionEvent event = new ActionEvent(this, 1001, "errorGetImage");
            this._observer.notifyObservers((Object)event);
        }
    }

    public ObservableClass getObserver() {
        return this._observer;
    }

    public int readResizeAndWrite(String inFileName, String outFileName, int quality, double width, double height) {
        this._image = null;
        this._urlOrFileName = inFileName;
        if (this.readImage() != 0) {
            return -1;
        }
        double w = this.getWidth();
        double h = this.getHeight();
        height = (int)(width / w * h);
        return this.resizeAndWrite(outFileName, quality, width, height);
    }

    public int resizeAndWrite(String outFileName, int quality, double width, double height) {
        if (width > 0.0 && height > 0.0) {
            this.setImageSize(width, height);
            this.scaleImage(false);
        }
        this.drawTime(null);
        try {
            File file = new File(outFileName);
            PhotoViewer.writeImageToJPEG(this._image, quality, file);
        }
        catch (Exception e) {
            System.out.println(e);
            return -1;
        }
        return 0;
    }

    protected void checkAuth() {
        if (this._urlOrFileName.indexOf("://") < 0) {
            return;
        }
        int slash = this._urlOrFileName.indexOf("//") + 2;
        int ast = this._urlOrFileName.substring(slash).indexOf("@") + slash;
        if (ast < slash) {
            return;
        }
        String newUrl = this._urlOrFileName.substring(0, slash) + this._urlOrFileName.substring(ast + 1);
        String up = this._urlOrFileName.substring(slash, ast);
        int colon = up.indexOf(":");
        if (colon < 0) {
            return;
        }
        String user = up.substring(0, colon);
        String pass = up.substring(colon + 1);
        Authenticator.setDefault(new MyAuthenticator(user, pass));
        this._urlOrFileName = newUrl;
    }

    public static void writeImageToJPEG(BufferedImage buffImage, int quality, File outputFile) {
        Iterator<ImageWriter> iter;
        if (quality < 0) {
            quality = 0;
        }
        if (quality > 100) {
            quality = 100;
        }
        if (!(iter = ImageIO.getImageWritersByFormatName("JPG")).hasNext()) {
            Logger logger = Logger.getLogger(PhotoViewer.class.getName());
            logger.log(Level.WARNING, "No Image writers exist for Image Type = {0}", "JPG");
            return;
        }
        ImageWriter next = iter.next();
        ImageWriteParam defaultWriteParam = next.getDefaultWriteParam();
        if (defaultWriteParam.canWriteCompressed()) {
            defaultWriteParam.setCompressionMode(2);
            defaultWriteParam.setCompressionQuality(quality / 100);
        }
        try {
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile));
            next.setOutput(ImageIO.createImageOutputStream(out));
            next.write(null, new IIOImage(buffImage, null, null), defaultWriteParam);
            out.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected BufferedImage retrieveSecureImage(String urlString) throws Exception {
        int i = urlString.indexOf("//");
        String hostFull = urlString.substring(i + 2);
        i = hostFull.indexOf("/");
        String host = hostFull.substring(0, i);
        String fileName = hostFull.substring(i);
        i = fileName.lastIndexOf("/");
        String pict = fileName.substring(i + 1);
        i = pict.lastIndexOf(".");
        String imageName = pict.substring(0, i);
        String imageSuffix = pict.substring(i);
        if (imageSuffix.equalsIgnoreCase(".jpeg")) {
            imageSuffix = ".jpg";
        }
        int port = 443;
        BufferedImage image = null;
        File cacheFile = null;
        try {
            int n;
            String line;
            SSLContext sslcontext = SSLContext.getInstance("SSL");
            sslcontext.init(null, new TrustManager[]{new PVTrustManager()}, new SecureRandom());
            SSLSocketFactory factory = sslcontext.getSocketFactory();
            SSLSocket socket = (SSLSocket)factory.createSocket(host, port);
            socket.startHandshake();
            OutputStreamWriter out = new OutputStreamWriter(socket.getOutputStream());
            out.write("GET " + fileName + " HTTP/1.1\r\n");
            out.write("Host: " + host + ":" + port + "\r\n");
            out.write("Agent: SSL-TEST\r\n");
            out.write("\r\n");
            ((Writer)out).flush();
            cacheFile = File.createTempFile(imageName, imageSuffix);
            cacheFile.deleteOnExit();
            FileOutputStream writer = new FileOutputStream(cacheFile);
            PvInputStream in = new PvInputStream(socket.getInputStream());
            while ((line = in.readLine()) != null) {
                if (line.indexOf("Content-Type") <= -1) continue;
                in.read();
                in.read();
                break;
            }
            byte[] buff = new byte[5000];
            while ((n = in.read(buff)) != -1) {
                writer.write(buff, 0, n);
            }
            writer.flush();
            writer.close();
            ((Writer)out).close();
            socket.close();
            image = ImageIO.read(cacheFile);
            cacheFile.delete();
        }
        catch (Exception e) {
            System.err.println(e);
            cacheFile.delete();
            throw new Exception(e);
        }
        return image;
    }

    class MyAuthenticator
    extends Authenticator {
        String _user;
        String _pass;

        public MyAuthenticator(String user, String pass) {
            this._user = user;
            this._pass = pass;
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this._user, this._pass.toCharArray());
        }
    }

    public static class PVTrustManager
    implements X509TrustManager {
        @Override
        public void checkClientTrusted(X509Certificate[] ax509certificate, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] ax509certificate, String authType) {
        }

        public boolean isClientTrusted(X509Certificate[] cert) {
            return true;
        }

        public boolean isServerTrusted(X509Certificate[] cert) {
            return true;
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }

    public class PvInputStream {
        InputStream _in;

        public PvInputStream(InputStream in) {
            this._in = in;
        }

        public String readLine() throws Exception {
            int c;
            StringBuffer line = new StringBuffer();
            while ((c = this._in.read()) != -1) {
                if (c == 13) continue;
                if (c == 10) {
                    return line.toString();
                }
                line.append((char)c);
            }
            return null;
        }

        public int read() throws Exception {
            return this._in.read();
        }

        public int read(byte[] buff) throws Exception {
            return this._in.read(buff);
        }

        public InputStream getInputStream() {
            return this._in;
        }
    }
}

